/*
 * Decompiled with CFR 0.152.
 */
package models.payments;

import controllers.util.BLLoggerPlay;
import controllers.util.CsvImport;
import controllers.util.TenantUtils;
import de.businesslogics.banking.api.DatabasePreferenceConstant;
import de.businesslogics.banking.api.DatabasePreferenceStore;
import de.businesslogics.banking.api.Util;
import de.businesslogics.banking.database.vo.Account;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.database.vo.ConverterFormat;
import de.businesslogics.banking.database.vo.PaymentOriginator;
import de.businesslogics.banking.database.vo.PaymentRecipient;
import de.businesslogics.banking.database.vo.PaymentTransferType;
import de.businesslogics.banking.database.vo.PaymentType;
import de.businesslogics.banking.database.vo.Preference;
import de.businesslogics.banking.database.vo.Tenant;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.banking.payments.api.PaymentConversionHandler2;
import de.businesslogics.banking.payments.api.PreferenceUtil;
import de.businesslogics.banking.payments.core.PreferenceConstants;
import de.businesslogics.format.csv.CSVConverterException;
import de.businesslogics.format.csv.Column;
import de.businesslogics.format.sepa.csv.FieldI;
import de.businesslogics.format.swift.mt101.MT101PaymentData;
import de.businesslogics.format.swift.mt101.csv.Format;
import de.businesslogics.format.swift.mt101.csv.MT101CSVFormatParser;
import de.businesslogics.util.Currency;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import models.Mt101PaymentForm;
import models.payments.PaymentCsvImportException;
import models.payments.PaymentCsvImportHandler;
import models.payments.PaymentException;
import models.payments.PaymentHandler;
import models.payments.PaymentUtils;
import play.i18n.Messages;

public final class Mt101PaymentCsvImportHandler
implements PaymentCsvImportHandler {
    private final User user;
    private final PaymentConversionHandler2<?> conversionHandler;
    private ConverterFormat converterFormat;
    private final List<Throwable> errors = new ArrayList<Throwable>();

    public Mt101PaymentCsvImportHandler(User user, PaymentConversionHandler2<?> conversionHandler, ConverterFormat converterFormat) {
        this.user = user;
        this.conversionHandler = conversionHandler;
        this.converterFormat = converterFormat;
    }

    @Override
    public void loadFieldsToDataMap(Map<String, String> dataMap) {
        Format format;
        if (this.converterFormat != null) {
            format = new Format(this.converterFormat.getFormat(), this.converterFormat.getCountryCode());
            if (dataMap != null && this.converterFormat.getCountryCode() != null) {
                dataMap.put("countryCode", this.converterFormat.getCountryCode());
            }
        } else {
            format = Format.DEFAULT_FORMAT;
        }
        this.loadToDataMap(dataMap, format, Format.Fields.ORIGINATOR1);
        this.loadToDataMap(dataMap, format, Format.Fields.ORIGINATOR2);
        this.loadToDataMap(dataMap, format, Format.Fields.ORIGINATOR3);
        this.loadToDataMap(dataMap, format, Format.Fields.ORIGINATOR4);
        this.loadToDataMap(dataMap, format, Format.Fields.ORIGINATOR_ACCOUNT_NUMBER);
        this.loadToDataMap(dataMap, format, Format.Fields.ORIGINATOR_BIC);
        this.loadToDataMap(dataMap, format, Format.Fields.SENDER_BIC);
        this.loadToDataMap(dataMap, format, Format.Fields.RECEIVER_BIC);
        this.loadToDataMap(dataMap, format, Format.Fields.RECIPIENT1);
        this.loadToDataMap(dataMap, format, Format.Fields.RECIPIENT2);
        this.loadToDataMap(dataMap, format, Format.Fields.RECIPIENT3);
        this.loadToDataMap(dataMap, format, Format.Fields.RECIPIENT4);
        this.loadToDataMap(dataMap, format, Format.Fields.RECIPIENT_ACCOUNT_NUMBER);
        this.loadToDataMap(dataMap, format, Format.Fields.RECIPIENT_BANK_CODE);
        this.loadToDataMap(dataMap, format, Format.Fields.INTERMEDIARY_BANK_CODE);
        this.loadToDataMap(dataMap, format, Format.Fields.AMOUNT);
        this.loadToDataMap(dataMap, format, Format.Fields.CURRENCY);
        this.loadToDataMap(dataMap, format, Format.Fields.DATE);
        this.loadToDataMap(dataMap, format, Format.Fields.PURPOSE1);
        this.loadToDataMap(dataMap, format, Format.Fields.PURPOSE2);
        this.loadToDataMap(dataMap, format, Format.Fields.PURPOSE3);
        this.loadToDataMap(dataMap, format, Format.Fields.PURPOSE4);
        this.loadToDataMap(dataMap, format, Format.Fields.TRANSACTON_REFERENCE);
    }

    @Override
    public List<CsvImport.Field> getFields(Messages messages) {
        Locale locale = messages != null ? messages.lang().locale() : Locale.getDefault();
        ArrayList<CsvImport.Field> result = new ArrayList<CsvImport.Field>();
        result.add(CsvImport.Field.getSeparator());
        result.add(CsvImport.Field.getTextField("GeneralMessages.originator", Format.Fields.ORIGINATOR1.name().toLowerCase(), true));
        result.add(CsvImport.Field.getTextField("GeneralMessages.address1", Format.Fields.ORIGINATOR2.name().toLowerCase(), false));
        result.add(CsvImport.Field.getTextField("GeneralMessages.address2", Format.Fields.ORIGINATOR3.name().toLowerCase(), false));
        result.add(CsvImport.Field.getTextField("GeneralMessages.address3", Format.Fields.ORIGINATOR4.name().toLowerCase(), false));
        result.add(CsvImport.Field.getTextField("GeneralMessages.originatorIban", Format.Fields.ORIGINATOR_ACCOUNT_NUMBER.name().toLowerCase(), true));
        result.add(CsvImport.Field.getTextField("GeneralMessages.originatorBic", Format.Fields.ORIGINATOR_BIC.name().toLowerCase(), true));
        result.add(CsvImport.Field.getTextField("GeneralMessages.sendingInstitute", Format.Fields.SENDER_BIC.name().toLowerCase(), true));
        result.add(CsvImport.Field.getTextField("GeneralMessages.receivingInstitute", Format.Fields.RECEIVER_BIC.name().toLowerCase(), true));
        result.add(CsvImport.Field.getSeparator());
        result.add(CsvImport.Field.getTextField("GeneralMessages.recipient", Format.Fields.RECIPIENT1.name().toLowerCase(), true));
        result.add(CsvImport.Field.getTextField("GeneralMessages.address1", Format.Fields.RECIPIENT2.name().toLowerCase(), false));
        result.add(CsvImport.Field.getTextField("GeneralMessages.address2", Format.Fields.RECIPIENT3.name().toLowerCase(), false));
        result.add(CsvImport.Field.getTextField("GeneralMessages.address3", Format.Fields.RECIPIENT4.name().toLowerCase(), false));
        result.add(CsvImport.Field.getTextField("GeneralMessages.recipientIban", Format.Fields.RECIPIENT_ACCOUNT_NUMBER.name().toLowerCase(), true));
        result.add(CsvImport.Field.getTextField("GeneralMessages.recipientBic", Format.Fields.RECIPIENT_BANK_CODE.name().toLowerCase(), true));
        result.add(CsvImport.Field.getTextField("GeneralMessages.intermediaryInstitutionBic", Format.Fields.INTERMEDIARY_BANK_CODE.name().toLowerCase(), false));
        result.add(CsvImport.Field.getSeparator());
        result.add(CsvImport.Field.getTextField("GeneralMessages.amount", Format.Fields.AMOUNT.name().toLowerCase(), true));
        result.add(CsvImport.Field.getSelectField("GeneralMessages.currency", Format.Fields.CURRENCY.name().toLowerCase(), true, PaymentUtils.getCurrencies()));
        result.add(CsvImport.Field.getTextField("GeneralMessages.purpose1", Format.Fields.PURPOSE1.name().toLowerCase(), false));
        result.add(CsvImport.Field.getTextField("GeneralMessages.purpose2", Format.Fields.PURPOSE2.name().toLowerCase(), false));
        result.add(CsvImport.Field.getTextField("GeneralMessages.purpose3", Format.Fields.PURPOSE3.name().toLowerCase(), false));
        result.add(CsvImport.Field.getTextField("GeneralMessages.purpose4", Format.Fields.PURPOSE4.name().toLowerCase(), false));
        result.add(CsvImport.Field.getTextField("GeneralMessages.executionDate", Format.Fields.DATE.name().toLowerCase(), false));
        result.add(CsvImport.Field.getTextField("GeneralMessages.reference", Format.Fields.TRANSACTON_REFERENCE.name().toLowerCase(), false));
        result.add(CsvImport.Field.getSelectField("GeneralMessages.feeType", Format.Fields.FEE_TYPE.name().toLowerCase(), true, Mt101PaymentForm.loadFeeTypes(locale)));
        return result;
    }

    @Override
    public String buildFormatString(Map<String, Object> formatFields, PaymentTransferType.PmtType pmtType) {
        StringBuilder result = new StringBuilder();
        this.appendFieldToFormatString(Format.Fields.ORIGINATOR1, formatFields, result);
        this.appendFieldToFormatString(Format.Fields.ORIGINATOR2, formatFields, result);
        this.appendFieldToFormatString(Format.Fields.ORIGINATOR3, formatFields, result);
        this.appendFieldToFormatString(Format.Fields.ORIGINATOR4, formatFields, result);
        this.appendFieldToFormatString(Format.Fields.ORIGINATOR_ACCOUNT_NUMBER, formatFields, result);
        this.appendFieldToFormatString(Format.Fields.ORIGINATOR_BIC, formatFields, result);
        this.appendFieldToFormatString(Format.Fields.SENDER_BIC, formatFields, result);
        this.appendFieldToFormatString(Format.Fields.RECEIVER_BIC, formatFields, result);
        this.appendFieldToFormatString(Format.Fields.RECIPIENT1, formatFields, result);
        this.appendFieldToFormatString(Format.Fields.RECIPIENT2, formatFields, result);
        this.appendFieldToFormatString(Format.Fields.RECIPIENT3, formatFields, result);
        this.appendFieldToFormatString(Format.Fields.RECIPIENT4, formatFields, result);
        this.appendFieldToFormatString(Format.Fields.RECIPIENT_ACCOUNT_NUMBER, formatFields, result);
        this.appendFieldToFormatString(Format.Fields.RECIPIENT_BANK_CODE, formatFields, result);
        this.appendFieldToFormatString(Format.Fields.INTERMEDIARY_BANK_CODE, formatFields, result);
        this.appendFieldToFormatString(Format.Fields.AMOUNT, formatFields, result);
        this.appendFieldToFormatString(Format.Fields.CURRENCY, formatFields, result);
        result.append(Format.MT101_SEPARATOR);
        this.appendFieldToFormatString(Format.Fields.DATE, formatFields, result);
        this.appendFieldToFormatString(Format.Fields.PURPOSE1, formatFields, result);
        this.appendFieldToFormatString(Format.Fields.PURPOSE2, formatFields, result);
        this.appendFieldToFormatString(Format.Fields.PURPOSE3, formatFields, result);
        this.appendFieldToFormatString(Format.Fields.PURPOSE4, formatFields, result);
        this.appendFieldToFormatString(Format.Fields.TRANSACTON_REFERENCE, formatFields, result);
        this.appendFieldToFormatString(Format.Fields.FEE_TYPE, formatFields, result);
        return result.substring(0, result.length() - 1);
    }

    @Override
    public List<PaymentHandler<?>> loadPayments(BankSettings bank, String formatString, PaymentTransferType.PmtType pmtType, String language, String[][] data, boolean stringentCheck, String encoding) {
        Format format = new Format(formatString, language);
        MT101CSVFormatParser csvParser = new MT101CSVFormatParser(format);
        boolean displaySalaries = Util.displayOpenSalaries((User)this.user);
        ArrayList result = new ArrayList(data.length);
        for (int i = 0; i < data.length; ++i) {
            try {
                Tenant tenant;
                Account account;
                MT101PaymentData paymentData = csvParser.getPaymentData(data[i], i);
                if (stringentCheck) {
                    this.checkPaymentData(paymentData, bank);
                }
                PaymentHandler<?> paymentHandler = PaymentHandler.getHandler(paymentData, pmtType);
                if (!displaySalaries && paymentHandler.isSalaryPayment()) {
                    throw new PaymentCsvImportException("sepapayment.csv.error.salarynotallowed", new Object[0]);
                }
                if (bank == null) {
                    BankSettings b;
                    account = null;
                    Iterator iterator = BankSettings.findBanksForUser((User)this.user).iterator();
                    while (iterator.hasNext() && (account = paymentHandler.getOriginatorAccount(b = (BankSettings)iterator.next())) == null) {
                    }
                    tenant = account != null ? account.getBank().getTenant() : null;
                } else {
                    account = paymentHandler.getOriginatorAccount(bank);
                    tenant = bank.getTenant();
                }
                if (new DatabasePreferenceStore(Preference.ApplicationId.SEPA, this.user, tenant).getBoolean((DatabasePreferenceConstant)de.businesslogics.banking.sepa.PreferenceConstants.SAVE_ACCOUNT_CURRENCY) && account != null && paymentData.getOriginatorBic() == null) {
                    ((MT101PaymentData)paymentHandler.getPayment()).setOriginatorBic(account.getBic());
                }
                result.add(paymentHandler);
                continue;
            }
            catch (CSVConverterException | PaymentCsvImportException | PaymentException e) {
                this.errors.add(e);
                BLLoggerPlay.error("Failed to read payment from CSV data in line " + i + "!", e);
            }
        }
        if (this.converterFormat == null) {
            this.converterFormat = new ConverterFormat();
            this.converterFormat.setTenant(TenantUtils.findTenantForConverterFormat(bank, result, this.user));
        }
        this.converterFormat.setType(ConverterFormat.Type.MT101);
        if (encoding != null && !encoding.isEmpty()) {
            this.converterFormat.setEncoding(encoding);
        }
        this.converterFormat.setFieldSeparator(String.valueOf(Format.MT101_SEPARATOR));
        this.converterFormat.setCountryCode(language);
        this.converterFormat.setFormat(formatString);
        return result;
    }

    @Override
    public PaymentType getRecipientPaymentType(User user) {
        return PaymentType.MT101;
    }

    @Override
    public PaymentType getOriginatorPaymentType() {
        return PaymentType.MT101;
    }

    @Override
    public void updateConverterFormat(boolean hasHeader) {
        if (this.converterFormat == null) {
            return;
        }
        this.converterFormat.setHasHeader(hasHeader);
        this.converterFormat.save();
    }

    private void loadToDataMap(Map<String, String> dataMap, Format format, Format.Fields field) {
        Column column = format.getColumn((FieldI)field);
        if (column != null) {
            if (column.getValue() != null && !column.getValue().isEmpty()) {
                dataMap.put(field.name().toLowerCase() + "_fix", column.getValue());
            } else {
                dataMap.put(field.name().toLowerCase(), String.valueOf(column.getColumnIndex()));
            }
        }
    }

    private void appendFieldToFormatString(Format.Fields field, Map<String, Object> fields, StringBuilder builder) {
        Object o = fields.get(field.name().toLowerCase());
        if (o != null) {
            if (o instanceof String) {
                builder.append('=');
            }
            builder.append(o);
        }
        builder.append(Format.MT101_SEPARATOR);
    }

    private void checkPaymentData(MT101PaymentData paymentData, BankSettings bank) throws PaymentCsvImportException {
        boolean allowRecipientRecording;
        if (paymentData.getOriginatorName() == null || paymentData.getOriginatorName().isEmpty()) {
            throw new PaymentCsvImportException("mt101payment.csv.missingInformation.originatorname", new Object[0]);
        }
        boolean allowOriginatorRecording = new DatabasePreferenceStore(Preference.ApplicationId.PAYMENTS, this.user).getBoolean((DatabasePreferenceConstant)PreferenceConstants.ALLOW_ORIGINATOR_RECORDING);
        if (!allowOriginatorRecording && PaymentOriginator.findOriginatorByName((PaymentType)PaymentType.MT101, (String)paymentData.getOriginatorName(), (Tenant)bank.getTenant()) == null) {
            throw new PaymentCsvImportException("mt101payment.csv.invalid.originatorname", paymentData.getOriginatorName());
        }
        if (paymentData.getRecipientName() == null || paymentData.getRecipientName().isEmpty()) {
            throw new PaymentCsvImportException("mt101payment.csv.missingInformation.recipientname", new Object[0]);
        }
        boolean bl = allowRecipientRecording = !PreferenceUtil.disableRecipientRecording((User)this.user);
        if (!allowRecipientRecording && PaymentRecipient.findRecipientByAccountInfo((PaymentType)PaymentType.MT101, (String)paymentData.getRecipientName(), (String)paymentData.getRecipientAccount(), (String)paymentData.getRecipientBankCode(), (Tenant)bank.getTenant()) == null) {
            throw new PaymentCsvImportException("mt101payment.csv.invalid.recipientname", paymentData.getRecipientAccount());
        }
        BigDecimal PAYMENT_MAX_AMOUNT = new BigDecimal("99999999999.999");
        if (PAYMENT_MAX_AMOUNT.compareTo(paymentData.getAmount()) < 0) {
            throw new PaymentCsvImportException("mt101payment.error.maxamount", de.businesslogics.util.PaymentUtils.formatAmount((BigDecimal)paymentData.getAmount(), (Currency)paymentData.getCurrency()));
        }
    }

    @Override
    public Set<String> getErrorMessages(Messages messages) {
        HashSet<String> result = new HashSet<String>(this.errors.size());
        for (Throwable t : this.errors) {
            if (t instanceof PaymentCsvImportException) {
                result.add(((PaymentCsvImportException)t).getMessage(messages));
                continue;
            }
            result.add(t.getMessage());
        }
        return result;
    }
}

