/*
 * Decompiled with CFR 0.152.
 */
package models.payments;

import de.businesslogics.banking.database.vo.PaymentRecipient;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.format.sepa.StatusCode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LoadVopRecipientNamesForm {
    public Map<Integer, Boolean> selectedRecipients = new HashMap<Integer, Boolean>();

    public List<RecipientVopResult> loadRecipientsMap(User user, List<Integer> recipientIds) {
        this.selectedRecipients = new HashMap<Integer, Boolean>();
        ArrayList<RecipientVopResult> result = new ArrayList<RecipientVopResult>();
        List recipients2 = recipientIds != null && !recipientIds.isEmpty() ? PaymentRecipient.findByIds(recipientIds, (User)user) : PaymentRecipient.findRecipients((User)user).findList();
        for (PaymentRecipient recipient : recipients2) {
            String vopName = recipient.getVopName();
            if (!StatusCode.VopResultCodes.RVMC.name().equals(recipient.getVopResult()) || vopName == null || vopName.isEmpty() || vopName.equals(recipient.getName())) continue;
            result.add(new RecipientVopResult(recipient.getId(), recipient.getName(), vopName));
            this.selectedRecipients.put(recipient.getId(), true);
        }
        return result;
    }

    public static final class RecipientVopResult {
        public final Integer recipientId;
        public final String currentName;
        public final String vopName;

        public RecipientVopResult(Integer recipientId, String currentName, String vopName) {
            this.recipientId = recipientId;
            this.currentName = currentName;
            this.vopName = vopName;
        }
    }
}

