/*
 * Decompiled with CFR 0.152.
 */
package models.payments;

import controllers.util.BLLoggerPlay;
import de.businesslogics.banking.api.BankUtils;
import de.businesslogics.banking.api.CountriesLoader;
import de.businesslogics.banking.database.vo.Account;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.database.vo.OpenPayment;
import de.businesslogics.banking.database.vo.PaymentOriginator;
import de.businesslogics.banking.database.vo.PaymentProperties;
import de.businesslogics.banking.database.vo.PaymentRecipient;
import de.businesslogics.banking.database.vo.PaymentTransferType;
import de.businesslogics.banking.database.vo.PaymentType;
import de.businesslogics.banking.database.vo.Send;
import de.businesslogics.banking.database.vo.SignedPayment;
import de.businesslogics.banking.database.vo.Tenant;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.banking.dta.api.DtazvApi;
import de.businesslogics.banking.dta.api.DtazvOriginatorData;
import de.businesslogics.banking.dta.api.DtazvPaymentPrinter;
import de.businesslogics.banking.dta.api.DtazvRecipientData;
import de.businesslogics.banking.payments.api.RecipientData;
import de.businesslogics.format.dta.DTAReader;
import de.businesslogics.format.dta.DTAWriter;
import de.businesslogics.format.dta.DTAZVPayment;
import de.businesslogics.format.dta.DTAZVTransaction;
import de.businesslogics.iban.IbanUtil;
import de.businesslogics.pdf.BLDocument;
import de.businesslogics.pdf.PDFException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import models.DtazvPaymentForm;
import models.payments.PaymentException;
import models.payments.PaymentHandler;
import models.payments.PaymentUtils;

public final class DtazvPaymentHandler
extends PaymentHandler<DTAZVPayment> {
    static boolean handlesPmtType(PaymentTransferType.PmtType pmtType) {
        return DtazvApi.isDtazvPmtType((PaymentTransferType.PmtType)pmtType);
    }

    static List<DtazvPaymentHandler> getDtazvHandlers(InputStream inputStream) throws PaymentException {
        ArrayList<DtazvPaymentHandler> result = new ArrayList<DtazvPaymentHandler>();
        try {
            DTAZVPayment payment;
            DTAReader reader = new DTAReader(inputStream);
            int sequenceNumber = 1;
            do {
                if ((payment = DTAZVPayment.readFrom((DTAReader)reader)) == null) continue;
                for (DTAZVTransaction transaction : payment.getTransactions()) {
                    DTAZVPayment toAdd = new DTAZVPayment();
                    toAdd.setCreationDate(payment.getCreationDate());
                    toAdd.setExecutionDate(payment.getExecutionDate());
                    toAdd.setOriginator(payment.getOriginator());
                    toAdd.setOriginator2(payment.getOriginator2());
                    toAdd.setOriginator3(payment.getOriginator3());
                    toAdd.setOriginator4(payment.getOriginator4());
                    toAdd.setSequentialNumber(payment.getSequentialNumber());
                    toAdd.setBlz(payment.getBlz());
                    toAdd.setCustomerNumber(payment.getCustomerNumber());
                    toAdd.getTransactions().add(transaction);
                    result.add(new DtazvPaymentHandler(toAdd, sequenceNumber++));
                }
            } while (payment != null);
        }
        catch (IOException e) {
            throw new PaymentException("Failed to parse DTAZV payments from input stream!", e);
        }
        return result;
    }

    DtazvPaymentHandler(PaymentTransferType.PmtType pmtType, byte[] rawPaymentData, int sequenceNumber) throws PaymentException {
        super(pmtType, rawPaymentData, sequenceNumber);
    }

    DtazvPaymentHandler(DTAZVPayment payment, int sequenceNumber) {
        super(payment, sequenceNumber);
    }

    @Override
    public String getOriginator() {
        return ((DTAZVPayment)this.payment).getOriginator();
    }

    @Override
    public boolean setOriginator(PaymentOriginator paymentOriginator) {
        if (paymentOriginator == null || paymentOriginator.getPaymentType() != PaymentType.DTAZV) {
            return false;
        }
        DtazvOriginatorData dtazvOriginator = new DtazvOriginatorData();
        try {
            dtazvOriginator.setPaymentOriginator(paymentOriginator);
            ((DTAZVPayment)this.payment).setOriginator(dtazvOriginator.getName());
            ((DTAZVPayment)this.payment).setOriginator2(dtazvOriginator.getName2());
            ((DTAZVPayment)this.payment).setOriginator3(dtazvOriginator.getStreet());
            ((DTAZVPayment)this.payment).setOriginator4(dtazvOriginator.getTown());
            ((DTAZVTransaction)((DTAZVPayment)this.payment).getTransactions().get(0)).setContact(dtazvOriginator.getContact());
            return true;
        }
        catch (IOException e) {
            BLLoggerPlay.error("Failed to load DTAZV originator information for originator " + paymentOriginator.getId() + "!", e);
            return false;
        }
    }

    @Override
    public Account getOriginatorAccount(BankSettings bankSettings) {
        DTAZVTransaction transaction = (DTAZVTransaction)((DTAZVPayment)this.payment).getTransactions().get(0);
        String accountCurrency = transaction.getAccountCurrency() != null ? transaction.getAccountCurrency() : transaction.getCurrency();
        Account account = Account.findGermanAccount((BankSettings)bankSettings, (String)String.valueOf(transaction.getBlz()), (String)String.valueOf(transaction.getAccount()), (String)accountCurrency);
        if (account == null) {
            account = Account.findGermanAccount((BankSettings)bankSettings, (String)String.valueOf(transaction.getBlz()), (String)String.valueOf(transaction.getAccount()), null);
        }
        return account;
    }

    @Override
    public String getOriginatorAccount() {
        DTAZVTransaction transaction = (DTAZVTransaction)((DTAZVPayment)this.payment).getTransactions().get(0);
        return Account.getGermanDisplayName((String)String.valueOf(((DTAZVPayment)this.payment).getBlz()), (String)String.valueOf(transaction.getAccount()), (String)transaction.getAccountCurrency(), null, (boolean)false, (boolean)false);
    }

    @Override
    public boolean setOriginatorAccount(Account account) {
        if (account == null || account.getGermanAccountNumber() == null || account.getGermanBankCode() == null) {
            return false;
        }
        ((DTAZVPayment)this.payment).setBlz(Integer.parseInt(account.getGermanBankCode()));
        ((DTAZVTransaction)((DTAZVPayment)this.payment).getTransactions().get(0)).setAccount(Long.parseLong(account.getGermanAccountNumber()));
        ((DTAZVTransaction)((DTAZVPayment)this.payment).getTransactions().get(0)).setBlz(((DTAZVPayment)this.payment).getBlz());
        ((DTAZVTransaction)((DTAZVPayment)this.payment).getTransactions().get(0)).setAccountCurrency(account.getCurrency());
        return true;
    }

    @Override
    public String getAccountRepresentation(Account account) {
        if (account != null) {
            return Account.getGermanDisplayName((Account)account, (boolean)true, (boolean)false);
        }
        Account dummyAccount = new Account();
        dummyAccount.setGermanAccountNumber(String.valueOf(((DTAZVTransaction)((DTAZVPayment)this.payment).getTransactions().get(0)).getAccount()));
        dummyAccount.setGermanBankCode(String.valueOf(((DTAZVPayment)this.payment).getBlz()));
        return Account.getGermanDisplayName((Account)dummyAccount, (boolean)false, (boolean)false);
    }

    @Override
    public String getRecipientAccountNumber() {
        return ((DTAZVTransaction)((DTAZVPayment)this.payment).getTransactions().get(0)).getIban();
    }

    @Override
    public String getRecipientNameAndAccount() {
        return ((DTAZVTransaction)((DTAZVPayment)this.payment).getTransactions().get(0)).getRecipient() + " (" + IbanUtil.formatIfIBAN((String)((DTAZVTransaction)((DTAZVPayment)this.payment).getTransactions().get(0)).getIban().substring(1)) + ")";
    }

    @Override
    public String getRecipientBankcode() {
        return ((DTAZVTransaction)((DTAZVPayment)this.payment).getTransactions().get(0)).getBic();
    }

    @Override
    public String getRecipientAccount() {
        Account account = new Account();
        DTAZVTransaction transaction = (DTAZVTransaction)((DTAZVPayment)this.payment).getTransactions().get(0);
        if (transaction.getIban() != null && !transaction.getIban().isEmpty() && transaction.getIban().charAt(0) == '/') {
            account.setIban(transaction.getIban().substring(1));
        } else {
            account.setIban(transaction.getIban());
        }
        account.setBic(transaction.getBic());
        return Account.getDefaultDisplayName((Account)account);
    }

    @Override
    public boolean isSalaryPayment() {
        return false;
    }

    @Override
    public boolean isCredit() {
        return true;
    }

    @Override
    public boolean isUrgent(PaymentTransferType.PmtType pmtType) {
        return false;
    }

    @Override
    public Date getExecutionDate() {
        return ((DTAZVPayment)this.payment).getExecutionDate();
    }

    @Override
    public String getRecipient() {
        return ((DTAZVTransaction)((DTAZVPayment)this.payment).getTransactions().get(0)).getRecipient();
    }

    @Override
    public BigDecimal getAmount() {
        return ((DTAZVTransaction)((DTAZVPayment)this.payment).getTransactions().get(0)).getAmount();
    }

    @Override
    public String getRecipientCountry() {
        return ((DTAZVTransaction)((DTAZVPayment)this.payment).getTransactions().get(0)).getRecipientCountry();
    }

    @Override
    public String getCurrencyCode() {
        DTAZVTransaction transaction = (DTAZVTransaction)((DTAZVPayment)this.payment).getTransactions().get(0);
        if (transaction.getInstructionCode4() == 91) {
            return "EUR";
        }
        return ((DTAZVTransaction)((DTAZVPayment)this.payment).getTransactions().get(0)).getCurrency();
    }

    @Override
    public String getPurpose() {
        return ((DTAZVTransaction)((DTAZVPayment)this.payment).getTransactions().get(0)).getPurpose();
    }

    @Override
    public void setPurpose(List<String> purpose) {
        DTAZVTransaction transaction = (DTAZVTransaction)((DTAZVPayment)this.payment).getTransactions().get(0);
        if (purpose == null || purpose.isEmpty()) {
            transaction.setPurpose(null);
            transaction.setPurpose2(null);
            transaction.setPurpose3(null);
            transaction.setPurpose4(null);
        } else {
            transaction.setPurpose(purpose.get(0));
            if (purpose.size() > 1) {
                transaction.setPurpose2(purpose.get(1));
            } else {
                transaction.setPurpose2(null);
            }
            if (purpose.size() > 2) {
                transaction.setPurpose3(purpose.get(2));
            } else {
                transaction.setPurpose3(null);
            }
            if (purpose.size() > 3) {
                transaction.setPurpose4(purpose.get(3));
            } else {
                transaction.setPurpose4(null);
            }
        }
    }

    @Override
    public boolean replaceInPurpose(String what, String by) {
        String replace;
        int maxLineLength = 35;
        int maxLineCount = 4;
        if (by == null) {
            by = "";
        }
        by = DtazvPaymentForm.convertToDtazvStringFormat(by, 140);
        DTAZVTransaction transaction = (DTAZVTransaction)((DTAZVPayment)this.payment).getTransactions().getFirst();
        if (what == null || what.isEmpty()) {
            String[] newPurpose = PaymentUtils.createDtazvPurposeLines(by);
            if (newPurpose.length > 0) {
                transaction.setPurpose(newPurpose[0]);
            } else {
                transaction.setPurpose("");
            }
            if (newPurpose.length > 1) {
                transaction.setPurpose2(newPurpose[1]);
            } else {
                transaction.setPurpose2("");
            }
            if (newPurpose.length > 2) {
                transaction.setPurpose3(newPurpose[2]);
            } else {
                transaction.setPurpose3("");
            }
            if (newPurpose.length > 3) {
                transaction.setPurpose4(newPurpose[3]);
            } else {
                transaction.setPurpose4("");
            }
            return true;
        }
        boolean modified = false;
        if (transaction.getPurpose() != null) {
            replace = transaction.getPurpose().replace(what, by);
            if (!(replace = replace.substring(0, Math.min(replace.length(), 35))).equals(transaction.getPurpose())) {
                transaction.setPurpose(replace);
                modified = true;
            }
        }
        if (transaction.getPurpose2() != null) {
            replace = transaction.getPurpose2().replace(what, by);
            if (!(replace = replace.substring(0, Math.min(replace.length(), 35))).equals(transaction.getPurpose2())) {
                transaction.setPurpose2(replace);
                modified = true;
            }
        }
        if (transaction.getPurpose3() != null) {
            replace = transaction.getPurpose3().replace(what, by);
            if (!(replace = replace.substring(0, Math.min(replace.length(), 35))).equals(transaction.getPurpose3())) {
                transaction.setPurpose3(replace);
                modified = true;
            }
        }
        if (transaction.getPurpose4() != null) {
            replace = transaction.getPurpose4().replace(what, by);
            if (!(replace = replace.substring(0, Math.min(replace.length(), 35))).equals(transaction.getPurpose4())) {
                transaction.setPurpose4(replace);
                modified = true;
            }
        }
        return modified;
    }

    @Override
    protected String getOrderType(String orderOrFileType, BankSettings bank) {
        if (BankUtils.isProtocolH005OrNewer((String)bank.getProtocolVersion())) {
            return "BTU";
        }
        return orderOrFileType;
    }

    @Override
    protected String getFileFormat(String orderOrFileType, BankSettings bank) {
        if (BankUtils.isProtocolH005OrNewer((String)bank.getProtocolVersion())) {
            return orderOrFileType;
        }
        return null;
    }

    @Override
    public void print(BLDocument document, Locale locale, String orderType, SignedPayment signedPayment) throws PDFException {
        Send send = signedPayment != null ? signedPayment.getSend() : null;
        new DtazvPaymentPrinter(locale, CountriesLoader.getInstance((Locale)locale), orderType, send).printPayment(document, (DTAZVPayment)this.payment, null);
    }

    @Override
    public void setEarliestExecutionDate(Date executionDate, BankSettings bank, PaymentProperties paymentProperties) {
        ((DTAZVPayment)this.payment).setExecutionDate(executionDate);
        ((DTAZVTransaction)((DTAZVPayment)this.payment).getTransactions().get(0)).setExecutionDate(executionDate);
    }

    @Override
    public boolean isExecutionDateExceeded(PaymentProperties paymentProperties, String orderOrFileType) {
        if (((DTAZVPayment)this.payment).getExecutionDate() != null) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(((DTAZVPayment)this.payment).getExecutionDate());
            cal.add(5, 1);
            return new Date().after(cal.getTime());
        }
        return false;
    }

    @Override
    public boolean isExecutionDateTooEarly(PaymentProperties paymentProperties) {
        if (((DTAZVPayment)this.payment).getExecutionDate() != null) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(((DTAZVPayment)this.payment).getExecutionDate());
            cal.add(5, -15);
            return new Date().before(cal.getTime());
        }
        return false;
    }

    @Override
    public String getCorrectionMessage(PaymentProperties paymentProperties, Locale locale) {
        return null;
    }

    @Override
    public int getMaxExecutionDateOffset(PaymentProperties paymentProperties) {
        return 15;
    }

    @Override
    public void correctPayment(OpenPayment vo, User user) {
    }

    public DtazvOriginatorData buildOriginator(Tenant tenant) throws PaymentException {
        PaymentOriginator paymentOriginator = PaymentOriginator.findOriginatorByName((PaymentType)PaymentType.DTAZV, (String)((DTAZVPayment)this.payment).getOriginator(), (Tenant)tenant);
        if (paymentOriginator == null) {
            paymentOriginator = new PaymentOriginator();
            paymentOriginator.setPaymentType(PaymentType.DTAZV);
            paymentOriginator.setName(((DTAZVPayment)this.payment).getOriginator());
            paymentOriginator.setTenant(tenant);
        }
        DtazvOriginatorData dtazvOriginatorData = new DtazvOriginatorData();
        DTAZVTransaction transaction = (DTAZVTransaction)((DTAZVPayment)this.payment).getTransactions().get(0);
        try {
            dtazvOriginatorData.setPaymentOriginator(paymentOriginator);
        }
        catch (IOException e) {
            throw new PaymentException("Failed to load DTAZV originator info!", e);
        }
        dtazvOriginatorData.setContact(transaction.getContact());
        dtazvOriginatorData.setName2(((DTAZVPayment)this.payment).getOriginator2());
        dtazvOriginatorData.setStreet(((DTAZVPayment)this.payment).getOriginator3());
        dtazvOriginatorData.setTown(((DTAZVPayment)this.payment).getOriginator4());
        return dtazvOriginatorData;
    }

    public DtazvRecipientData buildRecipient(boolean forceNewRecipient, Integer recipientId, PaymentType paymentType, Tenant tenant, List<Tenant> admissibleTenants, boolean allowRecipientModification) throws PaymentException {
        if (paymentType != PaymentType.DTAZV) {
            throw new PaymentException("Invalid payment type for DTAZV recipients: " + paymentType.name());
        }
        DTAZVTransaction transaction = (DTAZVTransaction)((DTAZVPayment)this.payment).getTransactions().get(0);
        PaymentRecipient paymentRecipient = null;
        if (!forceNewRecipient) {
            if (recipientId != null) {
                paymentRecipient = PaymentRecipient.findByIdAndTenants((int)recipientId, admissibleTenants);
            }
            if (paymentRecipient == null) {
                paymentRecipient = PaymentRecipient.findRecipientByAccountInfo(Collections.singletonList(PaymentType.DTAZV), (String)transaction.getRecipient(), (String)this.getRecipientAccount(), (String)transaction.getBic(), admissibleTenants);
            }
        }
        if (!allowRecipientModification && paymentRecipient != null) {
            return null;
        }
        if (paymentRecipient == null) {
            paymentRecipient = new PaymentRecipient();
            paymentRecipient.setTenant(tenant);
            paymentRecipient.setDisplayName(RecipientData.getUniqueDisplayName((String)transaction.getRecipient(), (PaymentType)PaymentType.DTAZV, (Tenant)tenant));
        }
        paymentRecipient.setPaymentType(PaymentType.DTAZV);
        paymentRecipient.setName(transaction.getRecipient());
        paymentRecipient.setAccountNumber(this.getRecipientAccount());
        paymentRecipient.setBankCode(transaction.getBic());
        paymentRecipient.setBankName(transaction.getBank());
        DtazvRecipientData dtazvRecipient = new DtazvRecipientData();
        try {
            dtazvRecipient.setPaymentRecipient(paymentRecipient);
        }
        catch (IOException e) {
            throw new PaymentException("Failed to load DTAZV recipient info!", e);
        }
        dtazvRecipient.setName2(transaction.getRecipient2());
        dtazvRecipient.setStreet(transaction.getRecipient3());
        dtazvRecipient.setTown(transaction.getRecipient4());
        dtazvRecipient.setCountry(transaction.getRecipientCountry());
        dtazvRecipient.setBankName2(transaction.getBank2());
        dtazvRecipient.setBankStreet(transaction.getBank3());
        dtazvRecipient.setBankTown(transaction.getBank4());
        dtazvRecipient.setBankCountry(transaction.getBankCountry());
        dtazvRecipient.setPurpose1(transaction.getPurpose());
        dtazvRecipient.setPurpose2(transaction.getPurpose2());
        dtazvRecipient.setPurpose3(transaction.getPurpose3());
        dtazvRecipient.setPurpose4(transaction.getPurpose4());
        dtazvRecipient.setFeeType(Byte.toString(transaction.getFeeType()));
        return dtazvRecipient;
    }

    @Override
    public byte[] buildPaymentData(BankSettings bank) throws PaymentException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ((DTAZVPayment)this.payment).writeTo(new DTAWriter((OutputStream)baos));
        }
        catch (IOException e) {
            throw new PaymentException("Failed to write DTAZV payment information: " + e.getLocalizedMessage(), e);
        }
        finally {
            try {
                baos.close();
            }
            catch (IOException e) {
                BLLoggerPlay.getLogger().logError("Failed to close stream!", (Throwable)e);
            }
        }
        return baos.toByteArray();
    }

    @Override
    public boolean updatePaymentAfterGeneration() {
        return false;
    }

    @Override
    public boolean checkRecipientAccount() {
        return true;
    }

    @Override
    protected DTAZVPayment loadPayment(PaymentTransferType.PmtType pmtType, byte[] rawPaymentData) throws PaymentException {
        ByteArrayInputStream bais = new ByteArrayInputStream(rawPaymentData);
        try {
            DTAZVPayment dTAZVPayment = DTAZVPayment.readFrom((DTAReader)new DTAReader((InputStream)bais));
            return dTAZVPayment;
        }
        catch (IOException e) {
            throw new PaymentException("Failed to read DTAZV payment data: " + e.getLocalizedMessage(), e);
        }
        finally {
            try {
                ((InputStream)bais).close();
            }
            catch (IOException e) {
                BLLoggerPlay.getLogger().logError("Failed to close stream!", (Throwable)e);
            }
        }
    }

    @Override
    protected String loadReference(int sequenceNumber) {
        return ((DTAZVPayment)this.payment).getSequentialNumber() + "/" + sequenceNumber;
    }

    @Override
    protected boolean internalResetReference() {
        return true;
    }

    @Override
    public PaymentTransferType.PmtType getPaymentType(PaymentTransferType.PmtType defaultType) {
        return DtazvApi.getPmtType();
    }
}

