/*
 * Decompiled with CFR 0.152.
 */
package models.payments;

import controllers.util.BLLoggerPlay;
import controllers.util.CsvImport;
import controllers.util.TenantUtils;
import de.businesslogics.banking.api.CountriesLoader;
import de.businesslogics.banking.api.DatabasePreferenceConstant;
import de.businesslogics.banking.api.DatabasePreferenceStore;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.database.vo.ConverterFormat;
import de.businesslogics.banking.database.vo.PaymentTransferType;
import de.businesslogics.banking.database.vo.PaymentType;
import de.businesslogics.banking.database.vo.Preference;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.banking.dta.api.DtazvApi;
import de.businesslogics.banking.payments.api.PaymentConversionHandler;
import de.businesslogics.banking.payments.core.PreferenceConstants;
import de.businesslogics.format.csv.Column;
import de.businesslogics.format.dta.DTAZVPayment;
import de.businesslogics.format.dta.DTAZVTransaction;
import de.businesslogics.format.dta.csv.Format;
import de.businesslogics.iban.IbanUtil;
import de.businesslogics.validation.RegularExpressions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import models.payments.PaymentCsvImportException;
import models.payments.PaymentCsvImportHandler;
import models.payments.PaymentException;
import models.payments.PaymentHandler;
import models.payments.PaymentUtils;
import play.i18n.Messages;
import scala.Tuple2;
import scala.collection.immutable.Seq;

public final class DtazvPaymentCsvImportHandler
implements PaymentCsvImportHandler {
    private final User user;
    private final PaymentConversionHandler<?> conversionHandler;
    private ConverterFormat converterFormat;
    private final List<Throwable> errors = new ArrayList<Throwable>();

    public DtazvPaymentCsvImportHandler(User user, PaymentConversionHandler<?> conversionHandler, ConverterFormat converterFormat) {
        this.user = user;
        this.conversionHandler = conversionHandler;
        this.converterFormat = converterFormat;
    }

    @Override
    public void loadFieldsToDataMap(Map<String, String> dataMap) {
        Format format;
        if (this.converterFormat != null) {
            format = new Format(this.converterFormat.getFormat(), this.converterFormat.getCountryCode());
            if (dataMap != null && this.converterFormat.getCountryCode() != null) {
                dataMap.put("countryCode", this.converterFormat.getCountryCode());
            }
        } else {
            format = (Format)this.conversionHandler.getDefaultFormat();
        }
        this.loadToDataMap(dataMap, format, Format.Fields.ORIGINATOR_NAME);
        this.loadToDataMap(dataMap, format, Format.Fields.ORIGINATOR_NAME2);
        this.loadToDataMap(dataMap, format, Format.Fields.ORIGINATOR_STREET);
        this.loadToDataMap(dataMap, format, Format.Fields.ORIGINATOR_TOWN);
        this.loadToDataMap(dataMap, format, Format.Fields.REFERENCE);
        this.loadToDataMap(dataMap, format, Format.Fields.ORIGINATOR_ACCOUNT_NUMBER);
        this.loadToDataMap(dataMap, format, Format.Fields.ORIGINATOR_BLZ);
        this.loadToDataMap(dataMap, format, Format.Fields.ORIGINATOR_ACCOUNT_CURRENCY);
        this.loadToDataMap(dataMap, format, Format.Fields.RECIPIENT_NAME);
        this.loadToDataMap(dataMap, format, Format.Fields.RECIPIENT_NAME2);
        this.loadToDataMap(dataMap, format, Format.Fields.RECIPIENT_STREET);
        this.loadToDataMap(dataMap, format, Format.Fields.RECIPIENT_TOWN);
        this.loadToDataMap(dataMap, format, Format.Fields.RECIPIENT_COUNTRY);
        this.loadToDataMap(dataMap, format, Format.Fields.RECIPIENT_ACCOUNT_NUMBER);
        this.loadToDataMap(dataMap, format, Format.Fields.RECIPIENT_BANK_CODE);
        this.loadToDataMap(dataMap, format, Format.Fields.RECIPIENT_BANK_NAME);
        this.loadToDataMap(dataMap, format, Format.Fields.RECIPIENT_BANK_NAME2);
        this.loadToDataMap(dataMap, format, Format.Fields.RECIPIENT_BANK_STREET);
        this.loadToDataMap(dataMap, format, Format.Fields.RECIPIENT_BANK_TOWN);
        this.loadToDataMap(dataMap, format, Format.Fields.RECIPIENT_BANK_COUNTRY);
        this.loadToDataMap(dataMap, format, Format.Fields.AMOUNT);
        this.loadToDataMap(dataMap, format, Format.Fields.CURRENCY);
        this.loadToDataMap(dataMap, format, Format.Fields.DATE);
        this.loadToDataMap(dataMap, format, Format.Fields.PURPOSE1);
        this.loadToDataMap(dataMap, format, Format.Fields.PURPOSE2);
        this.loadToDataMap(dataMap, format, Format.Fields.PURPOSE3);
        this.loadToDataMap(dataMap, format, Format.Fields.PURPOSE4);
        this.loadToDataMap(dataMap, format, Format.Fields.FEE_TYPE);
        this.loadToDataMap(dataMap, format, Format.Fields.INSTRUCTION_CODE1);
        this.loadToDataMap(dataMap, format, Format.Fields.INSTRUCTION_CODE2);
        this.loadToDataMap(dataMap, format, Format.Fields.INSTRUCTION_CODE3);
        this.loadToDataMap(dataMap, format, Format.Fields.INSTRUCTION_CODE4);
        this.loadToDataMap(dataMap, format, Format.Fields.INSTRUCTIONS);
        this.loadToDataMap(dataMap, format, Format.Fields.PAYMENT_TYPE);
    }

    @Override
    public List<CsvImport.Field> getFields(Messages messages) {
        Locale locale = messages != null ? messages.lang().locale() : Locale.getDefault();
        ArrayList<CsvImport.Field> result = new ArrayList<CsvImport.Field>();
        result.add(CsvImport.Field.getSeparator());
        result.add(CsvImport.Field.getTextField("GeneralMessages.originator", Format.Fields.ORIGINATOR_NAME.name().toLowerCase(), true));
        result.add(CsvImport.Field.getTextField("GeneralMessages.name2", Format.Fields.ORIGINATOR_NAME2.name().toLowerCase(), false));
        result.add(CsvImport.Field.getTextField("GeneralMessages.street", Format.Fields.ORIGINATOR_STREET.name().toLowerCase(), false));
        result.add(CsvImport.Field.getTextField("GeneralMessages.city", Format.Fields.ORIGINATOR_TOWN.name().toLowerCase(), false));
        result.add(CsvImport.Field.getTextField("GeneralMessages.reference", Format.Fields.REFERENCE.name().toLowerCase(), false));
        result.add(CsvImport.Field.getTextField("GeneralMessages.originatorAccountNumber", Format.Fields.ORIGINATOR_ACCOUNT_NUMBER.name().toLowerCase(), true));
        result.add(CsvImport.Field.getTextField("GeneralMessages.originatorBlz", Format.Fields.ORIGINATOR_BLZ.name().toLowerCase(), true));
        result.add(CsvImport.Field.getSelectField("GeneralMessages.accountCurrency", Format.Fields.ORIGINATOR_ACCOUNT_CURRENCY.name().toLowerCase(), true, PaymentUtils.getCurrencies(true)));
        result.add(CsvImport.Field.getSeparator());
        result.add(CsvImport.Field.getTextField("GeneralMessages.recipient", Format.Fields.RECIPIENT_NAME.name().toLowerCase(), true));
        result.add(CsvImport.Field.getTextField("GeneralMessages.name2", Format.Fields.RECIPIENT_NAME2.name().toLowerCase(), false));
        result.add(CsvImport.Field.getTextField("GeneralMessages.street", Format.Fields.RECIPIENT_STREET.name().toLowerCase(), false));
        result.add(CsvImport.Field.getTextField("GeneralMessages.city", Format.Fields.RECIPIENT_TOWN.name().toLowerCase(), false));
        Seq<Tuple2<String, String>> countries = PaymentUtils.getCountries(locale, true);
        result.add(CsvImport.Field.getSelectField("GeneralMessages.countryCode", Format.Fields.RECIPIENT_COUNTRY.name().toLowerCase(), true, countries));
        result.add(CsvImport.Field.getTextField("GeneralMessages.accountNumberIban", Format.Fields.RECIPIENT_ACCOUNT_NUMBER.name().toLowerCase(), true));
        result.add(CsvImport.Field.getTextField("GeneralMessages.blzBic", Format.Fields.RECIPIENT_BANK_CODE.name().toLowerCase(), true));
        result.add(CsvImport.Field.getTextField("GeneralMessages.recipientBank", Format.Fields.RECIPIENT_BANK_NAME.name().toLowerCase(), true));
        result.add(CsvImport.Field.getTextField("GeneralMessages.name2", Format.Fields.RECIPIENT_BANK_NAME2.name().toLowerCase(), false));
        result.add(CsvImport.Field.getTextField("GeneralMessages.street", Format.Fields.RECIPIENT_BANK_STREET.name().toLowerCase(), false));
        result.add(CsvImport.Field.getTextField("GeneralMessages.city", Format.Fields.RECIPIENT_BANK_TOWN.name().toLowerCase(), false));
        result.add(CsvImport.Field.getSelectField("GeneralMessages.countryCode", Format.Fields.RECIPIENT_BANK_COUNTRY.name().toLowerCase(), false, countries));
        result.add(CsvImport.Field.getSeparator());
        result.add(CsvImport.Field.getTextField("GeneralMessages.amount", Format.Fields.AMOUNT.name().toLowerCase(), true));
        result.add(CsvImport.Field.getSelectField("GeneralMessages.currency", Format.Fields.CURRENCY.name().toLowerCase(), true, PaymentUtils.getCurrencies(false)));
        result.add(CsvImport.Field.getTextField("GeneralMessages.executionDate", Format.Fields.DATE.name().toLowerCase(), true));
        result.add(CsvImport.Field.getTextField("GeneralMessages.purpose1", Format.Fields.PURPOSE1.name().toLowerCase(), true));
        result.add(CsvImport.Field.getTextField("GeneralMessages.purpose2", Format.Fields.PURPOSE2.name().toLowerCase(), false));
        result.add(CsvImport.Field.getTextField("GeneralMessages.purpose3", Format.Fields.PURPOSE3.name().toLowerCase(), false));
        result.add(CsvImport.Field.getTextField("GeneralMessages.purpose4", Format.Fields.PURPOSE4.name().toLowerCase(), false));
        result.add(CsvImport.Field.getSelectField("GeneralMessages.feeType", Format.Fields.FEE_TYPE.name().toLowerCase(), true, PaymentUtils.getDtazvFeeTypes(locale)));
        Seq<Tuple2<String, String>> instructionCodes = PaymentUtils.getDtazvInstructionCodes(false, locale);
        result.add(CsvImport.Field.getSelectField("GeneralMessages.instructioncode1", Format.Fields.INSTRUCTION_CODE1.name().toLowerCase(), false, instructionCodes));
        result.add(CsvImport.Field.getSelectField("GeneralMessages.instructioncode2", Format.Fields.INSTRUCTION_CODE2.name().toLowerCase(), false, instructionCodes));
        result.add(CsvImport.Field.getSelectField("GeneralMessages.instructioncode3", Format.Fields.INSTRUCTION_CODE3.name().toLowerCase(), false, instructionCodes));
        result.add(CsvImport.Field.getSelectField("GeneralMessages.instructioncode4", Format.Fields.INSTRUCTION_CODE4.name().toLowerCase(), false, instructionCodes));
        result.add(CsvImport.Field.getTextField("GeneralMessages.additionalInformation", Format.Fields.INSTRUCTIONS.name().toLowerCase(), false));
        result.add(CsvImport.Field.getSelectField("GeneralMessages.paymentMethod", Format.Fields.PAYMENT_TYPE.name().toLowerCase(), true, PaymentUtils.getDtazvPaymentTypes(locale)));
        return result;
    }

    @Override
    public String buildFormatString(Map<String, Object> formatFields, PaymentTransferType.PmtType pmtType) {
        StringBuilder result = new StringBuilder();
        this.appendFieldToFormatString(Format.Fields.ORIGINATOR_NAME, formatFields, result);
        this.appendFieldToFormatString(Format.Fields.ORIGINATOR_NAME2, formatFields, result);
        this.appendFieldToFormatString(Format.Fields.ORIGINATOR_STREET, formatFields, result);
        this.appendFieldToFormatString(Format.Fields.ORIGINATOR_TOWN, formatFields, result);
        this.appendFieldToFormatString(Format.Fields.ORIGINATOR_ACCOUNT_NUMBER, formatFields, result);
        this.appendFieldToFormatString(Format.Fields.ORIGINATOR_BLZ, formatFields, result);
        this.appendFieldToFormatString(Format.Fields.ORIGINATOR_ACCOUNT_CURRENCY, formatFields, result);
        this.appendFieldToFormatString(Format.Fields.RECIPIENT_NAME, formatFields, result);
        this.appendFieldToFormatString(Format.Fields.RECIPIENT_NAME2, formatFields, result);
        this.appendFieldToFormatString(Format.Fields.RECIPIENT_STREET, formatFields, result);
        this.appendFieldToFormatString(Format.Fields.RECIPIENT_TOWN, formatFields, result);
        this.appendFieldToFormatString(Format.Fields.RECIPIENT_COUNTRY, formatFields, result);
        this.appendFieldToFormatString(Format.Fields.RECIPIENT_ACCOUNT_NUMBER, formatFields, result);
        this.appendFieldToFormatString(Format.Fields.RECIPIENT_BANK_CODE, formatFields, result);
        this.appendFieldToFormatString(Format.Fields.RECIPIENT_BANK_NAME, formatFields, result);
        this.appendFieldToFormatString(Format.Fields.RECIPIENT_BANK_NAME2, formatFields, result);
        this.appendFieldToFormatString(Format.Fields.RECIPIENT_BANK_STREET, formatFields, result);
        this.appendFieldToFormatString(Format.Fields.RECIPIENT_BANK_TOWN, formatFields, result);
        this.appendFieldToFormatString(Format.Fields.RECIPIENT_BANK_COUNTRY, formatFields, result);
        this.appendFieldToFormatString(Format.Fields.AMOUNT, formatFields, result);
        this.appendFieldToFormatString(Format.Fields.CURRENCY, formatFields, result);
        this.appendFieldToFormatString(Format.Fields.DATE, formatFields, result);
        this.appendFieldToFormatString(Format.Fields.PURPOSE1, formatFields, result);
        this.appendFieldToFormatString(Format.Fields.PURPOSE2, formatFields, result);
        this.appendFieldToFormatString(Format.Fields.PURPOSE3, formatFields, result);
        this.appendFieldToFormatString(Format.Fields.PURPOSE4, formatFields, result);
        this.appendFieldToFormatString(Format.Fields.FEE_TYPE, formatFields, result);
        this.appendFieldToFormatString(Format.Fields.INSTRUCTION_CODE1, formatFields, result);
        this.appendFieldToFormatString(Format.Fields.INSTRUCTION_CODE2, formatFields, result);
        this.appendFieldToFormatString(Format.Fields.INSTRUCTION_CODE3, formatFields, result);
        this.appendFieldToFormatString(Format.Fields.INSTRUCTION_CODE4, formatFields, result);
        this.appendFieldToFormatString(Format.Fields.INSTRUCTIONS, formatFields, result);
        this.appendFieldToFormatString(Format.Fields.PAYMENT_TYPE, formatFields, result);
        this.appendFieldToFormatString(Format.Fields.REFERENCE, formatFields, result);
        return result.substring(0, result.length() - 1);
    }

    @Override
    public List<PaymentHandler<?>> loadPayments(BankSettings bank, String formatString, PaymentTransferType.PmtType pmtType, String language, String[][] data, boolean stringentCheck, String encoding) {
        Format format = new Format(formatString, language);
        ArrayList result = new ArrayList(data.length);
        for (int i = 0; i < data.length; ++i) {
            try {
                DTAZVPayment dtazvPayment = format.getPaymentData(data[i], i);
                if (stringentCheck) {
                    this.checkPaymentData(dtazvPayment);
                }
                result.add(PaymentHandler.getHandler(dtazvPayment, pmtType));
                continue;
            }
            catch (IOException | PaymentCsvImportException | PaymentException e) {
                this.errors.add(e);
                BLLoggerPlay.error("Failed to read payment from CSV data in line " + i + "!", e);
            }
        }
        if (this.converterFormat == null) {
            this.converterFormat = new ConverterFormat();
            this.converterFormat.setTenant(TenantUtils.findTenantForConverterFormat(bank, result, this.user));
        }
        this.converterFormat.setType(ConverterFormat.Type.DTAZV);
        if (encoding != null && !encoding.isEmpty()) {
            this.converterFormat.setEncoding(encoding);
        }
        this.converterFormat.setFieldSeparator("|");
        this.converterFormat.setCountryCode(language);
        this.converterFormat.setFormat(formatString);
        return result;
    }

    @Override
    public PaymentType getRecipientPaymentType(User user) {
        return PaymentType.DTAZV;
    }

    @Override
    public PaymentType getOriginatorPaymentType() {
        return PaymentType.DTAZV;
    }

    @Override
    public void updateConverterFormat(boolean hasHeader) {
        if (this.converterFormat == null) {
            return;
        }
        this.converterFormat.setHasHeader(hasHeader);
        this.converterFormat.save();
    }

    private void loadToDataMap(Map<String, String> dataMap, Format format, Format.Fields field) {
        Column column = format.getColumn(field);
        if (column != null) {
            if (column.getValue() != null && !column.getValue().isEmpty()) {
                dataMap.put(field.name().toLowerCase() + "_fix", column.getValue());
            } else {
                dataMap.put(field.name().toLowerCase(), String.valueOf(column.getColumnIndex()));
            }
        }
    }

    private void appendFieldToFormatString(Format.Fields field, Map<String, Object> fields, StringBuilder builder) {
        Object o = fields.get(field.name().toLowerCase());
        if (o != null) {
            if (o instanceof String) {
                builder.append('=');
            }
            builder.append(o);
        }
        builder.append("|");
    }

    private void checkPaymentData(DTAZVPayment paymentData) throws PaymentCsvImportException {
        DTAZVTransaction transaction = (DTAZVTransaction)paymentData.getTransactions().get(0);
        boolean isChequePayment = DtazvApi.isChequePaymentType((String)String.valueOf(transaction.getPaymentType()));
        if (isChequePayment) {
            if (transaction.getRecipient() == null || transaction.getRecipient().isEmpty() || transaction.getRecipient3() == null || transaction.getRecipient3().isEmpty() || transaction.getRecipient4() == null || transaction.getRecipient4().isEmpty() || transaction.getRecipientCountry() == null || transaction.getRecipientCountry().isEmpty()) {
                throw new PaymentCsvImportException("dtazvpayment.csv.error.chequeaddressincomplete", new Object[0]);
            }
        } else if (transaction.getIban() == null || transaction.getIban().isEmpty()) {
            throw new PaymentCsvImportException("dtazvpayment.csv.error.missingrecipientaccount", new Object[0]);
        }
        boolean allowInvalidBankConnection = new DatabasePreferenceStore(Preference.ApplicationId.PAYMENTS, this.user).getBoolean((DatabasePreferenceConstant)PreferenceConstants.ALLOW_INVALID_BANK_CONNECTION);
        String iban = transaction.getIban() != null && !transaction.getIban().isEmpty() && transaction.getIban().charAt(0) == '/' ? transaction.getIban().substring(1) : transaction.getIban();
        if (!allowInvalidBankConnection && RegularExpressions.IBAN.matches(iban) && !IbanUtil.checkIban((String)iban)) {
            throw new PaymentCsvImportException("sepapayment.csv.error.invalidiban", IbanUtil.formatIfIBAN((String)iban));
        }
        if (!(isChequePayment || transaction.getBic() != null && !transaction.getBic().isEmpty() || transaction.getBank() != null && !transaction.getBank().isEmpty() || transaction.getBank3() != null && !transaction.getBank3().isEmpty() || transaction.getBank4() != null && !transaction.getBank4().isEmpty() || transaction.getBankCountry() != null && !transaction.getBankCountry().isEmpty())) {
            throw new PaymentCsvImportException("dtazvpayment.csv.error.missingrecipientbank", new Object[0]);
        }
        CountriesLoader countries = CountriesLoader.getInstance((Locale)Locale.getDefault());
        if (transaction.getRecipientCountry() != null && !transaction.getRecipientCountry().isEmpty() && countries.getCountryName(transaction.getRecipientCountry()) == null) {
            throw new PaymentCsvImportException("dtazvpayment.csv.error.invalidcountry", transaction.getRecipientCountry());
        }
        if (transaction.getBankCountry() != null && !transaction.getBankCountry().isEmpty() && countries.getCountryName(transaction.getBankCountry()) == null) {
            throw new PaymentCsvImportException("dtazvpayment.csv.error.invalidbankcountry", transaction.getBankCountry());
        }
    }

    @Override
    public Set<String> getErrorMessages(Messages messages) {
        HashSet<String> result = new HashSet<String>(this.errors.size());
        for (Throwable t : this.errors) {
            if (t instanceof PaymentCsvImportException) {
                result.add(messages.at(((PaymentCsvImportException)t).getMessage(messages), new Object[0]));
                continue;
            }
            result.add(t.getMessage());
        }
        return result;
    }
}

