/*
 * Decompiled with CFR 0.152.
 */
package models.payments;

import de.businesslogics.banking.database.vo.PaymentRecipient;
import de.businesslogics.banking.database.vo.PaymentTransferType;
import de.businesslogics.banking.database.vo.PaymentType;
import de.businesslogics.banking.database.vo.Tenant;
import de.businesslogics.banking.payments.api.RecipientData;
import de.businesslogics.banking.sepa.api.ChequeRecipientData;
import de.businesslogics.format.sepa.SEPAPaymentData;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import models.payments.PaymentException;
import models.payments.SepaPaymentHandler;

public class ChequePaymentHandler
extends SepaPaymentHandler {
    protected static boolean handlesPmtType(PaymentTransferType.PmtType pmtType) {
        return PaymentTransferType.PmtType.SEPA_FOREIGN_CHEQUE.equals((Object)pmtType);
    }

    protected static List<ChequePaymentHandler> getChequeHandlers(InputStream inputStream, PaymentTransferType.PmtType pmtType) throws PaymentException {
        ArrayList<ChequePaymentHandler> result = new ArrayList<ChequePaymentHandler>();
        int sequenceNumber = 1;
        for (SEPAPaymentData payment : SepaPaymentHandler.getPaymentDataFromInputStream(inputStream, pmtType)) {
            result.add(new ChequePaymentHandler(pmtType, payment, sequenceNumber++));
        }
        return result;
    }

    protected ChequePaymentHandler(PaymentTransferType.PmtType pmtType, byte[] rawPaymentData, int sequenceNumber) throws PaymentException {
        super(pmtType, rawPaymentData, sequenceNumber);
    }

    protected ChequePaymentHandler(PaymentTransferType.PmtType pmtType, SEPAPaymentData payment, int sequenceNumber) {
        super(pmtType, payment, sequenceNumber);
    }

    @Override
    public RecipientData buildRecipient(boolean forceNewRecipient, Integer recipientId, PaymentType paymentType, Tenant tenant, List<Tenant> admissibleTenants, boolean allowRecipientModification) throws PaymentException {
        if (paymentType != PaymentType.CHEQUE) {
            throw new PaymentException("Invalid payment type for cheque recipients: " + paymentType.name());
        }
        PaymentRecipient paymentRecipient = null;
        if (!forceNewRecipient) {
            if (recipientId != null) {
                paymentRecipient = PaymentRecipient.findByIdAndTenants((int)recipientId, admissibleTenants);
            }
            if (paymentRecipient == null) {
                paymentRecipient = PaymentRecipient.findRecipientByAccountInfo(Collections.singletonList(paymentType), (String)((SEPAPaymentData)this.payment).getRecipient(), (String)((SEPAPaymentData)this.payment).getRecipientIban(), null, admissibleTenants);
            }
        }
        if (!allowRecipientModification && paymentRecipient != null) {
            return null;
        }
        if (paymentRecipient == null) {
            paymentRecipient = new PaymentRecipient();
            paymentRecipient.setTenant(tenant);
            paymentRecipient.setPaymentType(paymentType);
            paymentRecipient.setDisplayName(RecipientData.getUniqueDisplayName((String)((SEPAPaymentData)this.payment).getRecipient(), (PaymentType)paymentType, (Tenant)tenant));
        }
        paymentRecipient.setName(((SEPAPaymentData)this.payment).getRecipient());
        paymentRecipient.setAccountNumber(((SEPAPaymentData)this.payment).getRecipientIban());
        paymentRecipient.setBankCode(((SEPAPaymentData)this.payment).getRecipientBic());
        ChequeRecipientData recipientData = new ChequeRecipientData();
        try {
            recipientData.setPaymentRecipient(paymentRecipient);
            recipientData.addAddress(((SEPAPaymentData)this.payment).getRecipientAddressData());
            recipientData.setFeeType(((SEPAPaymentData)this.payment).getChargeBearer());
            return recipientData;
        }
        catch (IOException e) {
            throw new PaymentException("Failed to load cheque payment recipient info!", e);
        }
    }

    @Override
    protected boolean internalResetReference() {
        return false;
    }

    @Override
    public PaymentTransferType.PmtType getPaymentType(PaymentTransferType.PmtType defaultType) {
        return PaymentTransferType.PmtType.SEPA_FOREIGN_CHEQUE;
    }
}

