/*
 * Decompiled with CFR 0.152.
 */
package models.payments;

import controllers.util.BLLoggerPlay;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.database.vo.PaymentRecipient;
import de.businesslogics.banking.database.vo.PaymentTransferType;
import de.businesslogics.banking.database.vo.PaymentType;
import de.businesslogics.banking.database.vo.Tenant;
import de.businesslogics.banking.payments.api.RecipientData;
import de.businesslogics.banking.sepa.api.SepaForeignRecipientData;
import de.businesslogics.format.sepa.GeneralSEPAExtractor;
import de.businesslogics.format.sepa.GeneralSEPAWriter;
import de.businesslogics.format.sepa.SEPAPaymentData;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import models.payments.PaymentException;
import models.payments.SepaPaymentHandler;

public class AustrianForeignPaymentHandler
extends SepaPaymentHandler {
    protected static boolean handlesPmtType(PaymentTransferType.PmtType pmtType) {
        return PaymentTransferType.PmtType.AUSTRIAN_FOREIGN.equals((Object)pmtType);
    }

    protected static List<AustrianForeignPaymentHandler> getAustrianForeignHandlers(InputStream inputStream, PaymentTransferType.PmtType pmtType) throws PaymentException {
        ArrayList<AustrianForeignPaymentHandler> result = new ArrayList<AustrianForeignPaymentHandler>();
        int sequenceNumber = 1;
        for (SEPAPaymentData payment : SepaPaymentHandler.getPaymentDataFromInputStream(inputStream, pmtType)) {
            result.add(new AustrianForeignPaymentHandler(pmtType, payment, sequenceNumber++));
        }
        return result;
    }

    @Override
    public byte[] buildPaymentData(BankSettings bank) throws PaymentException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            GeneralSEPAWriter.write((GeneralSEPAWriter.Version)GeneralSEPAWriter.Version.V25IsoATX, (SEPAPaymentData)((SEPAPaymentData)this.payment), (OutputStream)baos);
        }
        catch (IOException e) {
            throw new PaymentException("Failed to write Austrian Foreign payment information: " + e.getLocalizedMessage(), e);
        }
        finally {
            try {
                baos.close();
            }
            catch (IOException e) {
                BLLoggerPlay.getLogger().logError("Failed to close stream!", (Throwable)e);
            }
        }
        return baos.toByteArray();
    }

    protected AustrianForeignPaymentHandler(PaymentTransferType.PmtType pmtType, byte[] rawPaymentData, int sequenceNumber) throws PaymentException {
        super(pmtType, rawPaymentData, sequenceNumber);
    }

    protected AustrianForeignPaymentHandler(PaymentTransferType.PmtType pmtType, SEPAPaymentData payment, int sequenceNumber) {
        super(pmtType, payment, sequenceNumber);
    }

    @Override
    protected SEPAPaymentData loadPayment(PaymentTransferType.PmtType pmtType, byte[] paymentData) throws PaymentException {
        ByteArrayInputStream bais = new ByteArrayInputStream(paymentData);
        try {
            SEPAPaymentData sEPAPaymentData = GeneralSEPAExtractor.getPaymentFromATX((InputStream)bais);
            return sEPAPaymentData;
        }
        catch (Exception e) {
            throw new PaymentException("Failed to load SEPA payment: " + e.getLocalizedMessage(), e);
        }
        finally {
            try {
                ((InputStream)bais).close();
            }
            catch (IOException e) {
                BLLoggerPlay.getLogger().logError("Failed to close stream!", (Throwable)e);
            }
        }
    }

    @Override
    public RecipientData buildRecipient(boolean forceNewRecipient, Integer recipientId, PaymentType paymentType, Tenant tenant, List<Tenant> admissibleTenants, boolean allowRecipientModification) throws PaymentException {
        PaymentRecipient paymentRecipient = null;
        if (!forceNewRecipient) {
            if (recipientId != null) {
                paymentRecipient = PaymentRecipient.findByIdAndTenants((int)recipientId, admissibleTenants);
            }
            if (paymentRecipient == null) {
                paymentRecipient = PaymentRecipient.findRecipientByAccountInfo(Collections.singletonList(PaymentType.SEPA_FOREIGN), (String)((SEPAPaymentData)this.payment).getRecipient(), (String)((SEPAPaymentData)this.payment).getRecipientIban(), null, admissibleTenants);
            }
        }
        if (!allowRecipientModification && paymentRecipient != null) {
            return null;
        }
        if (paymentRecipient == null) {
            paymentRecipient = new PaymentRecipient();
            paymentRecipient.setTenant(tenant);
            paymentRecipient.setDisplayName(RecipientData.getUniqueDisplayName((String)((SEPAPaymentData)this.payment).getRecipient(), (PaymentType)PaymentType.SEPA_FOREIGN, (Tenant)tenant));
        }
        paymentRecipient.setPaymentType(PaymentType.SEPA_FOREIGN);
        paymentRecipient.setName(((SEPAPaymentData)this.payment).getRecipient());
        paymentRecipient.setAccountNumber(((SEPAPaymentData)this.payment).getRecipientIban());
        paymentRecipient.setBankCode(((SEPAPaymentData)this.payment).getRecipientBic());
        try {
            SepaForeignRecipientData recipientData = new SepaForeignRecipientData();
            recipientData.setPaymentRecipient(paymentRecipient);
            recipientData.setName(((SEPAPaymentData)this.payment).getRecipient());
            recipientData.addAddress(((SEPAPaymentData)this.payment).getRecipientAddressData());
            recipientData.setBankName(((SEPAPaymentData)this.payment).getRecipientBankName());
            recipientData.setPurpose(((SEPAPaymentData)this.payment).getPurpose());
            recipientData.setFeeType(((SEPAPaymentData)this.payment).getChargeBearer());
            return recipientData;
        }
        catch (IOException e) {
            throw new PaymentException("Failed to load SEPA recipient info!", e);
        }
    }

    @Override
    protected boolean internalResetReference() {
        return false;
    }

    @Override
    public PaymentTransferType.PmtType getPaymentType(PaymentTransferType.PmtType defaultType) {
        return PaymentTransferType.PmtType.AUSTRIAN_FOREIGN;
    }
}

