/*
 * Decompiled with CFR 0.152.
 */
package models.payments;

import controllers.util.BLLoggerPlay;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.database.vo.PaymentTransferType;
import de.businesslogics.format.sepa.GeneralSEPAExtractor;
import de.businesslogics.format.sepa.GeneralSEPAWriter;
import de.businesslogics.format.sepa.SEPAPaymentData;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import models.payments.ChequePaymentHandler;
import models.payments.PaymentException;
import models.payments.SepaPaymentHandler;

public class ATChequePaymentHandler
extends ChequePaymentHandler {
    protected static boolean handlesPmtType(PaymentTransferType.PmtType pmtType) {
        return PaymentTransferType.PmtType.AUSTRIAN_FOREIGN_SEPA_CHEQUE.equals((Object)pmtType);
    }

    protected static List<ATChequePaymentHandler> getATChequeHandlers(InputStream inputStream, PaymentTransferType.PmtType pmtType) throws PaymentException {
        ArrayList<ATChequePaymentHandler> result = new ArrayList<ATChequePaymentHandler>();
        int sequenceNumber = 1;
        for (SEPAPaymentData payment : SepaPaymentHandler.getPaymentDataFromInputStream(inputStream, pmtType)) {
            result.add(new ATChequePaymentHandler(pmtType, payment, sequenceNumber++));
        }
        return result;
    }

    @Override
    public byte[] buildPaymentData(BankSettings bank) throws PaymentException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            GeneralSEPAWriter.write((GeneralSEPAWriter.Version)GeneralSEPAWriter.Version.V25IsoATX, (SEPAPaymentData)((SEPAPaymentData)this.payment), (OutputStream)baos);
        }
        catch (IOException e) {
            throw new PaymentException("Failed to write AT Cheque payment information: " + e.getLocalizedMessage(), e);
        }
        finally {
            try {
                baos.close();
            }
            catch (IOException e) {
                BLLoggerPlay.getLogger().logError("Failed to close stream!", (Throwable)e);
            }
        }
        return baos.toByteArray();
    }

    @Override
    protected SEPAPaymentData loadPayment(PaymentTransferType.PmtType pmtType, byte[] paymentData) throws PaymentException {
        ByteArrayInputStream bais = new ByteArrayInputStream(paymentData);
        try {
            SEPAPaymentData sEPAPaymentData = GeneralSEPAExtractor.getPaymentFromATX((InputStream)bais);
            return sEPAPaymentData;
        }
        catch (Exception e) {
            throw new PaymentException("Failed to load SEPA payment: " + e.getLocalizedMessage(), e);
        }
        finally {
            try {
                ((InputStream)bais).close();
            }
            catch (IOException e) {
                BLLoggerPlay.getLogger().logError("Failed to close stream!", (Throwable)e);
            }
        }
    }

    protected ATChequePaymentHandler(PaymentTransferType.PmtType pmtType, byte[] rawPaymentData, int sequenceNumber) throws PaymentException {
        super(pmtType, rawPaymentData, sequenceNumber);
    }

    protected ATChequePaymentHandler(PaymentTransferType.PmtType pmtType, SEPAPaymentData payment, int sequenceNumber) {
        super(pmtType, payment, sequenceNumber);
    }

    @Override
    public PaymentTransferType.PmtType getPaymentType(PaymentTransferType.PmtType defaultType) {
        return PaymentTransferType.PmtType.AUSTRIAN_FOREIGN_SEPA_CHEQUE;
    }
}

