/*
 * Decompiled with CFR 0.152.
 */
package models.cm;

import com.google.common.collect.ImmutableSet;
import controllers.branding.Branding;
import controllers.routes;
import controllers.util.AwvBookingsCollector;
import controllers.util.GeneralUtils;
import de.businesslogics.banking.api.BankingApiMessages;
import de.businesslogics.banking.api.DatabasePreferenceConstant;
import de.businesslogics.banking.api.DatabasePreferenceStore;
import de.businesslogics.banking.api.GeneralMessages;
import de.businesslogics.banking.api.Util;
import de.businesslogics.banking.api.WorkspaceFileSystem;
import de.businesslogics.banking.database.vo.Account;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.database.vo.CmBooking;
import de.businesslogics.banking.database.vo.CmFolder;
import de.businesslogics.banking.database.vo.CmPage;
import de.businesslogics.banking.database.vo.CmStatement;
import de.businesslogics.banking.database.vo.CmValueGroup;
import de.businesslogics.banking.database.vo.ExportFile;
import de.businesslogics.banking.database.vo.Preference;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.banking.database.vo.WorkspaceFile;
import de.businesslogics.banking.mt940.CmPrinter;
import de.businesslogics.banking.mt940.api.CMBank;
import de.businesslogics.banking.mt940.api.EclipseFreeHelper;
import de.businesslogics.banking.mt940.report.api.StatementBookingReportHandler;
import de.businesslogics.banking.preferences.CmPreferenceConstants;
import de.businesslogics.pdf.PDFException;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import play.api.mvc.Call;
import play.i18n.Messages;

public final class CmUtils {
    public static String localPartyLabel(CmBooking b, Messages messages) {
        if (b.getAmount().signum() > 0) {
            if (b.isDebit()) {
                return BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.payee", (Object[])new Object[0]);
            }
            return BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.recipient", (Object[])new Object[0]);
        }
        if (b.isDebit()) {
            return BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.payer", (Object[])new Object[0]);
        }
        return BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.originator", (Object[])new Object[0]);
    }

    public static String counterPartyLabel(CmBooking b, Messages messages) {
        if (b.getAmount().signum() > 0) {
            if (b.isDebit()) {
                return BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.payer", (Object[])new Object[0]);
            }
            return BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.originator", (Object[])new Object[0]);
        }
        if (b.isDebit()) {
            return BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.payee", (Object[])new Object[0]);
        }
        return BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.recipient", (Object[])new Object[0]);
    }

    public static String getStatementText(CmStatement stmt, Locale locale) {
        Object toReturn = EclipseFreeHelper.getDisplayText((CmStatement)stmt, (Locale)locale);
        CMBank bank = CMBank.get((BankSettings)stmt.getAccount().getBank());
        if (stmt.isAdvice()) {
            if (!bank.getAdviceType().equals((Object)stmt.getType())) {
                toReturn = (String)toReturn + " (" + stmt.getType().name() + ")";
            }
        } else {
            if (stmt.getClosingDate() != null) {
                toReturn = (String)toReturn + " (" + DateFormat.getDateInstance(2, locale).format(stmt.getClosingDate()) + ")";
            }
            if (!bank.getStatementType().equals((Object)stmt.getType())) {
                toReturn = (String)toReturn + " (" + stmt.getType().name() + ")";
            }
        }
        return toReturn;
    }

    public static String statementLabel(CmStatement statement, Messages messages) {
        if (statement.isStatement()) {
            return BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.statement", (Object[])new Object[0]);
        }
        if (statement.isAdvice()) {
            return BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.advice", (Object[])new Object[0]);
        }
        if (CmStatement.Type.CAMT054.equals((Object)statement.getType())) {
            return "camt.054-" + BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.file", (Object[])new Object[0]);
        }
        if (CmStatement.Type.LOGICAL_PAYMENT_FILE.equals((Object)statement.getType())) {
            return EclipseFreeHelper.getDisplayText((CmStatement)statement, (Locale)messages.lang().toLocale());
        }
        return statement.getFormatName() + "-" + BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.file", (Object[])new Object[0]);
    }

    public static String stmtDetailsTitle(CmStatement s, boolean newest, Messages messages) {
        Object result = s.isStatement() ? messages.at("bookings.stmtdetails.stmtTitle", new Object[0]) : (s.isAdvice() ? messages.at("bookings.stmtdetails.adviceTitle", new Object[0]) : (CmStatement.Type.CAMT054.equals((Object)s.getType()) ? "camt.054-" + BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.file", (Object[])new Object[0]) : (CmStatement.Type.LOGICAL_PAYMENT_FILE.equals((Object)s.getType()) ? EclipseFreeHelper.getDisplayText((CmStatement)s, (Locale)messages.lang().toLocale()) : s.getFormatName() + "-" + BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.file", (Object[])new Object[0]))));
        if (newest) {
            return (String)result + "&emsp;&mdash;&emsp;" + messages.at("bookings.stmtdetails.newest", new Object[0]);
        }
        return result;
    }

    public static String stmtDeleteLabel(CmStatement s, Messages messages) {
        if (s.isStatement()) {
            return messages.at("bookings.stmtdetails.deletestmt.stmtLabel", new Object[0]);
        }
        if (s.isAdvice()) {
            return messages.at("bookings.stmtdetails.deletestmt.adviceLabel", new Object[0]);
        }
        if (CmStatement.Type.CAMT054.equals((Object)s.getType())) {
            return messages.at("bookings.stmtdetails.deletestmt.fileLabel", new Object[]{"camt.054"});
        }
        if (CmStatement.Type.LOGICAL_PAYMENT_FILE.equals((Object)s.getType())) {
            return EclipseFreeHelper.getDisplayText((CmStatement)s, (Locale)messages.lang().toLocale());
        }
        return messages.at("bookings.stmtdetails.deletestmt.fileLabel", new Object[]{s.getFormatName()});
    }

    public static String stmtReferenceNumbers(boolean ref1, CmStatement s, String ref, Messages messages) {
        if (s.getType() == CmStatement.Type.DTI) {
            if (ref1) {
                if (ref != null) {
                    return GeneralMessages.getInstance((Locale)messages.lang().toLocale()).REFERENCE_NUMBER;
                }
                return null;
            }
            return null;
        }
        if (CmStatement.BbkTypes.contains(s.getType())) {
            if (ref1) {
                if (ref != null) {
                    return GeneralMessages.getInstance((Locale)messages.lang().toLocale()).SEQUENTIAL_NUMBER;
                }
                return null;
            }
            return null;
        }
        if (CmStatement.isMT94xFormat((CmStatement.Type)s.getType())) {
            if (ref1) {
                return BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.orderRef", (Object[])new Object[0]);
            }
            if (ref != null && ref.trim().length() > 0) {
                return messages.at("bookings.stmtdetails.ref2", new Object[0]);
            }
            return null;
        }
        if (CmStatement.isCamtFormat((CmStatement.Type)s.getType())) {
            if (ref1) {
                return GeneralMessages.getInstance((Locale)messages.lang().toLocale()).MESSAGE_ID;
            }
            return GeneralMessages.getInstance((Locale)messages.lang().toLocale()).REFERENCE_NUMBER;
        }
        return null;
    }

    public static String stmtCreationDate(CmStatement s, Timestamp ts, Locale locale) {
        if (s.getType() == CmStatement.Type.MT940) {
            return null;
        }
        if (s.getType() == CmStatement.Type.DTI || s.isBbkFile()) {
            if (ts != null) {
                return GeneralMessages.getInstance((Locale)locale).CREATION_DATE;
            }
            return null;
        }
        if (ts != null) {
            return GeneralMessages.getInstance((Locale)locale).CREATION_DATE;
        }
        return null;
    }

    public static BigDecimal getCreditandDebitSum(int countCredits, int countDebits, BigDecimal sumCredits, BigDecimal sumDebits) {
        if (countCredits == 0) {
            sumCredits = null;
        }
        if (countDebits == 0) {
            sumDebits = null;
        }
        BigDecimal totalSum = BigDecimal.ZERO;
        if (sumCredits != null) {
            totalSum = totalSum.add(sumCredits);
        }
        if (sumDebits != null) {
            totalSum = totalSum.add(sumDebits);
        }
        return totalSum;
    }

    public static Integer accountId(Account a) {
        if (a == null) {
            return -1;
        }
        return a.getId();
    }

    public static Integer stmtId(CmStatement s) {
        if (s == null) {
            return null;
        }
        return s.getId();
    }

    public static Integer pageId(CmPage p) {
        if (p == null) {
            return null;
        }
        return p.getId();
    }

    public static Integer folderId(CmFolder folder) {
        if (folder == null) {
            return null;
        }
        return folder.getId();
    }

    public static String getCmFolderName(Integer folderId, User user) {
        if (folderId != null) {
            CmFolder folder = CmFolder.findById((Integer)folderId, (User)user);
            if (folder == null) {
                return "";
            }
            return folder.getName();
        }
        return "";
    }

    public static String getGroupName(int groupId, User user) {
        CmValueGroup valueGroup = CmValueGroup.findById((Integer)groupId, (User)user);
        Object suffix = "";
        if (valueGroup == null) {
            return "";
        }
        if (user.getVisibleTenants().size() > 1) {
            suffix = " (" + valueGroup.getTenant().getName() + ")";
        }
        return valueGroup.getName() + (String)suffix;
    }

    public static Call getDTILink(CmBooking booking) {
        CmStatement s;
        CmBooking b = (CmBooking)CmBooking.findSingleBookingsQuery((CmBooking)booking).setMaxRows(1).findOne();
        if (b != null && (s = CmStatement.findById((int)b.getStatement().getId())) != null) {
            if (s.isDtiFile()) {
                return routes.DtiView.dti(s.getAccount().getId(), s.getId(), null);
            }
            return routes.DtiView.dtiByBooking(booking.getId());
        }
        return null;
    }

    public static boolean checkAccountPermission(User user) {
        return new DatabasePreferenceStore(Preference.ApplicationId.CM, user).getBoolean((DatabasePreferenceConstant)CmPreferenceConstants.DISPLAY_ONLY_ACCOUNTS_WITH_PAYMENT_PERMISSIONS);
    }

    public static String nameForFile(ExportFile file2) {
        return WorkspaceFileSystem.toFile((WorkspaceFile)file2.getWorkspaceFile()).getName();
    }

    public static String directoryForFile(ExportFile file2) {
        return WorkspaceFileSystem.toFile((WorkspaceFile)file2.getWorkspaceFile()).getParent();
    }

    public static File printCmFile(Collection<Account> accounts2, Collection<Account> dtiAccounts, Collection<CmStatement> statements, Collection<CmPage> pages, Map<CmStatement, Collection<CmBooking>> bookings2, java.util.Date printPeriodStartDate, java.util.Date printPeriodEndDate, User user, String prefix, Locale locale) throws IOException, PDFException {
        String[] additionalFooter = Branding.getBranding().getPrintedStatementFooter();
        File temp = Util.createTempFile((String)prefix, (String)".pdf", (boolean)true);
        DatabasePreferenceStore store = new DatabasePreferenceStore(Preference.ApplicationId.CM, user);
        boolean withLogo = GeneralUtils.printLogo(user);
        CmPrinter printer = new CmPrinter(temp, prefix, store, true, null, withLogo, locale, additionalFooter != null);
        Date start = printPeriodStartDate == null ? null : new Date(printPeriodStartDate.getTime());
        Date end = printPeriodEndDate == null ? null : new Date(printPeriodEndDate.getTime());
        printer.print(accounts2, dtiAccounts, statements, pages, bookings2, start, end);
        printer.close();
        if (additionalFooter != null) {
            String s1 = additionalFooter[0];
            String s2 = additionalFooter.length > 1 ? additionalFooter[1] : null;
            Util.applyPreferencesToPdf((File)temp, (User)user, null, (Locale)locale, (String)s1, (String)s2, (boolean)withLogo);
        } else {
            Util.applyPreferencesToPdf((File)temp, (User)user, null, (Locale)locale, null, null, (boolean)withLogo);
        }
        return temp;
    }

    public static File printAccounts(Collection<Account> accounts2, java.util.Date statementsPeriodStartDate, java.util.Date statementsPeriodEndDate, User user, String prefix, Locale locale) throws IOException, PDFException {
        if (accounts2 != null && accounts2.size() > 0) {
            return CmUtils.printCmFile(accounts2, null, null, null, null, statementsPeriodStartDate, statementsPeriodEndDate, user, prefix, locale);
        }
        return null;
    }

    public static File printBookings(Map<CmStatement, Collection<CmBooking>> bookings2, User user, String prefix, java.util.Date bookingsPeriodStartDate, java.util.Date bookingsPeriodEndDate, Locale locale) throws IOException, PDFException {
        if (bookings2 != null) {
            int countBookings = 0;
            for (Collection<CmBooking> c : bookings2.values()) {
                if (c == null) continue;
                countBookings += c.size();
            }
            if (countBookings > 0) {
                return CmUtils.printCmFile(null, null, null, null, bookings2, bookingsPeriodStartDate, bookingsPeriodEndDate, user, prefix, locale);
            }
        }
        return null;
    }

    public static File printStatement(CmStatement statement, User user, String prefix, Locale locale) throws IOException, PDFException {
        if (statement != null) {
            return CmUtils.printCmFile(null, null, (Collection<CmStatement>)ImmutableSet.of((Object)statement), null, null, null, null, user, prefix, locale);
        }
        return null;
    }

    public static File printPage(CmPage page, User user, String prefix, Locale locale) throws IOException, PDFException {
        if (page != null) {
            return CmUtils.printCmFile(null, null, null, (Collection<CmPage>)ImmutableSet.of((Object)page), null, null, null, user, prefix, locale);
        }
        return null;
    }

    public static List<StatementBookingReportHandler> getReportHandlers() {
        ArrayList<StatementBookingReportHandler> handlers = new ArrayList<StatementBookingReportHandler>(1);
        handlers.add(new AwvBookingsCollector());
        return handlers;
    }

    private CmUtils() {
    }
}

