/*
 * Decompiled with CFR 0.152.
 */
package models.cm;

import de.businesslogics.banking.database.vo.ExportFileFilter;
import de.businesslogics.banking.database.vo.FilterComparator;
import java.util.Date;
import play.data.Form;

public final class AutomaticExportFileFilterForm {
    public Integer automaticExport;
    public Integer fileNameComparator;
    public String fileName;
    public Integer dateComparator;
    public Date dateFrom;
    public Date dateTo;

    public AutomaticExportFileFilterForm() {
    }

    public AutomaticExportFileFilterForm(ExportFileFilter fetchFilter) {
        this.automaticExport = fetchFilter.getAutomaticExportId();
        if (fetchFilter.getFileNameComparator() != null) {
            this.fileNameComparator = fetchFilter.getFileNameComparator().ordinal();
        }
        this.fileName = fetchFilter.getFileName();
        this.dateComparator = fetchFilter.getDateComparatorIndex();
        if (this.dateComparator < 0) {
            this.dateComparator = null;
        }
        this.dateFrom = fetchFilter.getFromDate();
        this.dateTo = fetchFilter.getToDate();
    }

    public Form<AutomaticExportFileFilterForm> validate(Form<AutomaticExportFileFilterForm> form, ExportFileFilter fetchFilter) {
        fetchFilter.setAutomaticExportId(this.automaticExport);
        fetchFilter.setFileNameComparator(this.fileNameComparator.intValue());
        fetchFilter.setFileName(this.fileName);
        if (this.dateComparator == null || this.dateComparator < 0) {
            fetchFilter.setDateComparator(null);
            fetchFilter.setFromDate(null);
            fetchFilter.setToDate(null);
            if (this.dateFrom != null || this.dateTo != null) {
                form = form.withError("dateComparator", "error.invalid");
            }
        } else {
            fetchFilter.setDateComparatorIndex(this.dateComparator.intValue());
            if (fetchFilter.getDateComparator() == FilterComparator.Date.BETWEEN) {
                if (this.dateFrom == null && this.dateTo == null) {
                    fetchFilter.setFromDate(null);
                    fetchFilter.setToDate(null);
                    fetchFilter.setDateComparator(null);
                } else {
                    if (this.dateFrom == null) {
                        fetchFilter.setFromDate(null);
                    } else {
                        fetchFilter.setFromDate(new java.sql.Date(this.dateFrom.getTime()));
                    }
                    if (this.dateTo == null) {
                        fetchFilter.setDateComparator(FilterComparator.Date.GREATER);
                        fetchFilter.setToDate(null);
                    } else if (this.dateFrom == null) {
                        fetchFilter.setDateComparator(FilterComparator.Date.LESS);
                        fetchFilter.setFromDate(new java.sql.Date(this.dateTo.getTime()));
                    } else {
                        fetchFilter.setToDate(new java.sql.Date(this.dateTo.getTime()));
                    }
                }
            } else {
                if (this.dateFrom == null) {
                    form = form.withError("dateFrom", "error.invalid");
                    fetchFilter.setFromDate(null);
                } else {
                    fetchFilter.setFromDate(new java.sql.Date(this.dateFrom.getTime()));
                }
                fetchFilter.setToDate(null);
            }
        }
        return form;
    }
}

