/*
 * Decompiled with CFR 0.152.
 */
package models.banks;

import controllers.util.BLLoggerAdmin;
import de.businesslogics.banking.api.AdminLogger;
import de.businesslogics.banking.api.BankUtils;
import de.businesslogics.banking.api.ProgressMonitorDummy;
import de.businesslogics.banking.database.api.DB;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.banking.transfer.api.BankDelete;
import de.businesslogics.util.BLLogger;
import de.businesslogics.util.IProgressMonitorWrapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;

public class BankDeleteHandler {
    private static final de.businesslogics.banking.ds.api.BankDelete dsBankDelete = new de.businesslogics.banking.ds.api.BankDelete();
    private static final de.businesslogics.banking.mt940.api.BankDelete cmBankDelete = new de.businesslogics.banking.mt940.api.BankDelete();
    private static final de.businesslogics.banking.payments.api.BankDelete paymentBankDelete = new de.businesslogics.banking.payments.api.BankDelete();
    private static final BankDelete transferBankDelete = new BankDelete();
    private static final de.businesslogics.banking.mt940.bka.api.BankDelete bkaBankDelete = new de.businesslogics.banking.mt940.bka.api.BankDelete(){

        protected void refresh() {
        }
    };

    public static List<String> prepareDeleteQuestion(List<BankSettings> banksList, Locale locale) {
        ArrayList<String> result = new ArrayList<String>();
        BankSettings[] banks2 = banksList.toArray(new BankSettings[0]);
        BankDeleteHandler.appendInfo(result, dsBankDelete.checkDataToBeDeleted(banks2, locale));
        BankDeleteHandler.appendInfo(result, cmBankDelete.checkDataToBeDeleted(banks2, locale));
        BankDeleteHandler.appendInfo(result, paymentBankDelete.checkDataToBeDeleted(banks2, locale));
        BankDeleteHandler.appendInfo(result, transferBankDelete.checkDataToBeDeleted(banks2, locale));
        BankDeleteHandler.appendInfo(result, bkaBankDelete.checkDataToBeDeleted(banks2, locale));
        return result;
    }

    private static void appendInfo(List<String> list, String[] info) {
        if (info != null) {
            list.addAll(Arrays.asList(info));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteBanks(List<BankSettings> banks2, User user) {
        for (BankSettings bank : banks2) {
            boolean ownTransaction;
            boolean bl = ownTransaction = DB.currentTransaction() == null;
            if (ownTransaction) {
                DB.beginTransaction();
            }
            try {
                ProgressMonitorDummy monitor = ProgressMonitorDummy.getInstance();
                dsBankDelete.deleteBank(bank, (IProgressMonitorWrapper)monitor);
                cmBankDelete.deleteBank(bank, (IProgressMonitorWrapper)monitor);
                paymentBankDelete.deleteBank(bank, (IProgressMonitorWrapper)monitor);
                transferBankDelete.deleteBank(bank, (IProgressMonitorWrapper)monitor);
                bkaBankDelete.deleteBank(bank, (IProgressMonitorWrapper)monitor);
                BankUtils.prepareDeleteBank((BankSettings)bank);
                bank.delete();
                if (ownTransaction) {
                    DB.commitTransaction();
                }
                AdminLogger logger = new AdminLogger((BLLogger)BLLoggerAdmin.getLogger());
                logger.logBankDeleted(user, bank);
            }
            finally {
                if (!ownTransaction) continue;
                DB.endTransaction();
            }
        }
    }

    private BankDeleteHandler() {
    }
}

