/*
 * Decompiled with CFR 0.152.
 */
package models;

import controllers.AppSync;
import controllers.Yubikeys;
import controllers.util.BLLoggerAdmin;
import controllers.util.BLLoggerPlay;
import de.businesslogics.banking.api.AdminLogger;
import de.businesslogics.banking.api.BankingApiMessages;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.banking.database.vo.Yubikey;
import de.businesslogics.banking.yubikey.api.Oath;
import de.businesslogics.banking.yubikey.api.YubikeyWrapper;
import de.businesslogics.util.BLLogger;
import java.sql.Date;
import java.util.List;
import java.util.Locale;
import play.data.Form;
import play.data.validation.ValidationError;
import play.i18n.Messages;

public class YubikeyForm {
    public String newTokenOTP;
    public String existingTokenOTP;
    public String description;

    public Form<YubikeyForm> checkExistingOTP(Form<YubikeyForm> form, User user, Messages messages) {
        if (Yubikey.hasKeyOfType((User)user, (Yubikey.SecurityType[])new Yubikey.SecurityType[]{Yubikey.SecurityType.YUBIKEY, Yubikey.SecurityType.OATH})) {
            if (this.existingTokenOTP == null) {
                return form.withError("existingTokenOTP", "error.required");
            }
            if (!Yubikeys.validateOTP(this.existingTokenOTP, user)) {
                BLLoggerPlay.info("Invalid OTP for user " + user.getName() + ".");
                return form.withError("existingTokenOTP", BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.invalidOTP", (Object[])new Object[0]));
            }
        }
        return form;
    }

    public String addNewToken(User user, User operator, List<ValidationError> errors, Messages messages) {
        try {
            if (this.newTokenOTP == null) {
                errors.add(new ValidationError("newTokenOTP", "error.required"));
                return null;
            }
            String publicId = YubikeyWrapper.verify((String)this.newTokenOTP);
            if (publicId == null) {
                errors.add(new ValidationError("newTokenOTP", BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.invalidOTP", (Object[])new Object[0])));
                return null;
            }
            if (YubikeyWrapper.hasKey((String)publicId, (User)user)) {
                errors.add(new ValidationError("newTokenOTP", BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.tokenAlreadyExists", (Object[])new Object[]{publicId})));
                return null;
            }
            Yubikey key = new Yubikey();
            key.setPublicId(publicId);
            key.setUser(user);
            key.setDescription(this.description);
            key.setUsedSince(new Date(System.currentTimeMillis()));
            key.save();
            new AdminLogger((BLLogger)BLLoggerAdmin.getLogger()).logYubikeyAdded(operator, user, key);
            return publicId;
        }
        catch (Exception e) {
            BLLoggerPlay.warning("Invalid OTP for user " + user.getName() + ".", e);
            errors.add(new ValidationError("newTokenOTP", BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.invalidOTP2", (Object[])new Object[]{e.getMessage()})));
            return null;
        }
    }

    public String addNewOathToken(String encryptedUri, Form<YubikeyForm> form, User user, User operator, List<ValidationError> errors, Locale locale) {
        try {
            if (this.newTokenOTP == null) {
                errors.add(new ValidationError("newTokenOTP", "error.required"));
                return null;
            }
            String uri = AppSync.decryptFromPage(encryptedUri);
            String token = Oath.getKeyFromURI((String)uri);
            if (token == null) {
                errors.add(new ValidationError("newTokenOTP", BankingApiMessages.getString((Locale)locale, (String)"GeneralMessages.invalidOTP", (Object[])new Object[0])));
                return null;
            }
            if (Oath.isDemoCode((String)this.newTokenOTP) || Oath.checkCode((String)token, (String)((YubikeyForm)form.get()).newTokenOTP)) {
                Yubikey key = new Yubikey();
                if (Oath.isDemoCode((String)this.newTokenOTP)) {
                    key.setOathData(Oath.encrypt((String)this.newTokenOTP, (String)this.newTokenOTP));
                } else {
                    key.setOathData(Oath.encryptURI((String)uri));
                }
                key.setUser(user);
                key.setDescription(this.description);
                key.setUsedSince(new Date(System.currentTimeMillis()));
                key.save();
                new AdminLogger((BLLogger)BLLoggerAdmin.getLogger()).logYubikeyAdded(operator, user, key);
                return key.getDisplayString();
            }
            errors.add(new ValidationError("newTokenOTP", BankingApiMessages.getString((Locale)locale, (String)"GeneralMessages.invalidOTP", (Object[])new Object[0])));
            return null;
        }
        catch (Exception e) {
            BLLoggerPlay.warning("Invalid OTP for user " + user.getName() + ".", e);
            errors.add(new ValidationError("newTokenOTP", BankingApiMessages.getString((Locale)locale, (String)"GeneralMessages.invalidOTP", (Object[])new Object[0])));
            return null;
        }
    }
}

