/*
 * Decompiled with CFR 0.152.
 */
package models;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.webauthn4j.authenticator.Authenticator;
import com.webauthn4j.authenticator.AuthenticatorImpl;
import com.webauthn4j.data.AuthenticationData;
import com.webauthn4j.data.AuthenticationParameters;
import com.webauthn4j.data.AuthenticationRequest;
import com.webauthn4j.data.attestation.authenticator.AttestedCredentialData;
import com.webauthn4j.data.attestation.statement.AttestationStatement;
import com.webauthn4j.data.attestation.statement.NoneAttestationStatement;
import com.webauthn4j.data.client.Origin;
import com.webauthn4j.data.client.challenge.Challenge;
import com.webauthn4j.data.client.challenge.DefaultChallenge;
import com.webauthn4j.server.ServerProperty;
import com.webauthn4j.util.Base64UrlUtil;
import controllers.Setup;
import controllers.Yubikeys;
import controllers.util.BLLoggerPlay;
import de.businesslogics.banking.api.DatabasePreferenceConstant;
import de.businesslogics.banking.api.DatabasePreferenceStore;
import de.businesslogics.banking.database.api.DB;
import de.businesslogics.banking.database.vo.Preference;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.banking.database.vo.WebAuthn;
import de.businesslogics.banking.database.vo.Yubikey;
import de.businesslogics.banking.database.vo.YubikeyHistory;
import de.businesslogics.banking.preferences.PreferenceConstants;
import de.businesslogics.util.HexTool;
import java.io.ByteArrayInputStream;
import java.io.ObjectInputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Random;
import play.libs.Json;

public class WebAuthnData {
    private final String challenge;
    private final List<List<Integer>> allowedCredentialIds;

    private WebAuthnData(String challenge, List<List<Integer>> allowedCredentialIds) {
        this.challenge = challenge;
        this.allowedCredentialIds = allowedCredentialIds;
    }

    public String getChallenge() {
        return this.challenge;
    }

    public List<List<Integer>> getAllowedCredentialIds() {
        return this.allowedCredentialIds;
    }

    public static WebAuthnData buildForSigning(User user) {
        DatabasePreferenceStore preferenceStore = new DatabasePreferenceStore(Preference.ApplicationId.BANKING, user);
        if (preferenceStore.getBoolean((DatabasePreferenceConstant)PreferenceConstants.USE_2FA_FOR_SIGING)) {
            return WebAuthnData.build(user);
        }
        return null;
    }

    public static WebAuthnData build(User user) {
        List<List<Integer>> credentialIds = WebAuthnData.getWebAuthnKeysForUser(user);
        if (credentialIds == null) {
            return null;
        }
        return new WebAuthnData(User.createChallenge((User)user), credentialIds);
    }

    public static WebAuthnData buildDummyData(String username) {
        SecureRandom r = new SecureRandom();
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < 64; ++i) {
            if (b.length() > 0) {
                b.append(",");
            }
            b.append(r.nextInt(256));
        }
        return new WebAuthnData(b.toString(), WebAuthnData.buildDummyWebAuthnKey(username));
    }

    private static List<List<Integer>> buildDummyWebAuthnKey(String unknownUserId) {
        ArrayList<List<Integer>> credentialIds = new ArrayList<List<Integer>>();
        ByteBuffer buffer = ByteBuffer.allocate(8);
        byte[] nameInBytes = unknownUserId.getBytes();
        buffer.put(nameInBytes, 0, Math.min(nameInBytes.length, 8));
        while (buffer.position() < 8) {
            buffer.put(nameInBytes, 0, Math.min(nameInBytes.length, 8 - buffer.position()));
        }
        buffer.flip();
        Random r = new Random(buffer.getLong());
        ArrayList<Integer> key = new ArrayList<Integer>();
        for (int i = 0; i < 64; ++i) {
            key.add(r.nextInt(256));
        }
        credentialIds.add(key);
        return credentialIds;
    }

    private static List<List<Integer>> getWebAuthnKeysForUser(User user) {
        ArrayList<ArrayList<Integer>> credentialIds = null;
        for (Yubikey y : Yubikey.findForUser((User)user, (Yubikey.SecurityType[])new Yubikey.SecurityType[]{Yubikey.SecurityType.WEBAUTHN}).findList()) {
            byte[] c = Base64UrlUtil.decode((String)y.getCredentialId());
            ArrayList<Integer> l = new ArrayList<Integer>();
            for (byte b : c) {
                l.add(Byte.toUnsignedInt(b));
            }
            if (credentialIds == null) {
                credentialIds = new ArrayList<ArrayList<Integer>>();
            }
            credentialIds.add(l);
        }
        return credentialIds;
    }

    public static boolean checkWebAuthn(User user, byte[] authenticatorData, byte[] clientDataJSON, byte[] signature, String credentialId, byte[] challenge, List<WebAuthn> usedKeyReturnValue) {
        YubikeyHistory h = new YubikeyHistory();
        h.setUser(user);
        h.setPublicId(credentialId);
        Yubikey yubikey = Yubikey.findWebAuthnForUser((User)user, (String)credentialId);
        if (yubikey == null) {
            BLLoggerPlay.info("FAILED LOGIN ATTEMPT: Yubikey does not exist with credentialId: " + credentialId + "for userid " + user.getId());
            h.setErrorMessage("Yubikey does not exist with credentialId");
            DB.save((Object)h);
            return false;
        }
        WebAuthn webAuthn = WebAuthn.findByYubikey((Yubikey)yubikey);
        if (webAuthn == null) {
            BLLoggerPlay.info("FAILED LOGIN ATTEMPT: WebAuthnKey does not exist.");
            h.setErrorMessage("WebAuthnKey does not exist");
            DB.save((Object)h);
            return false;
        }
        if (challenge == null) {
            h.setErrorMessage("Timeout during login, challenge not found.");
            DB.save((Object)h);
            return false;
        }
        try {
            ByteArrayInputStream bin = new ByteArrayInputStream(webAuthn.getSerializedData());
            ObjectInputStream ois = new ObjectInputStream(bin);
            AttestedCredentialData data = (AttestedCredentialData)ois.readObject();
            AuthenticatorImpl authenticator = new AuthenticatorImpl(data, (AttestationStatement)new NoneAttestationStatement(), webAuthn.getCounter().longValue());
            AuthenticationRequest authenticationRequest = new AuthenticationRequest(Base64UrlUtil.decode((String)credentialId), HexTool.fromHex((String)user.getRandomId()), authenticatorData, clientDataJSON, null, signature);
            String url = Setup.WEBAUTHN_URL;
            String rpId = webAuthn.getRpId();
            if (rpId == null) {
                rpId = Setup.WEBAUTHN_RPID;
            }
            if (!url.contains(rpId) && Setup.WEBAUTHN_RPIP_OLD != null) {
                url = Setup.WEBAUTHN_RPIP_OLD.equals("localhost") ? "http://localhost:9000" : url.replace(Setup.WEBAUTHN_RPID, Setup.WEBAUTHN_RPIP_OLD);
            }
            ServerProperty serverProperty = new ServerProperty(new Origin(url), rpId, (Challenge)new DefaultChallenge(challenge), null);
            AuthenticationParameters authenticationParameters = new AuthenticationParameters(serverProperty, (Authenticator)authenticator, false);
            AuthenticationData authenticationData = Yubikeys.WEB_AUTHN_MANAGER.parse(authenticationRequest);
            Yubikeys.WEB_AUTHN_MANAGER.validate(authenticationData, authenticationParameters);
            webAuthn.setCounter(Long.valueOf(authenticationData.getAuthenticatorData().getSignCount()));
            DB.save((Object)webAuthn);
            h.setErrorMessage("OK");
            h.setOpt(HexTool.toHex((byte[])signature));
            DB.save((Object)h);
            if (usedKeyReturnValue != null) {
                usedKeyReturnValue.add(webAuthn);
            }
            return true;
        }
        catch (Exception e) {
            BLLoggerPlay.warning("FAILED LOGIN ATTEMPT: WebAuthnKey is not validated.", e);
            h.setErrorMessage(e.getMessage());
            DB.save((Object)h);
            return false;
        }
    }

    public static String loadJsParameters(WebAuthnData webAuthnData) {
        ObjectNode resultJson = Json.newObject();
        if (webAuthnData != null) {
            String challenge = webAuthnData.getChallenge();
            resultJson.put("challenge", challenge);
            ArrayNode arrayNode = resultJson.putArray("allowCredentials");
            for (List<Integer> allowedCredentialIds : webAuthnData.getAllowedCredentialIds()) {
                StringBuilder builder = new StringBuilder();
                for (Integer i : allowedCredentialIds) {
                    if (builder.length() > 0) {
                        builder.append(',');
                    }
                    builder.append(i);
                }
                arrayNode.addObject().put("id", builder.toString());
            }
        }
        return Base64.getEncoder().encodeToString(Json.asciiStringify((JsonNode)resultJson).getBytes(StandardCharsets.US_ASCII));
    }
}

