/*
 * Decompiled with CFR 0.152.
 */
package models;

import controllers.util.BLLoggerPlay;
import controllers.util.GeneralUtils;
import controllers.util.PasswordKeyEncryptionHandler;
import de.businesslogics.banking.api.EncryptData;
import de.businesslogics.banking.api.ImportMasterData;
import de.businesslogics.banking.api.Util;
import de.businesslogics.banking.bank.DatabaseToken;
import de.businesslogics.banking.database.api.DB;
import de.businesslogics.banking.database.vo.Tenant;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.zkasecurity.PasswordCallback;
import de.businesslogics.zkasecurity.SimplePasswordCallback;
import io.ebean.Transaction;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.sql.Date;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeoutException;
import java.util.regex.Pattern;
import org.xml.sax.SAXException;
import play.data.Form;
import play.data.validation.Constraints;
import play.i18n.Messages;

public final class UserSelectImportForm {
    @Constraints.Required
    public Integer tenantId;
    @Constraints.Required
    public String syncNumber;
    @Constraints.Required
    public String importPassword;
    private List<Tenant> tenants;

    public Form<UserSelectImportForm> validate(Form<UserSelectImportForm> form, User user, Messages messages) {
        if (this.tenantId > 0) {
            Tenant t = Tenant.findById((int)this.tenantId, (User)user, (boolean)false);
            if (t == null) {
                form = form.withError("tenantId", "tenants.noPermission");
            } else {
                this.tenants = Collections.singletonList(t);
            }
        } else {
            this.tenants = user.getTenants();
        }
        this.syncNumber = this.syncNumber.replaceAll("[^a-zA-Z0-9|]+", "");
        Pattern syncNumberPattern = Pattern.compile("(\\d{12}(\\|[0-9A-F]{32}){0,1})|([a-zA-Z0-9]{32}\\|[0-9A-F]{32})");
        if (this.syncNumber == null || this.syncNumber.length() == 0) {
            form = form.withError("syncNumber", "error.required");
        } else if (!syncNumberPattern.matcher(this.syncNumber).matches()) {
            form = form.withError("syncNumber", "error.invalid");
        }
        if (this.importPassword == null || this.importPassword.length() == 0) {
            form = form.withError("importPassword", "error.required");
        }
        return form;
    }

    public void runImport(User operatingUser) throws IOException, GeneralSecurityException, SAXException, TimeoutException {
        try (Transaction t = DB.beginTransaction();){
            operatingUser.setSecurityMedium(User.SecurityMedium.SOFTWARE);
            operatingUser.setEncryptionKey(EncryptData.getInstance().copyKey((EncryptData.KeyEncryptionHandler)new PasswordKeyEncryptionHandler(this.importPassword.toCharArray())));
            if (DatabaseToken.userKeysInKeybag) {
                operatingUser.setKeyDirectory(GeneralUtils.buildKeyDirForUser(operatingUser));
            } else {
                operatingUser.setKeyDirectory("DATABASE");
            }
            operatingUser.setLastPasswordChange(new Date(System.currentTimeMillis()));
            operatingUser.save();
            List tenants2 = operatingUser.getTenants();
            int pipePos = this.syncNumber.indexOf(124);
            String sync = pipePos > 0 ? this.syncNumber.substring(0, pipePos) : this.syncNumber;
            String key = pipePos > 0 ? this.syncNumber.substring(pipePos + 1) : null;
            ImportMasterData importMasterData = new ImportMasterData(operatingUser, Util.WORKSPACEDIR, (PasswordCallback)new SimplePasswordCallback(this.importPassword.toCharArray()), null, tenants2, false, false, BLLoggerPlay.getLogger());
            importMasterData.readFromLicenseServerWithRetry(sync, key);
            t.commit();
        }
    }
}

