/*
 * Decompiled with CFR 0.152.
 */
package models;

import controllers.util.BLLoggerPlay;
import controllers.util.EbicsUtil;
import de.businesslogics.banking.api.BankUtils;
import de.businesslogics.banking.api.BankingApiMessages;
import de.businesslogics.banking.api.PasswordRequirement;
import de.businesslogics.banking.api.Util;
import de.businesslogics.banking.core.EbicsWorker;
import de.businesslogics.banking.database.api.DB;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.database.vo.BankUser;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.ebics.schema.response.EbicsException;
import io.ebean.Transaction;
import java.io.File;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.List;
import java.util.Locale;
import play.data.Form;
import play.data.validation.Constraints;

public final class UserResetPasswordForm {
    @Constraints.Required
    public Integer userId;
    @Constraints.Required
    public String newPassword;
    @Constraints.Required
    public String confirmNewPassword;
    public boolean resetYubikeys = false;
    public boolean lockBankAccess = false;

    public Form<UserResetPasswordForm> validate(Form<UserResetPasswordForm> form, User user, Locale locale) {
        if (this.newPassword == null || this.newPassword.length() == 0) {
            return form.withError("newPassword", "error.required");
        }
        if (!this.newPassword.equals(this.confirmNewPassword)) {
            return form.withError("confirmNewPassword", BankingApiMessages.getString((Locale)locale, (String)"GeneralMessages.passwordsNotMatching", (Object[])new Object[0]));
        }
        String requirement = PasswordRequirement.getRequirement().check(this.newPassword.toCharArray(), user, locale);
        if (requirement != null) {
            return form.withError("newPassword", requirement);
        }
        return form;
    }

    public void resetBanksForUser(User user, boolean lockBanks) throws GeneralSecurityException, IOException, EbicsException {
        try (Transaction t = DB.beginTransaction();){
            File keyDir;
            if (lockBanks) {
                UserResetPasswordForm.lockUserInBanks(user, null);
            }
            BankUser.resetAllBanks((User)user);
            t.commit();
            String userKeyDir = user.getKeyDirectory();
            if (userKeyDir != null && !(keyDir = new File(Util.WORKSPACEDIR, userKeyDir)).renameTo(new File(keyDir.getParent(), "BACKUP_" + user.getName()))) {
                BLLoggerPlay.warning("Failed to create a backup for the key directory of the user " + user.getName());
            }
        }
    }

    public static void lockUserInBanks(User user, List<BankSettings> failedBanks) {
        for (BankUser bankUser : BankUser.findActiveBanksForUser((User)user)) {
            if (!BankUtils.isReady((BankUser)bankUser)) continue;
            try {
                EbicsWorker worker = EbicsUtil.getEbicsWorker(bankUser);
                worker.lockUserWithExistingSignature();
            }
            catch (EbicsException | IOException | GeneralSecurityException e) {
                BLLoggerPlay.error("Failed to send SPR for bank user " + bankUser.getId(), e);
                if (failedBanks == null) continue;
                failedBanks.add(bankUser.getBank());
            }
        }
    }
}

