/*
 * Decompiled with CFR 0.152.
 */
package models;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import controllers.Users;
import controllers.branding.Branding;
import controllers.routes;
import controllers.util.BLLoggerAdmin;
import controllers.util.PasswordKeyEncryptionHandler;
import de.businesslogics.banking.api.AdminLogger;
import de.businesslogics.banking.api.BankUtils;
import de.businesslogics.banking.api.BankingApiMessages;
import de.businesslogics.banking.api.DatabasePreferenceConstant;
import de.businesslogics.banking.api.DatabasePreferenceStore;
import de.businesslogics.banking.api.EncryptData;
import de.businesslogics.banking.api.PasswordRequirement;
import de.businesslogics.banking.database.api.DB;
import de.businesslogics.banking.database.vo.Account;
import de.businesslogics.banking.database.vo.AccountPermission;
import de.businesslogics.banking.database.vo.ApOverwrite;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.database.vo.BankUser;
import de.businesslogics.banking.database.vo.License;
import de.businesslogics.banking.database.vo.OrderType;
import de.businesslogics.banking.database.vo.Preference;
import de.businesslogics.banking.database.vo.Tenant;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.banking.database.vo.UserPermission;
import de.businesslogics.banking.preferences.PreferenceConstants;
import de.businesslogics.util.BLLogger;
import de.businesslogics.util.StringUtils;
import de.businesslogics.validation.RegularExpressions;
import io.ebean.Expr;
import io.ebean.ExpressionList;
import io.ebean.Transaction;
import java.io.IOException;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import play.data.Form;
import play.i18n.Messages;
import play.libs.Json;
import play.libs.Scala;
import scala.Tuple2;
import scala.collection.immutable.Seq;

public final class UserForm {
    public Map<Integer, BigDecimal> accountLimits = new HashMap<Integer, BigDecimal>();
    public String name;
    public int roleId = -1;
    public boolean isAdmin;
    public boolean isTenantAdmin;
    public boolean toBeImported;
    public boolean localUser;
    public String licenseCode;
    public boolean banking_allowViewAccountStatements;
    public boolean banking_allowDeleteStatements;
    public boolean banking_allowEditBankSettings;
    public boolean banking_allowFetchFiles;
    public boolean banking_allowSendFiles;
    public boolean banking_allowVEU;
    public boolean banking_allowNotifications;
    public boolean banking_allowPaymentRecording;
    public boolean banking_allowAWVRecording;
    public boolean banking_allowFolderFiles;
    public boolean banking_allowBanksAndAccounts;
    public boolean banking_allowSettings;
    public boolean banking_allowSynchronisation;
    public String banking_salaryPermissions;
    public boolean banking_confirmRecipientPermission;
    public boolean banking_allowUserCreation;
    public boolean banking_allowTenantCreation;
    public String password;
    public String confirmPassword;
    public Map<Integer, Boolean> banks = new HashMap<Integer, Boolean>();
    public Map<Integer, String> subscriberIDs = new HashMap<Integer, String>();
    public Map<Integer, String> accounts = new HashMap<Integer, String>();
    private String nameWithSuffix = null;
    private Set<BankSettings> banksToAdd;
    private Set<BankSettings> banksToRemove;
    private Map<BankSettings, String> subscriberIDsToChange;
    private Map<BankSettings, Set<ApOverwrite>> apOverwriteToSave;
    private Set<ApOverwrite> apOverwriteToRemove;
    private Map<BankSettings, Set<AccountPermission>> accountPermissionsToAdd;
    private Set<AccountPermission> accountPermissionsToRemove;

    public static String loadJsParameters(User user) {
        ObjectNode resultJson = Json.newObject();
        if (user != null) {
            resultJson.put("getEditModeUrl", routes.Users.editMode(user.getId(), "TAB").toString());
            resultJson.put("getUpdateLicenseUrl", routes.Users.updateLicense(user.getId(), "TAB").toString());
            resultJson.put("getResetUserPasswordUrl", routes.Users.resetUser(true, "TAB").toString());
            resultJson.put("getLockLoginUrl", routes.Users.lockLogin(true, "TAB").toString());
            resultJson.put("getUnlockLoginUrl", routes.Users.resetErrorCounter(user.getId(), true, "TAB").toString());
            resultJson.put("getEditUrl", routes.Users.edit(user.getId(), "TAB").toString());
            ArrayNode usersNode = resultJson.putArray("activeBankUsersWithKeys");
            for (BankUser bankUser : BankUser.findBanksForUser((User)user)) {
                if (!bankUser.hasActiveEBICSKeys()) continue;
                usersNode.addObject().put("bankId", String.valueOf(bankUser.getBank().getBankId()));
            }
        }
        return Base64.getEncoder().encodeToString(Json.asciiStringify((JsonNode)resultJson).getBytes(StandardCharsets.US_ASCII));
    }

    public static boolean isFieldEnabled(String fieldName, User loggedInUser, User editedUser, List<Tenant> tenants2, boolean inEditMode) {
        boolean editedUserIsNewUser;
        boolean isCurrentUser = editedUser != null && Objects.equals(loggedInUser.getId(), editedUser.getId());
        boolean bl = editedUserIsNewUser = editedUser == null || editedUser.getId() == null;
        if ("name".equals(fieldName)) {
            return editedUserIsNewUser || loggedInUser.isAdmin() && inEditMode || Branding.getBranding().allowTenantAdminUsernameUpdate() && inEditMode;
        }
        if ("localUser".equals(fieldName)) {
            if (!editedUserIsNewUser) {
                return !Users.isNumberOfUsersExceeded(loggedInUser) && !Users.isNumberOfUsersExceededForAny(editedUser.getTenants());
            }
            return !Users.isNumberOfUsersExceeded(loggedInUser) && !Users.isNumberOfUsersExceededForAny(tenants2);
        }
        if ("isAdmin".equals(fieldName)) {
            return loggedInUser.isAdmin() && (inEditMode || editedUserIsNewUser) && !isCurrentUser;
        }
        if ("toBeImported".equals(fieldName)) {
            return inEditMode && !editedUserIsNewUser;
        }
        if ("isTenantAdmin".equals(fieldName)) {
            return inEditMode && loggedInUser.isAdminOrTenantAdmin() && Branding.getBranding().doTenantsWithBank();
        }
        return true;
    }

    public static String getIdsFromTenants(Collection<Tenant> tenants2) {
        StringBuilder sb = new StringBuilder();
        boolean appending = false;
        for (Tenant tenant : tenants2) {
            if (appending) {
                sb.append(',');
            }
            sb.append(tenant.getId());
            appending = true;
        }
        return sb.toString();
    }

    public static UserForm getDefaults() {
        UserForm result = new UserForm();
        result.banking_allowAWVRecording = Boolean.parseBoolean(PreferenceConstants.ALLOW_AWV_RECORDING.getDefaultValue());
        result.banking_allowBanksAndAccounts = Boolean.parseBoolean(PreferenceConstants.ALLOW_BANKS_AND_ACCOUNTS.getDefaultValue());
        result.banking_allowDeleteStatements = Boolean.parseBoolean(PreferenceConstants.ALLOW_DELETE_STATMENTS.getDefaultValue());
        result.banking_allowEditBankSettings = Boolean.parseBoolean(PreferenceConstants.ALLOW_EDIT_BANK_SETTINGS.getDefaultValue());
        result.banking_allowFetchFiles = Boolean.parseBoolean(PreferenceConstants.ALLOW_FETCH_FILES.getDefaultValue());
        result.banking_allowNotifications = Boolean.parseBoolean(PreferenceConstants.ALLOW_NOTIFICATIONS.getDefaultValue());
        result.banking_allowFolderFiles = Boolean.parseBoolean(PreferenceConstants.ALLOW_FOLDER_FILES.getDefaultValue());
        result.banking_allowPaymentRecording = Boolean.parseBoolean(PreferenceConstants.ALLOW_PAYMENT_RECORDING.getDefaultValue());
        result.banking_allowSendFiles = Boolean.parseBoolean(PreferenceConstants.ALLOW_SEND_FILES.getDefaultValue());
        result.banking_allowSettings = Boolean.parseBoolean(PreferenceConstants.ALLOW_SETTINGS.getDefaultValue());
        result.banking_allowSynchronisation = Boolean.parseBoolean(PreferenceConstants.ALLOW_SYNCHRONISATION.getDefaultValue());
        result.banking_allowTenantCreation = Boolean.parseBoolean(PreferenceConstants.ALLOW_TENANT_CREATION.getDefaultValue());
        result.banking_allowUserCreation = Boolean.parseBoolean(PreferenceConstants.ALLOW_USER_CREATION.getDefaultValue());
        result.banking_allowVEU = Boolean.parseBoolean(PreferenceConstants.ALLOW_VEU.getDefaultValue());
        result.banking_allowViewAccountStatements = Boolean.parseBoolean(PreferenceConstants.ALLOW_VIEW_ACCOUNT_STATEMENTS.getDefaultValue());
        result.banking_confirmRecipientPermission = Boolean.parseBoolean(PreferenceConstants.CONFIRM_RECIPIENT_PERMISSION.getDefaultValue());
        result.banking_salaryPermissions = PreferenceConstants.SALARY_PERMISSIONS.getDefaultValue();
        return result;
    }

    public static Seq<Tuple2<String, String>> getSelectableRoles(Messages messages, boolean includeEmpty) {
        ArrayList<Tuple2> result = new ArrayList<Tuple2>();
        if (includeEmpty) {
            result.add(Scala.Tuple((Object)"-1", (Object)""));
        }
        for (SANTANDER_ROLES role : SANTANDER_ROLES.values()) {
            result.add(Scala.Tuple((Object)("" + role.ordinal()), (Object)messages.at("santander.role." + role.name(), new Object[0])));
        }
        return Scala.toSeq(result);
    }

    public static UserForm fill(User user) {
        UserForm result = new UserForm();
        result.name = user.getName();
        result.isAdmin = user.isAdmin();
        result.isTenantAdmin = false;
        result.localUser = user.isLocalUser();
        result.toBeImported = user.isToBeImported();
        if (user.getWebLicense() != null) {
            result.licenseCode = user.getWebLicense().getId();
        }
        DatabasePreferenceStore preferenceStore = new DatabasePreferenceStore(Preference.ApplicationId.BANKING, user);
        result.banking_allowViewAccountStatements = preferenceStore.getBoolean((DatabasePreferenceConstant)PreferenceConstants.ALLOW_VIEW_ACCOUNT_STATEMENTS);
        result.banking_allowFetchFiles = preferenceStore.getBoolean((DatabasePreferenceConstant)PreferenceConstants.ALLOW_FETCH_FILES);
        result.banking_allowSendFiles = preferenceStore.getBoolean((DatabasePreferenceConstant)PreferenceConstants.ALLOW_SEND_FILES);
        result.banking_allowVEU = preferenceStore.getBoolean((DatabasePreferenceConstant)PreferenceConstants.ALLOW_VEU);
        result.banking_allowNotifications = preferenceStore.getBoolean((DatabasePreferenceConstant)PreferenceConstants.ALLOW_NOTIFICATIONS);
        result.banking_allowPaymentRecording = preferenceStore.getBoolean((DatabasePreferenceConstant)PreferenceConstants.ALLOW_PAYMENT_RECORDING);
        result.banking_allowAWVRecording = preferenceStore.getBoolean((DatabasePreferenceConstant)PreferenceConstants.ALLOW_AWV_RECORDING);
        result.banking_allowFolderFiles = preferenceStore.getBoolean((DatabasePreferenceConstant)PreferenceConstants.ALLOW_FOLDER_FILES);
        result.banking_allowSettings = preferenceStore.getBoolean((DatabasePreferenceConstant)PreferenceConstants.ALLOW_SETTINGS);
        result.banking_allowBanksAndAccounts = preferenceStore.getBoolean((DatabasePreferenceConstant)PreferenceConstants.ALLOW_BANKS_AND_ACCOUNTS);
        result.banking_allowSynchronisation = preferenceStore.getBoolean((DatabasePreferenceConstant)PreferenceConstants.ALLOW_SYNCHRONISATION);
        result.banking_salaryPermissions = preferenceStore.getString((DatabasePreferenceConstant)PreferenceConstants.SALARY_PERMISSIONS);
        if (result.banking_salaryPermissions == null || result.banking_salaryPermissions.length() == 0) {
            result.banking_salaryPermissions = PreferenceConstants.SALARY_PERMISSIONS.getDefaultValue();
        }
        result.banking_confirmRecipientPermission = preferenceStore.getBoolean((DatabasePreferenceConstant)PreferenceConstants.CONFIRM_RECIPIENT_PERMISSION);
        result.banking_allowUserCreation = preferenceStore.getBoolean((DatabasePreferenceConstant)PreferenceConstants.ALLOW_USER_CREATION);
        result.banking_allowTenantCreation = preferenceStore.getBoolean((DatabasePreferenceConstant)PreferenceConstants.ALLOW_TENANT_CREATION);
        result.banking_allowDeleteStatements = preferenceStore.getBoolean((DatabasePreferenceConstant)PreferenceConstants.ALLOW_DELETE_STATMENTS);
        result.banking_allowEditBankSettings = preferenceStore.getBoolean((DatabasePreferenceConstant)PreferenceConstants.ALLOW_EDIT_BANK_SETTINGS);
        for (BankSettings bank : BankSettings.findBanksForTenants((List)user.getTenants())) {
            BankUser bankUser = BankUser.findBankUser((BankSettings)bank, (User)user);
            int bankID = bank.getBankId();
            result.banks.put(bankID, bankUser != null);
            result.subscriberIDs.put(bankID, bankUser != null && bankUser.getDefaultUser() != null ? bankUser.getDefaultUser() : "");
            for (Account account : Account.findAccountsForBank((BankSettings)bank)) {
                AccountPermission accountPermission;
                ApOverwrite apOverwrite = ApOverwrite.findByBankAndAccount((BankUser)bankUser, (Account)account);
                if (apOverwrite == null) {
                    if (account.getType() == Account.Type.HTD && !user.isLocalUser()) {
                        result.accounts.put(account.getId(), "default");
                        continue;
                    }
                    accountPermission = AccountPermission.findAccountPermissionForBank((BankUser)bankUser, (Account)account);
                    result.accounts.put(account.getId(), String.valueOf(accountPermission != null));
                    continue;
                }
                accountPermission = AccountPermission.findAccountPermissionForBank((BankUser)bankUser, (Account)account);
                result.accounts.put(account.getId(), String.valueOf(accountPermission != null));
                result.accountLimits.put(account.getId(), apOverwrite.getAmountLimit());
            }
        }
        return result;
    }

    public Form<UserForm> validate(Form<UserForm> form, User operator, User toUpdate, List<Tenant> tenants2, Locale locale) {
        String requirement;
        boolean isNewUser;
        boolean bl = isNewUser = toUpdate == null;
        if (isNewUser && (this.password == null || this.password.length() == 0)) {
            form = form.withError("password", "error.required");
        } else if (this.password != null && this.password.length() > 0 && !this.password.equals(this.confirmPassword)) {
            form = form.withError("password", BankingApiMessages.getString((Locale)locale, (String)"GeneralMessages.passwordsNotMatching", (Object[])new Object[0]));
            form = form.withError("confirmPassword", BankingApiMessages.getString((Locale)locale, (String)"GeneralMessages.passwordsNotMatching", (Object[])new Object[0]));
        } else if (this.password != null && this.password.length() > 0 && (requirement = PasswordRequirement.getRequirement().check(this.password.toCharArray(), null, locale)) != null) {
            form = form.withError("password", requirement);
        }
        if (isNewUser) {
            String suffix = Branding.getBranding().getUsernameSuffix().orElse("");
            this.nameWithSuffix = this.name + suffix;
        } else {
            this.nameWithSuffix = this.name;
        }
        if (UserForm.isFieldEnabled("name", operator, toUpdate, tenants2, true)) {
            if (this.name == null || this.name.length() == 0) {
                form = form.withError("name", "error.required");
            } else if (this.nameWithSuffix.length() > 255) {
                form = form.withError("name", "error.tooLong", Collections.singletonList(this.nameWithSuffix.length() - 255));
            } else {
                User user = User.getUser((String)this.nameWithSuffix);
                if (user != null && (isNewUser || !user.getId().equals(toUpdate.getId()))) {
                    form = form.withError("name", BankingApiMessages.getString((Locale)locale, (String)"GeneralMessages.nameAlreadyExists", (Object[])new Object[0]));
                } else if (this.nameWithSuffix.toUpperCase().contains("<SCRIPT")) {
                    form = form.withError("name", BankingApiMessages.getString((Locale)locale, (String)"GeneralMessages.nameInvalid", (Object[])new Object[0]));
                }
            }
        }
        if (!this.isAdmin) {
            ExpressionList expr = DB.find(User.class).where().eq("admin", (Object)true);
            if (!isNewUser) {
                expr = expr.not(Expr.eq((String)"id", (Object)toUpdate.getId()));
            }
            if (expr.findCount() == 0) {
                form = form.withGlobalError("users.noadmins");
            }
        }
        if (this.localUser) {
            if (!isNewUser && !toUpdate.isLocalUser()) {
                form = form.withGlobalError("users.settolocale");
            }
        } else if (!isNewUser && toUpdate.isLocalUser()) {
            form = form.withGlobalError("users.settobankuser");
        }
        form = this.handleBanksAndAccounts((Form<UserForm>)form, toUpdate, tenants2);
        return form;
    }

    public void store(User operator, User user, License license2, List<Tenant> tenants2) throws GeneralSecurityException, IOException {
        try (Transaction t = DB.beginTransaction();){
            Object bankUser;
            boolean isNewUser = user.getId() == null;
            boolean userNameChanged = false;
            String oldName = user.getName();
            if (UserForm.isFieldEnabled("name", operator, user, tenants2, true)) {
                userNameChanged = !Objects.equals(oldName, this.nameWithSuffix);
                user.setName(this.nameWithSuffix);
            }
            boolean adminFlagChanged = false;
            if (UserForm.isFieldEnabled("isAdmin", operator, user, tenants2, true)) {
                Boolean oldAdminFlag = user.isAdmin();
                adminFlagChanged = !Objects.equals(oldAdminFlag, this.isAdmin);
                user.setAdmin(this.isAdmin);
            }
            if (isNewUser && UserForm.isFieldEnabled("isTenantAdmin", operator, user, tenants2, true) && this.isTenantAdmin) {
                user.setManagedTenants(operator.getManageableTenants());
            }
            if (!UserForm.isFieldEnabled("localUser", operator, user, tenants2, true) && user.getId() != null) {
                boolean bl = this.localUser = user.getSecurityMedium() == User.SecurityMedium.DUMMY;
            }
            if (user.getId() == null) {
                if (this.localUser) {
                    user.setSecurityMedium(User.SecurityMedium.DUMMY);
                } else if (this.toBeImported) {
                    user.setSecurityMedium(User.SecurityMedium.IMPORT);
                } else {
                    user.setSecurityMedium(User.SecurityMedium.SOFTWARE);
                }
            } else if (!this.toBeImported && user.isToBeImported()) {
                if (this.localUser) {
                    user.setSecurityMedium(User.SecurityMedium.DUMMY);
                } else {
                    user.setSecurityMedium(User.SecurityMedium.SOFTWARE);
                }
            }
            if (UserForm.isFieldEnabled("password", operator, user, tenants2, true) && this.password != null) {
                user.setEncryptionKey(EncryptData.getInstance().copyKey((EncryptData.KeyEncryptionHandler)new PasswordKeyEncryptionHandler(this.password.toCharArray())));
            }
            if (UserForm.isFieldEnabled("licenseCode", operator, user, tenants2, true) && user.getWebLicense() == null) {
                user.setWebLicense(license2);
            }
            if (tenants2 != null) {
                user.setTenants(tenants2);
            }
            user.save();
            if (this.password != null) {
                PasswordRequirement.getRequirement().saveUsage(user, this.password.toCharArray(), null);
            }
            if (this.banksToAdd != null) {
                for (BankSettings bank : this.banksToAdd) {
                    bankUser = BankUser.createBankUser((BankSettings)bank, (User)user);
                    for (OrderType o : OrderType.findSendOrderTypesForBank((BankSettings)bank)) {
                        UserPermission userPermission = new UserPermission();
                        userPermission.setBankUser((BankUser)bankUser);
                        userPermission.setOrderType(o);
                        userPermission.save();
                    }
                }
            }
            if (this.banksToRemove != null) {
                for (BankSettings bank : this.banksToRemove) {
                    bankUser = BankUser.findBankUser((BankSettings)bank, (User)user);
                    if (bankUser == null) continue;
                    bankUser.delete();
                }
            }
            if (this.subscriberIDsToChange != null) {
                for (BankSettings bank : this.subscriberIDsToChange.keySet()) {
                    BankUser bankUser2 = BankUser.findBankUser((BankSettings)bank, (User)user);
                    if (bankUser2 == null) continue;
                    String newSubscriberID = this.subscriberIDsToChange.get(bank);
                    if (newSubscriberID == null) {
                        BankUser.UserState bankUserState = bankUser2.getState();
                        if (bankUserState == BankUser.UserState.CREATED || bankUserState == BankUser.UserState.READY || bankUserState == BankUser.UserState.KEY_CHANGE_REQUIRED) continue;
                        bankUser2.setDefaultUser(null);
                        bankUser2.save();
                        continue;
                    }
                    BankUtils.updateBankUser((BankUser)bankUser2, (String)newSubscriberID, (BLLogger)BLLoggerAdmin.getLogger());
                }
            }
            if (this.accountPermissionsToAdd != null) {
                for (BankSettings bank : this.accountPermissionsToAdd.keySet()) {
                    for (AccountPermission accountPermission : this.accountPermissionsToAdd.get(bank)) {
                        if (accountPermission.getBankUser() == null || accountPermission.getBankUser().getId() == null) {
                            accountPermission.setBankUser(BankUser.findBankUser((BankSettings)bank, (User)user));
                        }
                        accountPermission.save();
                    }
                }
            }
            if (this.accountPermissionsToRemove != null) {
                for (AccountPermission accountPermission : this.accountPermissionsToRemove) {
                    accountPermission.delete();
                }
            }
            if (this.apOverwriteToSave != null) {
                for (BankSettings bank : this.apOverwriteToSave.keySet()) {
                    for (ApOverwrite apOverwrite : this.apOverwriteToSave.get(bank)) {
                        if (apOverwrite.getBankUser() == null || apOverwrite.getBankUser().getId() == null) {
                            apOverwrite.setBankUser(BankUser.findBankUser((BankSettings)bank, (User)user));
                        }
                        apOverwrite.save();
                    }
                }
            }
            if (this.apOverwriteToRemove != null) {
                for (ApOverwrite apOverwrite : this.apOverwriteToRemove) {
                    apOverwrite.delete();
                }
            }
            boolean allowViewAccountsChanged = false;
            boolean allowFetchFilesChanged = false;
            boolean allowSendFilesChanged = false;
            boolean allowEdsChanged = false;
            boolean allowNotificationsChanged = false;
            boolean allowPaymentRecordingChanged = false;
            boolean allowAwvRecordingChanged = false;
            boolean allowFolderFilesChanged = false;
            boolean allowSettingsChanged = false;
            boolean allowBanksAndAccountsChanged = false;
            boolean allowSyncChanged = false;
            boolean allowSalaryChanged = false;
            boolean allowConfirmRecipientsChanged = false;
            boolean allowUserCreationChanged = false;
            boolean allowTenantCreationChanged = false;
            boolean allowDeleteStatementsChanged = false;
            boolean allowEditBankSettingsChanged = false;
            if (operator.isAdminOrTenantAdmin()) {
                DatabasePreferenceStore preferenceStore = new DatabasePreferenceStore(Preference.ApplicationId.BANKING, user);
                allowViewAccountsChanged = !Objects.equals(this.banking_allowViewAccountStatements, preferenceStore.getBoolean((DatabasePreferenceConstant)PreferenceConstants.ALLOW_VIEW_ACCOUNT_STATEMENTS));
                preferenceStore.setValue((DatabasePreferenceConstant)PreferenceConstants.ALLOW_VIEW_ACCOUNT_STATEMENTS, this.banking_allowViewAccountStatements);
                allowFetchFilesChanged = !Objects.equals(this.banking_allowFetchFiles, preferenceStore.getBoolean((DatabasePreferenceConstant)PreferenceConstants.ALLOW_FETCH_FILES));
                preferenceStore.setValue((DatabasePreferenceConstant)PreferenceConstants.ALLOW_FETCH_FILES, this.banking_allowFetchFiles);
                allowSendFilesChanged = !Objects.equals(this.banking_allowSendFiles, preferenceStore.getBoolean((DatabasePreferenceConstant)PreferenceConstants.ALLOW_SEND_FILES));
                preferenceStore.setValue((DatabasePreferenceConstant)PreferenceConstants.ALLOW_SEND_FILES, this.banking_allowSendFiles);
                allowEdsChanged = !Objects.equals(this.banking_allowVEU, preferenceStore.getBoolean((DatabasePreferenceConstant)PreferenceConstants.ALLOW_VEU));
                preferenceStore.setValue((DatabasePreferenceConstant)PreferenceConstants.ALLOW_VEU, this.banking_allowVEU);
                allowNotificationsChanged = !Objects.equals(this.banking_allowNotifications, preferenceStore.getBoolean((DatabasePreferenceConstant)PreferenceConstants.ALLOW_NOTIFICATIONS));
                preferenceStore.setValue((DatabasePreferenceConstant)PreferenceConstants.ALLOW_NOTIFICATIONS, this.banking_allowNotifications);
                allowPaymentRecordingChanged = !Objects.equals(this.banking_allowPaymentRecording, preferenceStore.getBoolean((DatabasePreferenceConstant)PreferenceConstants.ALLOW_PAYMENT_RECORDING));
                preferenceStore.setValue((DatabasePreferenceConstant)PreferenceConstants.ALLOW_PAYMENT_RECORDING, this.banking_allowPaymentRecording);
                allowAwvRecordingChanged = !Objects.equals(this.banking_allowAWVRecording, preferenceStore.getBoolean((DatabasePreferenceConstant)PreferenceConstants.ALLOW_AWV_RECORDING));
                preferenceStore.setValue((DatabasePreferenceConstant)PreferenceConstants.ALLOW_AWV_RECORDING, this.banking_allowAWVRecording);
                allowFolderFilesChanged = !Objects.equals(this.banking_allowFolderFiles, preferenceStore.getBoolean((DatabasePreferenceConstant)PreferenceConstants.ALLOW_FOLDER_FILES));
                preferenceStore.setValue((DatabasePreferenceConstant)PreferenceConstants.ALLOW_FOLDER_FILES, this.banking_allowFolderFiles);
                allowBanksAndAccountsChanged = !Objects.equals(this.banking_allowBanksAndAccounts, preferenceStore.getBoolean((DatabasePreferenceConstant)PreferenceConstants.ALLOW_BANKS_AND_ACCOUNTS));
                preferenceStore.setValue((DatabasePreferenceConstant)PreferenceConstants.ALLOW_BANKS_AND_ACCOUNTS, this.banking_allowBanksAndAccounts);
                if (Branding.getBranding().showSettingsMenuPref()) {
                    allowSettingsChanged = !Objects.equals(this.banking_allowSettings, preferenceStore.getBoolean((DatabasePreferenceConstant)PreferenceConstants.ALLOW_SETTINGS));
                    preferenceStore.setValue((DatabasePreferenceConstant)PreferenceConstants.ALLOW_SETTINGS, this.banking_allowSettings);
                }
                allowSyncChanged = !Objects.equals(this.banking_allowSynchronisation, preferenceStore.getBoolean((DatabasePreferenceConstant)PreferenceConstants.ALLOW_SYNCHRONISATION));
                preferenceStore.setValue((DatabasePreferenceConstant)PreferenceConstants.ALLOW_SYNCHRONISATION, this.banking_allowSynchronisation);
                if (this.banking_salaryPermissions != null && this.banking_salaryPermissions.length() > 0) {
                    String oldAllowViewAccounts = preferenceStore.getString((DatabasePreferenceConstant)PreferenceConstants.SALARY_PERMISSIONS);
                    allowSalaryChanged = !Objects.equals(oldAllowViewAccounts, this.banking_salaryPermissions);
                    preferenceStore.setValue((DatabasePreferenceConstant)PreferenceConstants.SALARY_PERMISSIONS, this.banking_salaryPermissions);
                }
                allowConfirmRecipientsChanged = !Objects.equals(this.banking_confirmRecipientPermission, preferenceStore.getBoolean((DatabasePreferenceConstant)PreferenceConstants.CONFIRM_RECIPIENT_PERMISSION));
                preferenceStore.setValue((DatabasePreferenceConstant)PreferenceConstants.CONFIRM_RECIPIENT_PERMISSION, this.banking_confirmRecipientPermission);
                allowUserCreationChanged = !Objects.equals(this.banking_allowUserCreation, preferenceStore.getBoolean((DatabasePreferenceConstant)PreferenceConstants.ALLOW_USER_CREATION));
                preferenceStore.setValue((DatabasePreferenceConstant)PreferenceConstants.ALLOW_USER_CREATION, this.banking_allowUserCreation);
                allowTenantCreationChanged = !Objects.equals(this.banking_allowTenantCreation, preferenceStore.getBoolean((DatabasePreferenceConstant)PreferenceConstants.ALLOW_TENANT_CREATION));
                preferenceStore.setValue((DatabasePreferenceConstant)PreferenceConstants.ALLOW_TENANT_CREATION, this.banking_allowTenantCreation);
                allowDeleteStatementsChanged = !Objects.equals(this.banking_allowDeleteStatements, preferenceStore.getBoolean((DatabasePreferenceConstant)PreferenceConstants.ALLOW_DELETE_STATMENTS));
                preferenceStore.setValue((DatabasePreferenceConstant)PreferenceConstants.ALLOW_DELETE_STATMENTS, this.banking_allowDeleteStatements);
                allowEditBankSettingsChanged = !Objects.equals(this.banking_allowEditBankSettings, preferenceStore.getBoolean((DatabasePreferenceConstant)PreferenceConstants.ALLOW_EDIT_BANK_SETTINGS));
                preferenceStore.setValue((DatabasePreferenceConstant)PreferenceConstants.ALLOW_EDIT_BANK_SETTINGS, this.banking_allowEditBankSettings);
            }
            t.commit();
            AdminLogger logger = new AdminLogger((BLLogger)BLLoggerAdmin.getLogger());
            if (isNewUser) {
                logger.logUserCreated(operator, user);
            } else {
                boolean detailsLogged = false;
                if (userNameChanged) {
                    logger.logUserRenamed(operator, user, oldName);
                    detailsLogged = true;
                }
                if (adminFlagChanged) {
                    logger.logUserChangedAdminPrivileges(operator, user);
                    detailsLogged = true;
                }
                for (BankSettings bankSettings : this.banksToAdd) {
                    logger.logBankAddedUser(operator, user, bankSettings);
                    detailsLogged = true;
                }
                for (BankSettings bankSettings : this.banksToRemove) {
                    logger.logBankRemovedUser(operator, user, bankSettings);
                    detailsLogged = true;
                }
                if (allowViewAccountsChanged) {
                    logger.logUserChangedPermission(operator, user, "view accounts", this.banking_allowViewAccountStatements);
                    detailsLogged = true;
                }
                if (allowFetchFilesChanged) {
                    logger.logUserChangedPermission(operator, user, "fetch files", this.banking_allowFetchFiles);
                    detailsLogged = true;
                }
                if (allowSendFilesChanged) {
                    logger.logUserChangedPermission(operator, user, "send files", this.banking_allowSendFiles);
                    detailsLogged = true;
                }
                if (allowEdsChanged) {
                    logger.logUserChangedPermission(operator, user, "access the VEU/EDS", this.banking_allowVEU);
                    detailsLogged = true;
                }
                if (allowNotificationsChanged) {
                    logger.logUserChangedPermission(operator, user, "access the notifications", this.banking_allowNotifications);
                    detailsLogged = true;
                }
                if (allowPaymentRecordingChanged) {
                    logger.logUserChangedPermission(operator, user, "record payments", this.banking_allowPaymentRecording);
                    detailsLogged = true;
                }
                if (allowAwvRecordingChanged) {
                    logger.logUserChangedPermission(operator, user, "record AWV payments", this.banking_allowAWVRecording);
                    detailsLogged = true;
                }
                if (allowFolderFilesChanged) {
                    logger.logUserChangedPermission(operator, user, "see and send files from watched directories", this.banking_allowFolderFiles);
                    detailsLogged = true;
                }
                if (allowSettingsChanged) {
                    logger.logUserChangedPermission(operator, user, "modify preference settings", this.banking_allowSettings);
                    detailsLogged = true;
                }
                if (allowBanksAndAccountsChanged) {
                    logger.logUserChangedPermission(operator, user, "see banks and accounts in settings", this.banking_allowBanksAndAccounts);
                    detailsLogged = true;
                }
                if (allowSyncChanged) {
                    logger.logUserChangedPermission(operator, user, "perform synchronisation with iOS/Android app", this.banking_allowSynchronisation);
                    detailsLogged = true;
                }
                if (allowSalaryChanged) {
                    logger.logUserChangedSalaryPermission(operator, user, this.banking_salaryPermissions);
                    detailsLogged = true;
                }
                if (allowConfirmRecipientsChanged) {
                    logger.logUserChangedPermission(operator, user, "confirm recipients in four-eyes principle", this.banking_confirmRecipientPermission);
                    detailsLogged = true;
                }
                if (allowUserCreationChanged) {
                    logger.logUserChangedPermission(operator, user, "create users and modify or delete admins", this.banking_allowUserCreation);
                    detailsLogged = true;
                }
                if (allowTenantCreationChanged) {
                    logger.logUserChangedPermission(operator, user, "create or delete tenants", this.banking_allowTenantCreation);
                    detailsLogged = true;
                }
                if (allowDeleteStatementsChanged) {
                    logger.logUserChangedPermission(operator, user, "delete statements", this.banking_allowDeleteStatements);
                    detailsLogged = true;
                }
                if (allowEditBankSettingsChanged) {
                    logger.logUserChangedPermission(operator, user, "edit bank settings", this.banking_allowEditBankSettings);
                    detailsLogged = true;
                }
                for (Map.Entry entry : this.subscriberIDsToChange.entrySet()) {
                    logger.logUserChangedDefaultUser(operator, user, (BankSettings)entry.getKey(), (String)entry.getValue());
                    detailsLogged = true;
                }
                if (!detailsLogged) {
                    logger.logUserModified(operator, user);
                }
            }
        }
    }

    private Form<UserForm> handleBanksAndAccounts(Form<UserForm> form, User toUpdate, List<Tenant> tenants2) {
        this.banksToAdd = new HashSet<BankSettings>();
        this.banksToRemove = new HashSet<BankSettings>();
        this.subscriberIDsToChange = new HashMap<BankSettings, String>();
        this.apOverwriteToSave = new HashMap<BankSettings, Set<ApOverwrite>>();
        this.apOverwriteToRemove = new HashSet<ApOverwrite>();
        this.accountPermissionsToAdd = new HashMap<BankSettings, Set<AccountPermission>>();
        this.accountPermissionsToRemove = new HashSet<AccountPermission>();
        for (BankSettings bank : BankSettings.findBanksForTenants((List)(tenants2 != null ? tenants2 : toUpdate.getTenants()))) {
            BankUser bankUser = BankUser.findBankUser((BankSettings)bank, (User)toUpdate);
            if (Boolean.TRUE.equals(this.banks.get(bank.getBankId()))) {
                boolean subscriberIDChanged;
                if (toUpdate == null || toUpdate.getId() == null || bankUser == null) {
                    this.banksToAdd.add(bank);
                }
                String newSubscriberID = StringUtils.checkNullAndTrim((String)this.subscriberIDs.getOrDefault(bank.getBankId(), ""));
                boolean newSubscriberIDEmpty = newSubscriberID.isEmpty();
                String oldSubscriberID = StringUtils.checkNullAndTrim((String)(bankUser != null ? bankUser.getDefaultUser() : ""));
                boolean oldSubscriberIDEmpty = oldSubscriberID.isEmpty();
                boolean bl = subscriberIDChanged = !Objects.equals(newSubscriberID, oldSubscriberID);
                if (subscriberIDChanged) {
                    if (!newSubscriberIDEmpty && !StringUtils.check((String)newSubscriberID, (RegularExpressions)RegularExpressions.EBICS_V24_USER_ID)) {
                        form = form.withError("subscriberIDs[" + bank.getBankId() + "]", "general.error.invalidCharacters");
                    } else if (newSubscriberIDEmpty && !oldSubscriberIDEmpty) {
                        this.subscriberIDsToChange.put(bank, null);
                    } else if (!newSubscriberIDEmpty) {
                        this.subscriberIDsToChange.put(bank, newSubscriberID);
                    }
                }
                for (Account account : Account.findAccountsForBank((BankSettings)bank)) {
                    Set apOverwrites;
                    Set accountPermissions;
                    AccountPermission accountPermission;
                    ApOverwrite apOverwrite;
                    boolean defaultSettingPossible;
                    String accountPermissionOption = this.accounts.get(account.getId());
                    BigDecimal accountLimit = this.accountLimits.get(account.getId());
                    boolean bl2 = defaultSettingPossible = account.isHTDAccount() && (toUpdate == null && !this.localUser || toUpdate != null && !toUpdate.isLocalUser());
                    if (!defaultSettingPossible && "default".equals(accountPermissionOption)) {
                        accountPermissionOption = "true";
                    }
                    if ("default".equals(accountPermissionOption)) {
                        apOverwrite = ApOverwrite.findByBankAndAccount((BankUser)bankUser, (Account)account);
                        if (apOverwrite == null) continue;
                        accountPermission = AccountPermission.findAccountPermissionForBank((BankUser)bankUser, (Account)account);
                        if (apOverwrite.isPreviousEnabled() && accountPermission == null) {
                            accountPermission = new AccountPermission();
                            accountPermission.setBankUser(bankUser);
                            accountPermission.setAccount(account);
                            accountPermissions = this.accountPermissionsToAdd.computeIfAbsent(bank, k -> new HashSet());
                            accountPermissions.add(accountPermission);
                        } else if (!apOverwrite.isPreviousEnabled() && accountPermission != null) {
                            this.accountPermissionsToRemove.add(accountPermission);
                        }
                        this.apOverwriteToRemove.add(apOverwrite);
                        continue;
                    }
                    if (Boolean.parseBoolean(accountPermissionOption)) {
                        if (account.getType() == Account.Type.HTD) {
                            accountPermission = AccountPermission.findAccountPermissionForBank((BankUser)bankUser, (Account)account);
                            apOverwrite = ApOverwrite.findByBankAndAccount((BankUser)bankUser, (Account)account);
                            if (apOverwrite == null) {
                                apOverwrite = new ApOverwrite();
                                apOverwrite.setBankUser(bankUser);
                                apOverwrite.setAccount(account);
                                apOverwrite.setPreviousEnabled(accountPermission != null);
                                apOverwrite.setAmountLimit(accountLimit);
                                apOverwrites = this.apOverwriteToSave.computeIfAbsent(bank, k -> new HashSet());
                                apOverwrites.add(apOverwrite);
                            } else if (apOverwrite.getAmountLimit() == null && accountLimit != null || apOverwrite.getAmountLimit() != null && !apOverwrite.getAmountLimit().equals(accountLimit)) {
                                apOverwrite.setAmountLimit(accountLimit);
                                apOverwrites = this.apOverwriteToSave.computeIfAbsent(bank, k -> new HashSet());
                                apOverwrites.add(apOverwrite);
                            }
                            if (accountPermission != null) continue;
                            accountPermission = new AccountPermission();
                            accountPermission.setBankUser(bankUser);
                            accountPermission.setAccount(account);
                            accountPermissions = this.accountPermissionsToAdd.computeIfAbsent(bank, k -> new HashSet());
                            accountPermissions.add(accountPermission);
                            continue;
                        }
                        accountPermission = AccountPermission.findAccountPermissionForBank((BankUser)bankUser, (Account)account);
                        if (accountPermission == null) {
                            accountPermission = new AccountPermission();
                            accountPermission.setBankUser(bankUser);
                            accountPermission.setAccount(account);
                            accountPermissions = this.accountPermissionsToAdd.computeIfAbsent(bank, k -> new HashSet());
                            accountPermissions.add(accountPermission);
                        }
                        if ((apOverwrite = ApOverwrite.findByBankAndAccount((BankUser)bankUser, (Account)account)) == null && accountLimit != null) {
                            apOverwrite = new ApOverwrite();
                            apOverwrite.setBankUser(bankUser);
                            apOverwrite.setAccount(account);
                            apOverwrite.setPreviousEnabled(accountPermission.getId() != null);
                            apOverwrite.setAmountLimit(accountLimit);
                            apOverwrites = this.apOverwriteToSave.computeIfAbsent(bank, k -> new HashSet());
                            apOverwrites.add(apOverwrite);
                            continue;
                        }
                        if (apOverwrite == null || (apOverwrite.getAmountLimit() != null || accountLimit == null) && (apOverwrite.getAmountLimit() == null || apOverwrite.getAmountLimit().equals(accountLimit))) continue;
                        apOverwrite.setAmountLimit(accountLimit);
                        apOverwrites = this.apOverwriteToSave.computeIfAbsent(bank, k -> new HashSet());
                        apOverwrites.add(apOverwrite);
                        continue;
                    }
                    if (account.getType() == Account.Type.HTD) {
                        accountPermission = AccountPermission.findAccountPermissionForBank((BankUser)bankUser, (Account)account);
                        apOverwrite = ApOverwrite.findByBankAndAccount((BankUser)bankUser, (Account)account);
                        if (apOverwrite == null) {
                            apOverwrite = new ApOverwrite();
                            apOverwrite.setBankUser(bankUser);
                            apOverwrite.setAccount(account);
                            apOverwrite.setPreviousEnabled(accountPermission != null);
                            apOverwrite.setAmountLimit(accountLimit);
                            apOverwrites = this.apOverwriteToSave.computeIfAbsent(bank, k -> new HashSet());
                            apOverwrites.add(apOverwrite);
                        }
                        if (accountPermission == null) continue;
                        this.accountPermissionsToRemove.add(accountPermission);
                        continue;
                    }
                    accountPermission = AccountPermission.findAccountPermissionForBank((BankUser)bankUser, (Account)account);
                    if (accountPermission != null) {
                        this.accountPermissionsToRemove.add(accountPermission);
                    }
                    if ((apOverwrite = ApOverwrite.findByBankAndAccount((BankUser)bankUser, (Account)account)) == null) continue;
                    this.apOverwriteToRemove.add(apOverwrite);
                }
                continue;
            }
            if (toUpdate == null || toUpdate.getId() == null || bankUser == null) continue;
            this.banksToRemove.add(bank);
        }
        return form;
    }

    public static enum SANTANDER_ROLES {
        BANK_ADMIN,
        HOTLINE_USER,
        CUSTOMER_MANAGER;

    }

    public static enum Tab {
        GENERAL("tabgeneral"),
        PERMISSIONS("tabpermissions"),
        BANKS("tabbanks"),
        ACCOUNTS("tabaccounts");

        public final String label;

        private Tab(String label) {
            this.label = label;
        }
    }
}

