/*
 * Decompiled with CFR 0.152.
 */
package models;

import controllers.ClusterFetchScheduler;
import controllers.DatabaseConnection;
import controllers.branding.Branding;
import controllers.util.BLLoggerAdmin;
import controllers.util.BLLoggerPlay;
import controllers.util.LicenseHandler;
import controllers.util.PasswordKeyEncryptionHandler;
import controllers.util.SortingHandler;
import de.businesslogics.banking.api.AdminLogger;
import de.businesslogics.banking.api.BankingApiMessages;
import de.businesslogics.banking.api.DatabasePreferenceConstant;
import de.businesslogics.banking.api.DatabasePreferenceStore;
import de.businesslogics.banking.api.EncryptData;
import de.businesslogics.banking.api.PasswordRequirement;
import de.businesslogics.banking.database.api.DB;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.database.vo.BankUser;
import de.businesslogics.banking.database.vo.Preference;
import de.businesslogics.banking.database.vo.Scheduler;
import de.businesslogics.banking.database.vo.Tenant;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.banking.mt940.api.AdvicePreScheduler;
import de.businesslogics.banking.mt940.api.StatementsPreScheduler;
import de.businesslogics.banking.preferences.PreferenceConstants;
import de.businesslogics.persistence.DBType;
import de.businesslogics.util.BLLogger;
import de.businesslogics.util.StringUtils;
import de.businesslogics.validation.RegularExpressions;
import io.ebean.Query;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import models.TenantUser;
import play.data.validation.Constraints;
import play.data.validation.ValidationError;

public class TenantForm {
    private static final String SCHEDULER_STATEMENTS_DAYS = "2-6";
    private static final String SCHEDULER_STATEMENTS_HOUR = "6";
    private static final String SCHEDULER_STATEMENTS_MINUTE = "00";
    private static final String SCHEDULER_STATEMENTS_YEAR = "-";
    private static final Scheduler.Interval SCHEDULER_STATEMENTS_INTERVAL = Scheduler.Interval.NONE;
    private static final String SCHEDULER_ADVICE_DAYS = "2-6";
    private static final String SCHEDULER_ADVICE_HOUR = "6-17";
    private static final String SCHEDULER_ADVICE_MINUTE = "00";
    private static final String SCHEDULER_ADVICE_YEAR = "-";
    private static final Scheduler.Interval SCHEDULER_ADVICE_INTERVAL = Scheduler.Interval.HOURLY;
    @Constraints.Required
    public String name;
    public Integer maxUserCount;
    public BankSettings bank;
    public String statementBankUserId = "";
    public Integer statementFetchScheduleId = null;
    public String adviceBankUserId = "";
    public Integer adviceFetchScheduleId = null;
    public String newUserName;
    public String newUserPassword;
    public String newUserConfirmPassword;
    public String newUserUserId;
    public boolean newUserIsManagingUser;
    public boolean newUserIsLocalUser;
    private String nameWithSuffix;
    private boolean isNewUserError = false;
    private Tenant tenant;
    public String addUser = null;

    public static Integer maxUserCount(User user) {
        try {
            String numberString = LicenseHandler.getInstance().getLicenseProperties(user).getProperty("NUMBER_OF_USERS");
            if (numberString == null) {
                return Integer.MAX_VALUE;
            }
            int allowedNumber = Integer.parseInt(numberString);
            if (allowedNumber <= 0) {
                return Integer.MAX_VALUE;
            }
            return allowedNumber;
        }
        catch (IOException e) {
            BLLoggerPlay.error("Failed to read license information!", e);
            return Integer.MAX_VALUE;
        }
    }

    public Tenant getTenant() {
        return this.tenant;
    }

    public void fill(Tenant tenant) {
        this.tenant = tenant;
        this.name = tenant.getName();
        this.maxUserCount = tenant.getUserCount();
        if (Branding.getBranding().doTenantsWithBank()) {
            this.bank = TenantForm.getBankForTenant(tenant);
            try {
                List<Scheduler> schedulersWithUser;
                Query q = Scheduler.findByPeriodicParameters((String)"2-6", null, (String)SCHEDULER_STATEMENTS_HOUR, (String)"00", (String)"-", (Scheduler.Interval)SCHEDULER_STATEMENTS_INTERVAL);
                q = q.where().eq("orderOrFileType", (Object)StatementsPreScheduler.class.getName()).eq("bank", (Object)this.bank).orderBy("id asc").query();
                BLLoggerPlay.info("Tenant scheduler query bind values: days=2-6, month=null, hour=6, minute=00, year=-, interval=" + String.valueOf(SCHEDULER_STATEMENTS_INTERVAL) + ", orderOrFileType=" + StatementsPreScheduler.class.getName() + ", bank=" + String.valueOf(this.bank));
                List schedulers = q.findList();
                if (schedulers.isEmpty()) {
                    schedulers = DB.find(Scheduler.class).where().eq("orderOrFileType", (Object)StatementsPreScheduler.class.getName()).eq("bank", (Object)this.bank).orderBy("id asc").findList();
                }
                if (!(schedulersWithUser = schedulers.stream().filter(s -> s.getLoginUser() != null).toList()).isEmpty()) {
                    this.statementFetchScheduleId = schedulersWithUser.getFirst().getId();
                    this.statementBankUserId = schedulersWithUser.getFirst().getBankUser().getId().toString();
                } else {
                    this.statementFetchScheduleId = !schedulers.isEmpty() ? ((Scheduler)schedulers.getFirst()).getId() : null;
                    this.statementBankUserId = null;
                }
                q = Scheduler.findByPeriodicParameters((String)"2-6", null, (String)SCHEDULER_ADVICE_HOUR, (String)"00", (String)"-", (Scheduler.Interval)SCHEDULER_ADVICE_INTERVAL);
                q = q.where().eq("orderOrFileType", (Object)AdvicePreScheduler.class.getName()).eq("bank", (Object)this.bank).orderBy("id asc").query();
                schedulers = q.findList();
                if (schedulers.isEmpty()) {
                    schedulers = DB.find(Scheduler.class).where().eq("orderOrFileType", (Object)AdvicePreScheduler.class.getName()).eq("bank", (Object)this.bank).orderBy("id asc").findList();
                }
                if (!(schedulersWithUser = schedulers.stream().filter(s -> s.getLoginUser() != null).toList()).isEmpty()) {
                    this.adviceFetchScheduleId = schedulersWithUser.getFirst().getId();
                    this.adviceBankUserId = schedulersWithUser.getFirst().getBankUser().getId().toString();
                } else {
                    this.adviceFetchScheduleId = !schedulers.isEmpty() ? ((Scheduler)schedulers.getFirst()).getId() : null;
                    this.adviceBankUserId = null;
                }
            }
            catch (Exception e) {
                BLLoggerPlay.error("Error while loading fetch schedules for tenant " + tenant.getName() + " (ID=" + tenant.getId() + "): " + e.getMessage());
            }
        }
    }

    public static List<TenantUser> getUsersForTenant(Tenant tenant, BankSettings bank, SortingHandler sorting) {
        Query query;
        if (tenant == null) {
            return new ArrayList<TenantUser>();
        }
        if (Branding.getBranding().doTenantsWithBank()) {
            query = User.getQueryForTenants(Collections.singletonList(tenant), (boolean)false, null);
            if (bank == null) {
                bank = TenantForm.getBankForTenant(tenant);
            }
        } else {
            query = User.getQueryForTenants(Collections.singletonList(tenant), (boolean)true);
        }
        if (sorting != null) {
            String sortColumnName;
            Object sortColumnDirection;
            sorting.computeForQuery(query);
            Object object = sortColumnDirection = sorting.isSortingAscending() ? " ASC" : " DESC";
            if (sorting.getSortingColumn() == 0) {
                sortColumnName = "name";
            } else if (sorting.getSortingColumn() == 1) {
                sortColumnName = "securityMedium";
            } else if (sorting.getSortingColumn() == 3) {
                sortColumnName = "lastLogin";
                if (DBType.PSQL.equals((Object)DatabaseConnection.getInstance().getDbType())) {
                    sortColumnDirection = (String)sortColumnDirection + (sorting.isSortingAscending() ? " NULLS FIRST" : " NULLS LAST");
                }
            } else {
                sortColumnName = sorting.getSortingColumn() == 4 ? "errorCounter" : null;
            }
            if (sortColumnName != null) {
                query.orderBy(sortColumnName + (String)sortColumnDirection);
            }
        }
        ArrayList<TenantUser> tenantUsers = new ArrayList<TenantUser>();
        for (User user : query.findList()) {
            TenantUser tu = new TenantUser();
            tu.user = user;
            if (Branding.getBranding().doTenantsWithBank()) {
                tu.bankUser = BankUser.findBankUser((BankSettings)bank, (User)user);
            } else {
                ArrayList<BankSettings> banks2 = new ArrayList<BankSettings>();
                for (BankSettings b : BankSettings.findBanksForUser((User)user)) {
                    if (!b.getTenant().equals(tenant)) continue;
                    banks2.add(b);
                }
                tu.banks = banks2;
            }
            tu.isManagingUser = user.getManagedTenants().contains(tenant);
            tenantUsers.add(tu);
        }
        return tenantUsers;
    }

    public static boolean hasUserBankConnection(User user, Tenant tenant) {
        if (user.isLocalUser()) {
            return false;
        }
        if (tenant == null && !user.isLocalUser()) {
            return true;
        }
        for (BankSettings b : BankSettings.findBanksForUser((User)user)) {
            if (!b.getTenant().equals(tenant)) continue;
            return true;
        }
        return false;
    }

    public static BankSettings getBankForTenant(Tenant tenant) {
        List banks2;
        BankSettings bankForTenant = null;
        if (tenant != null && !(banks2 = BankSettings.findBanksForTenants(Collections.singletonList(tenant))).isEmpty()) {
            bankForTenant = (BankSettings)banks2.stream().reduce((b1, b2) -> b1.getBankId() < b2.getBankId() ? b1 : b2).get();
        }
        if (bankForTenant == null) {
            bankForTenant = new BankSettings();
            Branding.getBranding().fillBankData(bankForTenant);
            bankForTenant.setTenant(tenant);
        }
        return bankForTenant;
    }

    public static void createStatementsFetchSchedulersForTenant(Tenant tenant, String bankUserId, ClusterFetchScheduler clusterFetchScheduler, User operator) {
        if (Branding.getBranding().doTenantsWithBank()) {
            AdminLogger logger = new AdminLogger((BLLogger)BLLoggerAdmin.getLogger());
            Scheduler s = TenantForm.createTenantFetchScheduler(TenantForm.getBankForTenant(tenant), StatementsPreScheduler.class.getName(), bankUserId, "-", "2-6", SCHEDULER_STATEMENTS_HOUR, "00", SCHEDULER_STATEMENTS_INTERVAL);
            logger.logSchedulerCreated(operator, s);
            clusterFetchScheduler.updateScheduler(s);
        }
    }

    public static void createAdviceFetchSchedulersForTenant(Tenant tenant, String bankUserId, ClusterFetchScheduler clusterFetchScheduler, User operator) {
        if (Branding.getBranding().doTenantsWithBank()) {
            AdminLogger logger = new AdminLogger((BLLogger)BLLoggerAdmin.getLogger());
            Scheduler s = TenantForm.createTenantFetchScheduler(TenantForm.getBankForTenant(tenant), AdvicePreScheduler.class.getName(), bankUserId, "-", "2-6", SCHEDULER_ADVICE_HOUR, "00", SCHEDULER_ADVICE_INTERVAL);
            logger.logSchedulerCreated(operator, s);
            clusterFetchScheduler.updateScheduler(s);
        }
    }

    public boolean isNewUserError() {
        return this.isNewUserError;
    }

    public List<ValidationError> validateAndSave(Tenant tenant, User operator, ClusterFetchScheduler clusterFetchScheduler, Locale locale) {
        Integer oldUserLimit;
        AdminLogger logger = new AdminLogger((BLLogger)BLLoggerAdmin.getLogger());
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        if (Branding.getBranding().doTenantsWithBank() && this.addUser != null) {
            return this.validateAndSaveNewTenantUser(tenant, operator, logger, locale);
        }
        String oldTenantName = tenant.getName();
        boolean tenantNameChanged = !Objects.equals(oldTenantName, this.name);
        tenant.setName(this.name);
        if (!tenant.checkUniqueName()) {
            errors.add(new ValidationError("name", BankingApiMessages.getString((Locale)locale, (String)"GeneralMessages.nameAlreadyExists", (Object[])new Object[0])));
        }
        boolean userLimitChanged = !Objects.equals(oldUserLimit = tenant.getUserCount(), this.maxUserCount);
        tenant.setUserCount(this.maxUserCount);
        String newBankName = null;
        String newBankUrl = null;
        String newBankHostId = null;
        String newBankCustomerId = null;
        String newBankProtocolVersion = null;
        String newBankEncHash = null;
        String newBankAuthHash = null;
        if (this.bank != null) {
            newBankName = StringUtils.trim((String)this.bank.getDisplayName());
            newBankUrl = StringUtils.trim((String)this.bank.getUrl());
            newBankHostId = StringUtils.trim((String)this.bank.getHostId());
            newBankCustomerId = StringUtils.trim((String)this.bank.getCustomerId());
            newBankProtocolVersion = this.bank.getProtocolVersion();
            newBankEncHash = StringUtils.removeAllWhitespace((String)StringUtils.trimAndUpperCase((String)this.bank.getExpectedDigestE002()));
            newBankAuthHash = StringUtils.removeAllWhitespace((String)StringUtils.trimAndUpperCase((String)this.bank.getExpectedDigestX002()));
            try {
                URL u = new URI(newBankUrl).toURL();
                if (!u.getProtocol().equalsIgnoreCase("https")) {
                    errors.add(new ValidationError("bank.url", BankingApiMessages.getString((Locale)locale, (String)"GeneralMessages.urlNoHttps", (Object[])new Object[0])));
                }
            }
            catch (MalformedURLException | URISyntaxException mal) {
                errors.add(new ValidationError("bank.url", BankingApiMessages.getString((Locale)locale, (String)"GeneralMessages.invalidUrl", (Object[])new Object[0])));
            }
            if (newBankHostId != null && !newBankHostId.isEmpty() && !StringUtils.check((String)newBankHostId, (RegularExpressions)RegularExpressions.EBICS_V24_HOST_ID)) {
                errors.add(new ValidationError("bank.hostId", "bankdetails.hostid.invalid"));
            }
            if (newBankCustomerId != null && !newBankCustomerId.isEmpty() && !StringUtils.check((String)newBankCustomerId, (RegularExpressions)RegularExpressions.EBICS_V24_PARTNER_ID)) {
                errors.add(new ValidationError("bank.customerId", "general.error.invalidCharacters"));
            }
            if (newBankEncHash != null && !newBankEncHash.isEmpty()) {
                if (!StringUtils.check((String)newBankEncHash, (RegularExpressions)RegularExpressions.HEX_STRING)) {
                    errors.add(new ValidationError("bank.expectedDigestE002", "bankdetails.hash.hexValue"));
                }
                if (newBankEncHash.length() > 64) {
                    errors.add(new ValidationError("bank.expectedDigestE002", "bankdetails.hash.invalid"));
                }
            }
            if (newBankAuthHash != null && !newBankAuthHash.isEmpty()) {
                if (!StringUtils.check((String)newBankAuthHash, (RegularExpressions)RegularExpressions.HEX_STRING)) {
                    errors.add(new ValidationError("bank.expectedDigestX002", "bankdetails.hash.hexValue"));
                }
                if (newBankAuthHash.length() > 64) {
                    errors.add(new ValidationError("bank.expectedDigestX002", "bankdetails.hash.invalid"));
                }
            }
        }
        if (!errors.isEmpty()) {
            return errors;
        }
        tenant.save();
        if (tenantNameChanged) {
            logger.logTenantRenamed(operator, tenant, oldTenantName);
        }
        if (userLimitChanged) {
            logger.logTenantChangedUserLimit(operator, tenant, oldUserLimit);
        }
        if (this.bank != null) {
            BankSettings bank = TenantForm.getBankForTenant(tenant);
            boolean bankIsNew = bank.getBankId() == null;
            String oldBankName = bank.getDisplayName();
            boolean bankNameChanged = !Objects.equals(oldBankName, newBankName);
            bank.setDisplayName(newBankName);
            String oldUrl = bank.getUrl();
            boolean urlChanged = !Objects.equals(oldUrl, newBankUrl);
            bank.setUrl(newBankUrl);
            String oldHostId = bank.getHostId();
            boolean hostIdChanged = !Objects.equals(oldHostId, newBankHostId);
            bank.setHostId(newBankHostId);
            String oldCustomerId = bank.getCustomerId();
            boolean customerIdChanged = !Objects.equals(oldCustomerId, newBankCustomerId);
            bank.setCustomerId(newBankCustomerId);
            String oldProtocolVersion = bank.getProtocolVersion();
            boolean protocolVersionChanged = !Objects.equals(oldProtocolVersion, newBankProtocolVersion);
            bank.setProtocolVersion(newBankProtocolVersion);
            String oldX002Hash = bank.getExpectedDigestX002();
            boolean x002HashChanged = !Objects.equals(oldX002Hash, newBankAuthHash);
            bank.setExpectedDigestX002(newBankAuthHash);
            String oldE002Hash = bank.getExpectedDigestE002();
            boolean e002HashChanged = !Objects.equals(oldE002Hash, newBankEncHash);
            bank.setExpectedDigestE002(newBankEncHash);
            bank.setTenant(tenant);
            bank.save();
            if (bankIsNew) {
                logger.logBankCreated(operator, bank);
            } else {
                boolean detailsLogged = false;
                if (bankNameChanged) {
                    logger.logBankRenamed(operator, bank, oldBankName);
                    detailsLogged = true;
                }
                if (urlChanged) {
                    logger.logBankUrlChanged(operator, bank, oldUrl);
                    detailsLogged = true;
                }
                if (hostIdChanged) {
                    logger.logBankHostIdChanged(operator, bank, oldHostId);
                    detailsLogged = true;
                }
                if (customerIdChanged) {
                    logger.logBankCustomerIdChanged(operator, bank, oldCustomerId);
                    detailsLogged = true;
                }
                if (protocolVersionChanged) {
                    logger.logEbicsVersionChanged(operator, bank, oldProtocolVersion);
                    detailsLogged = true;
                }
                if (e002HashChanged) {
                    logger.logBankDigestModified(operator, "E002", bank, newBankEncHash);
                    detailsLogged = true;
                }
                if (x002HashChanged) {
                    logger.logBankDigestModified(operator, "X002", bank, newBankAuthHash);
                    detailsLogged = true;
                }
                if (!detailsLogged) {
                    logger.logBankModified(operator, bank);
                }
            }
            boolean statementFetchScheduleFound = false;
            boolean adviceFetchScheduleFound = false;
            for (Scheduler s : Scheduler.findByBank((BankSettings)bank)) {
                if (s.getOrderOrFileType().equals(StatementsPreScheduler.class.getName())) {
                    this.updateFetchScheduleBankUser(operator, logger, s, this.statementBankUserId, clusterFetchScheduler);
                    statementFetchScheduleFound = true;
                    continue;
                }
                if (!s.getOrderOrFileType().equals(AdvicePreScheduler.class.getName())) continue;
                this.updateFetchScheduleBankUser(operator, logger, s, this.adviceBankUserId, clusterFetchScheduler);
                adviceFetchScheduleFound = true;
            }
            if (!statementFetchScheduleFound) {
                TenantForm.createStatementsFetchSchedulersForTenant(tenant, this.statementBankUserId, clusterFetchScheduler, operator);
            }
            if (!adviceFetchScheduleFound) {
                TenantForm.createAdviceFetchSchedulersForTenant(tenant, this.adviceBankUserId, clusterFetchScheduler, operator);
            }
        }
        return null;
    }

    public List<ValidationError> validateAndSaveNewTenantUser(Tenant tenant, User operator, AdminLogger logger, Locale locale) {
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        if (this.newUserName == null || this.newUserName.isEmpty()) {
            errors.add(new ValidationError("newUserName", "error.required"));
        } else if (this.newUserName.length() > 255) {
            errors.add(new ValidationError("newUserName", "error.tooLong", Collections.singletonList(this.newUserName.length() - 255)));
        } else {
            String suffix = Branding.getBranding().getUsernameSuffix().orElse("");
            this.nameWithSuffix = this.newUserName + suffix;
            if (User.getUser((String)this.nameWithSuffix) != null) {
                errors.add(new ValidationError("newUserName", BankingApiMessages.getString((Locale)locale, (String)"GeneralMessages.nameAlreadyExists", (Object[])new Object[0])));
            }
        }
        if (this.newUserPassword == null || this.newUserPassword.isEmpty()) {
            errors.add(new ValidationError("newUserPassword", "error.required"));
        } else if (this.newUserConfirmPassword == null || this.newUserConfirmPassword.isEmpty()) {
            errors.add(new ValidationError("newUserConfirmPassword", "error.required"));
        } else if (!this.newUserPassword.equals(this.newUserConfirmPassword)) {
            errors.add(new ValidationError("newUserPassword", BankingApiMessages.getString((Locale)locale, (String)"GeneralMessages.passwordsNotMatching", (Object[])new Object[0])));
            errors.add(new ValidationError("newUserConfirmPassword", BankingApiMessages.getString((Locale)locale, (String)"GeneralMessages.passwordsNotMatching", (Object[])new Object[0])));
        } else {
            String requirement = PasswordRequirement.getRequirement().check(this.newUserPassword.toCharArray(), null, locale);
            if (requirement != null) {
                errors.add(new ValidationError("newUserPassword", requirement));
            }
        }
        if (this.newUserUserId != null && !this.newUserUserId.isEmpty()) {
            if (!StringUtils.check((String)this.newUserUserId, (RegularExpressions)RegularExpressions.EBICS_V24_USER_ID)) {
                errors.add(new ValidationError("newUserUserId", "general.error.invalidCharacters"));
            } else {
                List users2 = BankUser.findAllWithUserID();
                for (BankUser bu : users2) {
                    if (!bu.getDefaultUser().equals(this.newUserUserId) || !Objects.equals(bu.getBank().getBankId(), TenantForm.getBankForTenant(tenant).getBankId())) continue;
                    errors.add(new ValidationError("newUserUserId", "bank.userId.alreadyexists", Collections.singletonList(this.newUserUserId)));
                }
            }
        }
        if (!errors.isEmpty()) {
            this.isNewUserError = true;
            return errors;
        }
        try {
            User newUser = new User();
            newUser.setName(this.nameWithSuffix);
            if (this.newUserIsLocalUser) {
                newUser.setSecurityMedium(User.SecurityMedium.DUMMY);
            } else {
                newUser.setSecurityMedium(User.SecurityMedium.SOFTWARE);
            }
            newUser.setEncryptionKey(EncryptData.getInstance().copyKey((EncryptData.KeyEncryptionHandler)new PasswordKeyEncryptionHandler(this.newUserPassword.toCharArray())));
            newUser.setWebLicense(operator.getWebLicense());
            newUser.setTenants(Collections.singletonList(tenant));
            if (this.newUserIsManagingUser) {
                newUser.setManagedTenants(Collections.singletonList(tenant));
            }
            newUser.save();
            logger.logUserCreated(operator, newUser);
            logger.logTenantAddedUser(operator, newUser, tenant);
            if (this.newUserIsManagingUser) {
                logger.logTenantGrantManagingUserPrivileges(operator, newUser, tenant);
            }
            DatabasePreferenceStore preferenceStore = new DatabasePreferenceStore(Preference.ApplicationId.BANKING, newUser);
            String salaryPermissions = this.newUserIsManagingUser ? "0" : "2";
            preferenceStore.setValue((DatabasePreferenceConstant)PreferenceConstants.SALARY_PERMISSIONS, salaryPermissions);
            if (!this.newUserIsLocalUser) {
                BankUser bankUser = new BankUser();
                bankUser.setBank(TenantForm.getBankForTenant(tenant));
                bankUser.setDefaultUser(this.newUserUserId);
                bankUser.setUser(newUser);
                bankUser.setState(BankUser.UserState.USED_NO_INI);
                bankUser.save();
            }
        }
        catch (Exception e) {
            errors.add(new ValidationError("newUserName", "users.failedtocreate", Collections.singletonList(e.toString())));
            this.isNewUserError = true;
            return errors;
        }
        return null;
    }

    private static Scheduler createTenantFetchScheduler(BankSettings bank, String orderOrFileType, String bankUserId, String schedulerYear, String schedulerDays, String schedulerHour, String schedulerMinute, Scheduler.Interval schedulerInterval) {
        Scheduler scheduler = new Scheduler();
        if (bankUserId != null && !bankUserId.isEmpty()) {
            scheduler.setBankUser(BankUser.findById((Integer)Integer.parseInt(bankUserId)));
        } else {
            scheduler.setBank(bank);
            scheduler.setLoginUser(null);
        }
        scheduler.setOrderOrFileType(orderOrFileType);
        scheduler.setYear(schedulerYear);
        scheduler.setDays(schedulerDays);
        scheduler.setHour(schedulerHour);
        scheduler.setMinute(schedulerMinute);
        scheduler.setInterval(schedulerInterval);
        scheduler.save();
        return scheduler;
    }

    private void updateFetchScheduleBankUser(User operator, AdminLogger logger, Scheduler scheduler, String bankUserId, ClusterFetchScheduler clusterFetchScheduler) {
        if (bankUserId == null || bankUserId.isEmpty()) {
            scheduler.setLoginUser(null);
            scheduler.save();
        } else {
            BankUser newBankUser;
            boolean bankUserChanged;
            BankUser oldBankUser = scheduler.getBankUser();
            boolean bl = bankUserChanged = !Objects.equals(oldBankUser, newBankUser = BankUser.findById((Integer)Integer.parseInt(bankUserId)));
            if (bankUserChanged) {
                scheduler.setBankUser(newBankUser);
                scheduler.save();
                new AdminLogger((BLLogger)BLLoggerAdmin.getLogger()).logSchedulerChangedBankUser(operator, scheduler, oldBankUser == null ? null : oldBankUser.getUser(), newBankUser == null ? null : newBankUser.getUser());
                clusterFetchScheduler.updateScheduler(scheduler);
            }
        }
    }

    public String getNameWithSuffix() {
        return this.nameWithSuffix;
    }
}

