/*
 * Decompiled with CFR 0.152.
 */
package models;

import controllers.util.BLLoggerPlay;
import de.businesslogics.banking.api.BankingApiMessages;
import de.businesslogics.banking.api.Util;
import de.businesslogics.banking.database.vo.Account;
import de.businesslogics.banking.database.vo.PaymentFolder;
import de.businesslogics.banking.database.vo.PaymentRecipient;
import de.businesslogics.banking.database.vo.PaymentTransferType;
import de.businesslogics.banking.database.vo.PaymentType;
import de.businesslogics.banking.database.vo.Tenant;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.banking.payments.api.PreferenceUtil;
import de.businesslogics.banking.sepa.api.SepaApi;
import de.businesslogics.banking.sepa.api.SepaRecipientData;
import de.businesslogics.format.sepa.SEPAPaymentData;
import de.businesslogics.format.sepa.SEPAServiceLevel;
import de.businesslogics.format.sepa.at.AustrianFeeItem;
import de.businesslogics.format.sepa.at.AustrianFeeMessage;
import de.businesslogics.format.sepa.at.AustrianFeeMessageHandler;
import de.businesslogics.format.sepa.at.AustrianFeeType;
import de.businesslogics.format.sepa.at.AustrianFeeTypeProvider;
import de.businesslogics.util.PaymentUtils;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.text.DateFormatSymbols;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import models.PaymentForm;
import models.SepaPaymentForm;
import models.payments.PaymentContextType;
import models.payments.PaymentException;
import play.data.Form;
import play.data.FormFactory;
import play.i18n.Messages;
import play.libs.Scala;
import scala.Tuple2;
import scala.collection.immutable.Seq;
import views.Utils;

public class TaxOfficePaymentForm
extends SepaPaymentForm {
    public static final String PURPOSE_CODE = "TAXS";
    public static final String SEPARATOR_KEY = "SEPARATOR";
    public static AustrianFeeTypeProvider FEE_TYPE_PROVIDER;
    public List<DateLine> datelines;
    private List<AustrianFeeMessage> feeMessages;
    private boolean includeOffsetAmount_used;
    private String includeOffsetAmount_type;
    private BigDecimal includeOffsetAmount_amount;

    public static PaymentTransferType.PmtType[] getPmtTypes() {
        return new PaymentTransferType.PmtType[]{PaymentTransferType.PmtType.AUSTRIAN_TAX_PAYMENT, PaymentTransferType.PmtType.AUSTRIAN_URGENT_TAX_PAYMENT};
    }

    public static boolean isTaxofficePmtType(PaymentTransferType.PmtType pmtType) {
        return PaymentTransferType.PmtType.AUSTRIAN_TAX_PAYMENT.equals((Object)pmtType) || PaymentTransferType.PmtType.AUSTRIAN_URGENT_TAX_PAYMENT.equals((Object)pmtType);
    }

    public static int getRecipientsCount(User user) {
        return PaymentRecipient.countRecipientsForPaymentTypes(Collections.singletonList(PaymentType.AUSTRIAN_TAX_OFFICE), (List)user.getTenants());
    }

    public static Seq<Tuple2<String, String>> loadTaxOfficeServiceLevels(Messages messages) {
        ArrayList<Tuple2> result = new ArrayList<Tuple2>();
        result.add(Scala.Tuple((Object)SEPAServiceLevel.SEPA.name(), (Object)messages.at("sepapayment.atSEPA", new Object[0])));
        result.add(Scala.Tuple((Object)SEPAServiceLevel.URGP.name(), (Object)messages.at("sepapayment.atURGP", new Object[0])));
        return Scala.toSeq(result);
    }

    public static List<SepaRecipientData> loadRecipients(User user) {
        ArrayList<SepaRecipientData> result = new ArrayList<SepaRecipientData>();
        for (PaymentRecipient paymentRecipient : PaymentRecipient.findRecipientsForPaymentType((PaymentType)PaymentType.AUSTRIAN_TAX_OFFICE, (List)user.getTenants())) {
            SepaRecipientData sepaRecipientData = new SepaRecipientData();
            try {
                sepaRecipientData.setPaymentRecipient(paymentRecipient);
                result.add(sepaRecipientData);
            }
            catch (IOException e) {
                BLLoggerPlay.error("Failed to load recipient with ID " + paymentRecipient.getId(), e);
            }
        }
        result.sort((o1, o2) -> {
            if (o1 == null && o2 == null) {
                return 0;
            }
            if (o1 == null) {
                return 1;
            }
            if (o2 == null) {
                return -1;
            }
            return o1.getDisplayName().compareTo(o2.getDisplayName());
        });
        return result;
    }

    public static Seq<Tuple2<String, String>> dateTypeOptions(Messages messages) {
        ArrayList<Tuple2> result = new ArrayList<Tuple2>();
        for (AustrianFeeTypeProvider.DateType dateType : AustrianFeeTypeProvider.DateType.values()) {
            result.add(new Tuple2((Object)dateType.name(), (Object)BankingApiMessages.getString((Locale)messages.lang().locale(), (String)("GeneralMessages.taxoffice.periodType." + dateType.name()), (Object[])new Object[0])));
        }
        return Scala.toSeq(result);
    }

    public static Seq<Tuple2<String, String>> monthOptions(Messages messages) {
        ArrayList<Tuple2> result = new ArrayList<Tuple2>();
        int i = 0;
        for (String month : new DateFormatSymbols(messages.lang().locale()).getMonths()) {
            if (month.length() <= 0) continue;
            result.add(new Tuple2((Object)String.format("%02d", ++i), (Object)month));
        }
        return Scala.toSeq(result);
    }

    public static Seq<Tuple2<String, String>> quarterOptions(Messages messages) {
        ArrayList<Tuple2> result = new ArrayList<Tuple2>();
        result.add(new Tuple2((Object)"01/03", (Object)messages.at("taxofficepayment.quarter1", new Object[0])));
        result.add(new Tuple2((Object)"04/06", (Object)messages.at("taxofficepayment.quarter2", new Object[0])));
        result.add(new Tuple2((Object)"07/09", (Object)messages.at("taxofficepayment.quarter3", new Object[0])));
        result.add(new Tuple2((Object)"10/12", (Object)messages.at("taxofficepayment.quarter4", new Object[0])));
        return Scala.toSeq(result);
    }

    public static Seq<Tuple2<String, String>> feeTypeOptions(AustrianFeeTypeProvider.DateType dateType) {
        ArrayList<Tuple2> result;
        block3: {
            List prioTypes;
            block4: {
                result = new ArrayList<Tuple2>();
                if (FEE_TYPE_PROVIDER == null) break block3;
                prioTypes = FEE_TYPE_PROVIDER.getHighPriorityFeeTypes(dateType);
                if (!prioTypes.isEmpty()) break block4;
                for (AustrianFeeType feeType : FEE_TYPE_PROVIDER.getFeeTypes(dateType)) {
                    result.add(new Tuple2((Object)feeType.getCode(), (Object)(feeType.getCode() + " - " + feeType.getDescription())));
                }
                break block3;
            }
            for (AustrianFeeType feeType : prioTypes) {
                result.add(new Tuple2((Object)feeType.getCode(), (Object)(feeType.getCode() + " - " + feeType.getDescription())));
            }
            List lowPrioTypes = FEE_TYPE_PROVIDER.getLowPriorityFeeTypes(dateType);
            if (lowPrioTypes.isEmpty()) break block3;
            result.add(new Tuple2((Object)SEPARATOR_KEY, (Object)""));
            for (AustrianFeeType feeType : lowPrioTypes) {
                result.add(new Tuple2((Object)feeType.getCode(), (Object)(feeType.getCode() + " - " + feeType.getDescription())));
            }
        }
        return Scala.toSeq(result);
    }

    public static boolean isFieldEnabled(String fieldName, User operator) {
        boolean allowRecipientRecording = PreferenceUtil.allowUnrestrictedRecipientRecording((User)operator);
        if ("recipientAccount".equals(fieldName) || "recipientBankCode".equals(fieldName)) {
            return allowRecipientRecording;
        }
        return true;
    }

    public TaxOfficePaymentForm() {
    }

    public TaxOfficePaymentForm(PaymentContextType paymentContextType, PaymentTransferType.PmtType pmtType, User user, PaymentFolder folder, boolean singleBooking, boolean saveRecipient) throws PaymentException {
        super(paymentContextType, pmtType, user, folder, singleBooking, saveRecipient);
    }

    public TaxOfficePaymentForm(Object databaseVO, boolean displaySalaries, boolean allowRecipientRecording, boolean saveRecipient) throws PaymentException {
        super(databaseVO, displaySalaries, allowRecipientRecording, false, saveRecipient);
    }

    public TaxOfficePaymentForm(Object dsOrder, SEPAPaymentData sepaPaymentData, boolean displaySalaries, boolean allowRecipientRecording, boolean saveRecipient) throws PaymentException {
        super(dsOrder, sepaPaymentData, displaySalaries, allowRecipientRecording, false, saveRecipient);
    }

    @Override
    protected PaymentType getPaymentType(User user) {
        return PaymentType.AUSTRIAN_TAX_OFFICE;
    }

    @Override
    protected Form<? extends PaymentForm> loadSelectedRecipient(Form<? extends PaymentForm> form, User user, Tenant tenant) {
        List paymentRecipients;
        if (this.recipientName == null || this.recipientName.length() == 0) {
            return form.withError("recipientName", "error.required");
        }
        PaymentRecipient paymentRecipient = PaymentRecipient.findRecipientByDisplayName((PaymentType)PaymentType.AUSTRIAN_TAX_OFFICE, (String)this.recipientName, (Tenant)tenant);
        if (paymentRecipient == null && (paymentRecipients = PaymentRecipient.findRecipientByName((PaymentType)PaymentType.AUSTRIAN_TAX_OFFICE, (String)this.recipientName, (Tenant)tenant)).size() == 1) {
            paymentRecipient = (PaymentRecipient)paymentRecipients.get(0);
        }
        if (paymentRecipient == null) {
            return form.withError("recipientName", "error.recipientNotFound");
        }
        this.recipientName = paymentRecipient.getName();
        this.recipientAccount = paymentRecipient.getAccountNumber();
        this.recipientBankCode = paymentRecipient.getBankCode();
        return form;
    }

    @Override
    protected PaymentTransferType.PmtType getInternalPmtType() {
        return SEPAServiceLevel.URGP.name().equals(this.paymentData.getServiceLevel()) ? PaymentTransferType.PmtType.AUSTRIAN_URGENT_TAX_PAYMENT : PaymentTransferType.PmtType.AUSTRIAN_TAX_PAYMENT;
    }

    @Override
    protected Form<? extends PaymentForm> reloadFormInternal(FormFactory formFactory) {
        return formFactory.form(TaxOfficePaymentForm.class).fill((Object)this);
    }

    @Override
    protected Form<? extends PaymentForm> validateSEPASpecialisation(Form<? extends PaymentForm> form, FormFactory formFactory, Messages messages) {
        this.purposeCode = PURPOSE_CODE;
        if (this.datelines == null) {
            this.datelines = new ArrayList<DateLine>();
        }
        this.feeMessages = new ArrayList<AustrianFeeMessage>();
        for (DateLine dateLine : this.datelines) {
            if (dateLine.datetype == null || dateLine.feelines == null) continue;
            String errorKey = String.format("datelines[%d]", this.feeMessages.size());
            String dateString = null;
            if (AustrianFeeTypeProvider.DateType.DATE.equals((Object)dateLine.datetype) && dateLine.date == null) {
                form = form.withError(errorKey, "taxofficepayment.error.daterequired");
            } else {
                dateString = AustrianFeeMessageHandler.FeeMessageDate.getDateInfo((AustrianFeeTypeProvider.DateType)dateLine.datetype, (Integer)dateLine.year, (String)dateLine.month1, (String)dateLine.month2, (String)dateLine.quarter, (Date)dateLine.date);
            }
            ArrayList<AustrianFeeItem> feeItems = new ArrayList<AustrianFeeItem>();
            boolean hasFeeTypeError = false;
            boolean hasAmountError = false;
            for (FeeLine feeLine : dateLine.feelines) {
                AustrianFeeType feeType = null;
                switch (dateLine.datetype) {
                    case YEAR: {
                        feeType = FEE_TYPE_PROVIDER.getFeeType(feeLine.feetype_YEAR, dateLine.datetype);
                        break;
                    }
                    case MONTH: {
                        feeType = FEE_TYPE_PROVIDER.getFeeType(feeLine.feetype_MONTH, dateLine.datetype);
                        break;
                    }
                    case INTERVAL: {
                        feeType = FEE_TYPE_PROVIDER.getFeeType(feeLine.feetype_INTERVAL, dateLine.datetype);
                        break;
                    }
                    case QUARTER: {
                        feeType = FEE_TYPE_PROVIDER.getFeeType(feeLine.feetype_QUARTER, dateLine.datetype);
                        break;
                    }
                    case YEAR_01_12: {
                        feeType = FEE_TYPE_PROVIDER.getFeeType(feeLine.feetype_YEAR_01_12, dateLine.datetype);
                        break;
                    }
                    case DATE: {
                        feeType = FEE_TYPE_PROVIDER.getFeeType(feeLine.feetype_DATE, dateLine.datetype);
                    }
                }
                if (feeLine.amount == null && feeType == null) continue;
                if (feeType == null && !hasFeeTypeError) {
                    form = form.withError(errorKey, "taxofficepayment.error.selectFeeType");
                    hasFeeTypeError = true;
                }
                if (feeLine.amount == null && !hasAmountError) {
                    form = form.withError(errorKey, "taxofficepayment.error.amountNeeded");
                    hasAmountError = true;
                }
                boolean isCredit = false;
                if (feeLine.amount != null && feeType != null) {
                    if ("credit".equals(feeLine.creditordebit)) {
                        isCredit = true;
                        if (feeLine.amount.signum() != 0 && !feeType.canAmountBeNegative()) {
                            form = form.withError(errorKey, "taxofficepayment.error.noCreditAllowed", Collections.singletonList(feeType.getDescription()));
                        }
                    }
                    if (!AustrianFeeType.isValidAmount((AustrianFeeType)feeType, (BigDecimal)feeLine.amount, (boolean)isCredit)) {
                        String amountString = PaymentUtils.formatAmount((BigDecimal)feeLine.amount, null, (int)2, (Locale)messages.lang().locale());
                        form = form.withError(errorKey, "taxofficepayment.error.invalidAmount", Arrays.asList(amountString, feeType.getDescription()));
                    }
                }
                feeItems.add(new AustrianFeeItem(feeType, feeLine.amount, isCredit));
            }
            if (feeItems.isEmpty()) continue;
            AustrianFeeMessage feeMessage = new AustrianFeeMessage(dateString, feeItems);
            this.feeMessages.add(feeMessage);
        }
        this.feeMessages = AustrianFeeMessageHandler.getUniqueFeeMessages(this.feeMessages);
        this.datelines = null;
        if (!(form = this.reloadForm(form, formFactory)).hasErrors()) {
            this.purpose = AustrianFeeMessageHandler.getPurpose(this.feeMessages);
            if (this.purpose != null && this.purpose.length() > 140) {
                form = form.withGlobalError(messages.at("taxofficepayment.purpose.tooLong", new Object[]{Collections.singletonList(this.purpose.length() - 140)}));
            }
            this.amount = AustrianFeeMessageHandler.getAmountSum(this.feeMessages);
            if (this.includeOffsetAmount_used && this.includeOffsetAmount_amount.signum() != 0) {
                this.amount = "credit".equals(this.includeOffsetAmount_type) ? this.amount.subtract(this.includeOffsetAmount_amount) : this.amount.add(this.includeOffsetAmount_amount);
            }
        }
        if (this.reference == null || this.reference.length() == 0) {
            form = form.withError("reference", "taxofficepayment.error.entertaxnumber");
        } else {
            this.reference = this.reference.replaceAll("[^A-Z0-9]", "");
        }
        return form;
    }

    @Override
    public final Form<? extends PaymentForm> validateBeforeVOCreation(Form<? extends PaymentForm> form, Messages messages, FormFactory formFactory, Map<String, String> flashMap) {
        Account originatorAcc;
        if (SEPAServiceLevel.URGP.name().equals(this.serviceLevel) && !SepaApi.isAustrianUrgentTaxOfficePaymentAllowed((Account)(originatorAcc = Account.findById((int)this.originatorAccountId)))) {
            String oldServiceLevel = this.serviceLevel;
            this.serviceLevel = SEPAServiceLevel.SEPA.name();
            this.isUrgent = false;
            this.pmtType = PaymentTransferType.PmtType.AUSTRIAN_TAX_PAYMENT;
            form = this.reloadForm(form, formFactory);
            form = form.withError("serviceLevel", BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.taxoffice.warning.serviceLevel", (Object[])new Object[]{oldServiceLevel}));
            Utils.addToFlash(flashMap, "info", BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.taxoffice.hint.serviceLevel", (Object[])new Object[0]));
        }
        return form;
    }

    @Override
    protected void loadSEPASpecialisationInfo() {
        this.feeMessages = AustrianFeeMessageHandler.getFeeMessagesAsList((String)this.purpose, (AustrianFeeTypeProvider)FEE_TYPE_PROVIDER);
        BigDecimal amountFromFees = this.feeMessages == null ? BigDecimal.ZERO : AustrianFeeMessageHandler.getAmountSum(this.feeMessages);
        BigDecimal difference = amountFromFees.subtract(this.amount);
        if (difference.signum() != 0) {
            this.includeOffsetAmount_used = true;
            this.includeOffsetAmount_type = difference.signum() > 0 ? "credit" : "debit";
            this.includeOffsetAmount_amount = difference.abs();
        } else {
            this.includeOffsetAmount_used = false;
        }
    }

    public List<AustrianFeeMessage> getFeeMessages() {
        return this.feeMessages;
    }

    static {
        try {
            File feeTypesFile = new File(new File(Util.WORKSPACEDIR, "data"), "AustrianFeeTypes.txt");
            FEE_TYPE_PROVIDER = new AustrianFeeTypeProvider(feeTypesFile);
        }
        catch (Exception e) {
            BLLoggerPlay.error("Could not load Austrian fee types", e);
        }
    }

    public static class DateLine {
        public AustrianFeeTypeProvider.DateType datetype;
        public String month1;
        public String month2;
        public String quarter;
        public Integer year;
        public Date date;
        public List<FeeLine> feelines;
    }

    public static class FeeLine {
        public String feetype_YEAR;
        public String feetype_MONTH;
        public String feetype_INTERVAL;
        public String feetype_DATE;
        public String feetype_QUARTER;
        public String feetype_YEAR_01_12;
        public BigDecimal amount;
        public String creditordebit;
    }
}

