/*
 * Decompiled with CFR 0.152.
 */
package models;

import controllers.util.BankOrder;
import de.businesslogics.banking.api.BankUtils;
import de.businesslogics.banking.api.SendParameters;
import de.businesslogics.banking.api.Util;
import de.businesslogics.banking.api.VopUtil;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.database.vo.PaymentRecipient;
import de.businesslogics.banking.database.vo.PaymentTransferType;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.banking.transfer.api.SendUtil;
import de.businesslogics.iban.IbanUtil;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import models.BankOrderWithPayments;
import models.PasswordForm;
import models.payments.PaymentUtils;
import play.i18n.Messages;

public class SignOrdersForm
extends PasswordForm {
    public List<String> bankOrdersStrings = new ArrayList<String>();
    public String requestString = null;
    public List<String> additionalInfos = new ArrayList<String>();
    public List<Boolean> useVop = new ArrayList<Boolean>();

    public static SignOrdersForm fillForm(User user, List<BankOrderWithPayments> bankOrders) {
        bankOrders = BankOrderWithPayments.sortByPmtType(bankOrders);
        String bankOrdersString = BankOrder.getRequestStringForBankOrders(bankOrders);
        SignOrdersForm form = new SignOrdersForm();
        form.bankOrdersStrings = Arrays.asList(bankOrdersString.split("(?<=\\))"));
        form.additionalInfos = new ArrayList<String>(Collections.nCopies(form.bankOrdersStrings.size(), ""));
        List<PaymentTransferType.PmtType> vopTypes = PaymentUtils.getSupportedVopPaymentTypes(true);
        for (BankOrderWithPayments bankOrderWithPayments : bankOrders) {
            BankOrder order = bankOrderWithPayments.getBankOrder();
            BankSettings bank = order.getBank();
            boolean vopAllowed = bank.isVopActivated() && order.getPmtType() != null && vopTypes.contains(order.getPmtType()) && VopUtil.hasVopPermission((User)user, (BankSettings)bank, (PaymentTransferType.PmtType)order.getPmtType());
            boolean vopMandatory = bank.isVopMandatory() && order.getPayments().size() == 1;
            boolean vopPreset = vopAllowed && (vopMandatory || SendUtil.useVopByDefault((User)user));
            form.useVop.add(vopPreset);
        }
        return form;
    }

    public static String getOrderTypeOrBtfWithVOP(BankSettings bank, PaymentTransferType.PmtType pmtType) {
        if (BankUtils.isProtocolH005OrNewer((String)bank.getProtocolVersion())) {
            return SendParameters.getBTFVop((BankSettings)bank, (PaymentTransferType.PmtType)pmtType);
        }
        return SendParameters.getOrderTypeVop((BankSettings)bank, (PaymentTransferType.PmtType)pmtType);
    }

    public static String getOrderTypeOrBtfWithoutVOP(BankSettings bank, PaymentTransferType.PmtType pmtType) {
        if (BankUtils.isProtocolH005OrNewer((String)bank.getProtocolVersion())) {
            return SendParameters.getBTF((BankSettings)bank, (PaymentTransferType.PmtType)pmtType);
        }
        return SendParameters.getOrderType((BankSettings)bank, (PaymentTransferType.PmtType)pmtType);
    }

    public static String getVopResultTooltip(PaymentRecipient recipient, Messages messages, boolean showIban) {
        if (recipient == null || recipient.getVopDate() == null) {
            return messages.at("signorder.vopInfo.noVop", new Object[0]);
        }
        StringBuilder result = new StringBuilder();
        if (showIban) {
            result.append(IbanUtil.formatIBAN((String)recipient.getAccountNumber()));
        }
        if (recipient.getVopDate() != null) {
            if (!result.isEmpty()) {
                result.append("<br>");
            }
            result.append(messages.at("signorder.vopInfo.lastVopCheck", new Object[0])).append("<br>").append(DateFormat.getDateInstance(2, messages.lang().locale()).format(recipient.getVopDate()));
        }
        if (recipient.getVopResult() != null) {
            if (!result.isEmpty()) {
                result.append("<br>");
            }
            result.append(messages.at("signorder.vopInfo.lastVopResult", new Object[0])).append("<br>").append(Util.getShortVopResultDescription((String)recipient.getVopResult(), (Locale)messages.lang().locale()));
        }
        if (VopUtil.isCloseMatch((String)recipient.getVopResult()) && recipient.getVopName() != null) {
            if (!result.isEmpty()) {
                result.append("<br>");
            }
            result.append(messages.at("signorder.vopInfo.lastVopName", new Object[0])).append("<br>").append(recipient.getVopName());
        }
        return result.toString();
    }
}

