/*
 * Decompiled with CFR 0.152.
 */
package models;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import controllers.Recipients;
import controllers.routes;
import controllers.util.TenantUtils;
import de.businesslogics.banking.api.BLZCache;
import de.businesslogics.banking.api.BankingApiMessages;
import de.businesslogics.banking.api.DatabasePreferenceConstant;
import de.businesslogics.banking.api.DatabasePreferenceStore;
import de.businesslogics.banking.api.Logger;
import de.businesslogics.banking.api.Util;
import de.businesslogics.banking.database.vo.PaymentRecipient;
import de.businesslogics.banking.database.vo.Preference;
import de.businesslogics.banking.database.vo.SclDirectory;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.banking.payments.api.BicLoader;
import de.businesslogics.banking.payments.api.PreferenceUtil;
import de.businesslogics.banking.payments.core.PreferenceConstants;
import de.businesslogics.banking.sepa.api.SepaRecipientData;
import de.businesslogics.format.AddressData;
import de.businesslogics.format.sepa.SepaCountry;
import de.businesslogics.format.sepa.StatusCode;
import de.businesslogics.iban.IbanUtil;
import de.businesslogics.validation.RegularExpressions;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Date;
import java.util.Locale;
import models.RecipientForm;
import models.payments.PaymentUtils;
import play.data.Form;
import play.data.validation.Constraints;
import play.i18n.Messages;
import play.libs.Json;
import play.libs.Scala;
import scala.Tuple2;
import scala.collection.immutable.Seq;
import views.Utils;

public class SepaRecipientForm
extends RecipientForm {
    @Constraints.Required
    public String iban;
    public String bic;
    public String bank;
    public String purpose;
    public String recipientDept;
    public String recipientSubdept;
    public String recipientStreet;
    public String recipientBuildingnumber;
    public String recipientBuildingname;
    public String recipientFloor;
    public String recipientTown;
    public String recipientPostcode;
    public String recipientSubcountry;
    public String country = "";
    public String leiNumber;
    public Date vopDate;
    public String vopResult;
    public String vopName;
    public String vopReason;
    public String vopAdditionalInfo;

    public static String loadJsParameters() {
        ObjectNode resultJson = Json.newObject();
        resultJson.put("bicSearchUrl", routes.Payments.findBics("SEARCH", BicLoader.Service.Sct.name()).toString());
        return Base64.getEncoder().encodeToString(Json.asciiStringify((JsonNode)resultJson).getBytes(StandardCharsets.US_ASCII));
    }

    public static Seq<Tuple2<String, String>> getVopResults(Locale locale) {
        ArrayList<Tuple2> result = new ArrayList<Tuple2>();
        result.add(Scala.Tuple((Object)"", (Object)""));
        for (StatusCode.VopResultCodes resultCode : StatusCode.VopResultCodes.values()) {
            result.add(Scala.Tuple((Object)resultCode.name(), (Object)Util.getShortVopResultDescription((StatusCode.VopResultCodes)resultCode, (Locale)locale)));
        }
        return Scala.toSeq(result);
    }

    public SepaRecipientForm() {
    }

    public SepaRecipientForm(PaymentRecipient paymentRecipient) {
        SepaRecipientData recipient = new SepaRecipientData();
        try {
            recipient.setPaymentRecipient(paymentRecipient);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.id = paymentRecipient.getId();
        this.displayName = recipient.getDisplayName();
        this.name = recipient.getName();
        this.tenantId = recipient.getTenant().getId();
        this.iban = IbanUtil.formatIBAN((String)recipient.getAccountNumber());
        this.bic = recipient.getBankCode();
        if (recipient.getAccountNumber() != null) {
            this.bank = BLZCache.getBankNameFromIBAN((String)recipient.getAccountNumber());
        }
        this.purpose = recipient.getPurpose();
        this.leiNumber = recipient.getLeiNumber();
        AddressData rAddress = recipient.getAddress();
        if (rAddress != null) {
            this.recipientDept = rAddress.getDepartment();
            this.recipientSubdept = rAddress.getSubDepartment();
            this.recipientStreet = rAddress.getStreetName();
            this.recipientBuildingnumber = rAddress.getBuildingNumber();
            this.recipientBuildingname = rAddress.getBuildingName();
            this.recipientFloor = rAddress.getFloor();
            this.recipientTown = rAddress.getTownName();
            this.recipientPostcode = rAddress.getPostCode();
            this.recipientSubcountry = rAddress.getCountrySubDivision();
            this.country = rAddress.getCountry();
        }
        this.vopDate = recipient.getVopDate();
        this.vopResult = recipient.getVopResult();
        this.vopName = recipient.getVopName();
        this.vopReason = recipient.getVopReason();
        this.vopAdditionalInfo = recipient.getVopAdditionalInfo();
    }

    public boolean hasAddress() {
        return this.recipientDept != null && !this.recipientDept.isEmpty() || this.recipientSubdept != null && !this.recipientSubdept.isEmpty() || this.recipientStreet != null && !this.recipientStreet.isEmpty() || this.recipientBuildingnumber != null && !this.recipientBuildingnumber.isEmpty() || this.recipientBuildingname != null && !this.recipientBuildingname.isEmpty() || this.recipientFloor != null && !this.recipientFloor.isEmpty() || this.recipientTown != null && !this.recipientTown.isEmpty() || this.recipientPostcode != null && !this.recipientPostcode.isEmpty() || this.recipientSubcountry != null && !this.recipientSubcountry.isEmpty() || this.country != null && !this.country.isEmpty();
    }

    public boolean hasBankAddress() {
        return false;
    }

    @Override
    public Form<? extends RecipientForm> validate(Form<? extends RecipientForm> form, Messages messages, User user) {
        String tenantError = TenantUtils.checkTenantId(this.tenantId, user);
        if (tenantError != null) {
            form = form.withError("tenantId", tenantError);
        }
        if (this.name != null && this.name.length() > 70) {
            this.name = this.name.substring(0, 70);
        }
        if (this.purpose != null && this.purpose.length() > 140) {
            this.purpose = this.purpose.substring(0, 140);
        }
        if (!RegularExpressions.SEPA_GUI.matches(this.name)) {
            form = form.withError("name", messages.at("error.invalid", new Object[0]));
        }
        boolean allowInvalidBankConnections = new DatabasePreferenceStore(Preference.ApplicationId.PAYMENTS, user).getBoolean((DatabasePreferenceConstant)PreferenceConstants.ALLOW_INVALID_BANK_CONNECTION);
        this.iban = this.iban.replaceAll(" ", "").trim();
        if (this.bic != null && this.bic.length() > 0) {
            this.bic = this.bic.replaceAll(" ", "").trim();
        }
        if (!allowInvalidBankConnections && !IbanUtil.checkIban((String)this.iban)) {
            form = form.withError("iban", messages.at("error.invalid", new Object[0]));
        } else if (!allowInvalidBankConnections && !SepaCountry.isSepaCountry((String)this.iban.substring(0, 2))) {
            form = form.withError("iban", messages.at("sepapayment.error.ibaninvalidcountry", new Object[0]));
        }
        if (this.bic == null || this.bic.length() == 0) {
            if (this.iban != null && this.iban.length() >= 2 && !SepaCountry.isIbanOnlyAllowed((String)this.iban.substring(0, 2))) {
                form = form.withError("bic", BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.bicMandatoryForCrossBorder", (Object[])new Object[0]));
            }
        } else if (!RegularExpressions.BIC.matches(this.bic) || !allowInvalidBankConnections && BicLoader.getInstance().getBankName(this.bic) == null) {
            form = form.withError("bic", messages.at("error.invalid", new Object[0]));
        }
        if (this.purpose != null && !RegularExpressions.SEPA_GUI.matches(this.purpose)) {
            form = form.withError("purpose", messages.at("error.invalid", new Object[0]));
        }
        if (this.leiNumber != null && !this.leiNumber.isEmpty() && !RegularExpressions.SEPA_LEI.matches(this.leiNumber)) {
            form = form.withError("leiNumber", messages.at("error.invalid", new Object[0]));
        }
        if (!(this.country == null || this.country.length() <= 70 && RegularExpressions.SEPA_GUI.matches(this.country))) {
            form = form.withError("country", messages.at("error.invalid", new Object[0]));
        }
        return form;
    }

    @Override
    public void store(PaymentRecipient paymentRecipient, User user) throws IOException {
        boolean isNewRecipient;
        SepaRecipientData recipientData = new SepaRecipientData();
        recipientData.setPaymentRecipient(paymentRecipient);
        boolean bl = isNewRecipient = paymentRecipient.getId() == null;
        if (SepaRecipientForm.isFieldEnabled("displayName", user, paymentRecipient.getId())) {
            recipientData.setDisplayName(this.displayName);
        }
        String oldName = paymentRecipient.getName();
        boolean nameChanged = false;
        if (SepaRecipientForm.isFieldEnabled("name", user, paymentRecipient.getId())) {
            nameChanged = !isNewRecipient && Utils.fieldValueChanged(oldName, this.name);
            recipientData.setName(this.name);
        }
        String oldAccNbr = paymentRecipient.getAccountNumber();
        boolean accNbrChanged = false;
        if (SepaRecipientForm.isFieldEnabled("iban", user, paymentRecipient.getId())) {
            accNbrChanged = !isNewRecipient && Utils.fieldValueChanged(oldAccNbr, this.iban);
            recipientData.setAccountNumber(this.iban);
        }
        String oldBankCode = paymentRecipient.getBankCode();
        boolean bankCodeChanged = false;
        if (SepaRecipientForm.isFieldEnabled("bic", user, paymentRecipient.getId())) {
            SclDirectory sclDirectory;
            bankCodeChanged = !isNewRecipient && Utils.fieldValueChanged(oldBankCode, this.bic);
            recipientData.setBankCode(this.bic);
            if (this.bic != null && (sclDirectory = SclDirectory.getForBIC((String)this.bic)) != null) {
                recipientData.setBankName(sclDirectory.getName());
            }
        }
        if (SepaRecipientForm.isFieldEnabled("purpose", user, paymentRecipient.getId())) {
            recipientData.setPurpose(this.purpose);
        }
        String oldLei = recipientData.getLeiNumber();
        boolean leiChanged = false;
        if (SepaRecipientForm.isFieldEnabled("leiNumber", user, paymentRecipient.getId())) {
            leiChanged = !isNewRecipient && Utils.fieldValueChanged(oldLei, this.leiNumber);
            recipientData.setLeiNumber(this.leiNumber);
        }
        if (SepaRecipientForm.isFieldEnabled("tenantId", user, paymentRecipient.getId())) {
            recipientData.setTenant(TenantUtils.getTenantByIdAndUser(this.tenantId, user));
        }
        if (SepaRecipientForm.isFieldEnabled("country", user, paymentRecipient.getId())) {
            AddressData rAddress = PaymentUtils.getFullAddressData(this.recipientDept, this.recipientSubdept, this.recipientStreet, this.recipientBuildingnumber, this.recipientBuildingname, this.recipientFloor, this.recipientTown, this.recipientPostcode, this.recipientSubcountry, "", this.country);
            recipientData.setAddress(rAddress);
        }
        Recipients.updateVopStatusAfterRecipientChanged(recipientData, accNbrChanged, nameChanged);
        recipientData.save(user, PreferenceUtil.useFourEyesForRecipientRecording((User)user));
        if (nameChanged) {
            Logger.logRecipientModified((User)user, (PaymentRecipient)paymentRecipient, (Logger.RecipientField)Logger.RecipientField.NAME, (String)oldName, (String)this.name);
        }
        if (accNbrChanged) {
            Logger.logRecipientModified((User)user, (PaymentRecipient)paymentRecipient, (Logger.RecipientField)Logger.RecipientField.ACCOUNT_NUMBER, (String)oldAccNbr, (String)this.iban);
        }
        if (bankCodeChanged) {
            Logger.logRecipientModified((User)user, (PaymentRecipient)paymentRecipient, (Logger.RecipientField)Logger.RecipientField.BANK_CODE, (String)oldBankCode, (String)this.bic);
        }
        if (leiChanged) {
            Logger.logRecipientModified((User)user, (PaymentRecipient)paymentRecipient, (Logger.RecipientField)Logger.RecipientField.LEI_NUMBER, (String)oldLei, (String)this.leiNumber);
        }
    }
}

