/*
 * Decompiled with CFR 0.152.
 */
package models;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import controllers.branding.Branding;
import controllers.routes;
import controllers.util.BLLoggerPlay;
import de.businesslogics.banking.api.BankingApiMessages;
import de.businesslogics.banking.api.DatabasePreferenceConstant;
import de.businesslogics.banking.api.DatabasePreferenceStore;
import de.businesslogics.banking.api.FormSettings;
import de.businesslogics.banking.api.Logger;
import de.businesslogics.banking.api.PermissionsLoader;
import de.businesslogics.banking.api.SendParameters;
import de.businesslogics.banking.api.sepa.SepaDebitType;
import de.businesslogics.banking.api.sepa.SepaSchemeHandler;
import de.businesslogics.banking.api.sepa.SepaSequenceType;
import de.businesslogics.banking.database.api.DB;
import de.businesslogics.banking.database.vo.Account;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.database.vo.BankUser;
import de.businesslogics.banking.database.vo.BankUserHtdInfo;
import de.businesslogics.banking.database.vo.CmBooking;
import de.businesslogics.banking.database.vo.OrderType;
import de.businesslogics.banking.database.vo.PaymentFolder;
import de.businesslogics.banking.database.vo.PaymentOriginator;
import de.businesslogics.banking.database.vo.PaymentProperties;
import de.businesslogics.banking.database.vo.PaymentRecipient;
import de.businesslogics.banking.database.vo.PaymentTransferType;
import de.businesslogics.banking.database.vo.PaymentType;
import de.businesslogics.banking.database.vo.Preference;
import de.businesslogics.banking.database.vo.SclDirectory;
import de.businesslogics.banking.database.vo.Tenant;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.banking.database.vo.UserPermission;
import de.businesslogics.banking.payments.api.BicLoader;
import de.businesslogics.banking.payments.api.PreferenceUtil;
import de.businesslogics.banking.payments.api.RecipientData;
import de.businesslogics.banking.payments.core.PreferenceConstants;
import de.businesslogics.banking.sepa.PreferenceConstants;
import de.businesslogics.banking.sepa.api.ChequeRecipientData;
import de.businesslogics.banking.sepa.api.SepaApi;
import de.businesslogics.banking.sepa.api.SepaForeignRecipientData;
import de.businesslogics.banking.sepa.api.SepaMandateData;
import de.businesslogics.banking.sepa.api.SepaOriginatorData;
import de.businesslogics.banking.sepa.api.SepaRecipientData;
import de.businesslogics.format.AddressData;
import de.businesslogics.format.sepa.ChequeInstructionData;
import de.businesslogics.format.sepa.GeneralSEPAExtractor;
import de.businesslogics.format.sepa.GeneralSEPAWriter;
import de.businesslogics.format.sepa.SEPAFeeType;
import de.businesslogics.format.sepa.SEPAInstructionPriority;
import de.businesslogics.format.sepa.SEPALocalInstrument;
import de.businesslogics.format.sepa.SEPAPaymentCategory;
import de.businesslogics.format.sepa.SEPAPaymentData;
import de.businesslogics.format.sepa.SEPAPurposeCode;
import de.businesslogics.format.sepa.SEPAServiceLevel;
import de.businesslogics.format.sepa.SEPAUtil;
import de.businesslogics.format.sepa.SepaCountry;
import de.businesslogics.format.swift.mt940.CMUtil;
import de.businesslogics.iban.IbanUtil;
import de.businesslogics.util.Currency;
import de.businesslogics.util.DateUtils;
import de.businesslogics.util.StringUtils;
import de.businesslogics.validation.RegularExpressions;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import models.PaymentForm;
import models.TaxOfficePaymentForm;
import models.payments.PaymentContextType;
import models.payments.PaymentException;
import models.payments.PaymentHandler;
import models.payments.PaymentUtils;
import play.data.Form;
import play.data.FormFactory;
import play.data.validation.Constraints;
import play.i18n.Messages;
import play.libs.Json;
import play.libs.Scala;
import scala.Tuple2;
import scala.collection.immutable.Seq;
import views.Utils;

public class SepaPaymentForm
extends PaymentForm {
    private static final Date NO_EXECUTION_DATE;
    public String mandate;
    public boolean createNewMandate = false;
    public String creditorId;
    public String ultimateOriginator;
    public String ultimateRecipient;
    public AddressData originatorAddress;
    public String originatorCountry;
    public String originatorDept;
    public String originatorSubdept;
    public String originatorStreet;
    public String originatorBuildingnumber;
    public String originatorBuildingname;
    public String originatorFloor;
    public String originatorTown;
    public String originatorPostcode;
    public String originatorSubcountry;
    public AddressData recipientAddress;
    public String recipientCountry;
    public String recipientDept;
    public String recipientSubdept;
    public String recipientStreet;
    public String recipientBuildingnumber;
    public String recipientBuildingname;
    public String recipientFloor;
    public String recipientTown;
    public String recipientPostcode;
    public String recipientSubcountry;
    public String recipientLei;
    public String clearingSystem;
    public String recipientBank;
    public AddressData bankAddress;
    public String bankCountry;
    public String bankDept;
    public String bankSubdept;
    public String bankStreet;
    public String bankBuildingnumber;
    public String bankBuildingname;
    public String bankFloor;
    public String bankTown;
    public String bankPostcode;
    public String bankSubcountry;
    public String chktype;
    public String deliveryMethod;
    public String deliveryName;
    public AddressData deliveryAddress;
    public String deliveryCountry;
    public String deliveryDept;
    public String deliverySubdept;
    public String deliveryStreet;
    public String deliveryBuildingnumber;
    public String deliveryBuildingname;
    public String deliveryFloor;
    public String deliveryTown;
    public String deliveryPostcode;
    public String deliverySubcountry;
    public String feeType;
    public String serviceLevel;
    public String mandateReference;
    public Date mandateSignDate;
    public String paymentCategory;
    public String purposeCode;
    public String instructionPriority;
    public String debitType;
    public String sequenceType;
    public boolean singleBooking;
    public boolean isDebit;
    public boolean isInstant;
    public boolean isSepaForeign;
    public boolean isCheque;
    @Constraints.MaxLength(value=35L)
    public @Constraints.MaxLength(value=35L) String purpose1;
    @Constraints.MaxLength(value=35L)
    public @Constraints.MaxLength(value=35L) String purpose2;
    @Constraints.MaxLength(value=35L)
    public @Constraints.MaxLength(value=35L) String purpose3;
    public boolean structuredPurpose;
    protected SEPAPaymentData paymentData;

    public static boolean isFieldEnabled(String fieldName, User operator, PaymentTransferType.PmtType pmtType) {
        boolean allowOriginatorRecording = new DatabasePreferenceStore(Preference.ApplicationId.PAYMENTS, operator).getBoolean((DatabasePreferenceConstant)de.businesslogics.banking.payments.core.PreferenceConstants.ALLOW_ORIGINATOR_RECORDING);
        boolean useMandate = SepaApi.isDebitPmtType((PaymentTransferType.PmtType)pmtType) && Utils.useSepaMandates(operator);
        boolean allowRecipientRecording = PreferenceUtil.allowUnrestrictedRecipientRecording((User)operator);
        if ("originatorCountry".equals(fieldName) || "originatorDept".equals(fieldName) || "originatorSubdept".equals(fieldName) || "originatorStreet".equals(fieldName) || "originatorBuildingnumber".equals(fieldName) || "originatorBuildingname".equals(fieldName) || "originatorFloor".equals(fieldName) || "originatorTown".equals(fieldName) || "originatorPostcode".equals(fieldName) || "originatorSubcountry".equals(fieldName)) {
            return allowOriginatorRecording;
        }
        if ("originatorName".equals(fieldName) || "recipientName".equals(fieldName)) {
            return !useMandate;
        }
        if ("creditorId".equals(fieldName)) {
            return !useMandate && allowOriginatorRecording;
        }
        if ("recipientCountry".equals(fieldName)) {
            return allowRecipientRecording && !useMandate;
        }
        if ("recipientDept".equals(fieldName) || "recipientSubdept".equals(fieldName) || "recipientStreet".equals(fieldName) || "recipientBuildingnumber".equals(fieldName) || "recipientBuildingname".equals(fieldName) || "recipientFloor".equals(fieldName) || "recipientTown".equals(fieldName) || "recipientPostcode".equals(fieldName) || "recipientSubcountry".equals(fieldName) || "recipientBank".equals(fieldName) || "recipientLei".equals(fieldName)) {
            if (pmtType == PaymentTransferType.PmtType.SEPA_CORE_DIRECT_DEBIT || pmtType == PaymentTransferType.PmtType.SEPA_B2B_DIRECT_DEBIT) {
                return allowRecipientRecording && (!useMandate || allowOriginatorRecording);
            }
            return allowRecipientRecording;
        }
        if ("bankDept".equals(fieldName) || "bankSubdept".equals(fieldName) || "bankStreet".equals(fieldName) || "bankBuildingnumber".equals(fieldName) || "bankBuildingname".equals(fieldName) || "bankFloor".equals(fieldName) || "bankTown".equals(fieldName) || "bankPostcode".equals(fieldName) || "bankSubcountry".equals(fieldName) || "bankCountry".equals(fieldName) || "deliveryDept".equals(fieldName) || "deliverySubdept".equals(fieldName) || "deliveryStreet".equals(fieldName) || "deliveryBuildingnumber".equals(fieldName) || "deliveryBuildingname".equals(fieldName) || "deliveryFloor".equals(fieldName) || "deliveryTown".equals(fieldName) || "deliveryPostcode".equals(fieldName) || "deliverySubcountry".equals(fieldName) || "deliveryCountry".equals(fieldName)) {
            return allowRecipientRecording;
        }
        if ("createNewMandate".equals(fieldName) || "clearingSystem".equals(fieldName)) {
            return allowRecipientRecording;
        }
        if ("mandateReference".equals(fieldName) || "mandateSignDate".equals(fieldName) || "recipientAccount".equals(fieldName) || "recipientBankCode".equals(fieldName)) {
            return !useMandate && allowRecipientRecording;
        }
        return true;
    }

    public void setDefaultValues(PaymentTransferType.PmtType pmtType) {
        this.isDebit = SepaApi.isDebitPmtType((PaymentTransferType.PmtType)pmtType);
        this.isUrgent = SepaApi.isUrgent((PaymentTransferType.PmtType)pmtType);
        this.isInstant = SepaApi.isInstantCreditPaymentType((PaymentTransferType.PmtType)pmtType);
        this.isSepaForeign = SepaApi.isForeignPayment((PaymentTransferType.PmtType)pmtType);
        this.isCheque = this.isChequePayment(pmtType);
        this.debitType = SepaPaymentForm.getDebitType(pmtType);
    }

    public static PaymentTransferType.PmtType[] getPmtTypes(boolean isCor1Supported, boolean includeSalaryPayments) {
        ArrayList<PaymentTransferType.PmtType> pmtTypes = new ArrayList<PaymentTransferType.PmtType>();
        pmtTypes.add(PaymentTransferType.PmtType.SEPA_TRANSFER);
        pmtTypes.add(PaymentTransferType.PmtType.SEPA_URGENT_TRANSFER);
        pmtTypes.add(PaymentTransferType.PmtType.SEPA_CORE_DIRECT_DEBIT);
        if (isCor1Supported) {
            pmtTypes.add(PaymentTransferType.PmtType.SEPA_COR1_DIRECT_DEBIT);
        }
        pmtTypes.add(PaymentTransferType.PmtType.SEPA_B2B_DIRECT_DEBIT);
        pmtTypes.add(PaymentTransferType.PmtType.SEPA_INSTANT_TRANSFER);
        if (includeSalaryPayments) {
            pmtTypes.add(PaymentTransferType.PmtType.SEPA_CONFIDENTAL_TRANSFER);
            pmtTypes.add(PaymentTransferType.PmtType.SEPA_URGENT_CONFIDENTAL_TRANSFER);
        }
        pmtTypes.add(PaymentTransferType.PmtType.SEPA_FOREIGN_CURRENCY_TRANSFER);
        pmtTypes.add(PaymentTransferType.PmtType.SEPA_FOREIGN_TRANSFER);
        pmtTypes.add(PaymentTransferType.PmtType.SEPA_FOREIGN_CHEQUE);
        return pmtTypes.toArray(new PaymentTransferType.PmtType[0]);
    }

    public static boolean isSepaPmtType(PaymentTransferType.PmtType pmtType) {
        return pmtType != null && Arrays.asList(SepaPaymentForm.getPmtTypes(true, true)).contains(pmtType);
    }

    public static Seq<Tuple2<String, String>> loadFeeTypes(Locale locale, boolean isSepaForeign) {
        ArrayList<Tuple2> result = new ArrayList<Tuple2>();
        for (SEPAFeeType fee : SEPAFeeType.values()) {
            if (isSepaForeign && fee == SEPAFeeType.SLEV) continue;
            result.add(Scala.Tuple((Object)fee.name(), (Object)fee.getDescription(locale)));
        }
        return Scala.toSeq(result);
    }

    private static boolean serviceLevelCanBeEmpty(User user) {
        DatabasePreferenceStore store = new DatabasePreferenceStore(Preference.ApplicationId.SEPA, user);
        return !store.getBoolean((DatabasePreferenceConstant)PreferenceConstants.SERVICE_LEVEL_MANDATORY);
    }

    public static Seq<Tuple2<String, String>> loadInternationalServiceLevel(Locale locale, User user) {
        ArrayList<Tuple2> result = new ArrayList<Tuple2>();
        if (SepaPaymentForm.serviceLevelCanBeEmpty(user)) {
            result.add(Scala.Tuple((Object)"NONE", (Object)""));
        }
        for (String fee : SEPAServiceLevel.getValuesForInternationalPayments()) {
            result.add(Scala.Tuple((Object)fee, (Object)SEPAServiceLevel.getLongDescription((String)fee, (Locale)locale)));
        }
        return Scala.toSeq(result);
    }

    public static List<SepaOriginatorData> loadOriginators(User user) {
        ArrayList<SepaOriginatorData> result = new ArrayList<SepaOriginatorData>();
        for (PaymentOriginator paymentOriginator : PaymentOriginator.findOriginatorsForPaymentType((PaymentType)PaymentType.SEPA, (List)user.getTenants())) {
            SepaOriginatorData originatorData = new SepaOriginatorData();
            try {
                originatorData.setPaymentOriginator(paymentOriginator);
                result.add(originatorData);
            }
            catch (IOException e) {
                BLLoggerPlay.error("Failed to load SEPA originator with ID: " + paymentOriginator.getId(), e);
            }
        }
        result.sort((o1, o2) -> {
            if (o1 == null && o2 == null) {
                return 0;
            }
            if (o1 == null) {
                return 1;
            }
            if (o2 == null) {
                return -1;
            }
            return o1.getName().compareTo(o2.getName());
        });
        return result;
    }

    public static Seq<Tuple2<String, String>> loadOriginatorSequence(User user, boolean includeEmptyLine) {
        ArrayList<Tuple2> result = new ArrayList<Tuple2>();
        if (includeEmptyLine) {
            result.add(Scala.Tuple((Object)"-1", (Object)""));
        }
        for (SepaOriginatorData originator : SepaPaymentForm.loadOriginators(user)) {
            result.add(Scala.Tuple((Object)originator.getPaymentOriginator().getId().toString(), (Object)Utils.addZWNJ(originator.getName())));
        }
        return Scala.toSeq(result);
    }

    public static int getRecipientsCount(User user, boolean onlyMandates, PaymentType pmtType) {
        ArrayList<PaymentType> paymentTypes = new ArrayList<PaymentType>();
        if (PaymentType.SEPA_FOREIGN.equals((Object)pmtType)) {
            paymentTypes.add(PaymentType.SEPA_FOREIGN);
        } else if (PaymentType.CHEQUE.equals((Object)pmtType)) {
            paymentTypes.add(PaymentType.CHEQUE);
        } else {
            paymentTypes.add(PaymentType.MANDATE);
            if (!onlyMandates) {
                paymentTypes.add(PaymentType.SEPA);
            }
        }
        return PaymentRecipient.countRecipientsForPaymentTypes(paymentTypes, (List)user.getTenants());
    }

    private static void loadRecipients(User user, List<RecipientData> result, PaymentType pmt) {
        for (PaymentRecipient paymentRecipient : PaymentRecipient.findRecipientsForPaymentType((PaymentType)pmt, (List)user.getTenants())) {
            Object sepaRecipientData = pmt == PaymentType.SEPA_FOREIGN ? new SepaForeignRecipientData() : (pmt == PaymentType.SEPA ? new SepaRecipientData() : (pmt == PaymentType.CHEQUE ? new ChequeRecipientData() : new SepaMandateData()));
            try {
                sepaRecipientData.setPaymentRecipient(paymentRecipient);
                result.add((RecipientData)sepaRecipientData);
            }
            catch (IOException e) {
                BLLoggerPlay.error("Failed to load recipient with ID " + paymentRecipient.getId(), e);
            }
        }
    }

    public static List<RecipientData> loadRecipients(User user, boolean onlyMandates, PaymentType pmtType) {
        ArrayList<RecipientData> result = new ArrayList<RecipientData>();
        if (PaymentType.SEPA_FOREIGN.equals((Object)pmtType)) {
            SepaPaymentForm.loadRecipients(user, result, PaymentType.SEPA_FOREIGN);
        } else if (PaymentType.CHEQUE.equals((Object)pmtType)) {
            SepaPaymentForm.loadRecipients(user, result, PaymentType.CHEQUE);
        } else {
            if (!onlyMandates) {
                SepaPaymentForm.loadRecipients(user, result, PaymentType.SEPA);
            }
            SepaPaymentForm.loadRecipients(user, result, PaymentType.MANDATE);
        }
        result.sort((o1, o2) -> {
            if (o1 == null && o2 == null) {
                return 0;
            }
            if (o1 == null) {
                return 1;
            }
            if (o2 == null) {
                return -1;
            }
            return o1.getDisplayName().compareTo(o2.getDisplayName());
        });
        return result;
    }

    public static String getDebitType(PaymentTransferType.PmtType pmtType) {
        if (!SepaApi.isDebitPmtType((PaymentTransferType.PmtType)pmtType)) {
            return null;
        }
        if (PaymentTransferType.PmtType.SEPA_B2B_DIRECT_DEBIT.equals((Object)pmtType) || PaymentTransferType.PmtType.SWISS_SEPA_B2B_DIRECT_DEBIT.equals((Object)pmtType)) {
            return SepaDebitType.B2B.name();
        }
        if (PaymentTransferType.PmtType.SEPA_CORE_DIRECT_DEBIT.equals((Object)pmtType) || PaymentTransferType.PmtType.SWISS_SEPA_CORE_DIRECT_DEBIT.equals((Object)pmtType)) {
            return SepaDebitType.CORE.name();
        }
        if (PaymentTransferType.PmtType.SEPA_COR1_DIRECT_DEBIT.equals((Object)pmtType)) {
            return SepaDebitType.COR1.name();
        }
        return null;
    }

    public static List<String> loadDebitEarliestExecutionDates(User user, PaymentTransferType.PmtType pmtType, Locale locale) {
        Map<SepaSequenceType, String> map;
        HashMap bankDates = new HashMap();
        Date today = DateUtils.getCurrentDateWithoutTimeStamp();
        String debitType = SepaPaymentForm.getDebitType(pmtType);
        SimpleDateFormat dateFormat = Utils.getJavaDatePickerFormat(locale);
        for (BankSettings bank : BankSettings.findBanksForUser((User)user)) {
            PaymentProperties paymentProperties = PaymentProperties.findForBank((BankSettings)bank);
            int leadTimeForDebits = paymentProperties == null || paymentProperties.getSepaLeadTimeForDebits() == null ? 1 : paymentProperties.getSepaLeadTimeForDebits();
            map = new HashMap();
            for (SepaSequenceType sequenceType : SepaSequenceType.values()) {
                map.put(sequenceType, dateFormat.format(SEPAUtil.getValidExecutionDate((GeneralSEPAWriter.Version)SepaSchemeHandler.getSepaVersion((BankSettings)bank, (PaymentTransferType.PmtType)pmtType), (boolean)false, (String)debitType, (String)sequenceType.name(), (Date)today, (int)leadTimeForDebits)));
            }
            bankDates.put(bank.getBankId(), map);
        }
        ArrayList<String> result = new ArrayList<String>();
        for (Account account : new PermissionsLoader(user).loadAccounts(SepaApi.DEBIT_ORDER_TYPES, PermissionsLoader.AccountType.IBAN)) {
            map = (Map)bankDates.get(account.getBank().getBankId());
            if (map == null) continue;
            for (SepaSequenceType sequenceType : map.keySet()) {
                String item = String.valueOf(account.getId()) + "\t" + sequenceType.name() + "\t" + (String)map.get(sequenceType);
                result.add(item);
            }
        }
        return result;
    }

    public static List<Integer> findAccountsForForeignCurrencies(User user, PaymentTransferType.PmtType pmtType) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        if (PaymentTransferType.PmtType.SEPA_TRANSFER.equals((Object)pmtType) || PaymentTransferType.PmtType.SEPA_FOREIGN_CURRENCY_TRANSFER.equals((Object)pmtType)) {
            String[] orderTypesOrBTFs = (String[])BankUser.findBanksForUser((User)user).stream().map(bu -> SendParameters.getTransferTypeByBank((BankSettings)bu.getBank(), (PaymentTransferType.PmtType)pmtType)).toArray(String[]::new);
            HashMap<Integer, BankUser> bankUsers = new HashMap<Integer, BankUser>();
            ArrayList<Integer> banksToAdd = new ArrayList<Integer>();
            for (Account account : new PermissionsLoader(user).loadAccounts(orderTypesOrBTFs, PermissionsLoader.AccountType.IBAN)) {
                BankUser bankUser = (BankUser)bankUsers.get(account.getBank().getBankId());
                if (bankUser == null) {
                    bankUser = BankUser.findBankUser((BankSettings)account.getBank(), (User)user);
                    bankUsers.put(account.getBank().getBankId(), bankUser);
                    String xctOrderTypeOrBTF = SendParameters.getTransferTypeByBank((BankSettings)account.getBank(), (PaymentTransferType.PmtType)PaymentTransferType.PmtType.SEPA_FOREIGN_CURRENCY_TRANSFER);
                    if (!(xctOrderTypeOrBTF == null || BankUserHtdInfo.findForBankUser((BankUser)bankUser) != null && UserPermission.findUserPermission((BankUser)bankUser, (OrderType.TransferType)OrderType.TransferType.SEND, (String)xctOrderTypeOrBTF).isEmpty())) {
                        banksToAdd.add(account.getBank().getBankId());
                    }
                }
                if (!banksToAdd.contains(account.getBank().getBankId())) continue;
                result.add(account.getId());
            }
        }
        return result;
    }

    public static String loadJsParameters(User user, Form<? extends SepaPaymentForm> form, Messages messages, boolean isNew, boolean isDebit, String recipientTypes) {
        boolean useMandates = isDebit && Utils.useSepaMandates(user);
        DatabasePreferenceStore paymentsPreferenceStore = new DatabasePreferenceStore(Preference.ApplicationId.PAYMENTS, user);
        DatabasePreferenceStore sepaPreferenceStore = new DatabasePreferenceStore(Preference.ApplicationId.SEPA, user);
        boolean allowOriginatorRecording = paymentsPreferenceStore.getBoolean((DatabasePreferenceConstant)de.businesslogics.banking.payments.core.PreferenceConstants.ALLOW_ORIGINATOR_RECORDING);
        boolean overwriteRecipientData = isNew || useMandates || paymentsPreferenceStore.getBoolean((DatabasePreferenceConstant)de.businesslogics.banking.payments.core.PreferenceConstants.OVERWRITE_RECIPIENT_DATA);
        boolean showCurrency = sepaPreferenceStore.getBoolean((DatabasePreferenceConstant)PreferenceConstants.ALLOW_FOREIGN_CURRENCIES);
        boolean isPurposeInISOFormat = sepaPreferenceStore.getBoolean((DatabasePreferenceConstant)PreferenceConstants.ALLOW_ONLY_ISO11649_CREDTIOR_REFERENCES);
        boolean initializeAccountAndOriginator = isNew && !PreferenceConstants.InitializationOfAccAndOrig.NONE.name().equals(paymentsPreferenceStore.getString((DatabasePreferenceConstant)de.businesslogics.banking.payments.core.PreferenceConstants.INITIALIZATION_OF_ACC_AND_ORIG));
        PaymentTransferType.PmtType pmtType = PaymentTransferType.PmtType.valueOf((String)form.field("pmtType").value().orElse(null));
        boolean isSepaForeign = SepaApi.isForeignPayment((PaymentTransferType.PmtType)pmtType);
        boolean isATX = PaymentTransferType.PmtType.AUSTRIAN_FOREIGN.equals((Object)pmtType) || PaymentTransferType.PmtType.AUSTRIAN_FOREIGN_SEPA_CHEQUE.equals((Object)pmtType);
        ObjectNode resultJson = Json.newObject();
        resultJson.put("initializeAccountAndOriginator", initializeAccountAndOriginator);
        resultJson.put("useIso11649", isPurposeInISOFormat);
        resultJson.put("isSepaForeign", isSepaForeign);
        resultJson.put("isNew", isNew);
        resultJson.put("useMandates", useMandates);
        resultJson.put("overwriteRecipientData", overwriteRecipientData);
        resultJson.put("showRecipientWithAccountNumber", paymentsPreferenceStore.getBoolean((DatabasePreferenceConstant)de.businesslogics.banking.payments.core.PreferenceConstants.DISPLAY_RECIPIENTS_WITH_ACCOUNT_NUMBER));
        resultJson.put("showBatchBookingWarning", Branding.getBranding().showBatchBookingWarning());
        resultJson.put("searchOriginatorsUrl", routes.Payments.findOriginators("SEARCH", 999, "SEPA").toString());
        resultJson.put("searchMandatesUrl", routes.Payments.findRecipients("SEARCH", 999, "MANDATE").toString());
        resultJson.put("searchRecipientsUrl", routes.Payments.findRecipients("SEARCH", 999, recipientTypes).toString());
        resultJson.put("bicSearchUrl", routes.Payments.findBics("SEARCH", "SERVICE").toString());
        resultJson.put("calculateDiscountUrl", routes.Payments.calculateDiscount().toString());
        resultJson.put("discountPurposeRegex", messages.at("sepapayment.discount.purposeregex", new Object[0]));
        resultJson.put("discountPurposeMessage", messages.at("sepapayment.discount.purpose", new Object[]{"DISCOUNT", "AMOUNT"}));
        resultJson.put("displayNameLocalized", BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.displayName", (Object[])new Object[0]));
        ArrayNode originators2 = resultJson.putArray("originators");
        for (SepaOriginatorData originator : SepaPaymentForm.loadOriginators(user)) {
            ObjectNode originatorNode = originators2.addObject();
            originatorNode.put("id", originator.getPaymentOriginator().getId()).put("name", originator.getName());
            if (user.getTenants().size() > 1) {
                originatorNode.put("tenant", originator.getTenant().getId());
            }
            if (isDebit) {
                originatorNode.put("creditorId", originator.getCreditorId());
            }
            if (originator.getDefaultAccount() != null) {
                originatorNode.put("defaultAccountId", originator.getDefaultAccount().getId());
            }
            if (PaymentTransferType.PmtType.AUSTRIAN_TAX_PAYMENT.equals((Object)pmtType) || PaymentTransferType.PmtType.AUSTRIAN_URGENT_TAX_PAYMENT.equals((Object)pmtType)) {
                originatorNode.put("taxnumber", originator.getTaxNumber());
            }
            if (isDebit) continue;
            AddressData oAddress = originator.getAddress();
            if (oAddress != null) {
                if (oAddress.getDepartment() != null) {
                    originatorNode.put("dept", oAddress.getDepartment());
                } else {
                    originatorNode.put("dept", "");
                }
                if (oAddress.getSubDepartment() != null) {
                    originatorNode.put("subdept", oAddress.getSubDepartment());
                } else {
                    originatorNode.put("subdept", "");
                }
                if (oAddress.getStreetName() != null) {
                    originatorNode.put("street", oAddress.getStreetName());
                } else {
                    originatorNode.put("street", "");
                }
                if (oAddress.getBuildingNumber() != null) {
                    originatorNode.put("buildingnumber", oAddress.getBuildingNumber());
                } else {
                    originatorNode.put("buildingnumber", "");
                }
                if (oAddress.getTownName() != null) {
                    originatorNode.put("town", oAddress.getTownName());
                } else {
                    originatorNode.put("town", "");
                }
                if (oAddress.getPostCode() != null) {
                    originatorNode.put("postcode", oAddress.getPostCode());
                } else {
                    originatorNode.put("postcode", "");
                }
                if (oAddress.getCountrySubDivision() != null) {
                    originatorNode.put("subcountry", oAddress.getCountrySubDivision());
                } else {
                    originatorNode.put("subcountry", "");
                }
                if (oAddress.getCountry() != null) {
                    originatorNode.put("country", oAddress.getCountry());
                    continue;
                }
                originatorNode.put("country", "");
                continue;
            }
            originatorNode.put("dept", "");
            originatorNode.put("subdept", "");
            originatorNode.put("street", "");
            originatorNode.put("buildingnumber", "");
            originatorNode.put("town", "");
            originatorNode.put("postcode", "");
            originatorNode.put("subcountry", "");
            originatorNode.put("country", "");
        }
        if (isATX) {
            ArrayNode servicelevel = resultJson.putArray("servicelevel");
            ObjectNode nurgNode = servicelevel.addObject();
            nurgNode.put("id", SEPAServiceLevel.NURG.name());
            nurgNode.put("title", messages.at("sepapayment.atxNURG", new Object[0]));
            ObjectNode sdvaNode = servicelevel.addObject();
            sdvaNode.put("id", SEPAServiceLevel.SDVA.name());
            sdvaNode.put("title", messages.at("sepapayment.atxSDVATooltip", new Object[0]));
        }
        if (user.getTenants().size() > 1) {
            ArrayNode recipients2 = resultJson.putArray("recipients");
            for (RecipientData recipientData : SepaPaymentForm.loadRecipients(user, false, pmtType.getRecipientPaymentType())) {
                ObjectNode recipientNode = recipients2.addObject();
                recipientNode.put("id", recipientData.getPaymentRecipient().getId());
                recipientNode.put("tenant", recipientData.getPaymentRecipient().getTenant().getId());
            }
        }
        if (isDebit) {
            ArrayNode executionDates = resultJson.putArray("debitExecutionDates");
            for (String info : SepaPaymentForm.loadDebitEarliestExecutionDates(user, pmtType, messages.lang().toLocale())) {
                String[] infoArray = info.split("\\t", 3);
                if (infoArray.length < 3) continue;
                ObjectNode executionDateNode = executionDates.addObject();
                executionDateNode.put("account", Integer.parseInt(infoArray[0]));
                executionDateNode.put("sequenceType", infoArray[1]);
                executionDateNode.put("executionDate", infoArray[2]);
            }
        }
        if (showCurrency) {
            StringBuilder accountIds = new StringBuilder();
            for (Integer accountId : SepaPaymentForm.findAccountsForForeignCurrencies(user, pmtType)) {
                if (!accountIds.isEmpty()) {
                    accountIds.append(',');
                }
                accountIds.append(accountId);
            }
            if (!accountIds.isEmpty()) {
                resultJson.put("accountsWithForeignCurrencies", accountIds.toString());
            }
        }
        ArrayNode accounts2 = resultJson.putArray("accounts");
        for (Account account : new PermissionsLoader(user).loadAccounts(pmtType, user, PermissionsLoader.AccountType.IBAN)) {
            ObjectNode accountNode = accounts2.addObject();
            accountNode.put("accountId", account.getId());
            if (account.getCurrency() != null && !account.getCurrency().isEmpty()) {
                accountNode.put("currency", account.getCurrency());
            }
            if (account.getSepaOriginator() != null) {
                if (allowOriginatorRecording) {
                    accountNode.put("defaultOriginator", account.getSepaOriginator().getName());
                } else {
                    accountNode.put("defaultOriginator", account.getSepaOriginator().getId());
                }
            }
            if (!useMandates && account.getAccountHolder() != null && !account.getAccountHolder().isEmpty()) {
                accountNode.put("holder", account.getAccountHolder());
            }
            if (user.getTenants().size() <= 1) continue;
            accountNode.put("tenantId", account.getBank().getTenant().getId());
        }
        if (isDebit) {
            form.field("debitType").value().ifPresent(debitType -> {
                if (SepaDebitType.COR1.name().equals(debitType)) {
                    resultJson.put("bicService", BicLoader.Service.Cor1.name());
                } else if (SepaDebitType.B2B.name().equals(debitType)) {
                    resultJson.put("bicService", BicLoader.Service.B2b.name());
                } else {
                    resultJson.put("bicService", BicLoader.Service.Sdd.name());
                }
            });
        } else {
            resultJson.put("bicService", BicLoader.Service.Sct.name());
        }
        resultJson.put("hasError", form.hasErrors());
        return Base64.getEncoder().encodeToString(Json.asciiStringify((JsonNode)resultJson).getBytes(StandardCharsets.US_ASCII));
    }

    public SepaPaymentForm() {
    }

    public SepaPaymentForm(CmBooking booking, User user, Map<String, String> flashMap, Messages messages, boolean displaySalaries, boolean allowRecipientRecording, boolean useMandates, boolean saveRecipient) throws PaymentException {
        super(PaymentContextType.OPEN_PAYMENT, PaymentTransferType.PmtType.SEPA_TRANSFER, null, saveRecipient);
        this.paymentData = new SEPAPaymentData();
        if (booking != null) {
            Account bookingAccount;
            String originator = booking.getLocalParty();
            if (originator != null) {
                this.paymentData.setOriginator(originator);
            }
            if ((bookingAccount = booking.getAccount()) != null) {
                if (bookingAccount.getId() != null) {
                    List foundOne = Account.findAllowedAccountsByIds(Collections.singletonList(bookingAccount.getId()), (User)user, (boolean)true);
                    String originatorIban = bookingAccount.getIban();
                    String originatorBic = bookingAccount.getBic();
                    if (!foundOne.isEmpty()) {
                        this.originatorAccountId = bookingAccount.getId();
                        if (originatorIban != null) {
                            this.originatorAccount = originatorIban;
                        }
                        if (originatorBic != null) {
                            this.paymentData.setOriginatorBic(bookingAccount.getBic());
                        }
                        if (this.paymentData.getOriginator() == null || this.paymentData.getOriginator().isEmpty()) {
                            if (bookingAccount.getSepaOriginator() != null) {
                                this.paymentData.setOriginator(bookingAccount.getSepaOriginator().getName());
                            } else {
                                this.paymentData.setOriginator(bookingAccount.getAccountHolder());
                            }
                        }
                    } else {
                        this.originatorAccountId = -1;
                        String originatorBank = bookingAccount.getBank().getDisplayName();
                        if (originatorIban == null || originatorIban.isEmpty()) {
                            Utils.addToFlash(flashMap, "warning", messages.at("bookings.createsepa.warningoriginator.nooriginator", new Object[0]));
                        } else if (originator != null && !originator.isEmpty()) {
                            if (originatorBic != null && !originatorBic.isEmpty()) {
                                Utils.addToFlash(flashMap, "warning", messages.at("bookings.createsepa.warningoriginator.nobic", new Object[]{originatorIban, originatorBank, originator}));
                            } else {
                                Utils.addToFlash(flashMap, "warning", messages.at("bookings.createsepa.warningoriginator", new Object[]{originatorIban, originatorBank, originatorBic, originator}));
                            }
                        } else if (originatorBic != null && !originatorBic.isEmpty()) {
                            Utils.addToFlash(flashMap, "warning", messages.at("bookings.createsepa.warningoriginator.noname", new Object[]{originatorIban, originatorBank, originatorBic}));
                        } else {
                            Utils.addToFlash(flashMap, "warning", messages.at("bookings.createsepa.warningoriginator.ibanonly", new Object[]{originatorIban, originatorBank}));
                        }
                    }
                }
            } else {
                Utils.addToFlash(flashMap, "warning", messages.at("bookings.createsepa.warningoriginator.nooriginator", new Object[0]));
            }
            if (booking.getCounterParty() != null) {
                this.paymentData.setRecipient(booking.getCounterParty());
            }
            if (booking.getCounterPartyAccountNumber() != null) {
                this.paymentData.setRecipientIban(booking.getCounterPartyAccountNumber());
            }
            if (booking.getCounterPartyBankCode() != null) {
                this.paymentData.setRecipientBic(booking.getCounterPartyBankCode());
            }
            Currency c = booking.getCurrency();
            BigDecimal a = booking.getAmount();
            Tenant tenant = booking.getAccount().getBank().getTenant();
            boolean allowForeignCurrencies = new DatabasePreferenceStore(Preference.ApplicationId.SEPA, user, tenant).getBoolean((DatabasePreferenceConstant)PreferenceConstants.ALLOW_FOREIGN_CURRENCIES);
            if (c != null && a != null && (allowForeignCurrencies || "EUR".equals(c.getCurrencyCode()))) {
                this.paymentData.setCurrency(c);
                this.paymentData.setAmount(a.abs());
            }
            Date date2 = DateUtils.getNextWorkingDay((Calendar)Calendar.getInstance()).getTime();
            this.paymentData.setExecutionDate(date2);
            this.paymentData.setPurpose(booking.getPurpose());
            if (CMUtil.isSinglePositiveCreditTransfer((String)booking.getGvc())) {
                this.paymentData.setPurposeCode("RRCT");
            } else if (CMUtil.isSinglePositiveDirectDebit((String)booking.getGvc())) {
                this.paymentData.setPurposeCode("RIMB");
            }
        }
        this.setDefaultValues(PaymentTransferType.PmtType.SEPA_TRANSFER);
        this.loadPaymentDataInfo(displaySalaries, allowRecipientRecording, useMandates);
    }

    public SepaPaymentForm(PaymentContextType paymentContextType, PaymentTransferType.PmtType pmtType, User user, PaymentFolder folder, boolean singleBooking, boolean saveRecipient) throws PaymentException {
        super(paymentContextType, pmtType, folder, saveRecipient);
        this.paymentData = new SEPAPaymentData();
        this.setDefaultValues(pmtType);
        if (this.isCheque) {
            this.setDefaultSepaPaymentSettingsForCheques();
        } else if (this.isUrgent) {
            this.paymentData.setServiceLevel(GeneralSEPAExtractor.URGP);
        } else if (this.isSepaForeign && !SepaPaymentForm.serviceLevelCanBeEmpty(user)) {
            this.paymentData.setServiceLevel(GeneralSEPAExtractor.NURG);
            this.serviceLevel = GeneralSEPAExtractor.NURG;
        }
        this.currency = "EUR";
        if (this.isDebit) {
            this.debitType = SepaPaymentForm.getDebitType(pmtType);
            this.paymentData.setDebitType(this.debitType);
            if (Branding.getBranding().SEPADebitPaymentCategory().isPresent()) {
                this.paymentCategory = Branding.getBranding().SEPADebitPaymentCategory().get();
            }
            if (Branding.getBranding().SEPADebitPurposeCode().isPresent()) {
                this.purposeCode = Branding.getBranding().SEPADebitPurposeCode().get();
            }
        }
        if (this.isInstant) {
            this.paymentData.setLocalInstrument(SEPALocalInstrument.INST.name());
        }
        if (SepaApi.isSalaryPaymentType((PaymentTransferType.PmtType)pmtType)) {
            this.paymentCategory = "SALA";
        }
        Optional<String> endToEndIdPrefill = Branding.getBranding().prefillEndToEndId();
        endToEndIdPrefill.ifPresent(s -> {
            this.reference = s;
        });
        this.singleBooking = singleBooking;
        if (this.isSepaForeign) {
            this.singleBooking = true;
            if (this.feeType == null) {
                this.feeType = "SHAR";
            }
            this.paymentData.setChargeBearer(this.feeType);
            if (this.isCheque) {
                this.paymentData.setChargeBearer("SHAR");
            }
        }
        if (this.isUrgent) {
            this.paymentData.setChargeBearer("SHAR");
        }
    }

    public SepaPaymentForm(Object databaseVO, boolean displaySalaries, boolean allowRecipientRecording, boolean useMandates, boolean saveRecipient) throws PaymentException {
        super(databaseVO, saveRecipient);
        byte[] rawPaymentData = this.getPaymentData();
        if (rawPaymentData != null) {
            this.paymentData = (SEPAPaymentData)PaymentHandler.getHandler(this.getPmtType(), rawPaymentData).getPayment();
        }
        this.setDefaultValues(this.getPmtType());
        this.loadPaymentDataInfo(displaySalaries, allowRecipientRecording, useMandates);
    }

    public boolean isChequePayment(PaymentTransferType.PmtType pmtType) {
        return PaymentTransferType.PmtType.SEPA_FOREIGN_CHEQUE.equals((Object)pmtType);
    }

    private void setDefaultSepaPaymentSettingsForCheques() {
        this.paymentData.setPaymentMethod("CHK");
        this.paymentData.setChargeBearer(SEPAFeeType.SHAR.name());
        this.paymentData.setServiceLevel("NURG");
    }

    public SepaPaymentForm(Object dsOrder, SEPAPaymentData sepaPaymentData, boolean displaySalaries, boolean allowRecipientRecording, boolean useMandates, boolean saveRecipient) throws PaymentException {
        super(dsOrder, saveRecipient);
        this.paymentData = sepaPaymentData;
        PaymentTransferType.PmtType pmtType = this.getPmtType();
        this.setDefaultValues(pmtType);
        this.loadPaymentDataInfo(displaySalaries, allowRecipientRecording, useMandates);
    }

    public boolean hasOriginatorAddress() {
        return this.originatorAddress != null && !this.originatorAddress.isEmpty() || this.originatorCountry != null && !this.originatorCountry.isEmpty();
    }

    public boolean hasRecipientAddress() {
        return this.recipientAddress != null && !this.recipientAddress.isEmpty() || this.recipientCountry != null && !this.recipientCountry.isEmpty();
    }

    public boolean hasRecipientBankAddress() {
        return this.bankAddress != null && !this.bankAddress.isEmpty() || this.bankCountry != null && !this.bankCountry.isEmpty();
    }

    public boolean hasDeliveryAddress() {
        return this.deliveryAddress != null && !this.deliveryAddress.isEmpty() || this.deliveryCountry != null && !this.deliveryCountry.isEmpty();
    }

    @Override
    public PaymentHandler<?> loadPaymentHandler(User user) throws PaymentException {
        Logger.PaymentField field;
        byte[] rawPaymentData;
        if (this.paymentData == null && (rawPaymentData = this.getPaymentData()) != null) {
            this.paymentData = (SEPAPaymentData)PaymentHandler.getHandler(this.getPmtType(), rawPaymentData).getPayment();
        }
        boolean newPayment = false;
        if (this.paymentData == null) {
            this.paymentData = new SEPAPaymentData();
            newPayment = true;
        }
        boolean isDebit = SepaApi.isDebitPmtType((PaymentTransferType.PmtType)this.getPmtType());
        this.paymentData.setInitiatingParty(this.originatorName);
        if (!newPayment) {
            Logger.PaymentField field2 = isDebit ? Logger.PaymentField.PAYEE : Logger.PaymentField.ORIGINATOR;
            this.reportFieldChange(field2, this.paymentData.getOriginator(), this.originatorName);
        }
        this.paymentData.setOriginator(this.originatorName);
        Account originatorAccount = (Account)DB.find(Account.class, (Object)this.originatorAccountId);
        if (originatorAccount != null) {
            Tenant tenant = originatorAccount.getBank().getTenant();
            DatabasePreferenceStore tenantPreferences = new DatabasePreferenceStore(Preference.ApplicationId.SEPA, user, tenant);
            this.paymentData.setOriginatorIban(originatorAccount.getIban());
            this.paymentData.setOriginatorBic(originatorAccount.getBic());
            if (originatorAccount.getCurrency() != null && (this.isSepaForeign || tenantPreferences.getBoolean((DatabasePreferenceConstant)PreferenceConstants.SAVE_ACCOUNT_CURRENCY))) {
                this.paymentData.setAccountCurrency(Currency.getInstance((String)originatorAccount.getCurrency()));
            } else {
                this.paymentData.setAccountCurrency(null);
            }
        } else {
            this.paymentData.setOriginatorIban(null);
            this.paymentData.setOriginatorBic(null);
        }
        if (!newPayment) {
            Logger.PaymentField field3 = isDebit ? Logger.PaymentField.PAYER : Logger.PaymentField.RECIPIENT;
            this.reportFieldChange(field3, this.paymentData.getRecipient(), this.recipientName);
        }
        this.paymentData.setRecipient(this.recipientName);
        this.paymentData.setRecipientLei(this.recipientLei);
        if (!newPayment) {
            this.reportFieldChange(Logger.PaymentField.RECIPIENT_IBAN, IbanUtil.formatIBAN((String)this.paymentData.getRecipientIban()), IbanUtil.formatIBAN((String)this.recipientAccount));
        }
        if (this.recipientAccount != null) {
            this.paymentData.setRecipientIban(this.recipientAccount.replaceAll(" ", "").trim());
        } else {
            this.paymentData.setRecipientIban(null);
        }
        if (!newPayment) {
            this.reportFieldChange(Logger.PaymentField.RECIPIENT_BIC, this.paymentData.getRecipientBic(), this.recipientBankCode);
        }
        this.paymentData.setRecipientBic(this.recipientBankCode);
        boolean isOriginatorAddressMandatory = !isDebit && SepaApi.isOriginatorAddressMandatory((String)this.paymentData.getOriginatorIban(), (String)this.paymentData.getRecipientIban());
        boolean isDebtorAddressMandatory = SepaCountry.isDebtorAddressMandatory((String)IbanUtil.getCountryCode((String)this.paymentData.getRecipientIban()));
        boolean isRecipientAddressMandatory = isDebit && isDebtorAddressMandatory;
        boolean saveOriginatorAddress = this.isSepaForeign || !isDebit;
        boolean saveRecipientAddress = true;
        boolean saveBankAddress = this.isSepaForeign;
        if (isOriginatorAddressMandatory && (this.originatorCountry == null || this.originatorCountry.isEmpty()) && IbanUtil.checkIban((String)this.paymentData.getOriginatorIban())) {
            this.originatorCountry = IbanUtil.getCountryCode((String)this.paymentData.getOriginatorIban());
        }
        if (isRecipientAddressMandatory && (this.recipientCountry == null || this.recipientCountry.isEmpty()) && IbanUtil.checkIban((String)this.paymentData.getRecipientIban())) {
            this.recipientCountry = IbanUtil.getCountryCode((String)this.paymentData.getRecipientIban());
        }
        if (saveOriginatorAddress) {
            this.originatorAddress = PaymentUtils.getFullAddressData(this.originatorDept, this.originatorSubdept, this.originatorStreet, this.originatorBuildingnumber, this.originatorBuildingname, this.originatorFloor, this.originatorTown, this.originatorPostcode, this.originatorSubcountry, "", this.originatorCountry);
            this.paymentData.setOriginatorAddressData(this.originatorAddress);
        } else {
            this.paymentData.setOriginatorAddressData(null);
        }
        this.recipientAddress = PaymentUtils.getFullAddressData(this.recipientDept, this.recipientSubdept, this.recipientStreet, this.recipientBuildingnumber, this.recipientBuildingname, this.recipientFloor, this.recipientTown, this.recipientPostcode, this.recipientSubcountry, "", this.recipientCountry);
        this.paymentData.setRecipientAddressData(this.recipientAddress);
        if (saveBankAddress) {
            if (this.clearingSystem != null && !this.clearingSystem.isEmpty() && !"bic".equals(this.clearingSystem)) {
                this.paymentData.setRecipientClearingSystemId(this.clearingSystem);
            }
            if (this.recipientBank != null && !this.recipientBank.isEmpty()) {
                this.paymentData.setRecipientBankName(this.recipientBank);
            }
            this.bankAddress = PaymentUtils.getFullAddressData(this.bankDept, this.bankSubdept, this.bankStreet, this.bankBuildingnumber, this.bankBuildingname, this.bankFloor, this.bankTown, this.bankPostcode, this.bankSubcountry, "", this.bankCountry);
            this.paymentData.setRecipientBankAddressData(this.bankAddress);
        }
        int currencydigits = 2;
        if (!newPayment) {
            this.reportFieldChange(Logger.PaymentField.CURRENCY, this.paymentData.getCurrency(), this.currency != null ? Currency.getInstance((String)this.currency) : null);
        }
        if (this.currency != null) {
            this.paymentData.setCurrency(Currency.getInstance((String)this.currency));
            currencydigits = Currency.getInstance((String)this.currency).getDefaultFractionDigits();
        }
        if (!newPayment) {
            this.reportFieldChange(Logger.PaymentField.AMOUNT, this.paymentData.getAmount(), this.amount);
        }
        if (this.amount != null) {
            this.amount = this.amount.setScale(currencydigits, RoundingMode.DOWN);
            this.paymentData.setAmount(this.amount);
        } else {
            this.paymentData.setAmount(null);
        }
        if (!this.structuredPurpose) {
            if (!newPayment) {
                this.reportFieldChange(Logger.PaymentField.PURPOSE, this.paymentData.getPurpose(), this.purpose);
            }
            this.paymentData.setHasStructuredPurpose(false);
            this.paymentData.setPurpose(this.purpose);
        } else {
            if (!newPayment) {
                this.reportFieldChange(Logger.PaymentField.PURPOSE, this.paymentData.getPurposeReference(), this.purpose);
            }
            this.paymentData.setHasStructuredPurpose(true);
            this.paymentData.setPurposeReferenceTypeCode("SCOR");
            this.paymentData.setPurposeReference(this.purpose);
        }
        if (this.executionDate == null && originatorAccount != null && de.businesslogics.util.PaymentUtils.isBundesbank((String)originatorAccount.getIban())) {
            if (!newPayment) {
                this.reportFieldChange(Logger.PaymentField.EXECUTION_DATE, this.paymentData.getExecutionDate(), null);
            }
            this.paymentData.setExecutionDate(NO_EXECUTION_DATE);
        } else {
            if (!newPayment) {
                this.reportFieldChange(Logger.PaymentField.EXECUTION_DATE, this.paymentData.getExecutionDate(), this.executionDate);
            }
            this.paymentData.setExecutionDate(this.executionDate);
        }
        if (!newPayment) {
            String oldEndToEndId = this.paymentData.getEndToEndId();
            if (oldEndToEndId.startsWith("TempMessageId-")) {
                oldEndToEndId = "";
            }
            this.reportFieldChange(Logger.PaymentField.END_TO_END_REFERENCE, oldEndToEndId, this.reference);
        }
        this.paymentData.setEndToEndId(this.reference);
        this.paymentData.setCreditorId(this.creditorId);
        if (!newPayment) {
            field = isDebit ? Logger.PaymentField.ULTIMATE_PAYEE : Logger.PaymentField.ULTIMATE_ORIGINATOR;
            this.reportFieldChange(field, this.paymentData.getUltimateOriginator(), this.ultimateOriginator);
        }
        this.paymentData.setUltimateOriginator(this.ultimateOriginator);
        if (!newPayment) {
            field = isDebit ? Logger.PaymentField.ULTIMATE_PAYER : Logger.PaymentField.ULTIMATE_RECIPIENT;
            this.reportFieldChange(field, this.paymentData.getUltimateRecipient(), this.ultimateRecipient);
        }
        this.paymentData.setUltimateRecipient(this.ultimateRecipient);
        this.paymentData.setMandateId(this.mandateReference);
        this.paymentData.setMandateSignDate(this.mandateSignDate);
        if (!newPayment) {
            this.reportFieldChange(Logger.PaymentField.PAYMENT_CATEGORY, this.paymentData.getPaymentCategory(), this.paymentCategory);
        }
        this.paymentData.setPaymentCategory(this.paymentCategory);
        if (!newPayment) {
            this.reportFieldChange(Logger.PaymentField.PURPOSE_CODE, this.paymentData.getPurposeCode(), "".equals(this.purposeCode) ? null : this.purposeCode);
        }
        this.paymentData.setPurposeCode(this.purposeCode);
        if (!newPayment) {
            this.reportFieldChange(Logger.PaymentField.INSTRUCTION_PRIORITY, this.paymentData.getInstructionPriority(), this.instructionPriority);
        }
        this.paymentData.setInstructionPriority(this.instructionPriority);
        if (!newPayment) {
            this.reportFieldChange(Logger.PaymentField.SEQUENCE_TYPE, this.paymentData.getSequenceType(), this.sequenceType);
        }
        this.paymentData.setSequenceType(this.sequenceType);
        if (this.isSepaForeign) {
            this.paymentData.setDebitType(null);
            this.paymentData.setDisplayAsSingleBooking(true);
        } else {
            this.paymentData.setDebitType(this.debitType);
            this.paymentData.setDisplayAsSingleBooking(this.singleBooking);
        }
        new DatabasePreferenceStore(Preference.ApplicationId.SEPA, user).setValue((DatabasePreferenceConstant)PreferenceConstants.DISPLAY_PAYMENT_AS_SINGLE_BOOKING, this.singleBooking);
        if (this.isSepaForeign) {
            if (this.serviceLevel == null || "NONE".equals(this.serviceLevel)) {
                this.serviceLevel = "";
            }
            this.paymentData.setServiceLevel(this.serviceLevel);
        } else if (this.isUrgent) {
            this.paymentData.setServiceLevel(GeneralSEPAExtractor.URGP);
            this.paymentData.setChargeBearer(SEPAFeeType.SHAR.name());
        } else if (PaymentTransferType.PmtType.SEPA_FOREIGN_CURRENCY_TRANSFER.equals((Object)this.getPmtType())) {
            this.paymentData.setServiceLevel(null);
        } else if (Arrays.asList(TaxOfficePaymentForm.getPmtTypes()).contains(this.getPmtType())) {
            this.paymentData.setServiceLevel(this.serviceLevel);
            if (SEPAServiceLevel.URGP.name().equals(this.serviceLevel)) {
                this.isUrgent = true;
            }
        }
        if (this.isInstant) {
            this.paymentData.setLocalInstrument(SEPALocalInstrument.INST.name());
        } else if (this.isSepaForeign) {
            this.paymentData.setLocalInstrument(null);
        }
        if (this.isSepaForeign) {
            this.paymentData.setChargeBearer(this.feeType);
        }
        if (this.isCheque) {
            this.setDefaultSepaPaymentSettingsForCheques();
            ChequeInstructionData cheque = this.getChequeData();
            this.paymentData.setChequeInstructionData(cheque);
        }
        return PaymentHandler.getHandler(this.paymentData, this.getPmtType());
    }

    @Override
    public boolean isUrgentPmtType(PaymentTransferType.PmtType pmtType) {
        return SepaApi.isUrgent((PaymentTransferType.PmtType)pmtType);
    }

    @Override
    public boolean isCredit() {
        return SepaApi.isCreditPmtType((PaymentTransferType.PmtType)this.getPmtType());
    }

    @Override
    protected PaymentType getPaymentType(User user) {
        if (this.isDebit && new DatabasePreferenceStore(Preference.ApplicationId.SEPA, user).getBoolean((DatabasePreferenceConstant)PreferenceConstants.USE_MANDATE_ADMISTRATION)) {
            return PaymentType.MANDATE;
        }
        if (this.isSepaForeign) {
            return PaymentType.SEPA_FOREIGN;
        }
        return PaymentType.SEPA;
    }

    @Override
    protected boolean doLoadOriginatorById(User user) {
        boolean useMandate = this.isDebit && new DatabasePreferenceStore(Preference.ApplicationId.SEPA, user).getBoolean((DatabasePreferenceConstant)PreferenceConstants.USE_MANDATE_ADMISTRATION);
        return super.doLoadOriginatorById(user) && !useMandate;
    }

    @Override
    protected Form<? extends PaymentForm> loadSelectedOriginator(Form<? extends PaymentForm> form, Tenant tenant) {
        PaymentOriginator paymentOriginator;
        if (this.originatorName == null || this.originatorName.isEmpty()) {
            return form.withError("originatorName", "error.required");
        }
        try {
            int originatorId = Integer.parseInt(this.originatorName);
            if (originatorId <= 0) {
                return form.withError("originatorName", "error.required");
            }
            paymentOriginator = (PaymentOriginator)DB.find(PaymentOriginator.class).where().eq("id", (Object)originatorId).eq("tenant", (Object)tenant).eq("paymentType", (Object)PaymentType.SEPA).setMaxRows(1).findOne();
        }
        catch (NumberFormatException e) {
            paymentOriginator = null;
        }
        if (paymentOriginator == null) {
            return form.withError("originatorName", "error.originatorNotFound");
        }
        this.originatorName = paymentOriginator.getName();
        SepaOriginatorData sepaOriginator = new SepaOriginatorData();
        try {
            sepaOriginator.setPaymentOriginator(paymentOriginator);
            if (this.isDebit) {
                this.creditorId = sepaOriginator.getCreditorId();
            }
            if (!this.isDebit) {
                this.originatorAddress = sepaOriginator.getAddress();
                this.setOriginatorAddress(this.originatorAddress);
            }
        }
        catch (IOException e) {
            BLLoggerPlay.warning("Failed to load SEPA originator!", e);
        }
        return form;
    }

    @Override
    protected Form<? extends PaymentForm> loadSelectedRecipient(Form<? extends PaymentForm> form, User user, Tenant tenant) {
        String fieldName;
        String paymentRecipientDisplayName;
        if (this.recipientName == null || this.recipientName.isEmpty()) {
            return form.withError("recipientName", "error.required");
        }
        boolean useMandates = new DatabasePreferenceStore(Preference.ApplicationId.SEPA, user).getBoolean((DatabasePreferenceConstant)PreferenceConstants.USE_MANDATE_ADMISTRATION);
        ArrayList<PaymentType> paymentTypes = new ArrayList<PaymentType>();
        if (this.isSepaForeign) {
            paymentTypes.add(PaymentType.SEPA_FOREIGN);
            paymentRecipientDisplayName = this.recipientName;
            fieldName = "recipientName";
        } else {
            paymentTypes.add(PaymentType.MANDATE);
            if (this.isCredit() || !useMandates) {
                paymentTypes.add(PaymentType.SEPA);
                paymentRecipientDisplayName = this.recipientName;
                fieldName = "recipientName";
            } else {
                paymentRecipientDisplayName = this.mandate;
                fieldName = "mandate";
            }
        }
        PaymentRecipient paymentRecipient = PaymentRecipient.findRecipientByDisplayName(paymentTypes, (String)paymentRecipientDisplayName, (Tenant)tenant);
        if (paymentRecipient == null) {
            List paymentRecipients = PaymentRecipient.findRecipientByName(paymentTypes, (String)paymentRecipientDisplayName, (Tenant)tenant);
            if (paymentRecipients.size() == 1) {
                paymentRecipient = (PaymentRecipient)paymentRecipients.getFirst();
            } else if (paymentRecipients.size() > 1) {
                return form.withError(fieldName, "error.ambiguous");
            }
        }
        if (paymentRecipient == null) {
            return form.withError(fieldName, "error.recipientNotFound");
        }
        this.recipientName = paymentRecipient.getName();
        this.recipientAccount = paymentRecipient.getAccountNumber();
        this.recipientBankCode = paymentRecipient.getBankCode();
        if (this.isDebit) {
            this.mandateReference = paymentRecipient.getSepaMandateId();
            try {
                if (paymentRecipient.getPaymentType() == PaymentType.SEPA) {
                    sepaRecipientData = new SepaRecipientData();
                    sepaRecipientData.setPaymentRecipient(paymentRecipient);
                    this.mandateSignDate = sepaRecipientData.getMandateSignDate();
                    this.recipientLei = sepaRecipientData.getLeiNumber();
                } else if (paymentRecipient.getPaymentType() == PaymentType.MANDATE) {
                    sepaMandateData = new SepaMandateData();
                    sepaMandateData.setPaymentRecipient(paymentRecipient);
                    this.mandateSignDate = sepaMandateData.getMandateSignDate();
                    this.recipientLei = sepaMandateData.getLeiNumber();
                    if (useMandates) {
                        this.originatorName = sepaMandateData.getCreditor();
                        this.creditorId = sepaMandateData.getCreditorId();
                    }
                }
            }
            catch (IOException e) {
                BLLoggerPlay.warning("Failed to load SEPA recipient!", e);
            }
        } else {
            try {
                if (paymentRecipient.getPaymentType() == PaymentType.SEPA) {
                    sepaRecipientData = new SepaRecipientData();
                    sepaRecipientData.setPaymentRecipient(paymentRecipient);
                    this.recipientLei = sepaRecipientData.getLeiNumber();
                } else if (paymentRecipient.getPaymentType() == PaymentType.MANDATE) {
                    sepaMandateData = new SepaMandateData();
                    sepaMandateData.setPaymentRecipient(paymentRecipient);
                    this.recipientLei = sepaMandateData.getLeiNumber();
                }
            }
            catch (IOException e) {
                BLLoggerPlay.warning("Failed to load SEPA recipient!", e);
            }
        }
        return form;
    }

    @Override
    protected Form<? extends PaymentForm> internalValidate(Form<? extends PaymentForm> form, Messages messages, FormFactory formFactory, User user, Map<String, String> flashMap) {
        PaymentRecipient mandate;
        String originatorIban;
        form = this.validateSEPASpecialisation(form, formFactory, messages);
        Account account = (Account)DB.find(Account.class, (Object)this.originatorAccountId);
        DatabasePreferenceStore sepaPreferenceStore = new DatabasePreferenceStore(Preference.ApplicationId.SEPA, user);
        boolean urgentAllowsIbanOnly = sepaPreferenceStore.getBoolean((DatabasePreferenceConstant)PreferenceConstants.URGENT_PAYMENT_ALLOWS_IBAN_ONLY);
        boolean isPurposeInISOFormat = sepaPreferenceStore.getBoolean((DatabasePreferenceConstant)PreferenceConstants.ALLOW_ONLY_ISO11649_CREDTIOR_REFERENCES);
        boolean sepaExtendedCheck = sepaPreferenceStore.getBoolean((DatabasePreferenceConstant)PreferenceConstants.EXTENDED_FILE_CHECK);
        boolean allowUKTransferWithoutOrigAddress = sepaPreferenceStore.getBoolean((DatabasePreferenceConstant)PreferenceConstants.ALLOW_UK_TRANSFER_WITHOUT_ORIGINATOR_ADDRESS);
        boolean allowSwissTransferWithoutOriginatorAddress = sepaPreferenceStore.getBoolean((DatabasePreferenceConstant)PreferenceConstants.ALLOW_CH_TRANSFER_WITHOUT_ORIGINATOR_ADDRESS);
        boolean allowSwissTransferWithoutRecipientAddress = sepaPreferenceStore.getBoolean((DatabasePreferenceConstant)PreferenceConstants.ALLOW_CH_TRANSFER_WITHOUT_RECIPIENT_ADDRESS);
        if (this.isUrgent && !urgentAllowsIbanOnly && account != null && (account.getBic() == null || account.getBic().isEmpty())) {
            form = form.withError("originatorAccountId", BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.bicMandatoryForCrossBorder", (Object[])new Object[0]));
        }
        if (this.getPaymentContextType() != PaymentContextType.PERIODIC_PAYMENT && this.getPaymentContextType() != PaymentContextType.PAYMENT_TEMPLATE) {
            if (this.executionDate == null && account != null && !de.businesslogics.util.PaymentUtils.isBundesbank((String)account.getIban())) {
                form = form.withError("executionDate", messages.at("error.required", new Object[0]));
            } else if (this.executionDate != null && account != null) {
                boolean reloadForm = false;
                Calendar cal = DateUtils.getCurrentCalendarWithoutTimeStamp();
                PaymentProperties paymentProperties = PaymentProperties.findForBank((BankSettings)account.getBank());
                if (this.isDebit) {
                    int leadTime;
                    GeneralSEPAWriter.Version sepaVersion = SepaSchemeHandler.getSepaVersion((BankSettings)this.bank, (PaymentTransferType.PmtType)this.pmtType);
                    if (SEPAUtil.isExecutionDateTooOld((GeneralSEPAWriter.Version)sepaVersion, (boolean)false, (String)this.debitType, (String)this.sequenceType, (Date)this.executionDate, (int)(leadTime = SepaApi.getLeadTimeForDebits((PaymentProperties)paymentProperties)))) {
                        this.executionDate = SEPAUtil.getValidExecutionDate((GeneralSEPAWriter.Version)sepaVersion, (boolean)false, (String)this.debitType, (String)this.sequenceType, (Date)this.executionDate, (int)leadTime);
                        form = form.withError("executionDate", messages.at("sepapayment.error.debitexecutiondateadjusted", new Object[0]));
                        reloadForm = true;
                    }
                } else if (this.executionDate.before(cal.getTime())) {
                    this.executionDate = cal.getTime();
                    form = form.withError("executionDate", BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.executionDateUpdated", (Object[])new Object[0]));
                    reloadForm = true;
                }
                if (paymentProperties.getSepaMaxExecDate() > 0) {
                    cal.add(5, paymentProperties.getSepaMaxExecDate());
                    if (this.executionDate.after(cal.getTime())) {
                        this.executionDate = cal.getTime();
                        form = form.withError("executionDate", messages.at("payment.error.executiondatefutureadjusted", new Object[0]));
                        reloadForm = true;
                    }
                }
                if (reloadForm) {
                    form = this.reloadForm((Form<? extends PaymentForm>)form, formFactory);
                }
            }
        } else if (this.executionDate == null) {
            this.executionDate = this.firstExecution;
        }
        if (this.originatorName == null || this.originatorName.isEmpty()) {
            form = form.withError("originatorName", messages.at("error.required", new Object[0]));
        } else if (!RegularExpressions.SEPA_GUI.matches(this.originatorName) || this.originatorName.length() > 70) {
            form = form.withError("originatorName", messages.at("error.invalid", new Object[0]));
        }
        if (!(this.ultimateOriginator == null || this.ultimateOriginator.isEmpty() || RegularExpressions.SEPA_GUI.matches(this.ultimateOriginator) && this.ultimateOriginator.length() <= 70)) {
            form = form.withError("ultimateOriginator", messages.at("error.invalid", new Object[0]));
        }
        this.originatorAddress = this.getOriginatorAddress();
        form = this.checkAddressDataLength((Form<? extends PaymentForm>)form, messages, this.originatorDept, this.originatorSubdept, this.originatorStreet, this.originatorBuildingnumber, this.originatorBuildingname, this.originatorFloor, this.originatorTown, this.originatorPostcode, this.originatorSubcountry);
        String string = originatorIban = account != null ? account.getIban() : this.originatorAccount;
        if (sepaExtendedCheck && !this.isDebit && !this.isSepaForeign && this.getPmtType() != PaymentTransferType.PmtType.AUSTRIAN_TAX_PAYMENT && this.getPmtType() != PaymentTransferType.PmtType.AUSTRIAN_URGENT_TAX_PAYMENT && this.getPmtType() != PaymentTransferType.PmtType.AUSTRIAN_POSTBAR_PAYMENT) {
            String recipientCountryCode;
            if (!allowSwissTransferWithoutOriginatorAddress && IbanUtil.isSwissOrLiechtensteinIban((String)originatorIban)) {
                if (this.originatorCountry == null || this.originatorCountry.isEmpty()) {
                    form = form.withError("originatorCountry", messages.at("general.mandatoryfield", new Object[0]));
                }
            } else if (SepaApi.isOriginatorAddressMandatory((String)originatorIban, (String)this.recipientAccount) && (recipientCountryCode = IbanUtil.getCountryCode((String)this.recipientAccount)) != null && !allowUKTransferWithoutOrigAddress && (this.originatorCountry == null || this.originatorCountry.isEmpty())) {
                form = form.withError("originatorCountry", messages.at("general.mandatoryfield", new Object[0]));
            }
        }
        if (this.isCheque) {
            if (this.serviceLevel != null && !GeneralSEPAExtractor.NURG.equals(this.serviceLevel)) {
                this.serviceLevel = GeneralSEPAExtractor.NURG;
                form = form.withGlobalError(messages.at("sepapayment.error.chk.servicelevel", new Object[0]));
            } else {
                this.serviceLevel = GeneralSEPAExtractor.NURG;
            }
        } else if (this.isSepaForeign) {
            boolean isSwissAccount = false;
            if (account != null) {
                BankSettings bank = account.getBank();
                boolean bl = isSwissAccount = bank != null && bank.isSwissBank() || IbanUtil.isSwissOrLiechtensteinIban((String)account.getIban());
            }
            if (SEPAServiceLevel.NURG.name().equals(this.serviceLevel) && isSwissAccount) {
                form = form.withError("serviceLevel", messages.at("sepapayment.error.serviceLevel.notForSwiss", new Object[]{"NURG"}));
            } else if (SEPAServiceLevel.PRPT.name().equals(this.serviceLevel) && !isSwissAccount) {
                form = form.withError("serviceLevel", messages.at("sepapayment.error.serviceLevel.onlyForSwiss", new Object[]{"PRPT"}));
            }
        }
        ChequeInstructionData cheque = this.getChequeData();
        if (this.isCheque) {
            boolean town;
            if (cheque != null && cheque.getDeliveryMethod() != null && ("MLDB".equals(cheque.getDeliveryMethod()) || "CRDB".equals(cheque.getDeliveryMethod()) || "RGDB".equals(cheque.getDeliveryMethod())) && (this.originatorTown == null || this.originatorTown.isEmpty()) && (this.originatorCountry == null || this.originatorCountry.isEmpty())) {
                form = form.withError("originatorTown", messages.at("sepapayment.error.chk.missingoriginatoraddress", new Object[0]));
                form = form.withError("originatorCountry", messages.at("sepapayment.error.chk.missingoriginatoraddress", new Object[0]));
            }
            form = this.checkAddressDataLength((Form<? extends PaymentForm>)form, messages, this.deliveryDept, this.deliverySubdept, this.deliveryStreet, this.deliveryBuildingnumber, this.deliveryBuildingname, this.deliveryFloor, this.deliveryTown, this.deliveryPostcode, this.deliverySubcountry);
            boolean name = this.deliveryName != null && !this.deliveryName.isEmpty();
            boolean country = this.deliveryCountry != null && !this.deliveryCountry.isEmpty();
            boolean bl = town = this.deliveryTown != null && !this.deliveryTown.isEmpty();
            if (name && !country && !town || !name && (country || town)) {
                form = form.withError("deliveryName", messages.at("sepapayment.error.recipientaddressneeded", new Object[0]));
                form = form.withError("deliveryTown", messages.at("sepapayment.error.recipientaddressneeded", new Object[0]));
                form = form.withError("deliveryCountry", messages.at("sepapayment.error.recipientaddressneeded", new Object[0]));
            }
        } else if (cheque != null) {
            this.deliveryMethod = null;
            this.deliveryName = null;
            this.deliveryDept = null;
            this.deliverySubdept = null;
            this.deliveryStreet = null;
            this.deliveryBuildingnumber = null;
            this.deliveryBuildingname = null;
            this.deliveryFloor = null;
            this.deliveryTown = null;
            this.deliveryPostcode = null;
            this.deliverySubcountry = null;
            this.deliveryCountry = null;
            form = form.withGlobalError(messages.at("sepapayment.error.resetchequeData", new Object[0]));
        }
        if (this.recipientName == null || this.recipientName.isEmpty()) {
            form = form.withError("recipientName", messages.at("error.required", new Object[0]));
        } else if (!RegularExpressions.SEPA_GUI.matches(this.recipientName) || this.recipientName.length() > 70) {
            form = form.withError("recipientName", messages.at("error.invalid", new Object[0]));
        } else if (this.createNewMandate && (mandate = PaymentRecipient.findRecipientByAccountInfo(Collections.singletonList(PaymentType.MANDATE), (String)this.recipientName, (String)this.recipientAccount.replaceAll(" ", ""), null, (List)user.getTenants())) != null) {
            form = form.withError("recipientName", messages.at("sepapayment.mandate.exists", new Object[0]));
        }
        if (this.ultimateRecipient != null && !this.ultimateRecipient.isEmpty()) {
            if (!RegularExpressions.SEPA_GUI.matches(this.ultimateRecipient) || this.ultimateRecipient.length() > 70) {
                form = form.withError("ultimateRecipient", messages.at("error.invalid", new Object[0]));
            } else if (this.isCheque) {
                this.ultimateRecipient = null;
                form = form.withGlobalError(messages.at("sepapayment.error.chk.resetultimaterecipient", new Object[0]));
            }
        }
        form = this.checkAddressDataLength((Form<? extends PaymentForm>)form, messages, this.recipientDept, this.recipientSubdept, this.recipientStreet, this.recipientBuildingnumber, this.recipientBuildingname, this.recipientFloor, this.recipientTown, this.recipientPostcode, this.recipientSubcountry);
        if (this.recipientLei != null && !this.recipientLei.isEmpty() && !RegularExpressions.SEPA_LEI.matches(this.recipientLei)) {
            form = form.withError("recipientLei", messages.at("error.invalid", new Object[0]));
        }
        if (sepaExtendedCheck && !this.isSepaForeign && this.getPmtType() != PaymentTransferType.PmtType.AUSTRIAN_TAX_PAYMENT && this.getPmtType() != PaymentTransferType.PmtType.AUSTRIAN_URGENT_TAX_PAYMENT && this.getPmtType() != PaymentTransferType.PmtType.AUSTRIAN_POSTBAR_PAYMENT) {
            if (this.isDebit) {
                String recipientCountryCode = IbanUtil.getCountryCode((String)this.recipientAccount);
                if (recipientCountryCode != null && SepaCountry.isDebtorAddressMandatory((String)recipientCountryCode) && (this.recipientCountry == null || this.recipientCountry.isEmpty())) {
                    form = form.withError("recipientCountry", messages.at("general.mandatoryfield", new Object[0]));
                }
            } else if (!this.isUrgent && !allowSwissTransferWithoutRecipientAddress && IbanUtil.isSwissOrLiechtensteinIban((String)originatorIban) && (this.recipientCountry == null || this.recipientCountry.isEmpty())) {
                form = form.withError("recipientCountry", messages.at("general.mandatoryfield", new Object[0]));
            }
        }
        if (this.isCheque) {
            if (this.isTownMandatoryInStructuredAddress() && (this.recipientTown == null || this.recipientTown.isEmpty())) {
                form = form.withError("recipientTown", messages.at("error.required", new Object[0]));
            }
            if (this.recipientCountry == null || this.recipientCountry.isEmpty()) {
                form = form.withError("recipientCountry", messages.at("error.required", new Object[0]));
            }
        }
        if (!(this.recipientCountry == null || this.recipientCountry.length() <= 70 && RegularExpressions.SEPA_GUI.matches(this.recipientCountry))) {
            form = form.withError("recipientCountry", messages.at("error.invalid", new Object[0]));
        }
        if (this.isDebit) {
            if (this.creditorId == null || this.creditorId.isEmpty()) {
                form = form.withError("creditorId", messages.at("error.required", new Object[0]));
            } else if (!sepaPreferenceStore.getBoolean((DatabasePreferenceConstant)PreferenceConstants.ALLOW_INVALID_CREDITOR_ID) && !SEPAUtil.checkCreditorId((String)this.creditorId)) {
                form = form.withError("creditorId", messages.at("error.invalid", new Object[0]));
            }
            if (this.mandateReference == null || this.mandateReference.isEmpty()) {
                form = form.withError("mandateReference", messages.at("error.required", new Object[0]));
            } else if (!RegularExpressions.SEPA_RESTRICTED_IDENTIFICATION_1.matches(this.mandateReference)) {
                form = form.withError("mandateReference", messages.at("error.invalid", new Object[0]));
            }
            if (this.mandateSignDate == null) {
                form = form.withError("mandateSignDate", messages.at("error.required", new Object[0]));
            } else if (this.mandateSignDate.compareTo(new Date()) > 0) {
                form = form.withError("mandateSignDate", messages.at("sepapayment.error.mandatesigndateinfuture", new Object[0]));
            }
        }
        if (this.isCheque) {
            if (this.recipientAccount != null && !this.recipientAccount.isEmpty()) {
                form = form.withError("recipientAccount", messages.at("sepapayment.error.chk.resetrecipientaccount", new Object[0]));
            }
            if (this.recipientBankCode != null && !this.recipientBankCode.isEmpty()) {
                form = form.withError("recipientBankCode", messages.at("sepapayment.error.chk.resetrecipientbankcode", new Object[0]));
            }
        } else {
            boolean allowInvalidBankConnections = new DatabasePreferenceStore(Preference.ApplicationId.PAYMENTS, user).getBoolean((DatabasePreferenceConstant)de.businesslogics.banking.payments.core.PreferenceConstants.ALLOW_INVALID_BANK_CONNECTION);
            if (this.recipientAccount != null && !this.recipientAccount.isEmpty()) {
                this.recipientAccount = this.recipientAccount.replaceAll(" ", "").trim();
            }
            if (this.recipientBankCode != null && !this.recipientBankCode.isEmpty()) {
                this.recipientBankCode = this.recipientBankCode.replaceAll(" ", "").trim();
            }
            if (this.recipientAccount == null || this.recipientAccount.isEmpty()) {
                form = form.withError("recipientAccount", messages.at("error.required", new Object[0]));
            } else if (!this.isSepaForeign && !allowInvalidBankConnections) {
                if (!IbanUtil.checkIban((String)this.recipientAccount)) {
                    form = form.withError("recipientAccount", messages.at("error.invalid", new Object[0]));
                } else if (!SepaCountry.isSepaCountry((String)this.recipientAccount.substring(0, 2))) {
                    form = form.withError("recipientAccount", messages.at("sepapayment.error.ibaninvalidcountry", new Object[0]));
                }
            }
            if (this.recipientBankCode == null || this.recipientBankCode.isEmpty()) {
                if (this.isSepaForeign) {
                    form = form.withError("recipientBankCode", messages.at("error.required", new Object[0]));
                } else if (this.isUrgent && !urgentAllowsIbanOnly || this.recipientAccount != null && this.recipientAccount.length() > 1 && !SepaCountry.isIbanOnlyAllowed((String)this.recipientAccount.substring(0, 2))) {
                    form = form.withError("recipientBankCode", BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.bicMandatoryForCrossBorder", (Object[])new Object[0]));
                }
            } else if (!RegularExpressions.BIC.matches(this.recipientBankCode) && !this.isSepaForeign) {
                form = form.withError("recipientBankCode", messages.at("error.invalid", new Object[0]));
            } else if (!(allowInvalidBankConnections || BicLoader.getInstance().isBicSupported(this.recipientBankCode, this.getService()) || this.isSepaForeign)) {
                form = form.withError("recipientBankCode", BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.sclBicNotSupported", (Object[])new Object[]{BicLoader.getDisplayNameForService((BicLoader.Service)this.getService()), this.recipientBankCode}));
            } else if (sepaPreferenceStore.getBoolean((DatabasePreferenceConstant)PreferenceConstants.SCL_CHECK) && SclDirectory.getForBIC((String)this.recipientBankCode) == null && !this.isSepaForeign) {
                Utils.addToFlash(flashMap, "warning", messages.at("sepapayment.error.bicunknown", new Object[]{this.recipientBankCode}));
            }
            if (this.isSepaForeign) {
                this.bankAddress = this.getBankAddress();
                form = this.checkAddressDataLength((Form<? extends PaymentForm>)form, messages, this.bankDept, this.bankSubdept, this.bankStreet, this.bankBuildingnumber, this.bankBuildingname, this.bankFloor, this.bankTown, this.bankPostcode, this.bankSubcountry);
            }
        }
        if (SEPAUtil.SEPA_PAYMENT_MAX_AMOUNT.compareTo(this.amount) < 0) {
            form = form.withError("amount", BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.amountLimitExceeded", (Object[])new Object[]{SEPAUtil.SEPA_PAYMENT_MAX_AMOUNT}));
        }
        if (this.isSepaForeign && this.currency != null) {
            this.amount = this.amount.setScale(Currency.getInstance((String)this.currency).getDefaultFractionDigits(), RoundingMode.DOWN);
        }
        if (Branding.getBranding().isPurposeMandatory()) {
            if (Branding.getBranding().doSEPAThreeLinesPurpose()) {
                if (this.purpose1 == null || this.purpose1.isEmpty()) {
                    form = form.withError("purpose1", messages.at("error.required", new Object[0]));
                }
            } else if (this.purpose == null || this.purpose.isEmpty()) {
                form = form.withError("purpose", messages.at("error.required", new Object[0]));
            }
        }
        if (Branding.getBranding().doSEPAThreeLinesPurpose()) {
            this.purpose1 = StringUtils.checkNullAndTrim((String)this.purpose1);
            this.purpose2 = StringUtils.checkNullAndTrim((String)this.purpose2);
            this.purpose3 = StringUtils.checkNullAndTrim((String)this.purpose3);
            if (!this.purpose1.isEmpty()) {
                if (!RegularExpressions.SEPA_GUI.matches(this.purpose1)) {
                    form = form.withError("purpose1", messages.at("payment.error.invalidcharacter", new Object[0]));
                } else if (this.purpose1.length() > 35) {
                    form = form.withError("purpose1", messages.at("payment.error.length", new Object[]{35}));
                }
            }
            if (!this.purpose2.isEmpty()) {
                if (!RegularExpressions.SEPA_GUI.matches(this.purpose2)) {
                    form = form.withError("purpose2", messages.at("payment.error.invalidcharacter", new Object[0]));
                } else if (this.purpose2.length() > 35) {
                    form = form.withError("purpose2", messages.at("payment.error.length", new Object[]{35}));
                }
            }
            if (!this.purpose3.isEmpty()) {
                if (!RegularExpressions.SEPA_GUI.matches(this.purpose3)) {
                    form = form.withError("purpose3", messages.at("payment.error.invalidcharacter", new Object[0]));
                } else if (this.purpose3.length() > 35) {
                    form = form.withError("purpose3", messages.at("payment.error.length", new Object[]{35}));
                }
            }
            StringBuilder sb = new StringBuilder();
            sb.append(this.purpose1);
            if (!this.purpose2.isEmpty() || !this.purpose3.isEmpty()) {
                while (sb.length() < 35) {
                    sb.append(" ");
                }
                sb.append(this.purpose2);
                if (!this.purpose3.isEmpty()) {
                    while (sb.length() < 70) {
                        sb.append(" ");
                    }
                    sb.append(this.purpose3);
                }
            }
            this.purpose = sb.toString();
        }
        if (this.purpose != null && !this.purpose.isEmpty()) {
            if (this.structuredPurpose) {
                if (isPurposeInISOFormat && !de.businesslogics.util.PaymentUtils.isISO11649CreditorReference((String)this.purpose)) {
                    form = form.withError("purpose", messages.at("sepapayment.paymentreference.notISO", new Object[0]));
                } else if (this.purpose.length() > 35) {
                    form = form.withError("purpose", messages.at("payment.error.length", new Object[]{35}));
                }
            } else if (!RegularExpressions.SEPA_GUI.matches(this.purpose)) {
                form = form.withError("purpose", messages.at("payment.error.invalidcharacter", new Object[0]));
            } else if (this.purpose.length() > 140) {
                form = form.withError("purpose", messages.at("payment.error.length", new Object[]{140}));
            }
        }
        if (PaymentTransferType.PmtType.AUSTRIAN_URGENT_TAX_PAYMENT != this.getPmtType() && this.purposeCode != null && !this.purposeCode.isEmpty()) {
            Object[] purposeCodes = this.isUrgent ? SEPAPurposeCode.getUrgentPaymentPurposeCodes((boolean)true) : SEPAPurposeCode.getPurposeCodes((boolean)true);
            if (this.isUrgent && Arrays.binarySearch(purposeCodes, this.purposeCode) < 0) {
                this.purposeCode = null;
                form = form.withError("purposeCode", messages.at("sepapayment.error.resetpurposecode", new Object[0]));
            }
        }
        if (!(this.instructionPriority == null || this.instructionPriority.isEmpty() || !this.isDebit && SEPAInstructionPriority.isSupported((String)this.instructionPriority))) {
            this.instructionPriority = null;
            form = form.withError("instructionPriority", messages.at("error.invalid", new Object[0]));
        }
        if (this.paymentCategory != null && !this.paymentCategory.isEmpty()) {
            Object[] paymentCategories = this.isUrgent ? SEPAPaymentCategory.getUrgentPaymentCategories((boolean)true) : SEPAPaymentCategory.getPaymentCategories((boolean)true);
            if (this.isUrgent && Arrays.binarySearch(paymentCategories, this.paymentCategory) < 0) {
                this.paymentCategory = null;
                form = form.withError("paymentCategory", messages.at("sepapayment.error.resetpaymentcategory", new Object[0]));
            }
        }
        if (this.reference != null && !this.reference.isEmpty() && !RegularExpressions.SEPA_RESTRICTED_IDENTIFICATION_1.matches(this.reference)) {
            form = form.withError("reference", messages.at("error.invalid", new Object[0]));
        }
        return form;
    }

    private Form<? extends PaymentForm> checkAddressDataLength(Form<? extends PaymentForm> form, Messages messages, String dept, String subdept, String street, String buildingnumber, String buildingname, String floor, String town, String postcode, String subcountry) {
        if (dept != null && dept.length() > 70) {
            form = form.withError(dept, messages.at("error.invalid", new Object[0]));
        }
        if (subdept != null && subdept.length() > 70) {
            form = form.withError(subdept, messages.at("error.invalid", new Object[0]));
        }
        if (street != null && street.length() > 70) {
            form = form.withError(street, messages.at("error.invalid", new Object[0]));
        }
        if (buildingnumber != null && buildingnumber.length() > 16) {
            form = form.withError(buildingnumber, messages.at("error.invalid", new Object[0]));
        }
        if (buildingname != null && buildingname.length() > 35) {
            form = form.withError(buildingname, messages.at("error.invalid", new Object[0]));
        }
        if (floor != null && floor.length() > 70) {
            form = form.withError(floor, messages.at("error.invalid", new Object[0]));
        }
        if (town != null && town.length() > 35) {
            form = form.withError(town, messages.at("error.invalid", new Object[0]));
        }
        if (postcode != null && postcode.length() > 16) {
            form = form.withError(postcode, messages.at("error.invalid", new Object[0]));
        }
        if (subcountry != null && subcountry.length() > 35) {
            form = form.withError(subcountry, messages.at("error.invalid", new Object[0]));
        }
        return form;
    }

    @Override
    protected void internalRecipientHandling(User user, PaymentHandler<?> payment, Tenant tenant) throws PaymentException {
        if (!this.isCredit() && new DatabasePreferenceStore(Preference.ApplicationId.SEPA, user).getBoolean((DatabasePreferenceConstant)PreferenceConstants.USE_MANDATE_ADMISTRATION)) {
            try {
                RecipientData recipient = payment.buildRecipient(false, null, this.getPaymentType(user), tenant, user.getTenants(), !this.createNewMandate);
                if (recipient != null) {
                    recipient.save(user, PreferenceUtil.useFourEyesForRecipientRecording((User)user));
                }
            }
            catch (IOException e) {
                throw new PaymentException("Failed to store mandate!", e);
            }
        }
    }

    @Override
    protected PaymentTransferType.PmtType getInternalPmtType() {
        if (this.paymentData == null) {
            return null;
        }
        return SepaApi.getPmtType((SEPAPaymentData)this.paymentData, this.bank == null ? null : this.bank.getCountryCode());
    }

    @Override
    protected Form<? extends PaymentForm> reloadFormInternal(FormFactory formFactory) {
        return formFactory.form(SepaPaymentForm.class).fill((Object)this);
    }

    @Override
    public void loadDefaultFormSettings(User user) {
        super.loadDefaultFormSettings(user);
        if (!this.isDebit) {
            Branding.getBranding().SEPACreditPaymentCategory(user).ifPresent(s -> {
                this.paymentCategory = s;
            });
            Branding.getBranding().SEPACreditPurposeCode(user).ifPresent(s -> {
                this.purposeCode = s;
            });
        }
    }

    protected Form<? extends PaymentForm> validateSEPASpecialisation(Form<? extends PaymentForm> form, FormFactory formFactory, Messages messages) {
        return form;
    }

    protected void loadSEPASpecialisationInfo() {
    }

    @Override
    protected FormSettings.Form getFormSettingsType() {
        if (this.isDebit) {
            return FormSettings.Form.SEPA_DEBIT_PAYMENT;
        }
        return FormSettings.Form.SEPA_CREDIT_PAYMENT;
    }

    @Override
    protected void storeRememberRecipientPreference(User user) {
        boolean useMandates = new DatabasePreferenceStore(Preference.ApplicationId.SEPA, user).getBoolean((DatabasePreferenceConstant)PreferenceConstants.USE_MANDATE_ADMISTRATION);
        if (this.isCredit() || !useMandates) {
            new DatabasePreferenceStore(Preference.ApplicationId.PAYMENTS, user).setValue((DatabasePreferenceConstant)de.businesslogics.banking.payments.core.PreferenceConstants.SAVE_RECIPIENT, this.rememberRecipient);
        }
    }

    private BicLoader.Service getService() {
        if (this.isDebit) {
            if (this.debitType == null || this.debitType.isEmpty()) {
                return BicLoader.Service.Sdd;
            }
            if (this.debitType.equals(SepaDebitType.COR1.name())) {
                return BicLoader.Service.Cor1;
            }
            if (this.debitType.equals(SepaDebitType.B2B.name())) {
                return BicLoader.Service.B2b;
            }
            return BicLoader.Service.Sdd;
        }
        return BicLoader.Service.Sct;
    }

    public void setOriginatorAddress(AddressData data) {
        if (data != null) {
            data = PaymentUtils.getFullAddressData(data.getDepartment(), data.getSubDepartment(), data.getStreetName(), data.getBuildingNumber(), data.getBuildingName(), data.getFloor(), data.getTownName(), data.getPostCode(), data.getCountrySubDivision(), data.getAddressLines(), data.getCountry());
        }
        this.originatorAddress = data;
        if (data != null) {
            this.originatorDept = data.getDepartment();
            this.originatorSubdept = data.getSubDepartment();
            this.originatorStreet = data.getStreetName();
            this.originatorBuildingnumber = data.getBuildingNumber();
            this.originatorBuildingname = data.getBuildingName();
            this.originatorFloor = data.getFloor();
            this.originatorTown = data.getTownName();
            this.originatorPostcode = data.getPostCode();
            this.originatorSubcountry = data.getCountrySubDivision();
            this.originatorCountry = this.originatorAddress.getCountry();
        }
    }

    public boolean isTownMandatoryInStructuredAddress() {
        return true;
    }

    public AddressData getOriginatorAddress() {
        this.originatorAddress = PaymentUtils.getStructuredAddressData(this.originatorDept, this.originatorSubdept, this.originatorStreet, this.originatorBuildingnumber, this.originatorBuildingname, this.originatorFloor, this.originatorTown, this.originatorPostcode, this.originatorSubcountry, this.originatorCountry);
        return this.originatorAddress;
    }

    public AddressData getRecipientAddress() {
        this.recipientAddress = PaymentUtils.getStructuredAddressData(this.recipientDept, this.recipientSubdept, this.recipientStreet, this.recipientBuildingnumber, this.recipientBuildingname, this.recipientFloor, this.recipientTown, this.recipientPostcode, this.recipientSubcountry, this.recipientCountry);
        return this.recipientAddress;
    }

    public void setRecipientAddress(AddressData data) {
        if (data != null) {
            data = PaymentUtils.getFullAddressData(data.getDepartment(), data.getSubDepartment(), data.getStreetName(), data.getBuildingNumber(), data.getBuildingName(), data.getFloor(), data.getTownName(), data.getPostCode(), data.getCountrySubDivision(), data.getAddressLines(), data.getCountry());
        }
        this.recipientAddress = data;
        if (data != null) {
            this.recipientDept = data.getDepartment();
            this.recipientSubdept = data.getSubDepartment();
            this.recipientStreet = data.getStreetName();
            this.recipientBuildingnumber = data.getBuildingNumber();
            this.recipientBuildingname = data.getBuildingName();
            this.recipientFloor = data.getFloor();
            this.recipientTown = data.getTownName();
            this.recipientPostcode = data.getPostCode();
            this.recipientSubcountry = data.getCountrySubDivision();
            this.recipientCountry = this.recipientAddress.getCountry();
        }
    }

    public AddressData getBankAddress() {
        this.bankAddress = PaymentUtils.getStructuredAddressData(this.bankDept, this.bankSubdept, this.bankStreet, this.bankBuildingnumber, this.bankBuildingname, this.bankFloor, this.bankTown, this.bankPostcode, this.bankSubcountry, this.bankCountry);
        return this.bankAddress;
    }

    public void setBankAddress(AddressData data) {
        if (data != null) {
            data = PaymentUtils.getFullAddressData(data.getDepartment(), data.getSubDepartment(), data.getStreetName(), data.getBuildingNumber(), data.getBuildingName(), data.getFloor(), data.getTownName(), data.getPostCode(), data.getCountrySubDivision(), data.getAddressLines(), data.getCountry());
        }
        this.bankAddress = data;
        if (data != null) {
            this.bankDept = data.getDepartment();
            this.bankSubdept = data.getSubDepartment();
            this.bankStreet = data.getStreetName();
            this.bankBuildingnumber = data.getBuildingNumber();
            this.bankBuildingname = data.getBuildingName();
            this.bankFloor = data.getFloor();
            this.bankTown = data.getTownName();
            this.bankPostcode = data.getPostCode();
            this.bankSubcountry = data.getCountrySubDivision();
            this.bankCountry = this.bankAddress.getCountry();
        }
    }

    public void setChequeData(ChequeInstructionData chequeData) {
        this.deliveryMethod = chequeData.getDeliveryMethod();
        this.deliveryName = chequeData.getDeliverToName();
        this.deliveryAddress = chequeData.getDeliverToAddress();
        if (this.deliveryAddress != null) {
            this.deliveryAddress = PaymentUtils.getFullAddressData(this.deliveryAddress.getDepartment(), this.deliveryAddress.getSubDepartment(), this.deliveryAddress.getStreetName(), this.deliveryAddress.getBuildingNumber(), this.deliveryAddress.getBuildingName(), this.deliveryAddress.getFloor(), this.deliveryAddress.getTownName(), this.deliveryAddress.getPostCode(), this.deliveryAddress.getCountrySubDivision(), this.deliveryAddress.getAddressLines(), this.deliveryAddress.getCountry());
            this.deliveryDept = this.deliveryAddress.getDepartment();
            this.deliverySubdept = this.deliveryAddress.getSubDepartment();
            this.deliveryStreet = this.deliveryAddress.getStreetName();
            this.deliveryBuildingnumber = this.deliveryAddress.getBuildingNumber();
            this.deliveryBuildingname = this.deliveryAddress.getBuildingName();
            this.deliveryFloor = this.deliveryAddress.getFloor();
            this.deliveryTown = this.deliveryAddress.getTownName();
            this.deliveryPostcode = this.deliveryAddress.getPostCode();
            this.deliverySubcountry = this.deliveryAddress.getCountrySubDivision();
            this.deliveryCountry = this.deliveryAddress.getCountry();
        }
        this.chktype = chequeData.getChequeType();
    }

    public ChequeInstructionData getChequeData() {
        if (!(this.deliveryMethod != null && !this.deliveryMethod.isEmpty() || this.deliveryName != null && !this.deliveryName.isEmpty() || this.deliveryCountry != null && !this.deliveryCountry.isEmpty() || this.chktype != null && !this.chktype.isEmpty())) {
            return null;
        }
        ChequeInstructionData chequeData = new ChequeInstructionData();
        if (this.chktype != null && !this.chktype.isEmpty()) {
            chequeData.setChequeType(this.chktype);
        }
        if (this.deliveryMethod != null && !this.deliveryMethod.isEmpty()) {
            chequeData.setDeliveryMethod(this.deliveryMethod);
        }
        if (this.deliveryName != null && !this.deliveryName.isEmpty()) {
            chequeData.setDeliverToName(this.deliveryName);
        }
        this.deliveryAddress = PaymentUtils.getFullAddressData(this.deliveryDept, this.deliverySubdept, this.deliveryStreet, this.deliveryBuildingnumber, this.deliveryBuildingname, this.deliveryFloor, this.deliveryTown, this.deliveryPostcode, this.deliverySubcountry, "", this.deliveryCountry);
        chequeData.setDeliverToAddress(this.deliveryAddress);
        return chequeData;
    }

    private void loadPaymentDataInfo(boolean displaySalaries, boolean allowRecipientRecording, boolean useMandates) {
        if (this.paymentData != null) {
            PaymentRecipient paymentRecipient;
            String accountCurrency = this.paymentData.getAccountCurrency() != null ? this.paymentData.getAccountCurrency().getCurrencyCode() : "EUR";
            Account originatorAccount = this.paymentData.getOriginatorBic() != null && !this.paymentData.getOriginatorBic().isEmpty() ? Account.findAccountByIbanBic((BankSettings)this.getBankFromVO(), (String)this.paymentData.getOriginatorIban(), (String)this.paymentData.getOriginatorBic(), (String)accountCurrency) : Account.findAccountByIban((BankSettings)this.getBankFromVO(), (String)this.paymentData.getOriginatorIban(), (String)accountCurrency);
            if (originatorAccount != null) {
                this.originatorAccountId = originatorAccount.getId();
            }
            this.originatorName = this.paymentData.getOriginator();
            if (this.paymentData.getOriginatorAddressData() != null) {
                this.setOriginatorAddress(this.paymentData.getOriginatorAddressData());
            }
            this.originatorAccount = IbanUtil.formatIBAN((String)this.paymentData.getOriginatorIban());
            this.originatorBankCode = this.paymentData.getOriginatorBic();
            if (allowRecipientRecording || !this.createNewMandate) {
                this.recipientName = this.paymentData.getRecipient();
            } else {
                paymentRecipient = PaymentRecipient.findRecipientByAccountInfo((PaymentType)PaymentType.MANDATE, (String)this.paymentData.getRecipient(), (String)this.paymentData.getRecipientIban(), (String)this.paymentData.getRecipientBic(), (Tenant)this.bank.getTenant());
                if (paymentRecipient == null) {
                    paymentRecipient = PaymentRecipient.findRecipientByAccountInfo((PaymentType)PaymentType.MANDATE, (String)this.paymentData.getRecipient(), (String)this.paymentData.getRecipientIban(), (String)this.paymentData.getRecipientBic(), (Tenant)this.bank.getTenant());
                }
                this.recipientName = paymentRecipient == null ? this.paymentData.getRecipient() : paymentRecipient.getDisplayName();
            }
            this.recipientAccount = IbanUtil.formatIBAN((String)this.paymentData.getRecipientIban());
            this.recipientBankCode = this.paymentData.getRecipientBic();
            this.recipientLei = this.paymentData.getRecipientLei();
            if (this.paymentData.getRecipientAddressData() != null) {
                this.setRecipientAddress(this.paymentData.getRecipientAddressData());
            }
            if (this.isSepaForeign) {
                if (this.paymentData.getRecipientClearingSystemId() != null) {
                    this.clearingSystem = this.paymentData.getRecipientClearingSystemId();
                }
                if (this.paymentData.getRecipientBankName() != null) {
                    this.recipientBank = this.paymentData.getRecipientBankName();
                }
                if (this.paymentData.getRecipientBankAddressData() != null) {
                    this.setBankAddress(this.paymentData.getRecipientBankAddressData());
                }
                if (this.paymentData.getChequeInstructionData() != null) {
                    this.setChequeData(this.paymentData.getChequeInstructionData());
                }
            }
            if (displaySalaries || !SEPAUtil.isSalaryPayment((String)this.paymentData.getPaymentCategory(), (String)this.paymentData.getPurposeCode())) {
                this.amount = this.paymentData.getAmount();
            }
            this.currency = this.paymentData.getCurrency() != null ? this.paymentData.getCurrency().getCurrencyCode() : "EUR";
            if (this.paymentData.hasStructuredPurpose()) {
                this.structuredPurpose = true;
                this.purpose = this.paymentData.getPurposeReference();
            } else {
                this.structuredPurpose = false;
                this.purpose = this.paymentData.getPurpose();
            }
            if (Branding.getBranding().doSEPAThreeLinesPurpose() && this.purpose != null) {
                this.purpose1 = this.purpose.substring(0, Math.min(35, this.purpose.length())).trim();
                if (this.purpose.length() > 35) {
                    this.purpose2 = this.purpose.substring(35, Math.min(70, this.purpose.length())).trim();
                    if (this.purpose.length() > 70) {
                        this.purpose3 = this.purpose.substring(70).trim();
                    }
                }
            }
            if (this.paymentData.getExecutionDate() != null && !NO_EXECUTION_DATE.equals(this.paymentData.getExecutionDate())) {
                this.executionDate = this.paymentData.getExecutionDate();
            }
            if (this.paymentData.getEndToEndId() != null && !this.paymentData.getEndToEndId().startsWith("TempMessageId")) {
                this.reference = this.paymentData.getEndToEndId();
            }
            if (useMandates && !this.paymentData.isCredit() && this.paymentData.getMandateId() != null && (paymentRecipient = PaymentRecipient.findSepaMandateByMandateId((String)this.paymentData.getMandateId(), (Tenant)this.bank.getTenant())) != null) {
                this.mandate = paymentRecipient.getDisplayName();
            }
            this.serviceLevel = this.paymentData.getServiceLevel();
            this.feeType = this.paymentData.getChargeBearer();
            this.creditorId = this.paymentData.getCreditorId();
            this.ultimateOriginator = this.paymentData.getUltimateOriginator();
            this.ultimateRecipient = this.paymentData.getUltimateRecipient();
            this.mandateReference = this.paymentData.getMandateId();
            this.mandateSignDate = this.paymentData.getMandateSignDate();
            this.paymentCategory = this.paymentData.getPaymentCategory();
            this.purposeCode = this.paymentData.getPurposeCode();
            this.instructionPriority = this.paymentData.getInstructionPriority();
            this.debitType = this.paymentData.getDebitType();
            this.sequenceType = this.paymentData.getSequenceType();
            this.singleBooking = this.paymentData.displayAsSingleBooking();
        }
        this.isDebit = SepaApi.isDebitPmtType((PaymentTransferType.PmtType)this.getPmtType());
        this.loadSEPASpecialisationInfo();
    }

    static {
        Calendar cal = Calendar.getInstance();
        cal.set(1, 1999);
        cal.set(2, 0);
        cal.set(5, 1);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        NO_EXECUTION_DATE = cal.getTime();
    }
}

