/*
 * Decompiled with CFR 0.152.
 */
package models;

import controllers.branding.Branding;
import controllers.util.TenantUtils;
import de.businesslogics.banking.api.BankingApiMessages;
import de.businesslogics.banking.api.DatabasePreferenceConstant;
import de.businesslogics.banking.api.DatabasePreferenceStore;
import de.businesslogics.banking.api.Logger;
import de.businesslogics.banking.database.vo.Account;
import de.businesslogics.banking.database.vo.PaymentOriginator;
import de.businesslogics.banking.database.vo.PaymentType;
import de.businesslogics.banking.database.vo.Preference;
import de.businesslogics.banking.database.vo.Tenant;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.banking.sepa.PreferenceConstants;
import de.businesslogics.banking.sepa.api.SepaOriginatorData;
import de.businesslogics.format.AddressData;
import de.businesslogics.format.sepa.SEPAUtil;
import de.businesslogics.validation.RegularExpressions;
import java.io.IOException;
import java.util.Locale;
import models.OriginatorForm;
import models.payments.PaymentUtils;
import play.data.Form;
import play.i18n.Messages;
import views.Utils;

public final class SepaOriginatorForm
extends OriginatorForm {
    public String creditorId;
    public String taxNumber;
    public String dept;
    public String subdept;
    public String street;
    public String buildingnumber;
    public String buildingname;
    public String floor;
    public String town;
    public String postcode;
    public String subcountry;
    public String country;

    public SepaOriginatorForm() {
        this.creditorId = Branding.getBranding().SEPACreditorID;
    }

    public SepaOriginatorForm(PaymentOriginator paymentOriginator) {
        SepaOriginatorData originator = new SepaOriginatorData();
        try {
            originator.setPaymentOriginator(paymentOriginator);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.name = originator.getName();
        this.tenantId = originator.getTenant().getId();
        this.creditorId = originator.getCreditorId();
        this.taxNumber = originator.getTaxNumber();
        AddressData oAddress = originator.getAddress();
        if (oAddress != null) {
            this.dept = oAddress.getDepartment();
            this.subdept = oAddress.getSubDepartment();
            this.street = oAddress.getStreetName();
            this.buildingnumber = oAddress.getBuildingNumber();
            this.buildingname = oAddress.getBuildingName();
            this.floor = oAddress.getFloor();
            this.town = oAddress.getTownName();
            this.postcode = oAddress.getPostCode();
            this.subcountry = oAddress.getCountrySubDivision();
            this.country = oAddress.getCountry();
        }
        if (paymentOriginator.getDefaultAccount() != null) {
            this.defaultAccountId = paymentOriginator.getDefaultAccount().getId();
        }
    }

    public boolean hasAddress() {
        return this.dept != null && !this.dept.isEmpty() || this.subdept != null && !this.subdept.isEmpty() || this.street != null && !this.street.isEmpty() || this.buildingnumber != null && !this.buildingnumber.isEmpty() || this.buildingname != null && !this.buildingname.isEmpty() || this.floor != null && !this.floor.isEmpty() || this.town != null && !this.town.isEmpty() || this.postcode != null && !this.postcode.isEmpty() || this.subcountry != null && !this.subcountry.isEmpty() || this.country != null && !this.country.isEmpty();
    }

    @Override
    public Form<? extends OriginatorForm> validate(Form<? extends OriginatorForm> form, User user, Messages messages, PaymentOriginator paymentOriginator) {
        String tenantError = TenantUtils.checkTenantId(this.tenantId, user);
        if (tenantError != null) {
            return form.withError("tenantId", tenantError);
        }
        this.tenant = TenantUtils.getTenantByIdAndUser(this.tenantId, user);
        String accountError = this.checkAccountId(user);
        if (accountError != null) {
            return form.withError("defaultAccountId", accountError);
        }
        if (!RegularExpressions.SEPA_GUI.matches(this.name)) {
            form = form.withError("name", messages.at("error.invalid", new Object[0]));
        } else {
            PaymentOriginator existingOriginator = PaymentOriginator.findOriginatorByName((PaymentType)PaymentType.SEPA, (String)this.name, (Tenant)this.tenant);
            if (!(existingOriginator == null || paymentOriginator != null && paymentOriginator.getId() != null && paymentOriginator.getId().equals(existingOriginator.getId()))) {
                form = form.withError("name", BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.nameAlreadyExists", (Object[])new Object[0]));
            } else if (this.name != null && this.name.length() > 70) {
                this.name = this.name.substring(0, 70);
            }
        }
        if (this.creditorId != null && this.creditorId.length() > 0 && !new DatabasePreferenceStore(Preference.ApplicationId.SEPA, user).getBoolean((DatabasePreferenceConstant)PreferenceConstants.ALLOW_INVALID_CREDITOR_ID) && !SEPAUtil.checkCreditorId((String)this.creditorId)) {
            form = form.withError("creditorId", messages.at("error.invalid", new Object[0]));
        }
        if (this.taxNumber != null && this.taxNumber.length() > 0) {
            this.taxNumber = this.taxNumber.replaceAll("[^A-Z0-9]", "");
        }
        return form;
    }

    @Override
    public void store(PaymentOriginator paymentOriginator, User user) throws IOException {
        SepaOriginatorData originatorData = new SepaOriginatorData();
        originatorData.setPaymentOriginator(paymentOriginator);
        boolean isNewOriginator = paymentOriginator.getId() == null;
        String oldName = originatorData.getName();
        boolean nameChanged = false;
        if (SepaOriginatorForm.isFieldEnabled("name", user)) {
            nameChanged = !isNewOriginator && Utils.fieldValueChanged(oldName, this.name);
            originatorData.setName(this.name);
        }
        String oldCreditorId = originatorData.getCreditorId();
        boolean creditorIdChanged = false;
        if (SepaOriginatorForm.isFieldEnabled("creditorId", user)) {
            creditorIdChanged = !isNewOriginator && Utils.fieldValueChanged(oldCreditorId, this.creditorId);
            originatorData.setCreditorId(this.creditorId);
        }
        String oldTaxNumber = originatorData.getTaxNumber();
        boolean taxNumberChanged = false;
        if (SepaOriginatorForm.isFieldEnabled("taxNumber", user)) {
            taxNumberChanged = !isNewOriginator && Utils.fieldValueChanged(oldTaxNumber, this.taxNumber);
            originatorData.setTaxNumber(this.taxNumber);
        }
        if (SepaOriginatorForm.isFieldEnabled("country", user)) {
            AddressData oAddress = PaymentUtils.getFullAddressData(this.dept, this.subdept, this.street, this.buildingnumber, this.buildingname, this.floor, this.town, this.postcode, this.subcountry, "", this.country);
            originatorData.setAddress(oAddress);
        }
        Tenant oldTenant = originatorData.getTenant();
        boolean tenantChanged = false;
        if (SepaOriginatorForm.isFieldEnabled("tenantId", user)) {
            tenantChanged = !isNewOriginator && this.tenant == null && oldTenant != null || this.tenant != null && oldTenant == null || this.tenant != null && !this.tenant.getId().equals(oldTenant.getId());
            originatorData.setTenant(this.tenant);
        }
        Account oldAccount = originatorData.getDefaultAccount();
        boolean accountChanged = false;
        if (SepaOriginatorForm.isFieldEnabled("defaultAccountId", user)) {
            accountChanged = !isNewOriginator && this.defaultAccount == null && oldAccount != null || this.defaultAccount != null && oldAccount == null || this.defaultAccount != null && !this.defaultAccount.getId().equals(oldAccount.getId());
            originatorData.setDefaultAccount(this.defaultAccount);
        }
        originatorData.save();
        if (nameChanged) {
            Logger.logOriginatorModified((User)user, (PaymentOriginator)paymentOriginator, (Logger.OriginatorField)Logger.OriginatorField.NAME, (String)oldName, (String)this.name);
        }
        if (creditorIdChanged) {
            Logger.logOriginatorModified((User)user, (PaymentOriginator)paymentOriginator, (Logger.OriginatorField)Logger.OriginatorField.CREDITOR_ID, (String)oldCreditorId, (String)this.creditorId);
        }
        if (taxNumberChanged) {
            Logger.logOriginatorModified((User)user, (PaymentOriginator)paymentOriginator, (Logger.OriginatorField)Logger.OriginatorField.TAX_NUMBER, (String)oldTaxNumber, (String)this.taxNumber);
        }
        if (tenantChanged) {
            Logger.logOriginatorModified((User)user, (PaymentOriginator)paymentOriginator, (Logger.OriginatorField)Logger.OriginatorField.TENANT_ID, (String)(oldTenant == null ? null : oldTenant.getName() + " (" + oldTenant.getId() + ")"), this.tenant == null ? null : this.tenant.getName() + " (" + this.tenant.getId() + ")");
        }
        if (accountChanged) {
            Logger.logOriginatorModified((User)user, (PaymentOriginator)paymentOriginator, (Logger.OriginatorField)Logger.OriginatorField.DEFAULT_ACCOUNT, (String)(oldAccount == null ? null : oldAccount.getName() + " (" + oldAccount.getId() + ")"), this.defaultAccount == null ? null : this.defaultAccount.getName() + " (" + this.defaultAccount.getId() + ")");
        }
    }
}

