/*
 * Decompiled with CFR 0.152.
 */
package models;

import controllers.branding.Branding;
import controllers.util.TenantUtils;
import de.businesslogics.banking.api.DatabasePreferenceConstant;
import de.businesslogics.banking.api.DatabasePreferenceStore;
import de.businesslogics.banking.api.Logger;
import de.businesslogics.banking.api.sepa.SepaDebitType;
import de.businesslogics.banking.api.sepa.SepaSequenceType;
import de.businesslogics.banking.database.vo.PaymentRecipient;
import de.businesslogics.banking.database.vo.Preference;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.banking.payments.api.PreferenceUtil;
import de.businesslogics.banking.sepa.PreferenceConstants;
import de.businesslogics.banking.sepa.api.SepaMandateData;
import de.businesslogics.format.AddressData;
import de.businesslogics.format.sepa.SEPAUtil;
import de.businesslogics.format.sepa.SepaCountry;
import de.businesslogics.iban.IbanUtil;
import de.businesslogics.validation.RegularExpressions;
import java.io.IOException;
import java.text.DateFormat;
import java.util.Date;
import models.RecipientForm;
import models.SepaRecipientForm;
import models.payments.PaymentUtils;
import play.data.Form;
import play.data.validation.Constraints;
import play.i18n.Messages;
import views.Utils;

public final class SepaMandateForm
extends SepaRecipientForm {
    @Constraints.Required
    public String creditorName;
    @Constraints.Required
    public String creditorId;
    @Constraints.Required
    public String debitType;
    public String mandateId;
    public Date signDate;
    public String sequenceType;

    public static SepaMandateForm createNew() {
        SepaMandateForm result = new SepaMandateForm();
        if (Branding.getBranding().SEPACreditorID != null) {
            result.creditorId = Branding.getBranding().SEPACreditorID;
        }
        return result;
    }

    public SepaMandateForm() {
        this.signDate = new Date();
        this.creditorId = Branding.getBranding().SEPACreditorID;
    }

    public SepaMandateForm(PaymentRecipient paymentRecipient) {
        super(paymentRecipient);
        SepaMandateData mandate = new SepaMandateData();
        try {
            mandate.setPaymentRecipient(paymentRecipient);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.mandateId = paymentRecipient.getSepaMandateId();
        this.signDate = mandate.getMandateSignDate();
        this.creditorName = mandate.getCreditor();
        this.creditorId = mandate.getCreditorId();
        if (mandate.getMandateType() != null) {
            this.debitType = mandate.getMandateType().name();
        }
        if (mandate.getSequenceType() != null) {
            this.sequenceType = mandate.getSequenceType().name();
        }
        this.country = mandate.getAddress().getCountry();
    }

    @Override
    public boolean hasAddress() {
        return this.country != null && !this.country.isEmpty();
    }

    @Override
    public Form<? extends RecipientForm> validate(Form<? extends RecipientForm> form, Messages messages, User user) {
        String recipientCountryCode;
        SepaSequenceType type;
        if (this.mandateId == null || this.mandateId.isEmpty()) {
            return form.withError("mandateId", messages.at("error.required", new Object[0]));
        }
        if (this.signDate == null) {
            return form.withError("signDate", messages.at("error.required", new Object[0]));
        }
        if (this.sequenceType == null) {
            return form.withError("sequenceType", messages.at("error.required", new Object[0]));
        }
        if (this.creditorName != null && this.creditorName.length() > 70) {
            this.creditorName = this.creditorName.substring(0, 70);
        }
        if (!RegularExpressions.SEPA_GUI.matches(this.creditorName)) {
            form = form.withError("creditorName", messages.at("error.invalid", new Object[0]));
        }
        if (!new DatabasePreferenceStore(Preference.ApplicationId.SEPA, user).getBoolean((DatabasePreferenceConstant)PreferenceConstants.ALLOW_INVALID_CREDITOR_ID) && !SEPAUtil.checkCreditorId((String)this.creditorId)) {
            form = form.withError("creditorId", messages.at("error.invalid", new Object[0]));
        }
        if (!RegularExpressions.SEPA_RESTRICTED_IDENTIFICATION_1.matches(this.mandateId) || this.mandateId.length() > 35) {
            form = form.withError("mandateId", messages.at("error.invalid", new Object[0]));
        }
        if (new Date().before(this.signDate)) {
            form = form.withError("signDate", messages.at("sepapayment.error.mandatesigndateinfuture", new Object[0]));
        }
        if (SepaDebitType.getByName((String)this.debitType) == null) {
            form = form.withError("debitType", messages.at("error.invalid", new Object[0]));
        }
        if ((type = SepaSequenceType.getByName((String)this.sequenceType)) != null && type != SepaSequenceType.OOFF && type != SepaSequenceType.RCUR) {
            form = form.withError("sequenceType", messages.at("error.invalid", new Object[0]));
        }
        if (!(this.country == null || this.country.length() <= 70 && RegularExpressions.SEPA_GUI.matches(this.country))) {
            form = form.withError("country", messages.at("error.invalid", new Object[0]));
        }
        if (SepaCountry.isDebtorAddressMandatory((String)(recipientCountryCode = IbanUtil.getCountryCode((String)this.iban))) && (this.country == null || this.country.isEmpty())) {
            form = form.withError("country", messages.at("general.mandatoryfield", new Object[0]));
        }
        form = super.validate((Form<? extends RecipientForm>)form, messages, user);
        return form;
    }

    @Override
    public void store(PaymentRecipient paymentRecipient, User user) throws IOException {
        boolean isNewMandate;
        SepaMandateData mandate = new SepaMandateData();
        mandate.setPaymentRecipient(paymentRecipient);
        boolean bl = isNewMandate = paymentRecipient.getId() == null;
        if (SepaMandateForm.isFieldEnabled("displayName", user, paymentRecipient.getId())) {
            mandate.setDisplayName(this.displayName);
        }
        String oldName = mandate.getName();
        boolean nameChanged = false;
        if (SepaMandateForm.isFieldEnabled("name", user, paymentRecipient.getId())) {
            nameChanged = !isNewMandate && Utils.fieldValueChanged(oldName, this.name);
            mandate.setName(this.name);
        }
        String oldAccNbr = mandate.getAccountNumber();
        boolean accNbrChanged = false;
        if (SepaMandateForm.isFieldEnabled("iban", user, paymentRecipient.getId())) {
            accNbrChanged = !isNewMandate && Utils.fieldValueChanged(oldAccNbr, this.iban);
            mandate.setAccountNumber(this.iban);
        }
        String oldBankCode = mandate.getBankCode();
        boolean bankCodeChanged = false;
        if (SepaMandateForm.isFieldEnabled("bic", user, paymentRecipient.getId())) {
            bankCodeChanged = !isNewMandate && Utils.fieldValueChanged(oldBankCode, this.bic);
            mandate.setBankCode(this.bic);
        }
        if (SepaMandateForm.isFieldEnabled("purpose", user, paymentRecipient.getId())) {
            mandate.setPurpose(this.purpose);
        }
        String oldCreditor = mandate.getCreditor();
        boolean creditorChanged = false;
        if (SepaMandateForm.isFieldEnabled("creditorName", user, paymentRecipient.getId())) {
            creditorChanged = !isNewMandate && Utils.fieldValueChanged(oldCreditor, this.creditorName);
            mandate.setCreditor(this.creditorName);
        }
        String oldCreditorId = mandate.getCreditorId();
        boolean creditorIdChanged = false;
        if (SepaMandateForm.isFieldEnabled("creditorId", user, paymentRecipient.getId())) {
            creditorIdChanged = !isNewMandate && Utils.fieldValueChanged(oldCreditorId, this.creditorId);
            mandate.setCreditorId(this.creditorId);
        }
        String oldMandateId = paymentRecipient.getSepaMandateId();
        boolean mandateIdChanged = false;
        if (SepaMandateForm.isFieldEnabled("mandateId", user, paymentRecipient.getId())) {
            mandateIdChanged = !isNewMandate && Utils.fieldValueChanged(oldMandateId, this.mandateId);
            paymentRecipient.setSepaMandateId(this.mandateId);
        }
        Date oldSignDate = mandate.getMandateSignDate();
        boolean signDateChanged = false;
        if (SepaMandateForm.isFieldEnabled("signDate", user, paymentRecipient.getId())) {
            signDateChanged = !isNewMandate && Utils.fieldValueChanged(oldSignDate, this.signDate);
            mandate.setMandateSignDate(this.signDate);
        }
        String oldDebitType = mandate.getMandateType() != null ? mandate.getMandateType().name() : null;
        boolean debitTypeChanged = false;
        if (SepaMandateForm.isFieldEnabled("debitType", user, paymentRecipient.getId())) {
            debitTypeChanged = !isNewMandate && Utils.fieldValueChanged(oldDebitType, this.debitType);
            mandate.setMandateType(SepaDebitType.getByName((String)this.debitType));
        }
        String oldSequenceType = mandate.getSequenceType() != null ? mandate.getSequenceType().name() : null;
        boolean sequenceTypeChanged = false;
        if (SepaMandateForm.isFieldEnabled("sequenceType", user, paymentRecipient.getId())) {
            sequenceTypeChanged = !isNewMandate && Utils.fieldValueChanged(oldSequenceType, this.sequenceType);
            mandate.setSequenceType(SepaSequenceType.getByName((String)this.sequenceType));
        }
        String oldLei = mandate.getLeiNumber();
        boolean leiChanged = false;
        if (SepaMandateForm.isFieldEnabled("leiNumber", user, paymentRecipient.getId())) {
            leiChanged = !isNewMandate && Utils.fieldValueChanged(oldLei, this.leiNumber);
            mandate.setLeiNumber(this.leiNumber);
        }
        if (SepaMandateForm.isFieldEnabled("tenantId", user, paymentRecipient.getId())) {
            mandate.setTenant(TenantUtils.getTenantByIdAndUser(this.tenantId, user));
        }
        if (SepaMandateForm.isFieldEnabled("country", user, paymentRecipient.getId())) {
            AddressData rAddress = PaymentUtils.getFullAddressData(this.recipientDept, this.recipientSubdept, this.recipientStreet, this.recipientBuildingnumber, this.recipientBuildingname, this.recipientFloor, this.recipientTown, this.recipientPostcode, this.recipientSubcountry, "", this.country);
            mandate.setAddress(rAddress);
        }
        mandate.save(user, PreferenceUtil.useFourEyesForRecipientRecording((User)user));
        if (nameChanged) {
            Logger.logSepaMandateModified((User)user, (PaymentRecipient)mandate.getPaymentRecipient(), (Logger.RecipientField)Logger.RecipientField.NAME, (String)oldName, (String)this.name);
        }
        if (accNbrChanged) {
            Logger.logSepaMandateModified((User)user, (PaymentRecipient)mandate.getPaymentRecipient(), (Logger.RecipientField)Logger.RecipientField.ACCOUNT_NUMBER, (String)oldAccNbr, (String)this.iban);
        }
        if (bankCodeChanged) {
            Logger.logSepaMandateModified((User)user, (PaymentRecipient)mandate.getPaymentRecipient(), (Logger.RecipientField)Logger.RecipientField.BANK_CODE, (String)oldBankCode, (String)this.bic);
        }
        if (creditorChanged) {
            Logger.logSepaMandateModified((User)user, (PaymentRecipient)mandate.getPaymentRecipient(), (Logger.RecipientField)Logger.RecipientField.CREDITOR_NAME, (String)oldCreditor, (String)this.creditorName);
        }
        if (creditorIdChanged) {
            Logger.logSepaMandateModified((User)user, (PaymentRecipient)mandate.getPaymentRecipient(), (Logger.RecipientField)Logger.RecipientField.CREDITOR_ID, (String)oldCreditorId, (String)this.creditorId);
        }
        if (mandateIdChanged) {
            Logger.logSepaMandateModified((User)user, (PaymentRecipient)mandate.getPaymentRecipient(), (Logger.RecipientField)Logger.RecipientField.MANDATE_ID, (String)oldMandateId, (String)this.mandateId);
        }
        if (signDateChanged) {
            Logger.logSepaMandateModified((User)user, (PaymentRecipient)mandate.getPaymentRecipient(), (Logger.RecipientField)Logger.RecipientField.MANDATE_SIGN_DATE, (String)DateFormat.getDateInstance(2).format(oldSignDate), (String)DateFormat.getDateInstance(2).format(this.signDate));
        }
        if (debitTypeChanged) {
            Logger.logSepaMandateModified((User)user, (PaymentRecipient)mandate.getPaymentRecipient(), (Logger.RecipientField)Logger.RecipientField.DEBIT_TYPE, (String)oldDebitType, (String)this.debitType);
        }
        if (sequenceTypeChanged) {
            Logger.logSepaMandateModified((User)user, (PaymentRecipient)mandate.getPaymentRecipient(), (Logger.RecipientField)Logger.RecipientField.SEQUENCE_TYPE, (String)oldSequenceType, (String)this.sequenceType);
        }
        if (leiChanged) {
            Logger.logSepaMandateModified((User)user, (PaymentRecipient)mandate.getPaymentRecipient(), (Logger.RecipientField)Logger.RecipientField.LEI_NUMBER, (String)oldLei, (String)this.leiNumber);
        }
    }
}

