/*
 * Decompiled with CFR 0.152.
 */
package models;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import controllers.routes;
import controllers.util.TenantUtils;
import de.businesslogics.banking.database.vo.PaymentRecipient;
import de.businesslogics.banking.database.vo.SclDirectory;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.banking.payments.api.BicLoader;
import de.businesslogics.banking.payments.api.PreferenceUtil;
import de.businesslogics.banking.sepa.api.SepaForeignRecipientData;
import de.businesslogics.format.AddressData;
import de.businesslogics.iban.IbanUtil;
import de.businesslogics.validation.RegularExpressions;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import models.RecipientForm;
import models.SepaRecipientForm;
import models.payments.PaymentUtils;
import play.data.Form;
import play.i18n.Messages;
import play.libs.Json;

public class SepaForeignRecipientForm
extends SepaRecipientForm {
    public String bankDept;
    public String bankSubdept;
    public String bankStreet;
    public String bankBuildingnumber;
    public String bankBuildingname;
    public String bankFloor;
    public String bankTown;
    public String bankPostcode;
    public String bankSubcountry;
    public String bankCountry = "";
    public String recipientDept;
    public String recipientSubdept;
    public String recipientStreet;
    public String recipientBuildingnumber;
    public String recipientBuildingname;
    public String recipientFloor;
    public String recipientTown;
    public String recipientPostcode;
    public String recipientSubcountry;
    public String country = "";
    public String clearingSystem;
    public String feeType;
    public String leiNumber;
    public String bic;
    public String bank;
    public String purpose;

    public static String loadJsParameters() {
        ObjectNode resultJson = Json.newObject();
        resultJson.put("bicSearchUrl", routes.Payments.findBics("SEARCH", BicLoader.Service.Sct.name()).toString());
        return Base64.getEncoder().encodeToString(Json.asciiStringify((JsonNode)resultJson).getBytes(StandardCharsets.US_ASCII));
    }

    public SepaForeignRecipientForm() {
    }

    public SepaForeignRecipientForm(PaymentRecipient paymentRecipient) {
        AddressData bAddress;
        SepaForeignRecipientData recipient = new SepaForeignRecipientData();
        try {
            recipient.setPaymentRecipient(paymentRecipient);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.id = paymentRecipient.getId();
        this.displayName = recipient.getDisplayName();
        this.name = recipient.getName();
        this.tenantId = recipient.getTenant().getId();
        this.iban = IbanUtil.formatIBAN((String)recipient.getAccountNumber());
        this.clearingSystem = recipient.getClearingSystemId();
        this.bic = recipient.getBankCode();
        this.bank = recipient.getBankName();
        this.purpose = recipient.getPurpose();
        AddressData rAddress = recipient.getAddress();
        if (rAddress != null) {
            this.recipientDept = rAddress.getDepartment();
            this.recipientSubdept = rAddress.getSubDepartment();
            this.recipientStreet = rAddress.getStreetName();
            this.recipientBuildingnumber = rAddress.getBuildingNumber();
            this.recipientBuildingname = rAddress.getBuildingName();
            this.recipientFloor = rAddress.getFloor();
            this.recipientTown = rAddress.getTownName();
            this.recipientPostcode = rAddress.getPostCode();
            this.recipientSubcountry = rAddress.getCountrySubDivision();
            this.country = rAddress.getCountry();
        }
        if ((bAddress = recipient.getBankAddress()) != null) {
            this.bankDept = bAddress.getDepartment();
            this.bankSubdept = bAddress.getSubDepartment();
            this.bankStreet = bAddress.getStreetName();
            this.bankBuildingnumber = bAddress.getBuildingNumber();
            this.bankBuildingname = bAddress.getBuildingName();
            this.bankFloor = bAddress.getFloor();
            this.bankTown = bAddress.getTownName();
            this.bankPostcode = bAddress.getPostCode();
            this.bankSubcountry = bAddress.getCountrySubDivision();
            this.bankCountry = bAddress.getCountry();
        }
        this.feeType = recipient.getFeeType();
        this.leiNumber = recipient.getLeiNumber();
    }

    @Override
    public boolean hasBankAddress() {
        return this.bankDept != null && !this.bankDept.isEmpty() || this.bankSubdept != null && !this.bankSubdept.isEmpty() || this.bankStreet != null && !this.bankStreet.isEmpty() || this.bankBuildingnumber != null && !this.bankBuildingnumber.isEmpty() || this.bankBuildingname != null && !this.bankBuildingname.isEmpty() || this.bankFloor != null && !this.bankFloor.isEmpty() || this.bankTown != null && !this.bankTown.isEmpty() || this.bankPostcode != null && !this.bankPostcode.isEmpty() || this.bankSubcountry != null && !this.bankSubcountry.isEmpty() || this.bankCountry != null && !this.bankCountry.isEmpty();
    }

    @Override
    public Form<? extends RecipientForm> validate(Form<? extends RecipientForm> form, Messages messages, User user) {
        String tenantError = TenantUtils.checkTenantId(this.tenantId, user);
        if (tenantError != null) {
            form = form.withError("tenantId", tenantError);
        }
        if (this.name != null && this.name.length() > 70) {
            this.name = this.name.substring(0, 70);
        }
        if (this.purpose != null && this.purpose.length() > 140) {
            this.purpose = this.purpose.substring(0, 140);
        }
        if (!RegularExpressions.SEPA_GUI.matches(this.name)) {
            form = form.withError("name", messages.at("error.invalid", new Object[0]));
        }
        if (this.purpose != null && !RegularExpressions.SEPA_GUI.matches(this.purpose)) {
            form = form.withError("purpose", messages.at("error.invalid", new Object[0]));
        }
        if (this.leiNumber != null && !this.leiNumber.isEmpty() && !RegularExpressions.SEPA_LEI.matches(this.leiNumber)) {
            form = form.withError("leiNumber", messages.at("error.invalid", new Object[0]));
        }
        return form;
    }

    @Override
    public void store(PaymentRecipient paymentRecipient, User user) throws IOException {
        SclDirectory sclDirectory;
        SepaForeignRecipientData recipientData = new SepaForeignRecipientData();
        recipientData.setPaymentRecipient(paymentRecipient);
        recipientData.setDisplayName(this.displayName);
        recipientData.setName(this.name);
        this.iban = this.iban.replaceAll(" ", "").trim();
        recipientData.setAccountNumber(this.iban);
        recipientData.setBankCode(this.bic);
        if (this.bic != null && (sclDirectory = SclDirectory.getForBIC((String)this.bic)) != null) {
            recipientData.setBankName(sclDirectory.getName());
        }
        if (this.clearingSystem != null && !this.clearingSystem.equals("bic")) {
            recipientData.setClearingSystemId(this.clearingSystem);
        } else {
            recipientData.setClearingSystemId(null);
        }
        recipientData.setPurpose(this.purpose);
        AddressData rAddress = PaymentUtils.getFullAddressData(this.recipientDept, this.recipientSubdept, this.recipientStreet, this.recipientBuildingnumber, this.recipientBuildingname, this.recipientFloor, this.recipientTown, this.recipientPostcode, this.recipientSubcountry, "", this.country);
        recipientData.setAddress(rAddress);
        AddressData bAddress = PaymentUtils.getFullAddressData(this.bankDept, this.bankSubdept, this.bankStreet, this.bankBuildingnumber, this.bankBuildingname, this.bankFloor, this.bankTown, this.bankPostcode, this.bankSubcountry, "", this.bankCountry);
        recipientData.setBankAddress(bAddress);
        recipientData.setBankName(this.bank);
        recipientData.setFeeType(this.feeType);
        recipientData.setLeiNumber(this.leiNumber);
        recipientData.setTenant(TenantUtils.getTenantByIdAndUser(this.tenantId, user));
        recipientData.save(user, PreferenceUtil.useFourEyesForRecipientRecording((User)user));
    }
}

