/*
 * Decompiled with CFR 0.152.
 */
package models;

import de.businesslogics.banking.database.vo.Tenant;
import de.businesslogics.banking.database.vo.User;
import java.util.ArrayList;
import play.libs.Scala;
import scala.Tuple2;
import scala.collection.immutable.Seq;

public final class SendLogsForm {
    public String comment;
    public String callMe;
    public String mailMe;
    public boolean acceptPrivacyPolicy = false;
    public String category;

    public static Seq<Tuple2<String, String>> categoryOptions() {
        ArrayList<Tuple2> toReturn = new ArrayList<Tuple2>();
        toReturn.add(new Tuple2((Object)"Zahlung(en) nicht ausf\u00fchrbar", (Object)"sendlogs.categories.paymentNotExecutable"));
        toReturn.add(new Tuple2((Object)"Upload fehlgeschlagen", (Object)"sendlogs.categories.uploadFailed"));
        toReturn.add(new Tuple2((Object)"Zahlung(en) f\u00fcr Unterschrift nicht sichtbar", (Object)"sendlogs.categories.paymentNotVisible"));
        toReturn.add(new Tuple2((Object)"BIC-Code fehlerhaft", (Object)"sendlogs.categories.incorrectBIC"));
        toReturn.add(new Tuple2((Object)"Sonstiges", (Object)"sendlogs.categories.miscellaneous"));
        return Scala.toSeq(toReturn);
    }

    public String buildMessage(User user) {
        StringBuilder message = new StringBuilder();
        if (this.comment != null && this.comment.length() > 0) {
            message.append(this.comment);
        }
        if (this.category != null && this.category.length() > 0) {
            message.append("\nCATEGORY: ").append(this.category);
        }
        if (this.callMe != null && this.callMe.length() > 0) {
            message.append("\nCALL ME: ").append(this.callMe);
        }
        if (this.mailMe != null && this.mailMe.length() > 0) {
            message.append("\nMAIL ME: ").append(this.mailMe);
        }
        if (user != null) {
            message.append("\nUSERNAME: ").append(user.getName());
            message.append("\nTENANTS: ");
            boolean first = true;
            for (Tenant t : user.getTenants()) {
                message.append(first ? "" : ", ");
                message.append(t.getName());
                first = false;
            }
        }
        return message.toString();
    }
}

