/*
 * Decompiled with CFR 0.152.
 */
package models;

import controllers.branding.Branding;
import de.businesslogics.banking.database.vo.Account;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.database.vo.DsOrderDetails;
import de.businesslogics.banking.database.vo.FilterComparator;
import de.businesslogics.banking.database.vo.PaymentTransferType;
import de.businesslogics.banking.database.vo.SendFilter;
import de.businesslogics.banking.database.vo.User;
import java.math.BigDecimal;
import java.sql.Date;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import models.payments.PaymentUtils;
import play.data.Form;
import play.libs.Scala;
import scala.Tuple2;
import scala.collection.immutable.Seq;
import views.Utils;

public final class SendFilterForm {
    public Integer bank;
    public Integer account;
    public Integer orderTypeComparator;
    public String orderType;
    public Integer orderNumberComparator;
    public String orderNumber;
    public String state;
    public Integer dateComparator;
    public java.util.Date dateFrom;
    public java.util.Date dateTo;
    public Integer amountComparator;
    public Boolean isSigned;
    public String sender;
    public Integer senderComparator;
    public BigDecimal amountFrom;
    public BigDecimal amountTo;
    public String filterPmtType;
    PaymentTransferType.PmtType pmtType;
    public Integer filterPmtTypeComparator;

    public static Map<String, Seq<Tuple2<String, String>>> getAccountsSeq(String username, List<String> bankIds) {
        ArrayList<Tuple2> list;
        List<Account> accounts2 = PaymentUtils.getAccounts(username, null, null, true);
        accounts2.sort((a1, a2) -> {
            int b = a1.getBank().getDisplayName().compareTo(a2.getBank().getDisplayName());
            if (b != 0) {
                return b;
            }
            return a1.getName().compareTo(a2.getName());
        });
        HashMap result = new HashMap();
        for (String id : bankIds) {
            list = new ArrayList<Tuple2>();
            list.add(Scala.Tuple((Object)"-1", (Object)""));
            result.put(id, list);
        }
        list = (ArrayList<Tuple2>)result.get(bankIds.get(0));
        for (Account account : accounts2) {
            Object accountDisplayName = Account.getDefaultDisplayName((Account)account);
            accountDisplayName = (String)accountDisplayName + Branding.getBranding().getAccountSuffix(account);
            Tuple2 tuple = Scala.Tuple((Object)String.valueOf(account.getId()), (Object)Utils.addZWNJ((String)accountDisplayName));
            list.add(tuple);
            ((List)result.get(String.valueOf(account.getBank().getBankId()))).add(tuple);
        }
        return result.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> Scala.toSeq((List)((List)e.getValue()))));
    }

    public SendFilterForm() {
    }

    public SendFilterForm(SendFilter sendFilter, boolean ds) {
        Account a;
        BankSettings b;
        User user = sendFilter.getUser();
        if (sendFilter.getBank() != null && (b = BankSettings.getByIdAndUser((Integer)sendFilter.getBank().getBankId(), (User)user)) != null) {
            this.bank = b.getBankId();
        }
        if (sendFilter.getAccount() != null && (a = Account.findAccountByIdAndUser((int)sendFilter.getAccount().getId(), (User)user, (boolean)true)) != null && (sendFilter.getBank() == null || a.getBank().equals(sendFilter.getBank()))) {
            this.account = a.getId();
        }
        if (sendFilter.getPmtTypeComparator() != null) {
            this.filterPmtTypeComparator = sendFilter.getPmtTypeComparator().ordinal();
        }
        if (sendFilter.getPmtType() != null) {
            this.filterPmtType = sendFilter.getPmtType().name();
        }
        if (sendFilter.getOrderTypeComparator() != null) {
            this.orderTypeComparator = sendFilter.getOrderTypeComparator().ordinal();
        }
        this.orderType = sendFilter.getOrderType();
        if (sendFilter.getOrderNumberComparator() != null) {
            this.orderNumberComparator = sendFilter.getOrderNumberComparator().ordinal();
        }
        this.orderNumber = sendFilter.getOrderNumber();
        if (ds) {
            if (sendFilter.getDsState() != null) {
                this.state = sendFilter.getDsState().name();
            }
        } else if (sendFilter.getSendState() != null) {
            this.state = sendFilter.getSendState().name();
        }
        this.dateComparator = sendFilter.getDateComparatorIndex();
        if (this.dateComparator < 0) {
            this.dateComparator = null;
        }
        this.dateFrom = sendFilter.getFromDate();
        this.dateTo = sendFilter.getToDate();
        this.amountComparator = sendFilter.getAmountComparatorIndex();
        if (this.amountComparator < 0) {
            this.amountComparator = null;
            this.amountFrom = null;
            this.amountTo = null;
        } else {
            this.amountFrom = sendFilter.getFromAmount();
            this.amountTo = sendFilter.getToAmount();
        }
        this.isSigned = sendFilter.getDsOverviewSigned();
        this.sender = sendFilter.getSender();
        if (sendFilter.getSenderComparator() != null) {
            this.senderComparator = sendFilter.getSenderComparator().ordinal();
        }
    }

    public Form<SendFilterForm> validate(Form<SendFilterForm> form, SendFilter sendFilter, boolean ds) {
        User user = sendFilter.getUser();
        if (this.bank == null || this.bank < 0) {
            sendFilter.setBank(null);
        } else {
            BankSettings b = BankSettings.getByIdAndUser((Integer)this.bank, (User)user);
            if (b != null) {
                sendFilter.setBank(b);
            } else {
                form = form.withError("bank", "error.invalid");
            }
        }
        if (this.account == null || this.account < 0) {
            sendFilter.setAccount(null);
        } else {
            Account a = Account.findAccountByIdAndUser((int)this.account, (User)user, (boolean)true);
            if (a != null) {
                if (sendFilter.getBank() == null || a.getBank().equals(sendFilter.getBank())) {
                    sendFilter.setAccount(a);
                } else {
                    form = form.withError("account", "sendfilterform.error.accountbankmatch");
                }
            } else {
                form = form.withError("account", "error.invalid");
            }
        }
        if (this.filterPmtTypeComparator != null) {
            sendFilter.setPmtTypeComparator(this.filterPmtTypeComparator.intValue());
        } else {
            sendFilter.setPmtTypeComparator(0);
        }
        if (this.filterPmtType != null && !this.filterPmtType.isEmpty()) {
            this.pmtType = PaymentTransferType.PmtType.valueOf((String)this.filterPmtType);
            sendFilter.setPmtType(this.pmtType);
        } else {
            sendFilter.setPmtType(null);
        }
        if (this.orderTypeComparator != null) {
            sendFilter.setOrderTypeComparator(this.orderTypeComparator.intValue());
        } else {
            sendFilter.setOrderTypeComparator(0);
        }
        sendFilter.setOrderType(this.orderType);
        if (this.orderNumberComparator != null) {
            sendFilter.setOrderNumberComparator(this.orderNumberComparator.intValue());
        } else {
            sendFilter.setOrderNumberComparator(0);
        }
        sendFilter.setOrderNumber(this.orderNumber);
        if (this.state == null || this.state.isEmpty()) {
            if (ds) {
                sendFilter.setDsState(null);
            } else {
                sendFilter.setSendState(null);
            }
        } else {
            try {
                if (ds) {
                    stateVal = DsOrderDetails.State.valueOf((String)this.state);
                    sendFilter.setDsState(stateVal);
                } else {
                    stateVal = SendFilter.State.valueOf((String)this.state);
                    sendFilter.setSendState((SendFilter.State)stateVal);
                }
            }
            catch (IllegalArgumentException e) {
                form = form.withError("state", "error.invalid");
            }
        }
        if (this.dateComparator == null || this.dateComparator < 0) {
            sendFilter.setDateComparator(null);
            sendFilter.setFromDate(null);
            sendFilter.setToDate(null);
            this.dateFrom = null;
            this.dateTo = null;
        } else {
            sendFilter.setDateComparatorIndex(this.dateComparator.intValue());
            if (sendFilter.getDateComparator() == FilterComparator.Date.BETWEEN) {
                if (this.dateFrom == null && this.dateTo == null) {
                    sendFilter.setFromDate(null);
                    sendFilter.setToDate(null);
                    sendFilter.setDateComparator(null);
                } else {
                    if (this.dateFrom == null) {
                        sendFilter.setFromDate(null);
                    } else {
                        sendFilter.setFromDate(new Date(this.dateFrom.getTime()));
                    }
                    if (this.dateTo == null) {
                        sendFilter.setDateComparator(FilterComparator.Date.GREATER);
                        sendFilter.setToDate(null);
                    } else if (this.dateFrom == null) {
                        sendFilter.setDateComparator(FilterComparator.Date.LESS);
                        sendFilter.setFromDate(new Date(this.dateTo.getTime()));
                    } else {
                        sendFilter.setToDate(new Date(this.dateTo.getTime()));
                    }
                }
            } else {
                if (this.dateFrom == null) {
                    form = form.withError("dateFrom", "error.invalid");
                    sendFilter.setFromDate(null);
                } else {
                    sendFilter.setFromDate(new Date(this.dateFrom.getTime()));
                }
                sendFilter.setToDate(null);
            }
        }
        if (this.amountComparator == null || this.amountFrom == null && this.amountTo == null) {
            sendFilter.setAmountComparator(null);
            sendFilter.setFromAmount(null);
            sendFilter.setToAmount(null);
        } else {
            sendFilter.setAmountComparatorIndex(this.amountComparator.intValue());
            if (sendFilter.getAmountComparator() == null) {
                form = form.withError("amountComparator", "error.invalid");
            }
            if (sendFilter.getAmountComparator() == FilterComparator.Amount.BETWEEN) {
                if (this.amountFrom == null) {
                    sendFilter.setFromAmount(this.amountTo);
                    sendFilter.setAmountComparator(FilterComparator.Amount.LESS);
                } else if (this.amountTo == null) {
                    sendFilter.setFromAmount(this.amountFrom);
                    sendFilter.setAmountComparator(FilterComparator.Amount.GREATER);
                } else {
                    sendFilter.setFromAmount(this.amountFrom);
                    sendFilter.setToAmount(this.amountTo);
                }
            } else {
                if (this.amountFrom == null) {
                    sendFilter.setAmountComparator(null);
                }
                sendFilter.setFromAmount(this.amountFrom);
                sendFilter.setToAmount(null);
            }
        }
        sendFilter.setDsOverviewSigned(this.isSigned);
        sendFilter.setSender(this.sender);
        if (this.senderComparator != null) {
            sendFilter.setSenderComparator(this.senderComparator.intValue());
        } else {
            sendFilter.setSenderComparator(0);
        }
        return form;
    }
}

