/*
 * Decompiled with CFR 0.152.
 */
package models;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import controllers.branding.Branding;
import controllers.routes;
import controllers.util.BLLoggerPlay;
import controllers.util.GeneralUtils;
import de.businesslogics.banking.api.BankUtils;
import de.businesslogics.banking.api.sepa.SepaSchemeHandler;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.database.vo.BankUser;
import de.businesslogics.banking.database.vo.ConverterFormat;
import de.businesslogics.banking.database.vo.PaymentTransferType;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.banking.dta.api.DtazvApi;
import de.businesslogics.banking.dta.api.DtazvPaymentConversionHandler;
import de.businesslogics.banking.mt101.api.MT101Api;
import de.businesslogics.banking.mt101.api.MT101PaymentConversionHandler;
import de.businesslogics.banking.payments.api.PaymentConversionHandler;
import de.businesslogics.banking.payments.api.PaymentConversionHandler2;
import de.businesslogics.banking.sepa.api.SepaApi;
import de.businesslogics.banking.sepa.api.SepaPaymentConversionHandler2;
import de.businesslogics.ebics.client.BTFTranslator;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import play.data.Form;
import play.i18n.Messages;
import play.libs.Json;
import play.libs.Scala;
import scala.Tuple2;
import scala.collection.immutable.Seq;

public final class SendFileForm {
    public static final String FILE_TYPE_GENERAL = "GENERAL_FILE";
    public static final String FILE_TYPE_SEPA = "SEPA_FILE";
    public static final String FILE_TYPE_CSV = "CSV_FILE";
    public String sendFileType;
    public Integer bankId;
    public String orderOrFileType;
    public String pmtTypeName;
    public String encoding;
    private BankUser bankUser;
    private PaymentConversionHandler<?> paymentConversionHandler;
    private PaymentConversionHandler2<?> paymentConversionHandler2;
    private ConverterFormat converterFormat;

    public static Seq<Tuple2<String, String>> getFileFormatTypes(Messages messages, User user) {
        ArrayList<Tuple2> result = new ArrayList<Tuple2>();
        boolean onlyCSV = Branding.getBranding().allowOnlyCSVForSending(user);
        if (!onlyCSV) {
            result.add(Scala.Tuple((Object)FILE_TYPE_SEPA, (Object)messages.at("sent.filetype.sepa", new Object[0])));
        }
        result.add(Scala.Tuple((Object)FILE_TYPE_CSV, (Object)messages.at("sent.filetype.csv", new Object[0])));
        if (!onlyCSV) {
            result.add(Scala.Tuple((Object)FILE_TYPE_GENERAL, (Object)messages.at("sent.filetype.general", new Object[0])));
        }
        return Scala.toSeq(result);
    }

    public static String loadJsParameters(User user) {
        ObjectNode resultJson = Json.newObject();
        ArrayNode ebics3BanksNode = resultJson.putArray("ebics3Banks");
        Seq<Tuple2<String, String>> readyEbics3Banks = GeneralUtils.getReadyBanks(user.getName(), false, true);
        readyEbics3Banks.foreach(v2 -> ebics3BanksNode.add((String)v2._1));
        return Base64.getEncoder().encodeToString(Json.asciiStringify((JsonNode)resultJson).getBytes(StandardCharsets.US_ASCII));
    }

    public static String loadBtfModalJsParameters(String btfModalHtmlID, String btfTextFieldHtmlID, String btfButtonHtmlID) {
        ObjectNode resultJson = Json.newObject();
        resultJson.put("createBtfStringUrl", routes.BtfUtils.mergeBtfString("SERVICE_NAME", "SERVICE_OPTION", "SCOPE", "CONTAINER", "MESSAGE", "VARIANT", "VERSION", "FORMAT", "false").toString());
        resultJson.put("splitBtfStringUrl", routes.BtfUtils.splitBtfString("BTF_STRING", "PMT_TYPE_NAME", -1).toString());
        resultJson.put("modalHtmlID", btfModalHtmlID);
        ArrayNode pmtTypesNode = resultJson.putArray("btfElements");
        ObjectNode btfElement = pmtTypesNode.addObject();
        btfElement.put("textFieldHtmlID", btfTextFieldHtmlID);
        btfElement.put("buttonHtmlID", btfButtonHtmlID);
        return Base64.getEncoder().encodeToString(Json.asciiStringify((JsonNode)resultJson).getBytes(StandardCharsets.US_ASCII));
    }

    public Form<SendFileForm> validate(Form<SendFileForm> form, User user, List<File> files, List<String> originalFileNames) {
        if (files.isEmpty()) {
            form = form.withError("send_order_file", "error.required");
        }
        for (String originalFileName : originalFileNames) {
            if (GeneralUtils.checkUploadFile(originalFileName, this.isCSVPaymentFile())) continue;
            form = form.withError("send_order_file", "general.upload.error.insecure");
            return form;
        }
        if (this.isSepaFile()) {
            return form;
        }
        if (this.bankId == null) {
            form = form.withError("bankId", "error.required");
        }
        boolean isFrenchBank = false;
        BankSettings bank = null;
        if (this.bankId != null) {
            bank = BankSettings.getById((Integer)this.bankId);
            if (bank == null) {
                form = form.withError("bankId", "fetched.fetch.error.nobank");
            } else {
                this.bankUser = BankUser.findBankUser((BankSettings)bank, (User)user);
                if (this.bankUser == null || this.bankUser.getState() != BankUser.UserState.READY) {
                    form = form.withError("bankId", "fetched.fetch.error.nobankaccess");
                }
                isFrenchBank = bank.isFrenchBank();
            }
        }
        if (this.isCSVPaymentFile()) {
            if (files.size() > 1) {
                form = form.withError("send_order_file", "sent.send.error.onlyonefile");
            }
            if (this.pmtTypeName == null || this.pmtTypeName.isEmpty()) {
                form = form.withError("pmtTypeName", "error.required");
            } else {
                try {
                    PaymentTransferType.PmtType.valueOf((String)this.pmtTypeName);
                }
                catch (IllegalArgumentException e) {
                    form = form.withError("pmtTypeName", "payment.error.unknownpaymenttype", Collections.singletonList(this.pmtTypeName));
                }
            }
        } else if (this.orderOrFileType == null || this.orderOrFileType.isEmpty()) {
            form = form.withError("orderOrFileType", "error.required");
        } else if (bank != null && BankUtils.isProtocolH005OrNewer((String)bank.getProtocolVersion())) {
            if (!this.orderOrFileType.matches("[A-Z0-9]{3}") && !BTFTranslator.isBTFString((String)this.orderOrFileType)) {
                form = form.withError("orderOrFileType", "fetched.fetch.error.invalidordertype");
            }
        } else if (!isFrenchBank && !this.orderOrFileType.matches("[A-Z0-9]{3}")) {
            form = form.withError("orderOrFileType", "fetched.fetch.error.invalidordertype");
        }
        return form;
    }

    public BankUser getBankUser() {
        return this.bankUser;
    }

    public void prepareForCsv(File file2, User user) {
        PaymentTransferType.PmtType pmtType = PaymentTransferType.PmtType.valueOf((String)this.pmtTypeName);
        BankSettings bank = null;
        if (this.bankId != null && this.bankId >= 0) {
            bank = BankSettings.getByIdAndUser((Integer)this.bankId, (User)user);
        }
        if (SepaApi.isForeignPayment((PaymentTransferType.PmtType)pmtType)) {
            this.paymentConversionHandler2 = new SepaPaymentConversionHandler2(SepaSchemeHandler.getSepaVersion((BankSettings)bank, (PaymentTransferType.PmtType)pmtType), ConverterFormat.Type.PAIN_001_INTERNATIONAL, BLLoggerPlay.getLogger(), file2);
        } else if (SepaApi.isCreditPmtType((PaymentTransferType.PmtType)pmtType)) {
            this.paymentConversionHandler2 = new SepaPaymentConversionHandler2(SepaSchemeHandler.getSepaVersion((BankSettings)bank, (PaymentTransferType.PmtType)pmtType), ConverterFormat.Type.SEPA_CREDIT, BLLoggerPlay.getLogger(), file2);
        } else if (SepaApi.isDebitPmtType((PaymentTransferType.PmtType)pmtType)) {
            this.paymentConversionHandler2 = new SepaPaymentConversionHandler2(SepaSchemeHandler.getSepaVersion((BankSettings)bank, (PaymentTransferType.PmtType)pmtType), ConverterFormat.Type.SEPA_DEBIT, BLLoggerPlay.getLogger(), file2);
        } else if (DtazvApi.isDtazvPmtType((PaymentTransferType.PmtType)pmtType)) {
            this.paymentConversionHandler = new DtazvPaymentConversionHandler(BLLoggerPlay.getLogger(), file2);
        } else if (MT101Api.isMt101PmtType((PaymentTransferType.PmtType)pmtType)) {
            this.paymentConversionHandler2 = new MT101PaymentConversionHandler(BLLoggerPlay.getLogger(), file2);
        }
        if (this.paymentConversionHandler != null && this.paymentConversionHandler.canHandle()) {
            this.converterFormat = this.paymentConversionHandler.getConverterFormat(user);
        } else if (this.paymentConversionHandler2.canHandle()) {
            this.converterFormat = this.paymentConversionHandler2.getConverterFormat(user);
        }
    }

    public PaymentConversionHandler<?> getPaymentConversionHandler() {
        return this.paymentConversionHandler;
    }

    public PaymentConversionHandler2<?> getPaymentConversionHandler2() {
        return this.paymentConversionHandler2;
    }

    public ConverterFormat getConverterFormat() {
        return this.converterFormat;
    }

    public boolean isSepaFile() {
        return FILE_TYPE_SEPA.equals(this.sendFileType);
    }

    public boolean isCSVPaymentFile() {
        return FILE_TYPE_CSV.equals(this.sendFileType);
    }
}

