/*
 * Decompiled with CFR 0.152.
 */
package models;

import controllers.FetchSchedule;
import controllers.Setup;
import controllers.util.FileExportPostProcessing;
import controllers.util.GeneralUtils;
import de.businesslogics.banking.api.BankUtils;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.database.vo.BankUser;
import de.businesslogics.banking.database.vo.Scheduler;
import de.businesslogics.banking.database.vo.Tenant;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.banking.transfer.api.FreePreScheduler;
import de.businesslogics.ebics.client.BTFTranslator;
import java.text.DateFormatSymbols;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import play.data.Form;
import play.data.validation.Constraints;
import play.i18n.Messages;
import play.libs.Scala;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.Seq;

public final class SchedulerForm {
    public static final String NO_PATTERN = "noPattern";
    public static final String INCORRECT_PATTERN = "incorrectPattern";
    private static final int DAILY_HOURS_DEFAULT = 6;
    private static final int DAILY_MINS_DEFAULT = 0;
    private static final int START_HOURS_DEFAULT = 6;
    private static final int END_HOURS_DEFAULT = 17;
    private static final int INTERVAL_DEFAULT = 60;
    @Constraints.Required
    public Integer bankId;
    public Map<Integer, Integer> user;
    @Constraints.Required
    public String schedulerType;
    public String orderType;
    public String fromToFetch = String.valueOf(false);
    public int fromDate = 0;
    public int toDate = 0;
    public String exportDir;
    public boolean monday;
    public boolean tuesday;
    public boolean wednesday;
    public boolean thursday;
    public boolean friday;
    public boolean saturday;
    public boolean sunday;
    public boolean onceADay;
    public Integer dailyHours;
    public Integer dailyMins;
    public Integer startHours;
    public Integer endHours;
    public Integer interval;
    public Integer weekOrMonth;
    public boolean day1;
    public boolean day2;
    public boolean day3;
    public boolean day4;
    public boolean day5;
    public boolean day6;
    public boolean day7;
    public boolean day8;
    public boolean day9;
    public boolean day10;
    public boolean day11;
    public boolean day12;
    public boolean day13;
    public boolean day14;
    public boolean day15;
    public boolean day16;
    public boolean day17;
    public boolean day18;
    public boolean day19;
    public boolean day20;
    public boolean day21;
    public boolean day22;
    public boolean day23;
    public boolean day24;
    public boolean day25;
    public boolean day26;
    public boolean day27;
    public boolean day28;
    public boolean day29;
    public boolean day30;
    public boolean day31;
    public boolean month1;
    public boolean month2;
    public boolean month3;
    public boolean month4;
    public boolean month5;
    public boolean month6;
    public boolean month7;
    public boolean month8;
    public boolean month9;
    public boolean month10;
    public boolean month11;
    public boolean month12;

    public static Seq<Tuple2<String, String>> getSelectableBanks(User loggedInUser) {
        if (loggedInUser.isAdmin()) {
            return GeneralUtils.getAllBanks(loggedInUser.getName(), false);
        }
        return GeneralUtils.getKeyBanks(loggedInUser.getName(), false);
    }

    public static Seq<Tuple2<String, String>> getSelectableUsersForPossibleTenantAdmin(Messages messages, BankSettings bank, User tenantAdmin) {
        return SchedulerForm.getSelectableUsersCheckingTeanantAdmin(messages, bank, tenantAdmin);
    }

    public static Seq<Tuple2<String, String>> getSelectableUsers(Messages messages, BankSettings bank) {
        return SchedulerForm.getSelectableUsersCheckingTeanantAdmin(messages, bank, null);
    }

    public static String getMonthName(int month, Locale loc) {
        return new DateFormatSymbols(loc).getMonths()[month];
    }

    public static Seq<Tuple2<String, String>> getSelectableUsersCheckingTeanantAdmin(Messages messages, BankSettings bank, User operator) {
        ArrayList<Tuple2> toReturn = new ArrayList<Tuple2>();
        toReturn.add(new Tuple2((Object)"", (Object)messages.at("fetchschedule.userAssignedAutomatically", new Object[0])));
        if (bank != null) {
            for (BankUser bu : BankUser.findActiveNonLocalBankUsersForBank((BankSettings)bank)) {
                Tenant tenant = bank.getTenant();
                if (tenant != null && (!bu.getUser().getTenants().contains(tenant) || operator != null && !operator.isAdmin() && !operator.getManagedTenants().contains(tenant)) && !bu.getUser().equals(operator)) continue;
                toReturn.add(new Tuple2((Object)bu.getId().toString(), (Object)SchedulerForm.buildFetcherName(bu)));
            }
        }
        return Scala.asScala(toReturn);
    }

    private static String buildFetcherName(BankUser bankUser) {
        return bankUser.getUser().getName() + " (" + bankUser.getDefaultUser() + ")";
    }

    public SchedulerForm() {
    }

    public SchedulerForm(User loggedInUser, Scheduler scheduler) {
        this.fillUserMap(loggedInUser, scheduler);
        this.bankId = scheduler.getBank().getBankId();
        FetchSchedule.SchedulerType schedulerTypeEnum = FetchSchedule.SchedulerType.getByClassname(scheduler.getOrderOrFileType());
        if (schedulerTypeEnum != null) {
            this.schedulerType = schedulerTypeEnum.getId();
            if (FetchSchedule.SchedulerType.FREE.equals((Object)schedulerTypeEnum)) {
                if (FreePreScheduler.class.getName().equals(scheduler.getOrderOrFileType())) {
                    this.orderType = FreePreScheduler.getOrderTypesFromParameter((String)scheduler.getParameter());
                    this.fromToFetch = FreePreScheduler.getFromToFetchFromParameter((String)scheduler.getParameter());
                    this.fromDate = FreePreScheduler.getFromDateFromParameter((String)scheduler.getParameter());
                    this.toDate = FreePreScheduler.getToDateFromParameter((String)scheduler.getParameter());
                    this.exportDir = FreePreScheduler.getExportDirFromParameter((String)scheduler.getParameter());
                } else {
                    this.orderType = scheduler.getOrderOrFileType();
                    this.exportDir = scheduler.getParameter();
                }
            }
        }
        if (scheduler.getMonth() != null && !scheduler.getMonth().isEmpty()) {
            this.weekOrMonth = 1;
            this.extractMonth(scheduler.getMonth());
            this.extractCalendarDays(scheduler.getDays());
        } else {
            this.weekOrMonth = 0;
            this.extractDays(scheduler.getDays());
        }
        this.extractInterval(scheduler.getInterval());
        this.extractHour(scheduler.getHour());
        this.extractMinute(scheduler.getMinute());
    }

    private void fillUserMap(User loggedInUser, Scheduler scheduler) {
        this.user = new HashMap<Integer, Integer>();
        Iterator selectableBanks = SchedulerForm.getSelectableBanks(loggedInUser).iterator();
        while (selectableBanks.hasNext()) {
            BankUser loggedInBankUser;
            BankUser bankUser;
            int selectableBankId = Integer.parseInt((String)((Tuple2)selectableBanks.next())._1);
            if (scheduler != null && selectableBankId == scheduler.getBank().getBankId() && (bankUser = scheduler.getBankUser()) != null) {
                this.user.put(selectableBankId, bankUser.getId());
            }
            if (scheduler != null && loggedInUser.isAdmin() || (loggedInBankUser = BankUser.findBankUser((BankSettings)BankSettings.getById((Integer)selectableBankId), (User)loggedInUser)) == null || loggedInBankUser.isDeactivated() || loggedInBankUser.getState() != BankUser.UserState.READY) continue;
            this.user.put(selectableBankId, loggedInBankUser.getId());
            if (this.bankId != null || scheduler != null) continue;
            this.bankId = selectableBankId;
        }
    }

    public void loadDefaults(User loggedInUser) {
        this.monday = true;
        this.tuesday = true;
        this.wednesday = true;
        this.thursday = true;
        this.friday = true;
        this.saturday = false;
        this.sunday = false;
        this.onceADay = true;
        this.interval = 60;
        this.month1 = true;
        this.month2 = true;
        this.month3 = true;
        this.month4 = true;
        this.month5 = true;
        this.month6 = true;
        this.month7 = true;
        this.month8 = true;
        this.month9 = true;
        this.month10 = true;
        this.month11 = true;
        this.month12 = true;
        this.day1 = true;
        this.dailyHours = 6;
        this.dailyMins = 0;
        this.startHours = 6;
        this.endHours = 17;
        this.fillUserMap(loggedInUser, null);
    }

    public Form<SchedulerForm> validate(Form<SchedulerForm> form, Scheduler scheduler, Messages messages) {
        boolean isFrenchBank = false;
        BankSettings bank = null;
        if (this.bankId == null) {
            form = form.withError("bankId", "error.required");
        } else {
            bank = BankSettings.getById((Integer)this.bankId);
            if (bank == null) {
                form = form.withError("bankId", "error.invalid");
            } else {
                isFrenchBank = bank.isFrenchBank();
                scheduler.setBank(bank);
                Integer bankUserId = this.user.get(this.bankId);
                if (bankUserId == null) {
                    scheduler.setLoginUser(null);
                } else {
                    BankUser bankUser = BankUser.findById((Integer)bankUserId);
                    scheduler.setLoginUser(bankUser.getUser());
                }
            }
        }
        if (this.schedulerType == null) {
            form = form.withError("schedulerType", "error.required");
        } else {
            FetchSchedule.SchedulerType schedulerTypeEnum = FetchSchedule.SchedulerType.getById(this.schedulerType);
            if (schedulerTypeEnum == null) {
                form = form.withError("schedulerType", "error.invalid");
            } else if (FetchSchedule.SchedulerType.FREE.equals((Object)schedulerTypeEnum)) {
                boolean orderTypeError = false;
                if (this.orderType == null || this.orderType.isEmpty()) {
                    form = form.withError("orderType", "error.required");
                    orderTypeError = true;
                } else if (bank != null && BankUtils.isProtocolH005OrNewer((String)bank.getProtocolVersion())) {
                    if (!this.orderType.matches("[A-Z0-9]{3}") && !BTFTranslator.isBTFString((String)this.orderType)) {
                        form = form.withError("orderOrFileType", "fetched.fetch.error.invalidordertype");
                    }
                } else if (!isFrenchBank && !this.orderType.matches("[A-Z0-9]{3}")) {
                    form = form.withError("orderType", "fetched.fetch.error.invalidordertype");
                    orderTypeError = true;
                }
                if (!orderTypeError) {
                    scheduler.setOrderOrFileType(this.orderType);
                }
                if ((Setup.AUTOMATIC_EXPORT_PATH == null || Setup.AUTOMATIC_EXPORT_PATH.isEmpty()) && this.exportDir != null && !this.exportDir.trim().isEmpty()) {
                    try {
                        FileExportPostProcessing.getExample().substitute(this.exportDir);
                    }
                    catch (Exception e) {
                        form = form.withError("exportDir_field", "fetchschedule.exportDir.error.incorrectPattern");
                    }
                    scheduler.setParameter(this.exportDir.trim());
                } else {
                    scheduler.setParameter(null);
                }
                if ("true".equals(this.fromToFetch)) {
                    if (this.fromDate < this.toDate) {
                        form = form.withError("fromDate", "fetchschedule.fromToDateInvalid");
                    } else {
                        scheduler.setOrderOrFileType(FreePreScheduler.class.getName());
                        scheduler.setParameter(FreePreScheduler.buildParameterString((String)this.fromToFetch, (int)this.fromDate, (int)this.toDate, (String)this.orderType, (String)scheduler.getParameter()));
                    }
                }
            } else {
                scheduler.setOrderOrFileType(schedulerTypeEnum.getClassName());
                scheduler.setParameter(null);
            }
        }
        if (this.weekOrMonth == 0) {
            if (!(this.monday || this.tuesday || this.wednesday || this.thursday || this.friday || this.saturday || this.sunday)) {
                form = form.withError("monday", "fetchschedule.chooseDay");
            } else {
                scheduler.setDays(this.insertDays());
                scheduler.setMonth(null);
            }
        } else if (!(this.month1 || this.month2 || this.month3 || this.month4 || this.month5 || this.month6 || this.month7 || this.month8 || this.month9 || this.month10 || this.month11 || this.month12)) {
            form = form.withError("months", "fetchschedule.chooseMonth");
            if (!(this.day1 || this.day2 || this.day3 || this.day4 || this.day5 || this.day6 || this.day7 || this.day8 || this.day9 || this.day10 || this.day11 || this.day12 || this.day13 || this.day14 || this.day15 || this.day16 || this.day17 || this.day18 || this.day19 || this.day20 || this.day21 || this.day22 || this.day23 || this.day24 || this.day25 || this.day26 || this.day27 || this.day28 || this.day29 || this.day30 || this.day31)) {
                form = form.withError("caldays", "fetchschedule.chooseDayForMonth");
            }
        } else if (!(this.day1 || this.day2 || this.day3 || this.day4 || this.day5 || this.day6 || this.day7 || this.day8 || this.day9 || this.day10 || this.day11 || this.day12 || this.day13 || this.day14 || this.day15 || this.day16 || this.day17 || this.day18 || this.day19 || this.day20 || this.day21 || this.day22 || this.day23 || this.day24 || this.day25 || this.day26 || this.day27 || this.day28 || this.day29 || this.day30 || this.day31)) {
            form = form.withError("caldays", "fetchschedule.chooseDayForMonth");
        } else {
            scheduler.setMonth(this.insertMonths());
            scheduler.setDays(this.insertCalendarDays());
        }
        boolean foundDateError = false;
        if (this.onceADay) {
            if (this.dailyHours == null) {
                form = form.withError("dailyHours", "error.required");
                foundDateError = true;
            } else if (this.dailyHours < 0 || this.dailyHours > 23) {
                form = form.withError("dailyHours", "error.invalid");
                foundDateError = true;
            }
            if (this.dailyMins == null) {
                form = form.withError("dailyMins", "error.required");
                foundDateError = true;
            } else if (this.dailyMins < 0 || this.dailyMins > 59) {
                form = form.withError("dailyMins", "error.invalid");
                foundDateError = true;
            }
        } else {
            if (this.interval == null) {
                form = form.withError("interval", "error.required");
                foundDateError = true;
            } else if (this.interval != 5 && this.interval != 15 && this.interval != 30 && this.interval != 60) {
                form = form.withError("interval", "error.invalid");
                foundDateError = true;
            }
            if (this.startHours == null) {
                form = form.withError("startHours", "error.required");
                foundDateError = true;
            } else if (this.startHours < 0 || this.startHours > 23) {
                form = form.withError("startHours", "error.invalid");
                foundDateError = true;
            }
            if (this.endHours == null) {
                form = form.withError("endHours", "error.required");
                foundDateError = true;
            } else if (this.endHours < 0 || this.endHours > 23) {
                form = form.withError("endHours", "error.invalid");
                foundDateError = true;
            }
            if (this.startHours != null && this.endHours != null && this.startHours > this.endHours) {
                form = form.withError("startHours", "fetchschedule.error.startdateafterenddate");
                foundDateError = true;
            }
        }
        if (!foundDateError) {
            scheduler.setInterval(this.insertInterval());
            scheduler.setHour(this.insertHours());
            scheduler.setMinute(this.insertMinutes());
        }
        if (!scheduler.isUnique()) {
            form = form.withGlobalError(messages.at("fetchschedule.exists", new Object[0]));
        }
        return form;
    }

    private void extractDays(String days) {
        ArrayList<Integer> dayList = new ArrayList<Integer>();
        Pattern pattern = Pattern.compile("(\\d)-(\\d)");
        for (String s : days.split(",")) {
            Matcher matcher = pattern.matcher(s);
            if (matcher.matches()) {
                int from = Integer.parseInt(matcher.group(1));
                int to = Integer.parseInt(matcher.group(2));
                for (int i = from; i <= to; ++i) {
                    dayList.add(i);
                }
                continue;
            }
            if (!s.matches("\\d")) continue;
            dayList.add(Integer.valueOf(s));
        }
        java.util.Iterator iterator = dayList.iterator();
        while (iterator.hasNext()) {
            int day = (Integer)iterator.next();
            switch (day) {
                case 1: {
                    this.sunday = true;
                    break;
                }
                case 2: {
                    this.monday = true;
                    break;
                }
                case 3: {
                    this.tuesday = true;
                    break;
                }
                case 4: {
                    this.wednesday = true;
                    break;
                }
                case 5: {
                    this.thursday = true;
                    break;
                }
                case 6: {
                    this.friday = true;
                    break;
                }
                case 7: {
                    this.saturday = true;
                    break;
                }
            }
        }
    }

    private void extractMonth(String months) {
        ArrayList<Integer> dayList = new ArrayList<Integer>();
        Pattern pattern = Pattern.compile("(\\d+)-(\\d+)");
        for (String s : months.split(",")) {
            Matcher matcher = pattern.matcher(s);
            if (matcher.matches()) {
                int from = Integer.parseInt(matcher.group(1));
                int to = Integer.parseInt(matcher.group(2));
                for (int i = from; i <= to; ++i) {
                    dayList.add(i);
                }
                continue;
            }
            if (!s.matches("\\d+")) continue;
            dayList.add(Integer.valueOf(s));
        }
        java.util.Iterator iterator = dayList.iterator();
        while (iterator.hasNext()) {
            int day = (Integer)iterator.next();
            switch (day) {
                case 0: {
                    this.month1 = true;
                    break;
                }
                case 1: {
                    this.month2 = true;
                    break;
                }
                case 2: {
                    this.month3 = true;
                    break;
                }
                case 3: {
                    this.month4 = true;
                    break;
                }
                case 4: {
                    this.month5 = true;
                    break;
                }
                case 5: {
                    this.month6 = true;
                    break;
                }
                case 6: {
                    this.month7 = true;
                    break;
                }
                case 7: {
                    this.month8 = true;
                    break;
                }
                case 8: {
                    this.month9 = true;
                    break;
                }
                case 9: {
                    this.month10 = true;
                    break;
                }
                case 10: {
                    this.month11 = true;
                    break;
                }
                case 11: {
                    this.month12 = true;
                    break;
                }
            }
        }
    }

    private void extractCalendarDays(String days) {
        ArrayList<Integer> dayList = new ArrayList<Integer>();
        Pattern pattern = Pattern.compile("(\\d+)-(\\d+)");
        for (String s : days.split(",")) {
            Matcher matcher = pattern.matcher(s);
            if (matcher.matches()) {
                int from = Integer.parseInt(matcher.group(1));
                int to = Integer.parseInt(matcher.group(2));
                for (int i = from; i <= to; ++i) {
                    dayList.add(i);
                }
                continue;
            }
            if (!s.matches("\\d+")) continue;
            dayList.add(Integer.valueOf(s));
        }
        java.util.Iterator iterator = dayList.iterator();
        while (iterator.hasNext()) {
            int day = (Integer)iterator.next();
            switch (day) {
                case 1: {
                    this.day1 = true;
                    break;
                }
                case 2: {
                    this.day2 = true;
                    break;
                }
                case 3: {
                    this.day3 = true;
                    break;
                }
                case 4: {
                    this.day4 = true;
                    break;
                }
                case 5: {
                    this.day5 = true;
                    break;
                }
                case 6: {
                    this.day6 = true;
                    break;
                }
                case 7: {
                    this.day7 = true;
                    break;
                }
                case 8: {
                    this.day8 = true;
                    break;
                }
                case 9: {
                    this.day9 = true;
                    break;
                }
                case 10: {
                    this.day10 = true;
                    break;
                }
                case 11: {
                    this.day11 = true;
                    break;
                }
                case 12: {
                    this.day12 = true;
                    break;
                }
                case 13: {
                    this.day13 = true;
                    break;
                }
                case 14: {
                    this.day14 = true;
                    break;
                }
                case 15: {
                    this.day15 = true;
                    break;
                }
                case 16: {
                    this.day16 = true;
                    break;
                }
                case 17: {
                    this.day17 = true;
                    break;
                }
                case 18: {
                    this.day18 = true;
                    break;
                }
                case 19: {
                    this.day19 = true;
                    break;
                }
                case 20: {
                    this.day20 = true;
                    break;
                }
                case 21: {
                    this.day21 = true;
                    break;
                }
                case 22: {
                    this.day22 = true;
                    break;
                }
                case 23: {
                    this.day23 = true;
                    break;
                }
                case 24: {
                    this.day24 = true;
                    break;
                }
                case 25: {
                    this.day25 = true;
                    break;
                }
                case 26: {
                    this.day26 = true;
                    break;
                }
                case 27: {
                    this.day27 = true;
                    break;
                }
                case 28: {
                    this.day28 = true;
                    break;
                }
                case 29: {
                    this.day29 = true;
                    break;
                }
                case 30: {
                    this.day30 = true;
                    break;
                }
                case 31: {
                    this.day31 = true;
                    break;
                }
            }
        }
    }

    private String insertCalendarDays() {
        StringBuilder result = new StringBuilder();
        boolean[] days = new boolean[]{this.day1, this.day2, this.day3, this.day4, this.day5, this.day6, this.day7, this.day8, this.day9, this.day10, this.day11, this.day12, this.day13, this.day14, this.day15, this.day16, this.day17, this.day18, this.day19, this.day20, this.day21, this.day22, this.day23, this.day24, this.day25, this.day26, this.day27, this.day28, this.day29, this.day30, this.day31};
        int seqLength = 0;
        for (int i = 0; i < days.length; ++i) {
            if (days[i]) {
                if (seqLength == 0) {
                    if (!result.isEmpty()) {
                        result.append(",");
                    }
                    result.append(i + 1);
                } else if (!(seqLength != 1 || i != days.length - 1 && days[i + 1])) {
                    result.append(",").append(i + 1);
                } else if (i == days.length - 1 || !days[i + 1]) {
                    result.append("-").append(i + 1);
                }
                ++seqLength;
                continue;
            }
            seqLength = 0;
        }
        return result.toString();
    }

    private String insertDays() {
        StringBuilder result = new StringBuilder();
        boolean[] days = new boolean[]{this.sunday, this.monday, this.tuesday, this.wednesday, this.thursday, this.friday, this.saturday};
        int[] weekDays = new int[]{1, 2, 3, 4, 5, 6, 7};
        int seqLength = 0;
        for (int i = 0; i < days.length; ++i) {
            if (days[i]) {
                if (seqLength == 0) {
                    if (!result.isEmpty()) {
                        result.append(",");
                    }
                    result.append(weekDays[i]);
                } else if (!(seqLength != 1 || i != days.length - 1 && days[i + 1])) {
                    result.append(",").append(weekDays[i]);
                } else if (i == days.length - 1 || !days[i + 1]) {
                    result.append("-").append(weekDays[i]);
                }
                ++seqLength;
                continue;
            }
            seqLength = 0;
        }
        return result.toString();
    }

    private String insertMonths() {
        StringBuilder result = new StringBuilder();
        boolean[] formMonths = new boolean[]{this.month1, this.month2, this.month3, this.month4, this.month5, this.month6, this.month7, this.month8, this.month9, this.month10, this.month11, this.month12};
        int[] months = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11};
        int seqLength = 0;
        for (int i = 0; i < formMonths.length; ++i) {
            if (formMonths[i]) {
                if (seqLength == 0) {
                    if (!result.isEmpty()) {
                        result.append(",");
                    }
                    result.append(months[i]);
                } else if (!(seqLength != 1 || i != formMonths.length - 1 && formMonths[i + 1])) {
                    result.append(",").append(months[i]);
                } else if (i == formMonths.length - 1 || !formMonths[i + 1]) {
                    result.append("-").append(months[i]);
                }
                ++seqLength;
                continue;
            }
            seqLength = 0;
        }
        return result.toString();
    }

    private void extractInterval(Scheduler.Interval interval) {
        if (interval == null || interval == Scheduler.Interval.NONE) {
            this.onceADay = true;
            this.interval = 60;
        } else if (interval == Scheduler.Interval.FIVE_MINUTES) {
            this.interval = 5;
        } else if (interval == Scheduler.Interval.FIFTEEN_MINUTES) {
            this.interval = 15;
        } else if (interval == Scheduler.Interval.THIRTY_MINUTES) {
            this.interval = 30;
        } else if (interval == Scheduler.Interval.HOURLY) {
            this.interval = 60;
        }
    }

    private Scheduler.Interval insertInterval() {
        if (this.onceADay) {
            return Scheduler.Interval.NONE;
        }
        if (this.interval == null) {
            return null;
        }
        return switch (this.interval) {
            case 5 -> Scheduler.Interval.FIVE_MINUTES;
            case 15 -> Scheduler.Interval.FIFTEEN_MINUTES;
            case 30 -> Scheduler.Interval.THIRTY_MINUTES;
            case 60 -> Scheduler.Interval.HOURLY;
            default -> null;
        };
    }

    private void extractHour(String hour) {
        if (this.onceADay) {
            this.dailyHours = Integer.valueOf(hour);
            this.startHours = 6;
            this.endHours = 17;
        } else {
            String[] fromTo = hour.split("-");
            this.startHours = Integer.valueOf(fromTo[0]);
            this.endHours = Integer.valueOf(fromTo[1]);
            this.dailyHours = 6;
        }
    }

    private String insertHours() {
        StringBuilder result = new StringBuilder();
        if (this.onceADay) {
            result.append(this.dailyHours);
        } else {
            result.append(this.startHours).append("-").append(this.endHours);
        }
        return result.toString();
    }

    private void extractMinute(String minute) {
        this.dailyMins = this.onceADay ? Integer.valueOf(minute) : Integer.valueOf(0);
    }

    private String insertMinutes() {
        if (this.onceADay) {
            return String.format("%02d", this.dailyMins);
        }
        return "";
    }
}

