/*
 * Decompiled with CFR 0.152.
 */
package models;

import com.google.common.collect.ImmutableList;
import de.businesslogics.banking.api.BankUtils;
import de.businesslogics.banking.api.SignatureVersionChanger;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.database.vo.BankUser;
import de.businesslogics.ebics.schema.types.SignatureVersion;
import java.util.ArrayList;
import java.util.List;
import models.PasswordForm;
import play.data.validation.Constraints;
import play.data.validation.ValidationError;
import play.libs.Scala;
import scala.Tuple2;
import scala.collection.immutable.Seq;

@Constraints.Validate
public class RenewKeysForm
extends PasswordForm
implements Constraints.Validatable<List<ValidationError>> {
    @Constraints.Required
    private String signatureVersion;
    @Constraints.Required
    private int sigKeyLength;
    @Constraints.Required
    private int encKeyLength;
    @Constraints.Required
    private int authKeyLength;

    public static Seq<Tuple2<String, String>> signatureVersions(BankUser bankUser) {
        ArrayList<Tuple2> toReturn = new ArrayList<Tuple2>();
        List versions = SignatureVersionChanger.getSignatureVersions((BankSettings)bankUser.getBank());
        for (SignatureVersion version : versions) {
            toReturn.add(new Tuple2((Object)version.getValue(), (Object)version.getValue()));
        }
        SignatureVersion currentVersion = BankUtils.getSignatureVersion((BankUser)bankUser);
        if (!versions.contains(currentVersion)) {
            toReturn.add(new Tuple2((Object)currentVersion.getValue(), (Object)currentVersion.getValue()));
        }
        return Scala.toSeq(toReturn);
    }

    public List<ValidationError> validate() {
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        switch (this.signatureVersion) {
            case "A004": {
                errors.add(new ValidationError("signatureVersion", "bank.renewkeys.invalidVersion"));
                break;
            }
            case "A005": {
                if (this.sigKeyLength >= 2048 && this.sigKeyLength <= 4096) break;
                errors.add(new ValidationError("sigKeyLength", "bank.renewkeys.error.wrongLengthInt", (List)ImmutableList.of((Object)2048, (Object)4096)));
                break;
            }
            case "A006": {
                if (this.sigKeyLength >= 2048 && this.sigKeyLength <= 4096) break;
                errors.add(new ValidationError("sigKeyLength", "bank.renewkeys.error.wrongLengthInt", (List)ImmutableList.of((Object)2048, (Object)4096)));
                break;
            }
        }
        if (this.encKeyLength < 2048 || this.encKeyLength > 16384) {
            errors.add(new ValidationError("encKeyLength", "bank.renewkeys.error.wrongLengthInt", (List)ImmutableList.of((Object)2048, (Object)16384)));
        }
        if (this.authKeyLength < 2048 || this.authKeyLength > 16384) {
            errors.add(new ValidationError("authKeyLength", "bank.renewkeys.error.wrongLengthInt", (List)ImmutableList.of((Object)2048, (Object)16384)));
        }
        return errors.isEmpty() ? null : errors;
    }

    public static RenewKeysForm fill(BankUser bankUser) {
        RenewKeysForm form = new RenewKeysForm();
        form.signatureVersion = BankUtils.getSignatureVersion((BankUser)bankUser).getValue();
        form.sigKeyLength = bankUser.getSigKeyLength();
        form.encKeyLength = bankUser.getEncrKeyLength();
        form.authKeyLength = bankUser.getAuthKeyLength();
        return form;
    }

    public String getSignatureVersion() {
        return this.signatureVersion;
    }

    public void setSignatureVersion(String signatureVersion) {
        this.signatureVersion = signatureVersion;
    }

    public int getSigKeyLength() {
        return this.sigKeyLength;
    }

    public void setSigKeyLength(int sigKeyLength) {
        this.sigKeyLength = sigKeyLength;
    }

    public int getEncKeyLength() {
        return this.encKeyLength;
    }

    public void setEncKeyLength(int encKeyLength) {
        this.encKeyLength = encKeyLength;
    }

    public int getAuthKeyLength() {
        return this.authKeyLength;
    }

    public void setAuthKeyLength(int authKeyLength) {
        this.authKeyLength = authKeyLength;
    }
}

