/*
 * Decompiled with CFR 0.152.
 */
package models;

import controllers.branding.Branding;
import controllers.util.BLLoggerPlay;
import controllers.util.CsvImport;
import controllers.util.TenantUtils;
import de.businesslogics.banking.api.CountriesLoader;
import de.businesslogics.banking.api.CsvColumnSeparator;
import de.businesslogics.banking.api.DatabasePreferenceConstant;
import de.businesslogics.banking.api.DatabasePreferenceStore;
import de.businesslogics.banking.api.EncryptData;
import de.businesslogics.banking.api.sepa.SepaDebitType;
import de.businesslogics.banking.api.sepa.SepaSequenceType;
import de.businesslogics.banking.database.api.DB;
import de.businesslogics.banking.database.vo.PaymentRecipient;
import de.businesslogics.banking.database.vo.PaymentType;
import de.businesslogics.banking.database.vo.Preference;
import de.businesslogics.banking.database.vo.Tenant;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.banking.dta.api.DtazvRecipientData;
import de.businesslogics.banking.mt101.api.MT101RecipientData;
import de.businesslogics.banking.payments.api.BicLoader;
import de.businesslogics.banking.payments.api.PreferenceUtil;
import de.businesslogics.banking.payments.api.RecipientData;
import de.businesslogics.banking.payments.api.TableFileReader;
import de.businesslogics.banking.payments.core.PreferenceConstants;
import de.businesslogics.banking.sepa.api.ChequeRecipientData;
import de.businesslogics.banking.sepa.api.PostbarRecipientData;
import de.businesslogics.banking.sepa.api.SepaForeignRecipientData;
import de.businesslogics.banking.sepa.api.SepaMandateData;
import de.businesslogics.banking.sepa.api.SepaRecipientData;
import de.businesslogics.format.AddressData;
import de.businesslogics.format.ClearingSystem;
import de.businesslogics.format.sepa.SEPAUtil;
import de.businesslogics.format.sepa.SepaCountry;
import de.businesslogics.format.sepa.at.PostbarPurpose;
import de.businesslogics.iban.IbanUtil;
import de.businesslogics.util.ConverterUtil;
import de.businesslogics.util.SystemUtils;
import de.businesslogics.validation.RegularExpressions;
import io.ebean.Transaction;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import models.DtazvPaymentForm;
import models.Mt101PaymentForm;
import models.PostbarPaymentForm;
import models.payments.PaymentUtils;
import play.data.Form;
import play.data.validation.ValidationError;
import play.i18n.Messages;
import play.libs.Scala;
import scala.Tuple2;
import scala.collection.immutable.Seq;
import views.Utils;

public final class RecipientImportForm {
    private Messages messages;
    private static final Map<String, List<CsvImport.Field>> COLUMNS_MAP = new HashMap<String, List<CsvImport.Field>>();
    private static final List<PaymentType> PAYMENTTYPES_FOR_IMPORT = Arrays.asList(PaymentType.CHEQUE, PaymentType.SEPA, PaymentType.MT101, PaymentType.DTAZV, PaymentType.AUSTRIAN_TAX_OFFICE, PaymentType.MANDATE, PaymentType.SEPA_FOREIGN, PaymentType.AUSTRIAN_POSTBAR);
    private static final List<String> clearingSystems = new ArrayList<String>();
    private static final List<PostbarPurpose.PayOffMode> payOffModes = new ArrayList<PostbarPurpose.PayOffMode>();
    public Integer tenantId;
    private Tenant tenant;
    public String paymentType;
    public String separator;
    public String encoding;
    public boolean hasHeadline;
    ResourceBundle bundle = null;

    public static List<CsvImport.Field> getFormatColumns(PaymentType paymentType, User user, Messages messages) {
        Locale locale = messages.lang().locale();
        if (paymentType != null) {
            boolean sepaWithMandateFields;
            Object key;
            if (paymentType == PaymentType.SEPA && !new DatabasePreferenceStore(Preference.ApplicationId.SEPA, user).getBoolean((DatabasePreferenceConstant)de.businesslogics.banking.sepa.PreferenceConstants.USE_MANDATE_ADMISTRATION)) {
                key = paymentType.name() + "_WM";
                sepaWithMandateFields = true;
            } else {
                key = paymentType.name();
                sepaWithMandateFields = false;
            }
            List<CsvImport.Field> result = COLUMNS_MAP.get(key);
            if (result == null) {
                result = new ArrayList<CsvImport.Field>();
                COLUMNS_MAP.put((String)key, result);
                CsvImport.Field displayName = CsvImport.Field.getTextField("GeneralMessages.displayName", "displayname", false);
                CsvImport.Field recipientsName = CsvImport.Field.getTextField("GeneralMessages.name", "name", true);
                CsvImport.Field iban = CsvImport.Field.getTextField("GeneralMessages.iban", "iban", true);
                CsvImport.Field bic = CsvImport.Field.getTextField("GeneralMessages.bic", "bic", false);
                CsvImport.Field purpose = CsvImport.Field.getTextField("GeneralMessages.purpose", "purpose", false);
                if (paymentType == PaymentType.AUSTRIAN_TAX_OFFICE) {
                    result.addAll(Arrays.asList(displayName, recipientsName, iban, bic));
                } else if (paymentType == PaymentType.DTAZV) {
                    result.addAll(Arrays.asList(displayName, recipientsName));
                    result.add(CsvImport.Field.getTextField("GeneralMessages.name2", "name2", false));
                    result.add(CsvImport.Field.getTextField("GeneralMessages.street", "street", false));
                    result.add(CsvImport.Field.getTextField("GeneralMessages.city", "town", false));
                    result.add(CsvImport.Field.getSelectField("GeneralMessages.country", "country", false, PaymentUtils.getCountries(locale, true)));
                    result.add(CsvImport.Field.getTextField("GeneralMessages.accountNumberIban", "iban", true));
                    result.add(CsvImport.Field.getTextField("GeneralMessages.blzBic", "bic", false));
                    result.add(CsvImport.Field.getTextField("GeneralMessages.nameOfBank", "bankname", false));
                    result.add(CsvImport.Field.getTextField("GeneralMessages.nameOfBank2", "bankname2", false));
                    result.add(CsvImport.Field.getTextField("GeneralMessages.bankStreet", "bankstreet", false));
                    result.add(CsvImport.Field.getTextField("GeneralMessages.bankTown", "banktown", false));
                    result.add(CsvImport.Field.getSelectField("GeneralMessages.bankCountry", "bankcountry", false, PaymentUtils.getCountries(locale, true)));
                    result.add(CsvImport.Field.getTextField("GeneralMessages.purpose1", "purpose1", false));
                    result.add(CsvImport.Field.getTextField("GeneralMessages.purpose2", "purpose2", false));
                    result.add(CsvImport.Field.getTextField("GeneralMessages.purpose3", "purpose3", false));
                    result.add(CsvImport.Field.getTextField("GeneralMessages.purpose4", "purpose4", false));
                } else if (paymentType == PaymentType.SEPA) {
                    result.addAll(Arrays.asList(displayName, recipientsName, iban, bic, purpose));
                    if (sepaWithMandateFields) {
                        result.add(CsvImport.Field.getTextField("GeneralMessages.mandateReference", "mandatereference", false));
                        result.add(CsvImport.Field.getTextField("GeneralMessages.mandateSignDate", "mandatesigndate", false));
                        result.add(CsvImport.Field.getSelectField("GeneralMessages.sequenceType", "sequencetype", false, PaymentUtils.getSepaSequenceTypes(locale)));
                    }
                    result.add(CsvImport.Field.getTextField("GeneralMessages.street", "street", false));
                    result.add(CsvImport.Field.getTextField("GeneralMessages.town", "town", false));
                    result.add(CsvImport.Field.getTextField("GeneralMessages.country", "country", false));
                } else if (paymentType == PaymentType.MANDATE) {
                    result.add(displayName);
                    result.add(CsvImport.Field.getTextField("GeneralMessages.payer", "payer", true));
                    result.addAll(Arrays.asList(iban, bic, purpose));
                    result.add(CsvImport.Field.getTextField("GeneralMessages.mandateReference", "mandatereference", true));
                    result.add(CsvImport.Field.getTextField("GeneralMessages.mandateSignDate", "mandatesigndate", true));
                    result.add(CsvImport.Field.getSelectField("GeneralMessages.sequenceType", "sequencetype", true, PaymentUtils.getSepaSequenceTypes(locale)));
                    result.add(CsvImport.Field.getTextField(Branding.getBranding().originatorLabelForSEPADebit(), "payee", true));
                    result.add(CsvImport.Field.getTextField("GeneralMessages.creditorId", "creditorid", true));
                    result.add(CsvImport.Field.getSelectField("GeneralMessages.debitType", "debittype", true, PaymentUtils.getSepaDebitTypes(locale)));
                    result.add(CsvImport.Field.getTextField("GeneralMessages.street", "street", false));
                    result.add(CsvImport.Field.getTextField("GeneralMessages.town", "town", false));
                    result.add(CsvImport.Field.getTextField("GeneralMessages.country", "country", false));
                } else if (paymentType == PaymentType.MT101) {
                    result.addAll(Arrays.asList(displayName, recipientsName, CsvImport.Field.getTextField("GeneralMessages.address1", "address1", false), CsvImport.Field.getTextField("GeneralMessages.address2", "address2", false), CsvImport.Field.getTextField("GeneralMessages.address3", "address3", false), CsvImport.Field.getTextField("GeneralMessages.accountNumberIban", "iban", true), CsvImport.Field.getTextField("GeneralMessages.blzBic", "bic", true), CsvImport.Field.getTextField("GeneralMessages.purpose1", "purpose1", false), CsvImport.Field.getTextField("GeneralMessages.purpose2", "purpose2", false), CsvImport.Field.getTextField("GeneralMessages.purpose3", "purpose3", false), CsvImport.Field.getTextField("GeneralMessages.purpose4", "purpose4", false)));
                } else if (paymentType == PaymentType.CHEQUE) {
                    result.addAll(Arrays.asList(displayName, recipientsName, CsvImport.Field.getTextField("GeneralMessages.address", "address", false), CsvImport.Field.getTextField("GeneralMessages.departement", "department", false), CsvImport.Field.getTextField("GeneralMessages.subDepartement", "subdepartment", false), CsvImport.Field.getTextField("GeneralMessages.street", "street", false), CsvImport.Field.getTextField("GeneralMessages.buildingNumber", "buildingnumber", false), CsvImport.Field.getTextField("GeneralMessages.town", "town", false), CsvImport.Field.getTextField("GeneralMessages.postCode", "postalcode", false), CsvImport.Field.getTextField("GeneralMessages.subCountry", "subcountry", false), CsvImport.Field.getSelectField("GeneralMessages.country", "country", true, PaymentUtils.getCountries(locale, true)), purpose));
                } else if (paymentType == PaymentType.SEPA_FOREIGN) {
                    result.addAll(Arrays.asList(displayName, recipientsName, CsvImport.Field.getTextField("GeneralMessages.address", "address", false), CsvImport.Field.getTextField("GeneralMessages.departement", "department", false), CsvImport.Field.getTextField("GeneralMessages.subDepartement", "subdepartment", false), CsvImport.Field.getTextField("GeneralMessages.street", "street", false), CsvImport.Field.getTextField("GeneralMessages.buildingNumber", "buildingnumber", false), CsvImport.Field.getTextField("GeneralMessages.town", "town", false), CsvImport.Field.getTextField("GeneralMessages.postCode", "postalcode", false), CsvImport.Field.getTextField("GeneralMessages.subCountry", "subcountry", false), CsvImport.Field.getSelectField("GeneralMessages.country", "country", true, PaymentUtils.getCountries(locale, true)), CsvImport.Field.getTextField("GeneralMessages.accountNumberIban", "iban", true), CsvImport.Field.getTextField("GeneralMessages.clearingSystem", "clearingsystem", false), CsvImport.Field.getTextField("GeneralMessages.blzBic", "bic", true), CsvImport.Field.getTextField("GeneralMessages.nameOfBank", "bankname", false), CsvImport.Field.getTextField("GeneralMessages.bankAddress", "bankaddress", false), CsvImport.Field.getTextField("GeneralMessages.departement", "bankdepartment", false), CsvImport.Field.getTextField("GeneralMessages.subDepartement", "banksubdepartment", false), CsvImport.Field.getTextField("GeneralMessages.street", "bankstreet", false), CsvImport.Field.getTextField("GeneralMessages.buildingNumber", "bankbuildingnumber", false), CsvImport.Field.getTextField("GeneralMessages.town", "banktown", false), CsvImport.Field.getTextField("GeneralMessages.postCode", "bankpostalcode", false), CsvImport.Field.getTextField("GeneralMessages.subCountry", "banksubcountry", false), CsvImport.Field.getSelectField("GeneralMessages.country", "bankcountry", false, PaymentUtils.getCountries(locale, true)), purpose));
                } else if (paymentType == PaymentType.AUSTRIAN_POSTBAR) {
                    ArrayList<Tuple2> checkboxSelection = new ArrayList<Tuple2>();
                    checkboxSelection.add(Scala.Tuple((Object)"true", (Object)messages.at("payment.recipient.oldValue.checked", new Object[0])));
                    checkboxSelection.add(Scala.Tuple((Object)"false", (Object)messages.at("payment.recipient.oldValue.unchecked", new Object[0])));
                    result.addAll(Arrays.asList(displayName, recipientsName, CsvImport.Field.getTextField("GeneralMessages.address1", "address1", false), CsvImport.Field.getTextField("GeneralMessages.address2", "address2", false), CsvImport.Field.getTextField("GeneralMessages.postCode", "postalcode", true), CsvImport.Field.getSelectField("GeneralMessages.noforward", "noforward", true, (Seq<Tuple2<String, String>>)Scala.toSeq(checkboxSelection)), CsvImport.Field.getSelectField("GeneralMessages.inPerson", "inperson", true, (Seq<Tuple2<String, String>>)Scala.toSeq(checkboxSelection)), CsvImport.Field.getSelectField("GeneralMessages.payoffMode", "paymentmode", true, PostbarPaymentForm.payOffModeOptions(messages)), CsvImport.Field.getTextField("GeneralMessages.payoffMode.PayOffSms", "smsnumber", false), CsvImport.Field.getTextField("GeneralMessages.payOffPostPlz", "postalcodepostoffice", false), purpose, CsvImport.Field.getTextField("GeneralMessages.cashInstructionReference", "cashreference", true)));
                }
            }
            return result;
        }
        return new ArrayList<CsvImport.Field>();
    }

    public void setDefaultFileImportParameters(boolean forceMandate, Messages messages) {
        this.messages = messages;
        try {
            this.bundle = ResourceBundle.getBundle("de.businesslogics.format.csv.Message", messages.lang().locale());
        }
        catch (MissingResourceException e) {
            BLLoggerPlay.warning("No bundle found", e);
        }
        this.paymentType = forceMandate ? PaymentType.MANDATE.name() : PaymentType.SEPA.name();
        this.separator = CsvColumnSeparator.SEMICOLON.name();
        this.encoding = Charset.defaultCharset().name();
    }

    public void setDefaultImportConfigParameters(PaymentType type, boolean mandantes, Map<String, Object> formData, String[][] importData) {
        int columns = 0;
        if (importData != null) {
            for (String[] line : importData) {
                if (line == null || line.length <= columns) continue;
                columns = line.length;
            }
        }
        ArrayList<String> columnNames = new ArrayList<String>();
        if (type == PaymentType.CHEQUE) {
            columnNames.addAll(Arrays.asList("displayname", "name", "address", "department", "subdepartment", "street", "buildingnumber", "town", "postalcode", "subcountry", "country", "purpose"));
        } else if (type == PaymentType.AUSTRIAN_TAX_OFFICE) {
            columnNames.addAll(Arrays.asList("displayname", "name", "iban", "bic"));
        } else if (type == PaymentType.DTAZV) {
            columnNames.addAll(Arrays.asList("displayname", "name", "name2", "street", "town", "country", "iban", "bic", "bankname", "bankname2", "bankstreet", "banktown", "bankcountry", "purpose1", "purpose2", "purpose3", "purpose4"));
        } else if (type == PaymentType.MANDATE) {
            columnNames.addAll(Arrays.asList("displayname", "payee", "creditorid", "payer", "iban", "bic", "purpose", "mandatereference", "mandatesigndate", "debittype", "sequencetype", "street", "town", "country"));
        } else if (type == PaymentType.MT101) {
            columnNames.addAll(Arrays.asList("displayname", "name", "address1", "address2", "address3", "iban", "bic", "purpose1", "purpose2", "purpose3", "purpose4"));
        } else if (type == PaymentType.SEPA) {
            columnNames.addAll(Arrays.asList("displayname", "name", "iban", "bic", "purpose"));
            if (mandantes) {
                columnNames.addAll(Arrays.asList("mandatereference", "mandatesigndate", "sequencetype"));
            }
            columnNames.addAll(Arrays.asList("street", "town", "country"));
        } else if (type == PaymentType.SEPA_FOREIGN) {
            columnNames.addAll(Arrays.asList("displayname", "name", "address", "department", "subdepartment", "street", "buildingnumber", "town", "postalcode", "subcountry", "country", "iban", "clearingsystem", "bic", "bankname", "bankaddress", "bankdepartment", "banksubdepartment", "bankstreet", "bankbuildingnumber", "banktown", "bankpostalcode", "banksubcountry", "bankcountry", "purpose"));
        } else if (type == PaymentType.AUSTRIAN_POSTBAR) {
            columnNames.addAll(Arrays.asList("displayname", "name", "address1", "address2", "postalcode", "noforward", "inperson", "paymentmode", "smsnumber", "postalcodepostoffice", "purpose", "cashreference"));
        }
        for (int i = 0; i < columns; ++i) {
            if (i < columnNames.size()) {
                formData.put((String)columnNames.get(i), String.valueOf(i));
                continue;
            }
            formData.put("column" + i, String.valueOf(i));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[][] readFile(File file2, User user, Messages messages, boolean isPlainFile, List<ValidationError> errors) {
        InputStream inputStream;
        TableFileReader reader;
        block17: {
            this.messages = messages;
            try {
                this.bundle = ResourceBundle.getBundle("de.businesslogics.format.csv.Message", messages.lang().locale());
            }
            catch (MissingResourceException e) {
                BLLoggerPlay.warning("No bundle found", e);
            }
            String tenantError = TenantUtils.checkTenantId(this.tenantId, user);
            if (tenantError != null) {
                errors.add(new ValidationError("tenantId", tenantError));
                return null;
            }
            this.tenant = TenantUtils.getTenantByIdAndUser(this.tenantId, user);
            PaymentType type = PaymentType.valueOf((String)this.paymentType);
            if (!PAYMENTTYPES_FOR_IMPORT.contains(type)) {
                errors.add(new ValidationError("paymentType", messages.at("error.invalid", new Object[0])));
            }
            CsvColumnSeparator columnSeparator = CsvColumnSeparator.valueOf((String)this.separator);
            Charset charset = null;
            try {
                charset = Charset.forName(this.encoding);
            }
            catch (UnsupportedCharsetException e) {
                BLLoggerPlay.warning("User selected unsupported encoding!", e);
                errors.add(new ValidationError("encoding", messages.at("error.invalid", new Object[0])));
            }
            reader = new TableFileReader(columnSeparator, charset, 0);
            inputStream = null;
            try {
                if (isPlainFile) {
                    reader.readFile(file2);
                    break block17;
                }
                inputStream = EncryptData.getInstance().openInputStream(file2);
                reader.readCsvFile(inputStream);
            }
            catch (Exception e) {
                try {
                    BLLoggerPlay.error("Failed to parse import file!", e);
                    errors.add(new ValidationError("", messages.at("recipients.error.filefailed", new Object[]{Utils.getLocalizedMessage(e, messages)})));
                }
                catch (Throwable throwable) {
                    SystemUtils.close(inputStream);
                    throw throwable;
                }
                SystemUtils.close((AutoCloseable)inputStream);
            }
        }
        SystemUtils.close((AutoCloseable)inputStream);
        String[][] result = reader.getTableContent(this.hasHeadline);
        if (result.length > 0) {
            ArrayList<String[]> lines = new ArrayList<String[]>(result.length);
            int maxColumns = 0;
            for (String[] line : result) {
                if (line == null || line.length <= 0) continue;
                boolean isEmpty = true;
                for (String column : line) {
                    if (column == null || column.isEmpty()) continue;
                    isEmpty = false;
                    break;
                }
                if (isEmpty) continue;
                maxColumns = Math.max(maxColumns, line.length);
                lines.add(line);
            }
            result = new String[lines.size()][];
            for (int i = 0; i < lines.size(); ++i) {
                result[i] = new String[maxColumns];
                String[] line = (String[])lines.get(i);
                System.arraycopy(line, 0, result[i], 0, line.length);
                for (int j = line.length; j < maxColumns; ++j) {
                    result[i][j] = "";
                }
            }
        }
        if (result.length == 0) {
            errors.add(new ValidationError("import_recipient_file", messages.at("recipients.error.emptyfileimport", new Object[0])));
        }
        return result;
    }

    public int storeRecipients(Form<RecipientImportForm> form, Messages messages, User user, String[][] importData, List<ValidationError> errors, Map<String, String> flashMap) {
        int n;
        block11: {
            PaymentType type = PaymentType.valueOf((String)this.paymentType);
            this.validateMandatoryFields(type, form, messages, errors);
            if (!errors.isEmpty()) {
                return 0;
            }
            boolean sepaWithMandateFields = type == PaymentType.SEPA && !new DatabasePreferenceStore(Preference.ApplicationId.SEPA, user).getBoolean((DatabasePreferenceConstant)de.businesslogics.banking.sepa.PreferenceConstants.USE_MANDATE_ADMISTRATION);
            boolean allowInvalidBankConnection = new DatabasePreferenceStore(Preference.ApplicationId.PAYMENTS, user).getBoolean((DatabasePreferenceConstant)PreferenceConstants.ALLOW_INVALID_BANK_CONNECTION);
            boolean allowAllCreditorIds = new DatabasePreferenceStore(Preference.ApplicationId.SEPA, user).getBoolean((DatabasePreferenceConstant)de.businesslogics.banking.sepa.PreferenceConstants.ALLOW_INVALID_CREDITOR_ID);
            Transaction t = DB.beginTransaction();
            try {
                int count = 0;
                int lineNumber = this.hasHeadline ? 2 : 1;
                for (String[] line : importData) {
                    RecipientData data = this.validateLine(type, line, form.rawData(), flashMap, lineNumber, sepaWithMandateFields, allowInvalidBankConnection, allowAllCreditorIds);
                    if (data != null) {
                        data.save(user, PreferenceUtil.useFourEyesForRecipientRecording((User)user));
                        ++count;
                    }
                    ++lineNumber;
                }
                t.commit();
                n = count;
                if (t == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (t != null) {
                        try {
                            t.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    BLLoggerPlay.error("Failed to import recipients!", e);
                    return 0;
                }
            }
            t.close();
        }
        return n;
    }

    private RecipientData validateLine(PaymentType type, String[] line, Map<String, String> formData, Map<String, String> flashMap, int lineNumber, boolean sepaWithMandateFields, boolean allowInvalidBankConnection, boolean allowAllCreditorIds) throws IOException {
        DtazvRecipientData data = null;
        if (type == PaymentType.DTAZV) {
            data = this.validateDtazvRecipientLine(line, formData, lineNumber + 1, allowInvalidBankConnection, flashMap);
        } else if (type == PaymentType.SEPA || type == PaymentType.AUSTRIAN_TAX_OFFICE) {
            data = this.validateSepaLine(type, line, formData, lineNumber + 1, sepaWithMandateFields, allowInvalidBankConnection, flashMap);
        } else if (type == PaymentType.MANDATE) {
            data = this.validateSepaMandateLine(line, formData, lineNumber + 1, allowInvalidBankConnection, allowAllCreditorIds, flashMap);
        } else if (type == PaymentType.MT101) {
            data = this.validateMt101RecipientLine(line, formData, lineNumber + 1, allowInvalidBankConnection, flashMap);
        } else if (type == PaymentType.CHEQUE) {
            data = this.validateChequeLine(line, formData, lineNumber + 1, flashMap);
        } else if (type == PaymentType.SEPA_FOREIGN) {
            data = this.validateSepaForeignLine(line, formData, lineNumber + 1, flashMap);
        } else if (type == PaymentType.AUSTRIAN_POSTBAR) {
            data = this.validatePostbarLine(line, formData, lineNumber + 1, flashMap);
        }
        if (data != null && PaymentRecipient.findRecipientByAccountInfo((PaymentType)type, (String)data.getName(), (String)data.getAccountNumber(), (String)data.getBankCode(), (Tenant)data.getTenant()) == null) {
            return data;
        }
        return null;
    }

    public Map<String, Object> buildDataMap() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("tenantId", String.valueOf(this.tenantId));
        result.put("paymentType", this.paymentType);
        result.put("separator", this.separator);
        result.put("encoding", this.encoding);
        result.put("hasHeadline", String.valueOf(this.hasHeadline));
        return result;
    }

    private void validateMandatoryFields(PaymentType type, Form<RecipientImportForm> form, Messages messages, List<ValidationError> errors) {
        if (!PAYMENTTYPES_FOR_IMPORT.contains(type)) {
            errors.add(new ValidationError("paymentType", messages.at("error.invalid", new Object[0])));
        } else if (type == PaymentType.MANDATE) {
            this.checkMandatoryField(form, messages, "payee", errors);
            this.checkMandatoryField(form, messages, "creditorid", errors);
            this.checkMandatoryField(form, messages, "payer", errors);
            this.checkMandatoryField(form, messages, "iban", errors);
            this.checkMandatoryField(form, messages, "mandatereference", errors);
            this.checkMandatoryField(form, messages, "mandatesigndate", errors);
            this.checkMandatoryField(form, messages, "debittype", errors);
            this.checkMandatoryField(form, messages, "sequencetype", errors);
        } else {
            this.checkMandatoryField(form, messages, "name", errors);
            if (type == PaymentType.CHEQUE) {
                this.checkMandatoryField(form, messages, "country", errors);
            } else if (type == PaymentType.AUSTRIAN_POSTBAR) {
                this.checkMandatoryField(form, messages, "postalcode", errors);
            } else {
                this.checkMandatoryField(form, messages, "iban", errors);
                if (type == PaymentType.MT101) {
                    this.checkMandatoryField(form, messages, "bic", errors);
                } else if (type == PaymentType.SEPA_FOREIGN) {
                    this.checkMandatoryField(form, messages, "bic", errors);
                    this.checkMandatoryField(form, messages, "country", errors);
                }
            }
        }
    }

    private void checkMandatoryField(Form<RecipientImportForm> form, Messages messages, String fieldName, List<ValidationError> errors) {
        String field = (String)form.rawData().get(fieldName);
        if (field == null || field.isEmpty()) {
            field = (String)form.rawData().get(fieldName + "_fix");
            if (field == null || field.isEmpty()) {
                errors.add(new ValidationError(fieldName, messages.at("error.required", new Object[0])));
            }
        } else {
            try {
                Integer.valueOf(field);
            }
            catch (NumberFormatException e) {
                errors.add(new ValidationError(fieldName, messages.at("error.invalid", new Object[0])));
            }
        }
    }

    private ValueWithCoulmnId getDtazvConvertedLineField(ValueWithCoulmnId element, int length) {
        if (element != null) {
            element.value = DtazvPaymentForm.convertToDtazvStringFormat(element.value, length);
        }
        return element;
    }

    private String getValue(ValueWithCoulmnId el) {
        if (el != null) {
            return el.value;
        }
        return null;
    }

    private String getDisplayNameValue(ValueWithCoulmnId displayName, ValueWithCoulmnId name, PaymentType type) {
        if (displayName != null && !displayName.value.isEmpty()) {
            return RecipientData.getUniqueDisplayName((String)displayName.value, (PaymentType)type, (Tenant)this.tenant);
        }
        if (name != null && !name.value.isEmpty()) {
            return RecipientData.getUniqueDisplayName((String)name.value, (PaymentType)type, (Tenant)this.tenant);
        }
        return null;
    }

    private DtazvRecipientData validateDtazvRecipientLine(String[] line, Map<String, String> formData, int lineNumber, boolean allowInvalidBankConnection, Map<String, String> flashMap) throws IOException {
        ValueWithCoulmnId displayName = this.getLineField(line, formData, "displayname");
        ValueWithCoulmnId name = this.getDtazvConvertedLineField(this.getLineField(line, formData, "name"), 35);
        ValueWithCoulmnId name2 = this.getDtazvConvertedLineField(this.getLineField(line, formData, "name2"), 35);
        ValueWithCoulmnId street = this.getDtazvConvertedLineField(this.getLineField(line, formData, "street"), 35);
        ValueWithCoulmnId town = this.getDtazvConvertedLineField(this.getLineField(line, formData, "town"), 35);
        ValueWithCoulmnId country = this.getLineField(line, formData, "country");
        ValueWithCoulmnId accountNumber = this.getLineField(line, formData, "iban");
        ValueWithCoulmnId bankCode = this.getLineField(line, formData, "bic");
        ValueWithCoulmnId bankName = this.getDtazvConvertedLineField(this.getLineField(line, formData, "bankname"), 35);
        ValueWithCoulmnId bankName2 = this.getDtazvConvertedLineField(this.getLineField(line, formData, "bankname2"), 35);
        ValueWithCoulmnId bankStreet = this.getDtazvConvertedLineField(this.getLineField(line, formData, "bankstreet"), 35);
        ValueWithCoulmnId bankTown = this.getDtazvConvertedLineField(this.getLineField(line, formData, "banktown"), 35);
        ValueWithCoulmnId bankCountry = this.getLineField(line, formData, "bankcountry");
        ValueWithCoulmnId purpose1 = this.getDtazvConvertedLineField(this.getLineField(line, formData, "purpose1"), 35);
        ValueWithCoulmnId purpose2 = this.getDtazvConvertedLineField(this.getLineField(line, formData, "purpose2"), 35);
        ValueWithCoulmnId purpose3 = this.getDtazvConvertedLineField(this.getLineField(line, formData, "purpose3"), 35);
        ValueWithCoulmnId purpose4 = this.getDtazvConvertedLineField(this.getLineField(line, formData, "purpose4"), 35);
        if (name == null || name.value.isEmpty()) {
            this.addError(flashMap, name, lineNumber, "RECIPIENT_NAME", true);
            BLLoggerPlay.warning("Recipients import: missing name in line " + lineNumber);
            return null;
        }
        if (accountNumber == null || accountNumber.value.isEmpty()) {
            this.addError(flashMap, accountNumber, lineNumber, "RECIPIENT_IBAN", true);
            BLLoggerPlay.warning("Recipients import: missing account number in line " + lineNumber);
            return null;
        }
        if (!allowInvalidBankConnection && RegularExpressions.IBAN.matches(accountNumber.value) && !IbanUtil.checkIban((String)accountNumber.value)) {
            this.addError(flashMap, accountNumber, lineNumber, "RECIPIENT_IBAN", false);
            BLLoggerPlay.warning("Recipients import: invalid account number in line " + lineNumber);
            return null;
        }
        CountriesLoader countriesLoader = CountriesLoader.getInstance((Locale)this.messages.lang().locale());
        if (this.getValue(country) != null && countriesLoader.getCountryName(country.value) == null) {
            this.addError(flashMap, country, lineNumber, "RECIPIENT_COUNTRY", false);
            BLLoggerPlay.warning("Recipients import: invalid country in line " + lineNumber);
            return null;
        }
        if ((this.getValue(country) == null || countriesLoader.getCountryName(country.value) == null) && RegularExpressions.IBAN.matches(accountNumber.value)) {
            if (country == null) {
                country = new ValueWithCoulmnId(accountNumber.value.substring(0, 2));
            } else {
                country.value = accountNumber.value.substring(0, 2);
            }
        }
        if (this.getValue(bankCountry) != null && countriesLoader.getCountryName(bankCountry.value) == null) {
            this.addError(flashMap, bankCountry, lineNumber, "RECIPIENT_BANK_COUNTRY", false);
            BLLoggerPlay.warning("Recipients import: invalid country in line " + lineNumber);
            return null;
        }
        if (this.getValue(bankCountry) == null || countriesLoader.getCountryName(bankCountry.value) == null) {
            if (this.getValue(bankCode) != null && RegularExpressions.BIC.matches(bankCode.value) && countriesLoader.getCountryName(bankCode.value.substring(4, 6)) != null) {
                if (bankCountry == null) {
                    bankCountry = new ValueWithCoulmnId(bankCode.value.substring(4, 6));
                } else {
                    bankCountry.value = bankCode.value.substring(4, 6);
                }
            } else if (this.getValue(bankCountry) != null && this.getValue(country) != null) {
                if (bankCountry == null) {
                    bankCountry = new ValueWithCoulmnId(country.value);
                } else {
                    bankCountry.value = country.value;
                }
            }
        }
        if ((bankCode == null || bankCode.value.isEmpty()) && (bankName == null || bankName.value.isEmpty() || bankStreet == null || bankStreet.value.isEmpty() || bankTown == null || bankTown.value.isEmpty() || bankCountry == null || bankCountry.value.isEmpty())) {
            this.addError(flashMap, bankCode, lineNumber, "BIC_OR_BANK_ADDRESS_MISSING", false);
            BLLoggerPlay.warning("Recipients import: missing bank in line " + lineNumber);
            return null;
        }
        String uniqueDisplayName = this.getDisplayNameValue(displayName, name, PaymentType.DTAZV);
        PaymentRecipient paymentRecipient = new PaymentRecipient();
        paymentRecipient.setPaymentType(PaymentType.DTAZV);
        DtazvRecipientData data = new DtazvRecipientData();
        data.setPaymentRecipient(paymentRecipient);
        data.setDisplayName(uniqueDisplayName);
        data.setName(this.getValue(name));
        data.setName2(this.getValue(name2));
        data.setStreet(this.getValue(street));
        data.setTown(this.getValue(town));
        data.setCountry(this.getValue(country));
        data.setAccountNumber(this.getValue(accountNumber));
        data.setBankCode(this.getValue(bankCode));
        data.setBankName(this.getValue(bankName));
        data.setBankName2(this.getValue(bankName2));
        data.setBankStreet(this.getValue(bankStreet));
        data.setBankTown(this.getValue(bankTown));
        data.setBankCountry(this.getValue(bankCountry));
        data.setPurpose1(this.getValue(purpose1));
        data.setPurpose2(this.getValue(purpose2));
        data.setPurpose3(this.getValue(purpose3));
        data.setPurpose4(this.getValue(purpose4));
        data.setTenant(this.tenant);
        return data;
    }

    private SepaRecipientData getValidatedSepaPartLine(PaymentType type, ValueWithCoulmnId displayName, ValueWithCoulmnId name, ValueWithCoulmnId iban, ValueWithCoulmnId bic, int lineNumber, boolean allowInvalidBankConnection, Map<String, String> flashMap) throws IOException {
        if (name == null || name.value.isEmpty()) {
            this.addError(flashMap, name, lineNumber, "RECIPIENT_NAME", true);
            BLLoggerPlay.warning("Recipients import: missing name in line " + lineNumber);
            return null;
        }
        if (name.value.length() > 70) {
            name.value = name.value.substring(0, 70);
        }
        if (!RegularExpressions.SEPA_GUI.matches(name.value)) {
            this.addError(flashMap, name, lineNumber, "RECIPIENT_NAME", false);
            BLLoggerPlay.warning("Recipients import: invalid name in line " + lineNumber + ": " + name.value);
            return null;
        }
        if (iban == null) {
            this.addError(flashMap, iban, lineNumber, "RECIPIENT_IBAN", true);
            BLLoggerPlay.warning("Recipients import: missing IBAN in line " + lineNumber);
            return null;
        }
        if (!RegularExpressions.IBAN.matches(iban.value) || !allowInvalidBankConnection && !IbanUtil.checkIban((String)iban.value) && !SepaCountry.isSepaCountry((String)iban.value.substring(0, 2))) {
            this.addError(flashMap, iban, lineNumber, "RECIPIENT_IBAN", false);
            BLLoggerPlay.warning("Recipients import: IBAN has invalid iban in line " + lineNumber + " :" + iban.value);
            return null;
        }
        if (!(bic == null || bic.value.isEmpty() || RegularExpressions.BIC.matches(bic.value) || allowInvalidBankConnection)) {
            this.addError(flashMap, bic, lineNumber, "RECIPIENT_BIC", false);
            BLLoggerPlay.warning("Recipients import: invalid BIC in line " + lineNumber + " :" + bic.value);
            return null;
        }
        if ((bic == null || bic.value.isEmpty()) && !SepaCountry.isIbanOnlyAllowed((String)iban.value.substring(0, 2))) {
            this.addError(flashMap, this.messages.at("recipient.csv.error.missingBicCountryspecial", new Object[]{lineNumber, iban.value.substring(0, 2)}));
            BLLoggerPlay.warning("Recipients import: no BIC specified but country does not allow IBAN-only in line " + lineNumber);
            return null;
        }
        String uniqueDisplayName = this.getDisplayNameValue(displayName, name, type);
        PaymentRecipient paymentRecipient = new PaymentRecipient();
        paymentRecipient.setPaymentType(type);
        SepaRecipientData data = new SepaRecipientData();
        data.setPaymentRecipient(paymentRecipient);
        data.setDisplayName(uniqueDisplayName);
        data.setName(name.value);
        data.setAccountNumber(iban.value);
        data.setBankCode(this.getValue(bic));
        data.setTenant(this.tenant);
        return data;
    }

    private SepaRecipientData validateSepaLine(PaymentType type, String[] line, Map<String, String> formData, int lineNumber, boolean includeMandateFields, boolean allowInvalidBankConnection, Map<String, String> flashMap) throws IOException {
        ValueWithCoulmnId displayName = this.getLineField(line, formData, "displayname");
        ValueWithCoulmnId name = this.getLineField(line, formData, "name");
        ValueWithCoulmnId iban = this.getLineField(line, formData, "iban");
        ValueWithCoulmnId bic = this.getLineField(line, formData, "bic");
        SepaRecipientData data = null;
        if (type == PaymentType.SEPA) {
            data = this.getValidatedSepaPartLine(PaymentType.SEPA, displayName, name, iban, bic, lineNumber, allowInvalidBankConnection, flashMap);
            if (data == null) {
                return null;
            }
            ValueWithCoulmnId purpose = this.getLineField(line, formData, "purpose");
            if (purpose != null && purpose.value.length() > 140) {
                purpose.value = purpose.value.substring(0, 140);
            }
            if (purpose != null && !RegularExpressions.SEPA_GUI_WITH_PLACEHOLDER.matches(purpose.value)) {
                this.addError(flashMap, purpose, lineNumber, "PURPOSE", false);
                BLLoggerPlay.warning("Recipients import: invalid purpose in line " + lineNumber);
                return null;
            }
            data.setPurpose(this.getValue(purpose));
            if (includeMandateFields) {
                ValueWithCoulmnId mandateReference = this.getLineField(line, formData, "mandatereference");
                ValueWithCoulmnId mandateSignDate = this.getLineField(line, formData, "mandatesigndate");
                ValueWithCoulmnId sequenceType = this.getLineField(line, formData, "sequencetype");
                if (mandateReference != null) {
                    if (!mandateReference.value.isEmpty() && !RegularExpressions.SEPA_RESTRICTED_IDENTIFICATION_1.matches(mandateReference.value)) {
                        this.addError(flashMap, mandateReference, lineNumber, "MANDATE_ID", false);
                        BLLoggerPlay.warning("Recipients import: invalid mandate reference in line " + lineNumber);
                        return null;
                    }
                    data.getPaymentRecipient().setSepaMandateId(mandateReference.value);
                }
                if (mandateSignDate != null && !mandateSignDate.value.isEmpty()) {
                    try {
                        data.setMandateSignDate(new SimpleDateFormat("yyyyMMdd").parse(mandateSignDate.value));
                    }
                    catch (ParseException e) {
                        this.addError(flashMap, mandateSignDate, lineNumber, "MANDATE_SIGNATURE", false);
                        BLLoggerPlay.warning("Recipients import: failed to parse mandate sign date in line " + lineNumber, e);
                        return null;
                    }
                }
                if (sequenceType != null) {
                    if (SepaSequenceType.getByName((String)sequenceType.value) == null) {
                        this.addError(flashMap, sequenceType, lineNumber, "SEQUENCE_TYPE", false);
                        BLLoggerPlay.warning("Recipients import: invalid sequence type in line " + lineNumber);
                        return null;
                    }
                    data.setSequenceType(sequenceType.value);
                }
            }
            AddressData addressData = AddressData.getStructuredAddress((String)this.getValue(this.getLineField(line, formData, "street")), (String)this.getValue(this.getLineField(line, formData, "town")), (String)this.getValue(this.getLineField(line, formData, "country")));
            data.setAddress(addressData);
        } else if (type == PaymentType.AUSTRIAN_TAX_OFFICE) {
            data = this.getValidatedSepaPartLine(PaymentType.AUSTRIAN_TAX_OFFICE, displayName, name, iban, bic, lineNumber, allowInvalidBankConnection, flashMap);
        }
        return data;
    }

    private void addError(Map<String, String> flashMap, String message) {
        String oldText = flashMap.get("error");
        if (oldText == null || oldText.isEmpty()) {
            flashMap.put("error", message);
        } else {
            flashMap.put("error", oldText + "\n" + message);
        }
    }

    private void addError(Map<String, String> flashMap, ValueWithCoulmnId element, int linenumber, String textKey, boolean missing) {
        String oldText = flashMap.get("error");
        String field = this.bundle.getString(textKey);
        String message = textKey.equals("BIC_OR_BANK_ADDRESS_MISSING") ? MessageFormat.format(field, linenumber) : (missing ? (element != null && element.hasCol() ? MessageFormat.format(this.bundle.getString("NO_VALUE_IN_FILE"), field, linenumber, element.column) : MessageFormat.format(this.bundle.getString("NO_VALUE"), field)) : (element != null && element.hasCol() ? MessageFormat.format(this.bundle.getString("INVALID_VALUE_IN_FILE"), element.value, field, linenumber, element.column) : MessageFormat.format(this.bundle.getString("INVALID_VALUE"), element == null ? "null" : element.value, field)));
        if (oldText == null || oldText.isEmpty()) {
            flashMap.put("error", message);
        } else {
            flashMap.put("error", oldText + "\n" + message);
        }
    }

    private PostbarRecipientData validatePostbarLine(String[] line, Map<String, String> formData, int lineNumber, Map<String, String> flashMap) throws IOException {
        ValueWithCoulmnId displayName = this.getLineField(line, formData, "displayname");
        ValueWithCoulmnId name = this.getLineField(line, formData, "name");
        ValueWithCoulmnId address1 = this.getLineField(line, formData, "address1");
        ValueWithCoulmnId address2 = this.getLineField(line, formData, "address2");
        ValueWithCoulmnId postcode = this.getLineField(line, formData, "postalcode");
        ValueWithCoulmnId noforward = this.getLineField(line, formData, "noforward");
        ValueWithCoulmnId inperson = this.getLineField(line, formData, "inperson");
        ValueWithCoulmnId payoffmode = this.getLineField(line, formData, "paymentmode");
        ValueWithCoulmnId smsnumber = this.getLineField(line, formData, "smsnumber");
        ValueWithCoulmnId postcodepostoffice = this.getLineField(line, formData, "postalcodepostoffice");
        ValueWithCoulmnId purpose = this.getLineField(line, formData, "purpose");
        ValueWithCoulmnId cashref = this.getLineField(line, formData, "cashreference");
        if (name == null || name.value.isEmpty()) {
            this.addError(flashMap, name, lineNumber, "RECIPIENT_NAME", true);
            BLLoggerPlay.warning("Recipients import: missing name in line " + lineNumber);
            return null;
        }
        if (!RegularExpressions.SEPA_GUI.matches(name.value) || name.value.length() > 70) {
            this.addError(flashMap, name, lineNumber, "RECIPIENT_NAME", false);
            BLLoggerPlay.warning("Recipients import: invalid name in line " + lineNumber);
            return null;
        }
        if (!(this.getValue(address1) == null || RegularExpressions.SEPA_GUI.matches(address1.value) && address1.value.trim().length() <= 50)) {
            this.addError(flashMap, address1, lineNumber, "ADDRESS_1", false);
            BLLoggerPlay.warning("Recipients import: invalid address1 in line " + lineNumber);
            return null;
        }
        if (!(this.getValue(address2) == null || RegularExpressions.SEPA_GUI.matches(address2.value) && address2.value.trim().length() <= 50)) {
            this.addError(flashMap, address2, lineNumber, "ADDRESS_2", false);
            BLLoggerPlay.warning("Recipients import: invalid address2 in line " + lineNumber);
            return null;
        }
        if (this.getValue(postcode) == null) {
            this.addError(flashMap, postcode, lineNumber, "POSTCODE", true);
            BLLoggerPlay.warning("Recipients import: missing postcode in line " + lineNumber);
            return null;
        }
        if (!RegularExpressions.DIGITS.matches(postcode.value) || postcode.value.length() != 4) {
            this.addError(flashMap, postcode, lineNumber, "POSTCODE", false);
            BLLoggerPlay.warning("Recipients import: invalid postcode in line " + lineNumber);
            return null;
        }
        if (this.getValue(noforward) == null || !this.getValue(noforward).equalsIgnoreCase("false") && !this.getValue(noforward).equalsIgnoreCase("true")) {
            this.addError(flashMap, postcode, lineNumber, "NO_FORWARDED", false);
            BLLoggerPlay.warning("Recipients import: invalid postcode in line " + lineNumber);
            return null;
        }
        if (this.getValue(inperson) == null || !this.getValue(inperson).equalsIgnoreCase("false") && !this.getValue(inperson).equalsIgnoreCase("true")) {
            this.addError(flashMap, inperson, lineNumber, "IN_PERSON", false);
            BLLoggerPlay.warning("Recipients import: invalid postcode in line " + lineNumber);
            return null;
        }
        PostbarPurpose.PayOffMode pm = null;
        if (this.getValue(payoffmode) != null) {
            pm = PostbarPurpose.PayOffMode.valueOf((String)this.getValue(payoffmode));
            if (!payOffModes.contains(pm)) {
                this.addError(flashMap, name, lineNumber, "RECIPIENT_NAME", true);
                BLLoggerPlay.warning("Recipients import: missing name in line " + lineNumber);
                return null;
            }
            if (PostbarPurpose.PayOffMode.PayOffSms.equals((Object)pm)) {
                if (this.getValue(smsnumber) == null) {
                    this.addError(flashMap, name, lineNumber, "RECIPIENT_NAME", true);
                    BLLoggerPlay.warning("Recipients import: missing name in line " + lineNumber);
                    return null;
                }
                if (this.getValue(smsnumber).startsWith("+43")) {
                    smsnumber.value = smsnumber.value.substring("+43".length());
                } else if (this.getValue(smsnumber).startsWith("'+43") || this.getValue(smsnumber).startsWith("0043")) {
                    smsnumber.value = smsnumber.value.substring("0043".length());
                }
                if (!RegularExpressions.DIGITS.matches(this.getValue(smsnumber)) || this.getValue(smsnumber).length() < 9 || this.getValue(smsnumber).length() > 11) {
                    this.addError(flashMap, name, lineNumber, "RECIPIENT_NAME", true);
                    BLLoggerPlay.warning("Recipients import: missing name in line " + lineNumber);
                    return null;
                }
            } else if (PostbarPurpose.PayOffMode.PayOffPostPlz.equals((Object)pm)) {
                if (this.getValue(postcodepostoffice) == null) {
                    this.addError(flashMap, postcodepostoffice, lineNumber, "POSTCODE_POST_OFFICE", true);
                    BLLoggerPlay.warning("Recipients import: missing postcode in line " + lineNumber);
                    return null;
                }
                if (!RegularExpressions.DIGITS.matches(postcodepostoffice.value) || postcodepostoffice.value.length() != 4) {
                    this.addError(flashMap, postcodepostoffice, lineNumber, "POSTCODE_POST_OFFICE", false);
                    BLLoggerPlay.warning("Recipients import: invalid postcode in line " + lineNumber);
                    return null;
                }
            } else {
                smsnumber = null;
                postcodepostoffice = null;
            }
        }
        if (!(this.getValue(purpose) == null || RegularExpressions.SEPA_GUI.matches(purpose.value) && purpose.value.length() <= 140)) {
            this.addError(flashMap, purpose, lineNumber, "PURPOSE", false);
            BLLoggerPlay.warning("Recipients import: missing name in line " + lineNumber);
            return null;
        }
        if (!(this.getValue(cashref) == null || RegularExpressions.SEPA_GUI.matches(cashref.value) && cashref.value.length() <= 35)) {
            this.addError(flashMap, cashref, lineNumber, "END_TO_END", false);
            BLLoggerPlay.warning("Recipients import: invalid cash instruction reference in line " + lineNumber);
            return null;
        }
        String uniqueDisplayName = this.getDisplayNameValue(displayName, name, PaymentType.AUSTRIAN_POSTBAR);
        boolean forward = !"true".equalsIgnoreCase(this.getValue(noforward));
        boolean inPerson = "true".equalsIgnoreCase(this.getValue(inperson));
        PaymentRecipient paymentRecipient = new PaymentRecipient();
        paymentRecipient.setPaymentType(PaymentType.AUSTRIAN_POSTBAR);
        PostbarRecipientData data = new PostbarRecipientData();
        data.setPaymentRecipient(paymentRecipient);
        data.setDisplayName(uniqueDisplayName);
        data.setName(name.value);
        data.setAddress1(this.getValue(address1));
        data.setAddress2(this.getValue(address2));
        data.setPlz(this.getValue(postcode));
        data.setPayOffMode(pm);
        data.setPostPlz(this.getValue(postcodepostoffice));
        data.setSmsNumber(this.getValue(smsnumber));
        data.setForward(forward);
        data.setInPerson(inPerson);
        data.setPurpose(this.getValue(purpose));
        data.setReference(this.getValue(cashref));
        data.setTenant(this.tenant);
        return data;
    }

    private SepaForeignRecipientData validateSepaForeignLine(String[] line, Map<String, String> formData, int lineNumber, Map<String, String> flashMap) throws IOException {
        ValueWithCoulmnId displayName = this.getLineField(line, formData, "displayname");
        ValueWithCoulmnId name = this.getLineField(line, formData, "name");
        ValueWithCoulmnId address = this.getLineField(line, formData, "address");
        ValueWithCoulmnId dept = this.getLineField(line, formData, "department");
        ValueWithCoulmnId subdept = this.getLineField(line, formData, "subdepartment");
        ValueWithCoulmnId street = this.getLineField(line, formData, "street");
        ValueWithCoulmnId buildingnumber = this.getLineField(line, formData, "buildingnumber");
        ValueWithCoulmnId town = this.getLineField(line, formData, "town");
        ValueWithCoulmnId postalcode = this.getLineField(line, formData, "postalcode");
        ValueWithCoulmnId subcountry = this.getLineField(line, formData, "subcountry");
        ValueWithCoulmnId country = this.getLineField(line, formData, "country");
        ValueWithCoulmnId iban = this.getLineField(line, formData, "iban");
        ValueWithCoulmnId clearingSystem = this.getLineField(line, formData, "clearingsystem");
        ValueWithCoulmnId bic = this.getLineField(line, formData, "bic");
        ValueWithCoulmnId bankName = this.getLineField(line, formData, "bankname");
        ValueWithCoulmnId bankAddress = this.getLineField(line, formData, "bankaddress");
        ValueWithCoulmnId deptBank = this.getLineField(line, formData, "bankdepartment");
        ValueWithCoulmnId subdeptBank = this.getLineField(line, formData, "banksubdepartment");
        ValueWithCoulmnId streetBank = this.getLineField(line, formData, "bankstreet");
        ValueWithCoulmnId buildingnumberBank = this.getLineField(line, formData, "bankbuildingnumber");
        ValueWithCoulmnId townBank = this.getLineField(line, formData, "banktown");
        ValueWithCoulmnId postalcodeBank = this.getLineField(line, formData, "bankpostalcode");
        ValueWithCoulmnId subcountryBank = this.getLineField(line, formData, "banksubcountry");
        ValueWithCoulmnId bankCountry = this.getLineField(line, formData, "bankcountry");
        ValueWithCoulmnId purpose = this.getLineField(line, formData, "purpose");
        if (name == null || name.value.isEmpty()) {
            this.addError(flashMap, name, lineNumber, "RECIPIENT_NAME", true);
            BLLoggerPlay.warning("Recipients import: missing name in line " + lineNumber);
            return null;
        }
        if (name.value.length() > 70) {
            name.value = name.value.substring(0, 70);
        }
        if (!RegularExpressions.SEPA_GUI.matches(name.value)) {
            this.addError(flashMap, name, lineNumber, "RECIPIENT_NAME", false);
            BLLoggerPlay.warning("Recipients import: invalid name in line " + lineNumber);
            return null;
        }
        if (dept != null && dept.value.length() > 70) {
            dept.value = dept.value.substring(0, 70);
        }
        if (subdept != null && subdept.value.length() > 70) {
            subdept.value = subdept.value.substring(0, 70);
        }
        if (street != null && street.value.length() > 70) {
            street.value = street.value.substring(0, 70);
        }
        if (buildingnumber != null && buildingnumber.value.length() > 16) {
            buildingnumber.value = buildingnumber.value.substring(0, 16);
        }
        if (town != null && town.value.length() > 35) {
            town.value = town.value.substring(0, 35);
        }
        if (postalcode != null && postalcode.value.length() > 16) {
            postalcode.value = postalcode.value.substring(0, 16);
        }
        if (subcountry != null && subcountry.value.length() > 35) {
            subcountry.value = subcountry.value.substring(0, 35);
        }
        CountriesLoader countriesLoader = CountriesLoader.getInstance((Locale)this.messages.lang().locale());
        if (country == null || countriesLoader.getCountryName(country.value) == null) {
            this.addError(flashMap, country, lineNumber, "RECIPIENT_COUNTRY", country == null || country.value.isEmpty());
            BLLoggerPlay.warning("Recipients import: invalid country in line " + lineNumber);
            return null;
        }
        AddressData rAddress = null;
        if (this.getValue(country) != null) {
            rAddress = PaymentUtils.getFullAddressData(this.getValue(dept), this.getValue(subdept), this.getValue(street), this.getValue(buildingnumber), "", "", this.getValue(town), this.getValue(postalcode), this.getValue(subcountry), this.getValue(address), this.getValue(country));
        }
        if (iban == null || iban.value.isEmpty()) {
            this.addError(flashMap, iban, lineNumber, "RECIPIENT_IBAN", true);
            BLLoggerPlay.warning("Recipients import: missing iban in line " + lineNumber);
            return null;
        }
        if (bic == null || bic.value.isEmpty()) {
            this.addError(flashMap, bic, lineNumber, "RECIPIENT_BIC", true);
            BLLoggerPlay.warning("Recipients import: missing bic in line " + lineNumber);
            return null;
        }
        if (this.getValue(clearingSystem) != null) {
            if (!clearingSystems.contains(this.getValue(clearingSystem)) && !"bic".equalsIgnoreCase(this.getValue(clearingSystem))) {
                this.addError(flashMap, clearingSystem, lineNumber, "CLEARING_SYSTEM", false);
                BLLoggerPlay.warning("Recipients import: invalid clearing system in line " + lineNumber);
                return null;
            }
            if ("bic".equalsIgnoreCase(this.getValue(clearingSystem))) {
                clearingSystem = null;
            }
        }
        if (bankCountry != null && countriesLoader.getCountryName(bankCountry.value) == null) {
            this.addError(flashMap, bankCountry, lineNumber, "RECIPIENT_BANK_COUNTRY", false);
            BLLoggerPlay.warning("Recipients import: invalid country in line " + lineNumber);
            return null;
        }
        if (deptBank != null && deptBank.value.length() > 70) {
            deptBank.value = deptBank.value.substring(0, 70);
        }
        if (subdeptBank != null && subdeptBank.value.length() > 70) {
            subdeptBank.value = subdeptBank.value.substring(0, 70);
        }
        if (streetBank != null && streetBank.value.length() > 70) {
            streetBank.value = streetBank.value.substring(0, 70);
        }
        if (buildingnumberBank != null && buildingnumberBank.value.length() > 16) {
            buildingnumberBank.value = buildingnumberBank.value.substring(0, 16);
        }
        if (townBank != null && townBank.value.length() > 35) {
            townBank.value = townBank.value.substring(0, 35);
        }
        if (postalcodeBank != null && postalcodeBank.value.length() > 16) {
            postalcodeBank.value = postalcodeBank.value.substring(0, 16);
        }
        if (subcountryBank != null && subcountryBank.value.length() > 35) {
            subcountryBank.value = subcountryBank.value.substring(0, 35);
        }
        AddressData bAddress = null;
        if (this.getValue(bankCountry) != null) {
            bAddress = PaymentUtils.getFullAddressData(this.getValue(deptBank), this.getValue(subdeptBank), this.getValue(streetBank), this.getValue(buildingnumberBank), "", "", this.getValue(townBank), this.getValue(postalcodeBank), this.getValue(subcountryBank), this.getValue(bankAddress), this.getValue(bankCountry));
        }
        if (purpose != null && !purpose.value.isEmpty()) {
            if (purpose.value.length() > 140) {
                purpose.value = purpose.value.substring(0, 140);
            }
            if (!RegularExpressions.SEPA_GUI.matches(purpose.value)) {
                this.addError(flashMap, name, lineNumber, "PURPOSE", false);
                BLLoggerPlay.warning("Recipients import: invalid purpose in line " + lineNumber);
                return null;
            }
        }
        String uniqueDisplayName = this.getDisplayNameValue(displayName, name, PaymentType.SEPA_FOREIGN);
        PaymentRecipient paymentRecipient = new PaymentRecipient();
        paymentRecipient.setPaymentType(PaymentType.SEPA_FOREIGN);
        SepaForeignRecipientData data = new SepaForeignRecipientData();
        data.setPaymentRecipient(paymentRecipient);
        data.setDisplayName(uniqueDisplayName);
        data.setName(name.value);
        data.setAddress(rAddress);
        data.setAccountNumber(this.getValue(iban));
        data.setClearingSystemId(this.getValue(clearingSystem));
        data.setBankCode(this.getValue(bic));
        data.setBankName(this.getValue(bankName));
        data.setBankAddress(bAddress);
        data.setPurpose(this.getValue(purpose));
        data.setTenant(this.tenant);
        return data;
    }

    private ChequeRecipientData validateChequeLine(String[] line, Map<String, String> formData, int lineNumber, Map<String, String> flashMap) throws IOException {
        ValueWithCoulmnId displayName = this.getLineField(line, formData, "displayname");
        ValueWithCoulmnId name = this.getLineField(line, formData, "name");
        ValueWithCoulmnId address = this.getLineField(line, formData, "address");
        ValueWithCoulmnId dept = this.getLineField(line, formData, "department");
        ValueWithCoulmnId subdept = this.getLineField(line, formData, "subdepartment");
        ValueWithCoulmnId street = this.getLineField(line, formData, "street");
        ValueWithCoulmnId buildingnumber = this.getLineField(line, formData, "buildingnumber");
        ValueWithCoulmnId town = this.getLineField(line, formData, "town");
        ValueWithCoulmnId postalcode = this.getLineField(line, formData, "postalcode");
        ValueWithCoulmnId subcountry = this.getLineField(line, formData, "subcountry");
        ValueWithCoulmnId country = this.getLineField(line, formData, "country");
        ValueWithCoulmnId purpose = this.getLineField(line, formData, "purpose");
        if (name == null || name.value.isEmpty()) {
            this.addError(flashMap, name, lineNumber, "RECIPIENT_NAME", true);
            BLLoggerPlay.warning("Recipients import: missing name in line " + lineNumber);
            return null;
        }
        if (name.value.length() > 70) {
            name.value = name.value.substring(0, 70);
        }
        if (!RegularExpressions.SEPA_GUI.matches(name.value)) {
            this.addError(flashMap, name, lineNumber, "RECIPIENT_NAME", false);
            BLLoggerPlay.warning("Recipients import: invalid name in line " + lineNumber);
            return null;
        }
        if (dept != null && dept.value.length() > 70) {
            dept.value = dept.value.substring(0, 70);
        }
        if (subdept != null && subdept.value.length() > 70) {
            subdept.value = subdept.value.substring(0, 70);
        }
        if (street != null && street.value.length() > 70) {
            street.value = street.value.substring(0, 70);
        }
        if (buildingnumber != null && buildingnumber.value.length() > 16) {
            buildingnumber.value = buildingnumber.value.substring(0, 16);
        }
        if (town != null && town.value.length() > 35) {
            town.value = town.value.substring(0, 35);
        }
        if (postalcode != null && postalcode.value.length() > 16) {
            postalcode.value = postalcode.value.substring(0, 16);
        }
        if (subcountry != null && subcountry.value.length() > 35) {
            subcountry.value = subcountry.value.substring(0, 35);
        }
        CountriesLoader countriesLoader = CountriesLoader.getInstance((Locale)this.messages.lang().locale());
        if (country == null || countriesLoader.getCountryName(country.value) == null) {
            this.addError(flashMap, country, lineNumber, "RECIPIENT_COUNTRY", country == null || country.value.isEmpty());
            BLLoggerPlay.warning("Recipients import: invalid country in line " + lineNumber);
            return null;
        }
        AddressData rAddress = PaymentUtils.getFullAddressData(this.getValue(dept), this.getValue(subdept), this.getValue(street), this.getValue(buildingnumber), "", "", this.getValue(town), this.getValue(postalcode), this.getValue(subcountry), this.getValue(address), this.getValue(country));
        if (purpose != null && purpose.value.length() > 140) {
            purpose.value = purpose.value.substring(0, 140);
        }
        if (purpose != null && !RegularExpressions.SEPA_GUI_WITH_PLACEHOLDER.matches(purpose.value)) {
            this.addError(flashMap, purpose, lineNumber, "PURPOSE", false);
            BLLoggerPlay.warning("Recipients import: invalid purpose in line " + lineNumber);
            return null;
        }
        String uniqueDisplayName = this.getDisplayNameValue(displayName, name, PaymentType.CHEQUE);
        PaymentRecipient paymentRecipient = new PaymentRecipient();
        paymentRecipient.setPaymentType(PaymentType.CHEQUE);
        ChequeRecipientData data = new ChequeRecipientData();
        data.setPaymentRecipient(paymentRecipient);
        data.setDisplayName(uniqueDisplayName);
        data.setName(name.value);
        data.setAddress(rAddress);
        data.setPurpose(this.getValue(purpose));
        data.setTenant(this.tenant);
        return data;
    }

    private SepaMandateData validateSepaMandateLine(String[] line, Map<String, String> formData, int lineNumber, boolean allowInvalidBankConnection, boolean allowAllCreditorIds, Map<String, String> flashMap) throws IOException {
        ValueWithCoulmnId displayName = this.getLineField(line, formData, "displayname");
        ValueWithCoulmnId payee = this.getLineField(line, formData, "payee");
        ValueWithCoulmnId creditorId = this.getLineField(line, formData, "creditorid");
        ValueWithCoulmnId payer = this.getLineField(line, formData, "payer");
        ValueWithCoulmnId iban = this.getLineField(line, formData, "iban");
        ValueWithCoulmnId bic = this.getLineField(line, formData, "bic");
        ValueWithCoulmnId purpose = this.getLineField(line, formData, "purpose");
        ValueWithCoulmnId mandateReference = this.getLineField(line, formData, "mandatereference");
        ValueWithCoulmnId mandateSignDateString = this.getLineField(line, formData, "mandatesigndate");
        ValueWithCoulmnId debitType = this.getLineField(line, formData, "debittype");
        ValueWithCoulmnId sequenceType = this.getLineField(line, formData, "sequencetype");
        ValueWithCoulmnId debtorStreet = this.getLineField(line, formData, "street");
        ValueWithCoulmnId debtorTown = this.getLineField(line, formData, "town");
        ValueWithCoulmnId debtorCountry = this.getLineField(line, formData, "country");
        if (payee == null || payee.value.isEmpty()) {
            this.addError(flashMap, payee, lineNumber, "ORIGINATOR_NAME_DEBIT", true);
            BLLoggerPlay.warning("Recipients import: missing payee in line " + lineNumber);
            return null;
        }
        if (payee.value.length() > 70) {
            payee.value = payee.value.substring(0, 70);
        }
        if (!RegularExpressions.SEPA_GUI.matches(payee.value)) {
            this.addError(flashMap, payee, lineNumber, "ORIGINATOR_NAME_DEBIT", false);
            BLLoggerPlay.warning("Recipients import: invalid payee in line " + lineNumber);
            return null;
        }
        if (creditorId == null || creditorId.value.isEmpty()) {
            this.addError(flashMap, creditorId, lineNumber, "CREDITOR_ID", true);
            BLLoggerPlay.warning("Recipients import: missing or invalid creditor ID in line " + lineNumber);
            return null;
        }
        if (!allowAllCreditorIds && !SEPAUtil.checkCreditorId((String)creditorId.value)) {
            this.addError(flashMap, creditorId, lineNumber, "CREDITOR_ID", false);
        }
        if (payer == null || payer.value.isEmpty()) {
            this.addError(flashMap, payer, lineNumber, "RECIPIENT_NAME_DEBIT", true);
            BLLoggerPlay.warning("Recipients import: missing payer in line " + lineNumber);
            return null;
        }
        if (payer.value.length() > 70) {
            payer.value = payer.value.substring(0, 70);
        }
        if (!RegularExpressions.SEPA_GUI.matches(payer.value)) {
            this.addError(flashMap, payer, lineNumber, "RECIPIENT_NAME_DEBIT", false);
            BLLoggerPlay.warning("Recipients import: invalid payer in line " + lineNumber);
            return null;
        }
        if (iban == null || iban.value.isEmpty()) {
            this.addError(flashMap, iban, lineNumber, "RECIPIENT_IBAN", true);
            BLLoggerPlay.warning("Recipients import: missing or invalid IBAN in line " + lineNumber);
            return null;
        }
        if (!allowInvalidBankConnection && !IbanUtil.checkIban((String)iban.value) || !SepaCountry.isSepaCountry((String)iban.value.substring(0, 2))) {
            this.addError(flashMap, iban, lineNumber, "RECIPIENT_IBAN", false);
            BLLoggerPlay.warning("Recipients import: IBAN has invalid country in line " + lineNumber);
            return null;
        }
        if (!(bic == null || bic.value.isEmpty() || RegularExpressions.BIC.matches(bic.value) && (allowInvalidBankConnection || BicLoader.getInstance().getBankName(bic.value) != null))) {
            this.addError(flashMap, bic, lineNumber, "RECIPIENT_BIC", false);
            BLLoggerPlay.warning("Recipients import: missing or invalid BIC in line " + lineNumber);
            return null;
        }
        if ((bic == null || bic.value.isEmpty()) && !SepaCountry.isIbanOnlyAllowed((String)iban.value.substring(0, 2))) {
            this.addError(flashMap, this.messages.at("recipient.csv.error.missingBicCountspecial", new Object[]{lineNumber, iban.value.substring(0, 2)}));
            BLLoggerPlay.warning("Recipients import: no BIC specified but country does not allow IBAN-only in line " + lineNumber);
            return null;
        }
        if (purpose != null && !purpose.value.isEmpty()) {
            if (purpose.value.length() > 140) {
                purpose.value = purpose.value.substring(0, 140);
            }
            if (!RegularExpressions.SEPA_GUI_WITH_PLACEHOLDER.matches(purpose.value)) {
                this.addError(flashMap, purpose, lineNumber, "PURPOSE", false);
                BLLoggerPlay.warning("Recipients import: invalid purpose in line " + lineNumber);
                return null;
            }
        }
        if (mandateReference == null || mandateReference.value.isEmpty()) {
            this.addError(flashMap, mandateReference, lineNumber, "MANDATE_ID", true);
            BLLoggerPlay.warning("Recipients import: missing mandate reference in line " + lineNumber);
            return null;
        }
        if (mandateReference.value.length() > 35 || !RegularExpressions.SEPA_RESTRICTED_IDENTIFICATION_1.matches(mandateReference.value)) {
            this.addError(flashMap, mandateReference, lineNumber, "MANDATE_ID", false);
            BLLoggerPlay.warning("Recipients import:  invalid mandate reference in line " + lineNumber);
            return null;
        }
        Date mandateSignDate = null;
        if (mandateSignDateString == null || mandateSignDateString.value.isEmpty()) {
            this.addError(flashMap, mandateSignDateString, lineNumber, "MANDATE_SIGNATURE", true);
            BLLoggerPlay.warning("Recipients import: missing mandate sign date in line " + lineNumber);
            return null;
        }
        int n = 0;
        String[] stringArray = ConverterUtil.getConvertibleDateFormats();
        int n2 = stringArray.length;
        if (n < n2) {
            String format = stringArray[n];
            try {
                mandateSignDate = new SimpleDateFormat(format).parse(mandateSignDateString.value);
            }
            catch (ParseException e) {
                this.addError(flashMap, mandateSignDateString, lineNumber, "MANDATE_SIGNATURE", false);
                BLLoggerPlay.warning("Invalid mandate sign date string:" + e.getMessage());
                return null;
            }
        }
        if (debitType == null || debitType.value.isEmpty()) {
            this.addError(flashMap, debitType, lineNumber, "DEBIT_TYPE", true);
            BLLoggerPlay.warning("Recipients import: missing debit type in line " + lineNumber);
            return null;
        }
        SepaDebitType sepaDebitType = SepaDebitType.getByName((String)debitType.value);
        if (sepaDebitType == null) {
            this.addError(flashMap, debitType, lineNumber, "DEBIT_TYPE", false);
            BLLoggerPlay.warning("Recipients import: invalid debit type in line " + lineNumber);
            return null;
        }
        if (sequenceType == null || sequenceType.value.isEmpty()) {
            this.addError(flashMap, sequenceType, lineNumber, "SEQUENCE_TYPE", true);
            BLLoggerPlay.warning("Recipients import: missing sequence type in line " + lineNumber);
            return null;
        }
        SepaSequenceType sepaSequenceType = SepaSequenceType.getByName((String)sequenceType.value);
        if (sepaSequenceType == null) {
            this.addError(flashMap, sequenceType, lineNumber, "SEQUENCE_TYPE", false);
            BLLoggerPlay.warning("Recipients import: invalid sequence type in line " + lineNumber);
            return null;
        }
        String uniqueDisplayName = this.getDisplayNameValue(displayName, payee, PaymentType.MANDATE);
        PaymentRecipient paymentRecipient = new PaymentRecipient();
        paymentRecipient.setPaymentType(PaymentType.MANDATE);
        SepaMandateData data = new SepaMandateData();
        data.setPaymentRecipient(paymentRecipient);
        data.setDisplayName(uniqueDisplayName);
        data.setName(this.getValue(payer));
        data.setCreditorId(this.getValue(creditorId));
        data.setCreditor(this.getValue(payee));
        data.setAccountNumber(this.getValue(iban));
        data.setBankCode(this.getValue(bic));
        data.setPurpose(this.getValue(purpose));
        paymentRecipient.setSepaMandateId(mandateReference.value);
        data.setMandateSignDate(mandateSignDate);
        data.setMandateType(sepaDebitType);
        data.setSequenceType(sepaSequenceType);
        AddressData addressData = new AddressData();
        addressData.getAddressLines().add(this.getValue(debtorStreet));
        addressData.getAddressLines().add(this.getValue(debtorTown));
        addressData.setCountry(this.getValue(debtorCountry));
        data.setAddress(addressData);
        data.setTenant(this.tenant);
        return data;
    }

    private ValueWithCoulmnId getMt101ConvertedLineField(ValueWithCoulmnId element, int length) {
        if (element != null) {
            element.value = Mt101PaymentForm.convertToMt101StringFormat(element.value, length);
        }
        return element;
    }

    private MT101RecipientData validateMt101RecipientLine(String[] line, Map<String, String> formData, int lineNumber, boolean allowInvalidBankConnection, Map<String, String> flashMap) throws IOException {
        ValueWithCoulmnId displayName = this.getLineField(line, formData, "displayname");
        ValueWithCoulmnId name = this.getMt101ConvertedLineField(this.getLineField(line, formData, "name"), 35);
        ValueWithCoulmnId name2 = this.getMt101ConvertedLineField(this.getLineField(line, formData, "address1"), 35);
        ValueWithCoulmnId street = this.getMt101ConvertedLineField(this.getLineField(line, formData, "address2"), 35);
        ValueWithCoulmnId town = this.getMt101ConvertedLineField(this.getLineField(line, formData, "address3"), 35);
        ValueWithCoulmnId accountNumber = this.getLineField(line, formData, "iban");
        ValueWithCoulmnId bankCode = this.getLineField(line, formData, "bic");
        ValueWithCoulmnId purpose1 = this.getMt101ConvertedLineField(this.getLineField(line, formData, "purpose1"), 35);
        ValueWithCoulmnId purpose2 = this.getMt101ConvertedLineField(this.getLineField(line, formData, "purpose2"), 35);
        ValueWithCoulmnId purpose3 = this.getMt101ConvertedLineField(this.getLineField(line, formData, "purpose3"), 35);
        ValueWithCoulmnId purpose4 = this.getMt101ConvertedLineField(this.getLineField(line, formData, "purpose4"), 35);
        if (name == null || name.value.isEmpty()) {
            this.addError(flashMap, name, lineNumber, "RECIPIENT_NAME", true);
            BLLoggerPlay.warning("MT101 recipients import: missing name in line " + lineNumber);
            return null;
        }
        if (!RegularExpressions.SWIFT.matches(name.value)) {
            this.addError(flashMap, name, lineNumber, "RECIPIENT_NAME", false);
            BLLoggerPlay.warning("MT101 recipients import: invalid name in line " + lineNumber);
            return null;
        }
        if (name2 != null && name2.value.isEmpty() && !RegularExpressions.SWIFT.matches(name2.value)) {
            this.addError(flashMap, name, lineNumber, "RECIPIENT_NAME2", false);
            BLLoggerPlay.warning("Recipients import: invalid name 2 in line " + lineNumber);
            return null;
        }
        if (street != null && street.value.isEmpty() && !RegularExpressions.SWIFT.matches(street.value)) {
            this.addError(flashMap, name, lineNumber, "STREET", false);
            BLLoggerPlay.warning("MT101 recipients import: invalid street in line " + lineNumber);
            return null;
        }
        if (town != null && town.value.isEmpty() && !RegularExpressions.SWIFT.matches(town.value)) {
            this.addError(flashMap, name, lineNumber, "RECIPIENT_TOWN", false);
            BLLoggerPlay.warning("MT101 recipients import: invalid town in line " + lineNumber);
            return null;
        }
        if (accountNumber == null || accountNumber.value.isEmpty()) {
            this.addError(flashMap, accountNumber, lineNumber, "RECIPIENT_IBAN", true);
            BLLoggerPlay.warning("MT101 recipients import: missing account number in line " + lineNumber);
            return null;
        }
        if (accountNumber.value.length() > 34 || !RegularExpressions.SWIFT.matches(accountNumber.value) || !allowInvalidBankConnection && RegularExpressions.IBAN.matches(accountNumber.value) && !IbanUtil.checkIban((String)accountNumber.value)) {
            this.addError(flashMap, accountNumber, lineNumber, "RECIPIENT_IBAN", false);
            BLLoggerPlay.warning("MT101 recipients import: invalid account number in line " + lineNumber);
            return null;
        }
        if (bankCode == null || bankCode.value.isEmpty()) {
            this.addError(flashMap, bankCode, lineNumber, "RECIPIENT_BIC", true);
            BLLoggerPlay.warning("MT101 recipients import: missing bank code in line " + lineNumber);
            return null;
        }
        if (bankCode.value.length() > 34 || !RegularExpressions.SWIFT.matches(bankCode.value)) {
            this.addError(flashMap, bankCode, lineNumber, "RECIPIENT_BIC", false);
            BLLoggerPlay.warning("MT101 recipients import: invalid bank code in line " + lineNumber);
            return null;
        }
        if (purpose1 != null && purpose1.value.isEmpty() && !RegularExpressions.SWIFT.matches(purpose1.value)) {
            this.addError(flashMap, purpose1, lineNumber, "PURPOSE1", false);
            BLLoggerPlay.warning("MT101 recipients import: invalid purpose 1 in line " + lineNumber);
            return null;
        }
        if (purpose2 != null && purpose2.value.isEmpty() && !RegularExpressions.SWIFT.matches(purpose2.value)) {
            this.addError(flashMap, purpose2, lineNumber, "PURPOSE2", false);
            BLLoggerPlay.warning("MT101 recipients import: invalid purpose 2 in line " + lineNumber);
            return null;
        }
        if (purpose3 != null && purpose3.value.isEmpty() && !RegularExpressions.SWIFT.matches(purpose3.value)) {
            this.addError(flashMap, purpose3, lineNumber, "PURPOSE3", false);
            BLLoggerPlay.warning("MT101 recipients import: invalid purpose 3 in line " + lineNumber);
            return null;
        }
        if (purpose4 != null && purpose4.value.isEmpty() && !RegularExpressions.SWIFT.matches(purpose4.value)) {
            this.addError(flashMap, purpose4, lineNumber, "PURPOSE4", false);
            BLLoggerPlay.warning("MT101 recipients import: invalid purpose 4 in line " + lineNumber);
            return null;
        }
        String uniqueDisplayName = this.getDisplayNameValue(displayName, name, PaymentType.MT101);
        PaymentRecipient paymentRecipient = new PaymentRecipient();
        paymentRecipient.setPaymentType(PaymentType.MT101);
        MT101RecipientData result = new MT101RecipientData();
        result.setPaymentRecipient(paymentRecipient);
        result.setDisplayName(uniqueDisplayName);
        result.setName(name.value);
        result.setName2(this.getValue(name2));
        result.setStreet(this.getValue(street));
        result.setTown(this.getValue(town));
        result.setAccountNumber(accountNumber.value);
        result.setBankCode(this.getValue(bankCode));
        result.setPurpose1(this.getValue(purpose1));
        result.setPurpose2(this.getValue(purpose2));
        result.setPurpose3(this.getValue(purpose3));
        result.setPurpose4(this.getValue(purpose4));
        result.setTenant(this.tenant);
        return result;
    }

    private ValueWithCoulmnId getLineField(String[] line, Map<String, String> formData, String fieldName) {
        int column = -1;
        try {
            String columnString = formData.get(fieldName);
            if (columnString != null && !columnString.isEmpty()) {
                column = Integer.parseInt(columnString);
            }
        }
        catch (NumberFormatException e) {
            BLLoggerPlay.error("Error in recipient import form!", e);
        }
        if (column < 0 && fieldName != null) {
            return new ValueWithCoulmnId(formData.get(fieldName + "_fix"));
        }
        if (line == null || column >= line.length || line[column] == null || line[column].isEmpty()) {
            return null;
        }
        return new ValueWithCoulmnId(line[column], column + 1);
    }

    static {
        for (ClearingSystem c : ClearingSystem.values()) {
            clearingSystems.add(c.name());
        }
        Collections.addAll(payOffModes, PostbarPurpose.PayOffMode.values());
    }

    private static final class Id {
        public static final String DISPLAY_NAME = "displayname";
        public static final String RECIPIENTS_NAME = "name";
        public static final String RECIPIENTS_NAME_MANDATE = "payee";
        public static final String IBAN = "iban";
        public static final String BIC = "bic";
        public static final String PURPOSE = "purpose";
        public static final String ADDRESS = "address";
        public static final String COUNTRY = "country";
        public static final String MT101_ADDRESS_1 = "address1";
        public static final String MT101_ADDRESS_2 = "address2";
        public static final String MT101_ADDRESS_3 = "address3";
        public static final String MT101_PURPOSE_1 = "purpose1";
        public static final String MT101_PURPOSE_2 = "purpose2";
        public static final String MT101_PURPOSE_3 = "purpose3";
        public static final String MT101_PURPOSE_4 = "purpose4";
        public static final String CREDITOR_ID = "creditorid";
        public static final String PAYER = "payer";
        public static final String MANDATE_REFERENCE = "mandatereference";
        public static final String MANDATE_SIGN_DATE = "mandatesigndate";
        public static final String DEBIT_TYPE = "debittype";
        public static final String SEQUENCE_TYPE = "sequencetype";
        public static final String RECIPIENTS_NAME_2 = "name2";
        public static final String STREET = "street";
        public static final String TOWN = "town";
        public static final String BANK_NAME = "bankname";
        public static final String BANK_NAME_2 = "bankname2";
        public static final String BANK_STREET = "bankstreet";
        public static final String BANK_TOWN = "banktown";
        public static final String BANK_COUNTRY = "bankcountry";
        public static final String BANK_ADDRESS = "bankaddress";
        public static final String CLEARING_SYSTEM = "clearingsystem";
        public static final String NO_FORWARD = "noforward";
        public static final String IN_PERSON = "inperson";
        public static final String PAYMENT_MODE = "paymentmode";
        public static final String SMS_NUMBER = "smsnumber";
        public static final String CASH_REFERENCE = "cashreference";
        public static final String POSTAL_CODE = "postalcode";
        public static final String POSTAL_CODE_POST_OFFICE = "postalcodepostoffice";
        public static final String DEPARTMENT = "department";
        public static final String SUB_DEPARTMENT = "subdepartment";
        public static final String SUB_COUNTRY = "subcountry";
        public static final String BUILDINGNUMBER = "buildingnumber";
        public static final String BANK_DEPARTMENT = "bankdepartment";
        public static final String BANK_SUB_DEPARTMENT = "banksubdepartment";
        public static final String BANK_SUB_COUNTRY = "banksubcountry";
        public static final String BANK_BUILDINGNUMBER = "bankbuildingnumber";
        public static final String BANK_POSTAL_CODE = "bankpostalcode";

        private Id() {
        }
    }

    private static final class ValueWithCoulmnId {
        public String value;
        public int column = -1;

        public ValueWithCoulmnId(String val, int col) {
            this.value = val;
            this.column = col;
        }

        public ValueWithCoulmnId(String val) {
            this.value = val;
        }

        public boolean hasCol() {
            return this.column > -1;
        }
    }
}

