/*
 * Decompiled with CFR 0.152.
 */
package models;

import controllers.Recipients;
import controllers.util.SortingHandler;
import de.businesslogics.banking.database.vo.PaymentRecipient;
import de.businesslogics.banking.database.vo.Sorting;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.banking.payments.api.PreferenceUtil;
import java.io.IOException;
import play.data.Form;
import play.data.validation.Constraints;
import play.i18n.Messages;

public abstract class RecipientForm {
    @Constraints.Required
    public String displayName;
    @Constraints.Required
    public String name;
    public Integer id;
    public Integer tenantId;

    public static boolean isFieldEnabled(String fieldName, User loggedInUser, Integer recipientDatabaseId) {
        boolean isNewRecipient = recipientDatabaseId == null;
        boolean editable = isNewRecipient || Recipients.isRecipientEditable(loggedInUser, recipientDatabaseId);
        return RecipientForm.isFieldEnabled(fieldName, loggedInUser, editable);
    }

    public static boolean isFieldEnabled(String fieldName, User loggedInUser, boolean editable) {
        if ("country".equals(fieldName) || "bankCountry".equals(fieldName)) {
            return editable && !PreferenceUtil.disableRecipientRecording((User)loggedInUser);
        }
        return editable;
    }

    public abstract Form<? extends RecipientForm> validate(Form<? extends RecipientForm> var1, Messages var2, User var3);

    public abstract void store(PaymentRecipient var1, User var2) throws IOException;

    public void loadDefaultFormSettings(User user) {
        String tenantIdString = new SortingHandler(user, Sorting.Table.PMT_RECIPIENT).getProperty("TENANT");
        if (tenantIdString != null) {
            try {
                this.tenantId = Integer.parseInt(tenantIdString);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

