/*
 * Decompiled with CFR 0.152.
 */
package models;

import controllers.util.BLLoggerPlay;
import de.businesslogics.banking.api.BankUtils;
import de.businesslogics.banking.api.KeyUtil;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.database.vo.BankUser;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.ebics.schema.types.ProtocolVersion;
import de.businesslogics.ebics.schema.types.SignatureVersion;
import de.businesslogics.util.StringUtils;
import de.businesslogics.validation.RegularExpressions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import models.PasswordForm;
import play.data.validation.Constraints;
import play.data.validation.ValidationError;
import play.libs.Scala;
import scala.Tuple2;
import scala.collection.immutable.Seq;

@Constraints.Validate
public class ReIniForm
extends PasswordForm
implements Constraints.Validatable<List<ValidationError>> {
    @Constraints.Required
    public String userId;
    @Constraints.Required
    public SignatureVersion signatureVersion = SignatureVersion.A006;
    @Constraints.Min(value=2048L)
    @Constraints.Max(value=4096L)
    @Constraints.Required
    public @Constraints.Min(value=2048L) @Constraints.Max(value=4096L) @Constraints.Required int sigKeyLength = 2048;
    @Constraints.Min(value=2048L)
    @Constraints.Max(value=4096L)
    @Constraints.Required
    public @Constraints.Min(value=2048L) @Constraints.Max(value=4096L) @Constraints.Required int authKeyLength = 2048;
    @Constraints.Min(value=2048L)
    @Constraints.Max(value=4096L)
    @Constraints.Required
    public @Constraints.Min(value=2048L) @Constraints.Max(value=4096L) @Constraints.Required int encKeyLength = 2048;

    public static Seq<Tuple2<String, String>> signatureVersions(BankSettings bank) {
        List<SignatureVersion> versions;
        if (bank == null) {
            versions = Arrays.asList(SignatureVersion.A005, SignatureVersion.A006);
        } else {
            ProtocolVersion protocolVersion = ProtocolVersion.getInstance((String)bank.getProtocolVersion());
            versions = new KeyUtil(protocolVersion).getAvailableSignatureVersions();
        }
        ArrayList<Tuple2> toReturn = new ArrayList<Tuple2>();
        for (SignatureVersion version : versions) {
            toReturn.add(new Tuple2((Object)version.getValue(), (Object)version.getValue()));
        }
        return Scala.toSeq(toReturn);
    }

    public List<ValidationError> validate() {
        this.userId = StringUtils.trimAndUpperCase((String)this.userId);
        BLLoggerPlay.info("User ID: '" + this.userId + "'");
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        if (this.userId != null && this.userId.length() > 0 && !StringUtils.check((String)this.userId, (RegularExpressions)RegularExpressions.EBICS_V24_USER_ID)) {
            errors.add(new ValidationError("userId", "general.error.invalidCharacters"));
        }
        return errors.isEmpty() ? null : errors;
    }

    public static ReIniForm fill(BankUser bankUser) {
        ReIniForm form = new ReIniForm();
        form.userId = bankUser.getDefaultUser();
        if (BankUtils.getSignatureVersion((BankUser)bankUser) != null) {
            form.signatureVersion = BankUtils.getSignatureVersion((BankUser)bankUser);
        }
        form.sigKeyLength = bankUser.getSigKeyLength() != 0 ? bankUser.getSigKeyLength() : 2048;
        form.encKeyLength = bankUser.getEncrKeyLength() != 0 ? bankUser.getEncrKeyLength() : 2048;
        form.authKeyLength = bankUser.getAuthKeyLength() != 0 ? bankUser.getAuthKeyLength() : 2048;
        return form;
    }

    public BankUser createTemporaryBankUser(User user, BankSettings bank, BankUser bankUser) {
        BankUser b = new BankUser();
        b.setBank(bank);
        b.setUser(user);
        b.setDefaultUser(this.userId);
        b.setAuthKeyLength(this.authKeyLength);
        b.setEncrKeyLength(this.encKeyLength);
        b.setSigKeyLength(this.sigKeyLength);
        b.setSignatureVersion(this.signatureVersion.getValue());
        b.setState(BankUser.UserState.CREATED);
        if (bankUser != null) {
            b.setId(bankUser.getId());
            b.setOrderNumber(bankUser.getOrderNumber());
            b.setSepaMessageId(bankUser.getSepaMessageId());
            b.setDtausReferenceNumber(bankUser.getDtausReferenceNumber());
            b.setBundesbankFileNumber(bankUser.getBundesbankFileNumber());
        }
        if (bank != null) {
            b.setWithCerts(bank.isFrenchBank() || BankUtils.isProtocolH005OrNewer((String)bank.getProtocolVersion()));
        }
        return b;
    }
}

