/*
 * Decompiled with CFR 0.152.
 */
package models;

import controllers.util.EbicsUtil;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.database.vo.BankUser;
import de.businesslogics.ebics.client.EbicsSession;
import de.businesslogics.ebics.schema.response.EbicsException;
import de.businesslogics.ebics.schema.types.ProtocolVersion;
import de.businesslogics.ebics.security.AuthenticationHandler;
import de.businesslogics.ebics.security.EncryptionHandler;
import de.businesslogics.util.HexTool;
import de.businesslogics.validation.RegularExpressions;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.List;
import play.data.validation.Constraints;
import play.data.validation.ValidationError;

@Constraints.Validate
public class ProtocolVersionForm
implements Constraints.Validatable<List<ValidationError>> {
    private String encHash;
    private String authHash;

    public List<ValidationError> validate() {
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        if (this.encHash != null && this.encHash.length() > 0) {
            if (this.isNotHexString(this.encHash)) {
                errors.add(new ValidationError("encHash", "bankdetails.hash.hexValue"));
            }
            if (this.encHash.length() % 2 != 0) {
                errors.add(new ValidationError("encHash", "bankdetails.hash.oddNumber"));
            }
        }
        if (this.authHash != null && this.authHash.length() > 0) {
            if (this.isNotHexString(this.authHash)) {
                errors.add(new ValidationError("authHash", "bankdetails.hash.hexValue"));
            }
            if (this.authHash.length() % 2 != 0) {
                errors.add(new ValidationError("authHash", "bankdetails.hash.oddNumber"));
            }
        }
        return errors.isEmpty() ? null : errors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ProtocolVersionForm fill(BankUser bankUser) throws GeneralSecurityException, IOException, EbicsException {
        ProtocolVersionForm form = new ProtocolVersionForm();
        BankSettings bank = bankUser.getBank();
        ProtocolVersion current = ProtocolVersion.getInstance((String)bank.getProtocolVersion());
        try {
            bank.setProtocolVersion(ProtocolVersion.H003.getValue());
            EbicsSession ebicsSession = EbicsUtil.getEbicsWorker(bankUser).getEbicsSession();
            EncryptionHandler e002Handler = EncryptionHandler.getInstance((ProtocolVersion)ProtocolVersion.H003);
            AuthenticationHandler x002Handler = AuthenticationHandler.getInstance((ProtocolVersion)ProtocolVersion.H003);
            form.encHash = HexTool.toHex((byte[])e002Handler.getHash(ebicsSession.getBankEncrKey()));
            form.authHash = HexTool.toHex((byte[])x002Handler.getHash(ebicsSession.getBankAuthKey()));
        }
        finally {
            bank.setProtocolVersion(current.getValue());
            bank.save();
        }
        return form;
    }

    public String getEncHash() {
        return this.encHash;
    }

    public void setEncHash(String encHash) {
        this.encHash = encHash;
    }

    public String getAuthHash() {
        return this.authHash;
    }

    public void setAuthHash(String authHash) {
        this.authHash = authHash;
    }

    private boolean isNotHexString(String toTest) {
        return !RegularExpressions.HEX_STRING.getPattern().matcher(toTest).matches();
    }
}

