/*
 * Decompiled with CFR 0.152.
 */
package models;

import controllers.util.TenantUtils;
import de.businesslogics.banking.api.BankingApiMessages;
import de.businesslogics.banking.database.vo.PaymentRecipient;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.banking.payments.api.PreferenceUtil;
import de.businesslogics.banking.sepa.api.PostbarRecipientData;
import de.businesslogics.format.sepa.at.PostbarPurpose;
import de.businesslogics.validation.RegularExpressions;
import java.io.IOException;
import java.util.Locale;
import models.RecipientForm;
import play.data.Form;
import play.data.validation.Constraints;
import play.i18n.Messages;

public class PostbarRecipientForm
extends RecipientForm {
    public String address1;
    public String address2;
    @Constraints.Required
    public String plz;
    public boolean noForward;
    public boolean inPerson;
    public String payOffMode;
    public String smsNumber;
    public String postPlz;
    public String purpose;
    public String postbarReference;

    public PostbarRecipientForm() {
    }

    public PostbarRecipientForm(PaymentRecipient paymentRecipient) {
        PostbarRecipientData recipient = new PostbarRecipientData();
        try {
            recipient.setPaymentRecipient(paymentRecipient);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.id = paymentRecipient.getId();
        this.displayName = recipient.getDisplayName();
        this.name = recipient.getName();
        this.tenantId = recipient.getTenant().getId();
        this.address1 = recipient.getAddress1();
        this.address2 = recipient.getAddress2();
        this.plz = recipient.getPlz();
        this.noForward = !recipient.isForward();
        this.inPerson = recipient.isInPerson();
        this.payOffMode = recipient.getPayOffMode().name();
        this.smsNumber = recipient.getSmsNumber();
        this.postPlz = recipient.getPostPlz();
        this.purpose = recipient.getPurpose();
        this.postbarReference = recipient.getReference();
    }

    @Override
    public Form<? extends RecipientForm> validate(Form<? extends RecipientForm> form, Messages messages, User user) {
        PostbarPurpose.PayOffMode mode;
        String tenantError = TenantUtils.checkTenantId(this.tenantId, user);
        if (tenantError != null) {
            form = form.withError("tenantId", tenantError);
        }
        if (!RegularExpressions.SEPA_GUI.matches(this.name) || this.name.length() > 70) {
            form = form.withError("name", messages.at("error.invalid", new Object[0]));
        }
        if (!(this.purpose == null || RegularExpressions.SEPA_GUI.matches(this.purpose) && this.purpose.length() <= 140)) {
            form = form.withError("purpose", messages.at("error.invalid", new Object[0]));
        }
        if (!(this.address1 == null || RegularExpressions.SEPA_GUI.matches(this.address1) && this.address1.trim().length() <= 50)) {
            form = form.withError("address1", messages.at("error.invalid", new Object[0]));
        }
        if (!(this.address2 == null || RegularExpressions.SEPA_GUI.matches(this.address2) && this.address2.trim().length() <= 50)) {
            form = form.withError("address2", messages.at("error.invalid", new Object[0]));
        }
        if (this.plz == null || !RegularExpressions.DIGITS.matches(this.plz) || this.plz.length() != 4) {
            form = form.withError("plz", BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.plz.wrong", (Object[])new Object[0]));
        }
        if (!((mode = PostbarPurpose.PayOffMode.valueOf((String)this.payOffMode)) != PostbarPurpose.PayOffMode.PayOffPostPlz || this.postPlz != null && RegularExpressions.DIGITS.matches(this.postPlz) && this.postPlz.length() == 4)) {
            form = form.withError("postPlz", BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.payoffMode.PayOffPostPlz.wrong", (Object[])new Object[0]));
        } else if (!(mode != PostbarPurpose.PayOffMode.PayOffSms || this.smsNumber != null && RegularExpressions.DIGITS.matches(this.smsNumber) && this.smsNumber.length() >= 9 && this.smsNumber.length() <= 11)) {
            form = form.withError("smsNumber", BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.payoffMode.PayOffSms.wrong", (Object[])new Object[0]));
        }
        if (this.postbarReference == null || !RegularExpressions.SEPA_GUI.matches(this.postbarReference) || this.postbarReference.length() > 35) {
            form = form.withError("plz", messages.at("error.invalid", new Object[0]));
        }
        return form;
    }

    @Override
    public void store(PaymentRecipient paymentRecipient, User user) throws IOException {
        PostbarRecipientData recipientData = new PostbarRecipientData();
        recipientData.setPaymentRecipient(paymentRecipient);
        if (PostbarRecipientForm.isFieldEnabled("displayName", user, paymentRecipient.getId())) {
            recipientData.setDisplayName(this.displayName);
        }
        if (PostbarRecipientForm.isFieldEnabled("name", user, paymentRecipient.getId())) {
            recipientData.setName(this.name);
        }
        if (PostbarRecipientForm.isFieldEnabled("address1", user, paymentRecipient.getId())) {
            recipientData.setAddress1(this.address1);
        }
        if (PostbarRecipientForm.isFieldEnabled("address2", user, paymentRecipient.getId())) {
            recipientData.setAddress2(this.address2);
        }
        if (PostbarRecipientForm.isFieldEnabled("plz", user, paymentRecipient.getId())) {
            recipientData.setPlz(this.plz);
        }
        if (PostbarRecipientForm.isFieldEnabled("noForward", user, paymentRecipient.getId())) {
            recipientData.setForward(!this.noForward);
        }
        if (PostbarRecipientForm.isFieldEnabled("inPerson", user, paymentRecipient.getId())) {
            recipientData.setInPerson(this.inPerson);
        }
        PostbarPurpose.PayOffMode payOffModeValue = recipientData.getPayOffMode();
        if (PostbarRecipientForm.isFieldEnabled("payOffMode", user, paymentRecipient.getId())) {
            payOffModeValue = PostbarPurpose.PayOffMode.valueOf((String)this.payOffMode);
            recipientData.setPayOffMode(payOffModeValue);
        }
        if (PostbarRecipientForm.isFieldEnabled("smsNumber", user, paymentRecipient.getId())) {
            if (PostbarPurpose.PayOffMode.PayOffSms.equals((Object)payOffModeValue)) {
                recipientData.setSmsNumber(this.smsNumber);
            } else {
                recipientData.setSmsNumber(null);
            }
        }
        if (PostbarRecipientForm.isFieldEnabled("postPlz", user, paymentRecipient.getId())) {
            if (PostbarPurpose.PayOffMode.PayOffPostPlz.equals((Object)payOffModeValue)) {
                recipientData.setPostPlz(this.postPlz);
            } else {
                recipientData.setPostPlz(null);
            }
        }
        if (PostbarRecipientForm.isFieldEnabled("purpose", user, paymentRecipient.getId())) {
            recipientData.setPurpose(this.purpose);
        }
        if (PostbarRecipientForm.isFieldEnabled("postbarReference", user, paymentRecipient.getId())) {
            recipientData.setReference(this.postbarReference);
        }
        if (PostbarRecipientForm.isFieldEnabled("tenantId", user, paymentRecipient.getId())) {
            recipientData.setTenant(TenantUtils.getTenantByIdAndUser(this.tenantId, user));
        }
        recipientData.save(user, PreferenceUtil.useFourEyesForRecipientRecording((User)user));
    }

    @Override
    public void loadDefaultFormSettings(User user) {
        super.loadDefaultFormSettings(user);
        this.inPerson = true;
    }
}

