/*
 * Decompiled with CFR 0.152.
 */
package models;

import controllers.branding.Branding;
import controllers.util.BLLoggerPlay;
import de.businesslogics.banking.api.BankingApiMessages;
import de.businesslogics.banking.database.vo.PaymentFolder;
import de.businesslogics.banking.database.vo.PaymentRecipient;
import de.businesslogics.banking.database.vo.PaymentTransferType;
import de.businesslogics.banking.database.vo.PaymentType;
import de.businesslogics.banking.database.vo.Tenant;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.banking.payments.api.PreferenceUtil;
import de.businesslogics.banking.sepa.api.PostbarRecipientData;
import de.businesslogics.format.sepa.SEPAPaymentData;
import de.businesslogics.format.sepa.at.PostbarPurpose;
import de.businesslogics.validation.RegularExpressions;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import models.PaymentForm;
import models.SepaPaymentForm;
import models.payments.PaymentContextType;
import models.payments.PaymentException;
import play.data.Form;
import play.data.FormFactory;
import play.data.validation.Constraints;
import play.i18n.Messages;
import play.libs.Scala;
import scala.Tuple2;
import scala.collection.immutable.Seq;

public class PostbarPaymentForm
extends SepaPaymentForm {
    public static final int MAX_LENGTH_ADDRESS_LINE = 50;
    public static final int LENGTH_PLZ = 4;
    public static final int MIN_LENGTH_SMS_NUMBER = 9;
    public static final int MAX_LENGTH_SMS_NUMBER = 11;
    public static final String RECIPIENT = "BAWAGPSK";
    public static final String RECIPIENT_ACCOUNT = "AT846000000011471508";
    public static final String PAYMENT_CATEGORY = "CPPP";
    public static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyyMMdd");
    public String address1;
    public String address2;
    @Constraints.Required
    public String plz;
    public boolean earliestPayment;
    public Date earliestPaymentDate;
    public boolean storeUntil;
    public Date storeUntilDate;
    public boolean noForward;
    public boolean inPerson;
    public String payOffMode;
    public String smsNumber;
    public String postPlz;
    public String purposePart;

    public static PaymentTransferType.PmtType[] getPmtTypes() {
        return new PaymentTransferType.PmtType[]{PaymentTransferType.PmtType.AUSTRIAN_POSTBAR_PAYMENT};
    }

    public static boolean isPostbarPmtType(PaymentTransferType.PmtType pmtType) {
        return PaymentTransferType.PmtType.AUSTRIAN_POSTBAR_PAYMENT.equals((Object)pmtType);
    }

    public static int getRecipientsCount(User user) {
        return PaymentRecipient.countRecipientsForPaymentTypes(Collections.singletonList(PaymentType.AUSTRIAN_POSTBAR), (List)user.getTenants());
    }

    public static List<PostbarRecipientData> loadRecipients(User user) {
        ArrayList<PostbarRecipientData> result = new ArrayList<PostbarRecipientData>();
        for (PaymentRecipient paymentRecipient : PaymentRecipient.findRecipientsForPaymentType((PaymentType)PaymentType.AUSTRIAN_POSTBAR, (List)user.getTenants())) {
            PostbarRecipientData postbarRecipientData = new PostbarRecipientData();
            try {
                postbarRecipientData.setPaymentRecipient(paymentRecipient);
                result.add(postbarRecipientData);
            }
            catch (IOException e) {
                BLLoggerPlay.error("Failed to load recipient with ID " + paymentRecipient.getId(), e);
            }
        }
        result.sort((o1, o2) -> {
            if (o1 == null && o2 == null) {
                return 0;
            }
            if (o1 == null) {
                return 1;
            }
            if (o2 == null) {
                return -1;
            }
            return o1.getDisplayName().compareTo(o2.getDisplayName());
        });
        return result;
    }

    public static Seq<Tuple2<String, String>> payOffModeOptions(Messages messages) {
        ArrayList<Tuple2> result = new ArrayList<Tuple2>();
        for (PostbarPurpose.PayOffMode mode : PostbarPurpose.PayOffMode.values()) {
            result.add(new Tuple2((Object)mode.name(), (Object)BankingApiMessages.getString((Locale)messages.lang().locale(), (String)("GeneralMessages.payoffMode." + mode.name()), (Object[])new Object[0])));
        }
        return Scala.toSeq(result);
    }

    public static boolean isFieldEnabled(String fieldName, User operator) {
        boolean allowRecipientRecording = PreferenceUtil.allowUnrestrictedRecipientRecording((User)operator);
        if ("address1".equals(fieldName) || "address2".equals(fieldName) || "plz".equals(fieldName)) {
            return allowRecipientRecording;
        }
        return true;
    }

    public PostbarPaymentForm() {
    }

    public PostbarPaymentForm(PaymentContextType paymentContextType, PaymentTransferType.PmtType pmtType, User user, PaymentFolder folder, boolean saveRecipient) throws PaymentException {
        super(paymentContextType, pmtType, user, folder, false, saveRecipient);
    }

    public PostbarPaymentForm(Object databaseVO, boolean displaySalaries, boolean allowRecipientRecording, boolean saveRecipient) throws PaymentException {
        super(databaseVO, displaySalaries, allowRecipientRecording, false, saveRecipient);
    }

    public PostbarPaymentForm(Object dsOrder, SEPAPaymentData sepaPaymentData, boolean displaySalaries, boolean allowRecipientRecording, boolean saveRecipient) throws PaymentException {
        super(dsOrder, sepaPaymentData, displaySalaries, allowRecipientRecording, false, saveRecipient);
    }

    @Override
    protected PaymentType getPaymentType(User user) {
        return PaymentType.AUSTRIAN_POSTBAR;
    }

    @Override
    protected Form<? extends PaymentForm> loadSelectedRecipient(Form<? extends PaymentForm> form, User user, Tenant tenant) {
        List paymentRecipients;
        if (this.ultimateRecipient == null || this.ultimateRecipient.length() == 0) {
            return form.withError("ultimateRecipient", "error.required");
        }
        PaymentRecipient paymentRecipient = PaymentRecipient.findRecipientByDisplayName((PaymentType)PaymentType.AUSTRIAN_POSTBAR, (String)this.ultimateRecipient, (Tenant)tenant);
        if (paymentRecipient == null && (paymentRecipients = PaymentRecipient.findRecipientByName((PaymentType)PaymentType.AUSTRIAN_POSTBAR, (String)this.ultimateRecipient, (Tenant)tenant)).size() == 1) {
            paymentRecipient = (PaymentRecipient)paymentRecipients.get(0);
        }
        if (paymentRecipient == null) {
            return form.withError("ultimateRecipient", "error.recipientNotFound");
        }
        this.ultimateRecipient = paymentRecipient.getName();
        try {
            PostbarRecipientData postbarRecipientData = new PostbarRecipientData();
            postbarRecipientData.setPaymentRecipient(paymentRecipient);
            this.address1 = postbarRecipientData.getAddress1();
            this.address2 = postbarRecipientData.getAddress2();
            this.plz = postbarRecipientData.getPlz();
            this.noForward = !postbarRecipientData.isForward();
            this.inPerson = postbarRecipientData.isInPerson();
            PostbarPurpose.PayOffMode payOffMode = postbarRecipientData.getPayOffMode();
            this.payOffMode = payOffMode.name();
            this.smsNumber = PostbarPurpose.PayOffMode.PayOffSms.equals((Object)payOffMode) ? postbarRecipientData.getSmsNumber() : null;
            this.postPlz = PostbarPurpose.PayOffMode.PayOffPostPlz.equals((Object)payOffMode) ? postbarRecipientData.getPostPlz() : null;
        }
        catch (IOException e) {
            BLLoggerPlay.warning("Failed to load Postbar recipient!", e);
        }
        return form;
    }

    @Override
    protected PaymentTransferType.PmtType getInternalPmtType() {
        return PaymentTransferType.PmtType.AUSTRIAN_POSTBAR_PAYMENT;
    }

    @Override
    protected Form<? extends PaymentForm> reloadFormInternal(FormFactory formFactory) {
        return formFactory.form(PostbarPaymentForm.class).fill((Object)this);
    }

    @Override
    protected Form<? extends PaymentForm> validateSEPASpecialisation(Form<? extends PaymentForm> form, FormFactory formFactory, Messages messages) {
        PostbarPurpose.PayOffMode mode;
        this.recipientName = RECIPIENT;
        this.recipientAccount = RECIPIENT_ACCOUNT;
        this.paymentCategory = PAYMENT_CATEGORY;
        if (!(this.address1 == null || RegularExpressions.SEPA_GUI.matches(this.address1) && this.address1.trim().length() <= 50)) {
            form = form.withError("address1", messages.at("error.invalid", new Object[0]));
        }
        if (!(this.address2 == null || RegularExpressions.SEPA_GUI.matches(this.address2) && this.address2.trim().length() <= 50)) {
            form = form.withError("address2", messages.at("error.invalid", new Object[0]));
        }
        if (this.plz == null || !RegularExpressions.DIGITS.matches(this.plz) || this.plz.length() != 4) {
            form = form.withError("plz", BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.plz.wrong", (Object[])new Object[0]));
        }
        if (Branding.getBranding().isPurposeMandatory() && (this.purposePart == null || this.purposePart.isEmpty())) {
            form = form.withError("purposePart", messages.at("error.required", new Object[0]));
        }
        if (this.purposePart != null && !RegularExpressions.SEPA_GUI.matches(this.purposePart)) {
            form = form.withError("purposePart", messages.at("error.invalid", new Object[0]));
        }
        if (!((mode = PostbarPurpose.PayOffMode.valueOf((String)this.payOffMode)) != PostbarPurpose.PayOffMode.PayOffPostPlz || this.postPlz != null && RegularExpressions.DIGITS.matches(this.postPlz) && this.postPlz.length() == 4)) {
            form = form.withError("postPlz", BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.payoffMode.PayOffPostPlz.wrong", (Object[])new Object[0]));
        } else if (!(mode != PostbarPurpose.PayOffMode.PayOffSms || this.smsNumber != null && RegularExpressions.DIGITS.matches(this.smsNumber) && this.smsNumber.length() >= 9 && this.smsNumber.length() <= 11)) {
            form = form.withError("smsNumber", BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.payoffMode.PayOffSms.wrong", (Object[])new Object[0]));
        }
        String earliest = this.earliestPayment ? DATE_FORMAT.format(this.earliestPaymentDate) : null;
        String store = this.storeUntil && this.storeUntilDate != null ? DATE_FORMAT.format(this.storeUntilDate) : null;
        PostbarPurpose postbarPurpose = new PostbarPurpose(this.address1, this.address2, this.plz, earliest, this.noForward, this.inPerson, store, mode, this.smsNumber, this.postPlz, this.purposePart);
        this.purpose = postbarPurpose.getTotalPurpose();
        if (this.purpose != null && this.purpose.length() > 140) {
            form = form.withError("purposePart", messages.at("postbarpayment.purpose.tooLong", new Object[]{this.purpose.length() - 140}));
        }
        return form;
    }

    @Override
    protected void loadSEPASpecialisationInfo() {
        PostbarPurpose postbarPurpose = PostbarPurpose.getPostbarPurpose((String)this.purpose);
        if (postbarPurpose != null) {
            this.address1 = postbarPurpose.getAddress1();
            this.address2 = postbarPurpose.getAddress2();
            this.plz = postbarPurpose.getPlz();
            this.noForward = postbarPurpose.isNoForward();
            this.inPerson = postbarPurpose.isInPerson();
            this.payOffMode = postbarPurpose.getPayOffMode().name();
            this.smsNumber = postbarPurpose.getSmsNumber();
            this.postPlz = postbarPurpose.getPostPLZ();
            this.purposePart = postbarPurpose.getPurpose();
            if (postbarPurpose.getEarliestDate() != null) {
                this.earliestPayment = true;
                try {
                    this.earliestPaymentDate = DATE_FORMAT.parse(postbarPurpose.getEarliestDate());
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
            if (postbarPurpose.getStoreDate() != null && !postbarPurpose.getStoreDate().isEmpty()) {
                this.storeUntil = true;
                try {
                    this.storeUntilDate = DATE_FORMAT.parse(postbarPurpose.getStoreDate());
                }
                catch (ParseException e) {
                    BLLoggerPlay.error("Could not parse 'store until' date for postbar payment! " + e.getMessage());
                    this.storeUntil = false;
                }
            }
        }
    }
}

