/*
 * Decompiled with CFR 0.152.
 */
package models;

import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.database.vo.CmPdfStatement;
import de.businesslogics.banking.database.vo.FilterComparator;
import de.businesslogics.banking.database.vo.PdfStatementsFilter;
import de.businesslogics.banking.database.vo.User;
import java.util.Date;
import play.data.Form;

public final class PdfStatementFilterForm {
    public Integer bank;
    public Integer account;
    public Integer dateComparator;
    public Date dateFrom;
    public Date dateTo;
    public CmPdfStatement.Type type;

    public PdfStatementFilterForm() {
    }

    public PdfStatementFilterForm(PdfStatementsFilter filter) {
        BankSettings b;
        User user = filter.getUser();
        if (filter.getBank() != null && (b = BankSettings.getByIdAndUser((Integer)filter.getBank().getBankId(), (User)user)) != null) {
            this.bank = b.getBankId();
        }
        this.account = filter.getAccountId();
        this.dateComparator = filter.getDateComparatorIndex();
        if (this.dateComparator < 0) {
            this.dateComparator = null;
        }
        this.dateFrom = filter.getFromDate();
        this.dateTo = filter.getToDate();
        this.type = filter.getType();
    }

    public Form<PdfStatementFilterForm> validate(Form<PdfStatementFilterForm> form, PdfStatementsFilter filter) {
        User user = filter.getUser();
        if (this.bank == null || this.bank < 0) {
            filter.setBank(null);
        } else {
            BankSettings b = BankSettings.getByIdAndUser((Integer)this.bank, (User)user);
            if (b != null) {
                filter.setBank(b);
            } else {
                form = form.withError("bank", "error.invalid");
            }
        }
        filter.setAccountId(this.account);
        if (this.dateComparator == null || this.dateComparator < 0) {
            filter.setDateComparator(null);
            filter.setFromDate(null);
            filter.setToDate(null);
            if (this.dateFrom != null || this.dateTo != null) {
                form = form.withError("dateComparator", "error.invalid");
            }
        } else {
            filter.setDateComparatorIndex(this.dateComparator.intValue());
            if (filter.getDateComparator() == FilterComparator.Date.BETWEEN) {
                if (this.dateFrom == null && this.dateTo == null) {
                    filter.setFromDate(null);
                    filter.setToDate(null);
                    filter.setDateComparator(null);
                } else {
                    if (this.dateFrom == null) {
                        filter.setFromDate(null);
                    } else {
                        filter.setFromDate(new java.sql.Date(this.dateFrom.getTime()));
                    }
                    if (this.dateTo == null) {
                        filter.setDateComparator(FilterComparator.Date.GREATER);
                        filter.setToDate(null);
                    } else if (this.dateFrom == null) {
                        filter.setDateComparator(FilterComparator.Date.LESS);
                        filter.setFromDate(new java.sql.Date(this.dateTo.getTime()));
                    } else {
                        filter.setToDate(new java.sql.Date(this.dateTo.getTime()));
                    }
                }
            } else {
                if (this.dateFrom == null) {
                    form = form.withError("dateFrom", "error.invalid");
                    filter.setFromDate(null);
                } else {
                    filter.setFromDate(new java.sql.Date(this.dateFrom.getTime()));
                }
                filter.setToDate(null);
            }
        }
        if (this.type != null) {
            filter.setType(this.type);
        } else {
            filter.setType(null);
        }
        return form;
    }
}

