/*
 * Decompiled with CFR 0.152.
 */
package models;

import controllers.util.BLLoggerPlay;
import de.businesslogics.banking.api.BankUtils;
import de.businesslogics.banking.api.BankingApiMessages;
import de.businesslogics.banking.api.DatabasePreferenceConstant;
import de.businesslogics.banking.api.DatabasePreferenceStore;
import de.businesslogics.banking.api.EncryptData;
import de.businesslogics.banking.api.SendParameters;
import de.businesslogics.banking.api.Util;
import de.businesslogics.banking.api.sepa.SepaSchemeHandler;
import de.businesslogics.banking.database.api.DB;
import de.businesslogics.banking.database.vo.Account;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.database.vo.ConverterFormat;
import de.businesslogics.banking.database.vo.OpenPayment;
import de.businesslogics.banking.database.vo.PaymentFolder;
import de.businesslogics.banking.database.vo.PaymentTemplate;
import de.businesslogics.banking.database.vo.PaymentTransferType;
import de.businesslogics.banking.database.vo.PaymentType;
import de.businesslogics.banking.database.vo.PeriodicPayment;
import de.businesslogics.banking.database.vo.Preference;
import de.businesslogics.banking.database.vo.Tenant;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.banking.dta.api.DtazvApi;
import de.businesslogics.banking.dta.api.DtazvImportHandler;
import de.businesslogics.banking.dta.api.DtazvPaymentConversionHandler;
import de.businesslogics.banking.mt101.api.MT101Api;
import de.businesslogics.banking.mt101.api.MT101PaymentConversionHandler;
import de.businesslogics.banking.mt101.api.MT101PaymentImportHandler;
import de.businesslogics.banking.payments.api.PaymentConversionHandler;
import de.businesslogics.banking.payments.api.PaymentConversionHandler2;
import de.businesslogics.banking.payments.api.PeriodicPaymentImport;
import de.businesslogics.banking.payments.api.PreferenceUtil;
import de.businesslogics.banking.payments.core.PreferenceConstants;
import de.businesslogics.banking.sepa.api.SepaApi;
import de.businesslogics.banking.sepa.api.SepaPaymentConversionHandler;
import de.businesslogics.banking.sepa.api.SepaPaymentConversionHandler2;
import de.businesslogics.banking.sepa.api.SepaPaymentImportException;
import de.businesslogics.banking.sepa.api.SepaPaymentImportHandler;
import de.businesslogics.banking.sepa.api.SepaSendFileDetector;
import de.businesslogics.banking.transfer.api.SendFileAutoDetectException;
import de.businesslogics.banking.transfer.api.SendFileDetector;
import de.businesslogics.format.dta.DTAZVPayment;
import de.businesslogics.format.sepa.GeneralSEPAExtractor;
import de.businesslogics.format.sepa.SEPALocalInstrument;
import de.businesslogics.format.sepa.SEPAPaymentData;
import de.businesslogics.format.swift.mt101.MT101PaymentData;
import de.businesslogics.util.BLLogger;
import io.ebean.Transaction;
import java.io.File;
import java.io.InputStream;
import java.lang.runtime.SwitchBootstraps;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import models.payments.DtazvPaymentHandler;
import models.payments.Mt101PaymentHandler;
import models.payments.PaymentContextType;
import models.payments.PaymentException;
import models.payments.PaymentHandler;
import models.payments.PaymentImportOriginatorAndRecipientHandler;
import models.payments.SepaPaymentHandler;
import play.data.Form;
import play.data.validation.Constraints;
import play.i18n.Messages;
import play.libs.Scala;
import scala.Tuple2;
import scala.collection.immutable.Seq;

public final class PaymentImportForm {
    public static final String FILE_TYPE_GENERAL = "GENERAL_FILE";
    public static final String FILE_TYPE_CSV = "CSV_FILE";
    @Constraints.Required
    public Integer bankId;
    public String pmtTypeName;
    public String pmtTypeNameCsv;
    public String paymentContextTypeName;
    public boolean readPeriodicParametersFromFile;
    public Integer folderId;
    public String fileFormat = "GENERAL_FILE";
    public String encoding;
    public boolean saveRecipient;
    public boolean saveOriginator;
    public boolean sepaSingleBooking;
    public String templateName;
    public java.util.Date firstExecution = new java.util.Date();
    public java.util.Date previousExecution;
    public java.util.Date nextExecution;
    public java.util.Date lastExecution;
    public String executionInterval = PeriodicPayment.ExecutionInterval.MONTHLY.name();
    public Integer executionCount = 0;
    private final PaymentImportOriginatorAndRecipientHandler originatorAndRecipientHandler = new PaymentImportOriginatorAndRecipientHandler();
    private int ignoredPayments;
    private List<OpenPayment> openPayments;
    private List<PaymentTemplate> paymentTemplates;
    private List<PeriodicPayment> periodicPayments;
    private PaymentConversionHandler<?> paymentConversionHandler;
    private PaymentConversionHandler2<?> paymentConversionHandler2;
    private ConverterFormat converterFormat;
    public String orderIds;
    private PaymentFolder paymentFolder;
    private Set<String> importErrors;
    private PaymentTransferType.PmtType pmtType;

    public static Seq<Tuple2<String, String>> getSelectablePaymentContextTypes(Messages messages) {
        ArrayList<Tuple2> result = new ArrayList<Tuple2>();
        result.add(new Tuple2((Object)PaymentContextType.OPEN_PAYMENT.name(), (Object)messages.at("payment.contexttype." + PaymentContextType.OPEN_PAYMENT.name(), new Object[0])));
        result.add(new Tuple2((Object)PaymentContextType.PAYMENT_TEMPLATE.name(), (Object)messages.at("payment.contexttype." + PaymentContextType.PAYMENT_TEMPLATE.name(), new Object[0])));
        result.add(new Tuple2((Object)PaymentContextType.PERIODIC_PAYMENT.name(), (Object)messages.at("payment.contexttype." + PaymentContextType.PERIODIC_PAYMENT.name(), new Object[0])));
        return Scala.toSeq(result);
    }

    public static Seq<Tuple2<String, String>> getFileFormatTypes(Messages messages) {
        ArrayList<Tuple2> result = new ArrayList<Tuple2>();
        result.add(Scala.Tuple((Object)FILE_TYPE_GENERAL, (Object)messages.at("openpayments.import.file", new Object[0])));
        result.add(Scala.Tuple((Object)FILE_TYPE_CSV, (Object)messages.at("openpayments.import.csv", new Object[0])));
        return Scala.toSeq(result);
    }

    public Form<PaymentImportForm> validate(Form<PaymentImportForm> form, Messages messages, File file2, User user) {
        BankSettings bank;
        PaymentContextType paymentContextType;
        try {
            paymentContextType = PaymentContextType.valueOf(this.paymentContextTypeName);
        }
        catch (IllegalArgumentException e) {
            return form.withError("paymentContextTypeName", messages.at("error.invalid", new Object[0]));
        }
        boolean isCsv = FILE_TYPE_CSV.equals(this.fileFormat);
        if (this.orderIds == null || this.orderIds.isEmpty()) {
            try {
                this.pmtType = isCsv ? PaymentTransferType.PmtType.valueOf((String)this.pmtTypeNameCsv) : PaymentTransferType.PmtType.valueOf((String)this.pmtTypeName);
            }
            catch (IllegalArgumentException e) {
                return form.withError("pmtTypeName", messages.at("error.invalid", new Object[0]));
            }
        }
        if (!(this.orderIds != null && !this.orderIds.isEmpty() || file2 != null && file2.isFile() && file2.length() != 0L)) {
            return form.withError("import_payment_file", messages.at("error.required", new Object[0]));
        }
        if (this.bankId != null && this.bankId >= 0) {
            bank = BankSettings.getByIdAndUser((Integer)this.bankId, (User)user);
            if (bank == null) {
                return form.withError("bankId", messages.at("general.invalidbank", new Object[0]));
            }
        } else {
            boolean isSepaFile;
            bank = null;
            boolean bl = isSepaFile = SepaApi.isCreditPmtType((PaymentTransferType.PmtType)this.pmtType) || SepaApi.isDebitPmtType((PaymentTransferType.PmtType)this.pmtType) || SepaApi.isForeignPayment((PaymentTransferType.PmtType)this.pmtType);
            if (isSepaFile) {
                try {
                    SendFileDetector.Result result = new SepaSendFileDetector().detect(file2, user);
                    Map bankTransferTypeMap = result.getBankTransferTypeMap();
                    if (bankTransferTypeMap == null || bankTransferTypeMap.isEmpty()) {
                        BLLoggerPlay.error("No bank detected!");
                        return form.withError("bankId", messages.at("general.invalidbank", new Object[0]));
                    }
                    ArrayList possibleBanks = new ArrayList(bankTransferTypeMap.keySet());
                    if (possibleBanks.size() > 1) {
                        return form.withError("bankId", messages.at("sent.send.selectbank.info", new Object[0]));
                    }
                    bank = (BankSettings)possibleBanks.getFirst();
                }
                catch (SendFileAutoDetectException e) {
                    BLLoggerPlay.error("Failed to take over uploaded file from user " + user.getName(), e);
                }
            }
        }
        if (this.folderId != null && this.folderId >= 0) {
            this.paymentFolder = PaymentFolder.findById((Integer)this.folderId, (User)user);
            if (this.paymentFolder == null) {
                form = form.withError("folderId", messages.at("error.invalid", new Object[0]));
            } else if (bank != null && !bank.getTenant().equals(this.paymentFolder.getTenant())) {
                form = form.withError("folderId", messages.at("", new Object[0]));
            }
        }
        if (paymentContextType == PaymentContextType.PAYMENT_TEMPLATE) {
            if (this.templateName == null || this.templateName.isEmpty()) {
                return form.withError("templateName", messages.at("error.required", new Object[0]));
            }
            if (this.templateName.length() > 80) {
                return form.withError("templateName", messages.at("error.tooLong", new Object[]{this.templateName.length() - 80}));
            }
        }
        if (paymentContextType == PaymentContextType.PERIODIC_PAYMENT && !this.readPeriodicParametersFromFile) {
            if (this.firstExecution == null) {
                form = form.withError("firstExecution", "error.required");
            }
            Calendar cal = Calendar.getInstance();
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            if (this.nextExecution == null) {
                form = form.withError("nextExecution", "error.required");
            } else if (this.nextExecution.before(cal.getTime())) {
                form = form.withError("nextExecution", "error.invalid");
            }
            if (this.executionInterval == null) {
                form = form.withError("executionInterval", "error.required");
            } else {
                PeriodicPayment.ExecutionInterval.valueOf((String)this.executionInterval);
            }
        }
        DatabasePreferenceStore preferenceStore = new DatabasePreferenceStore(Preference.ApplicationId.PAYMENTS, user);
        this.saveOriginator &= preferenceStore.getBoolean((DatabasePreferenceConstant)PreferenceConstants.ALLOW_ORIGINATOR_RECORDING);
        if (PreferenceUtil.disableRecipientRecording((User)user)) {
            this.saveRecipient = false;
        } else {
            new DatabasePreferenceStore(Preference.ApplicationId.PAYMENTS, user).setValue((DatabasePreferenceConstant)PreferenceConstants.SAVE_RECIPIENT, this.saveRecipient);
        }
        return form;
    }

    public void importPaymentFile(Messages messages, File file2, User user, PaymentTransferType.PmtType paymentTypeFromEDS, Integer bankIdFromEDS, Set<String> errorMessages) throws Exception {
        boolean isSepaFile;
        PaymentContextType paymentContextType = PaymentContextType.valueOf(this.paymentContextTypeName);
        if (paymentTypeFromEDS != null) {
            this.pmtType = paymentTypeFromEDS;
        }
        if (bankIdFromEDS != null) {
            this.bankId = bankIdFromEDS;
        }
        BankSettings bank = this.bankId != null && this.bankId >= 0 ? BankSettings.getByIdAndUser((Integer)this.bankId, (User)user) : null;
        InputStream fileInputStream = this.orderIds == null || this.orderIds.isEmpty() ? Files.newInputStream(file2.toPath(), new OpenOption[0]) : EncryptData.getInstance().openInputStream(file2);
        boolean bl = isSepaFile = SepaApi.isCreditPmtType((PaymentTransferType.PmtType)this.pmtType) || SepaApi.isDebitPmtType((PaymentTransferType.PmtType)this.pmtType) || SepaApi.isForeignPayment((PaymentTransferType.PmtType)this.pmtType);
        if (isSepaFile && bank == null) {
            try {
                SendFileDetector.Result result = new SepaSendFileDetector().detect(file2, user);
                Map bankTransferTypeMap = result.getBankTransferTypeMap();
                if (bankTransferTypeMap == null || bankTransferTypeMap.isEmpty()) {
                    BLLoggerPlay.error("No bank detected!");
                    throw new Exception(messages.at("general.invalidbank", new Object[0]));
                }
                ArrayList possibleBanks = new ArrayList(bankTransferTypeMap.keySet());
                if (possibleBanks.size() > 1) {
                    throw new Exception(messages.at("sent.send.selectbank.info.error", new Object[0]));
                }
            }
            catch (SendFileAutoDetectException e) {
                BLLoggerPlay.error("Failed to take over uploaded file from user " + user.getName(), e);
            }
        }
        if (paymentContextType == PaymentContextType.PERIODIC_PAYMENT && this.readPeriodicParametersFromFile) {
            MyPeriodicPaymentImport periodicPaymentImport = new MyPeriodicPaymentImport(BLLoggerPlay.getLogger(), user);
            periodicPaymentImport.importFromZipFile(file2);
        } else if (SepaApi.isForeignPayment((PaymentTransferType.PmtType)this.pmtType)) {
            this.paymentConversionHandler2 = new SepaPaymentConversionHandler2(SepaSchemeHandler.getSepaVersion((BankSettings)bank, (PaymentTransferType.PmtType)this.pmtType), ConverterFormat.Type.PAIN_001_INTERNATIONAL, BLLoggerPlay.getLogger(), file2);
            new MySepaPaymentImportHandler(user, paymentContextType, messages, true).readFrom(fileInputStream, bank, this.pmtType, user);
        } else if (SepaApi.isCreditPmtType((PaymentTransferType.PmtType)this.pmtType) || SepaApi.isDebitPmtType((PaymentTransferType.PmtType)this.pmtType)) {
            boolean isCredit = SepaApi.isCreditPmtType((PaymentTransferType.PmtType)this.pmtType);
            this.paymentConversionHandler = new SepaPaymentConversionHandler(SepaSchemeHandler.getSepaVersion((BankSettings)bank, (PaymentTransferType.PmtType)this.pmtType), isCredit, BLLoggerPlay.getLogger(), file2);
            new MySepaPaymentImportHandler(user, paymentContextType, messages, false).readFrom(fileInputStream, bank, this.pmtType, user);
        } else if (DtazvApi.isDtazvPmtType((PaymentTransferType.PmtType)this.pmtType)) {
            this.paymentConversionHandler = new DtazvPaymentConversionHandler(BLLoggerPlay.getLogger(), file2);
            new MyDtazvPaymentImportHandler(paymentContextType, messages).readFrom(fileInputStream, bank, this.pmtType, user);
        } else if (MT101Api.isMt101PmtType((PaymentTransferType.PmtType)this.pmtType)) {
            this.paymentConversionHandler2 = new MT101PaymentConversionHandler(BLLoggerPlay.getLogger(), file2);
            new MyMt101PaymentImportHandler(paymentContextType, messages).readFrom(fileInputStream, bank, this.pmtType, user);
        } else {
            throw new Exception(messages.at("error.invalid", new Object[0]));
        }
        if (this.importErrors != null) {
            errorMessages.addAll(this.importErrors);
        }
        if (fileInputStream != null) {
            fileInputStream.close();
        }
    }

    public void prepareForCsv(File file2, User user) {
        BankSettings bank = null;
        if (this.bankId != null && this.bankId >= 0) {
            bank = BankSettings.getByIdAndUser((Integer)this.bankId, (User)user);
        }
        if (SepaApi.isForeignPayment((PaymentTransferType.PmtType)this.pmtType)) {
            this.paymentConversionHandler2 = new SepaPaymentConversionHandler2(SepaSchemeHandler.getSepaVersion((BankSettings)bank, (PaymentTransferType.PmtType)this.pmtType), ConverterFormat.Type.PAIN_001_INTERNATIONAL, BLLoggerPlay.getLogger(), file2);
        } else if (SepaApi.isCreditPmtType((PaymentTransferType.PmtType)this.pmtType)) {
            this.paymentConversionHandler2 = new SepaPaymentConversionHandler2(SepaSchemeHandler.getSepaVersion((BankSettings)bank, (PaymentTransferType.PmtType)this.pmtType), ConverterFormat.Type.SEPA_CREDIT, BLLoggerPlay.getLogger(), file2);
        } else if (SepaApi.isDebitPmtType((PaymentTransferType.PmtType)this.pmtType)) {
            this.paymentConversionHandler2 = new SepaPaymentConversionHandler2(SepaSchemeHandler.getSepaVersion((BankSettings)bank, (PaymentTransferType.PmtType)this.pmtType), ConverterFormat.Type.SEPA_DEBIT, BLLoggerPlay.getLogger(), file2);
        } else if (DtazvApi.isDtazvPmtType((PaymentTransferType.PmtType)this.pmtType)) {
            this.paymentConversionHandler = new DtazvPaymentConversionHandler(BLLoggerPlay.getLogger(), file2);
        } else if (MT101Api.isMt101PmtType((PaymentTransferType.PmtType)this.pmtType)) {
            this.paymentConversionHandler2 = new MT101PaymentConversionHandler(BLLoggerPlay.getLogger(), file2);
        }
        if (this.paymentConversionHandler != null && this.paymentConversionHandler.canHandle()) {
            this.converterFormat = this.paymentConversionHandler.getConverterFormat(user);
        } else if (this.paymentConversionHandler2.canHandle()) {
            this.converterFormat = this.paymentConversionHandler2.getConverterFormat(user);
        }
    }

    public int savePayment(User user) {
        try (Transaction t = DB.beginTransaction();){
            int result = 0;
            if (this.openPayments != null) {
                for (OpenPayment openPayment : this.openPayments) {
                    openPayment.save(user, false);
                    ++result;
                }
            } else if (this.paymentTemplates != null) {
                for (PaymentTemplate paymentTemplate : this.paymentTemplates) {
                    paymentTemplate.save();
                    ++result;
                }
            } else if (this.periodicPayments != null) {
                for (PeriodicPayment periodicPayment : this.periodicPayments) {
                    periodicPayment.save(user, false);
                    ++result;
                }
            }
            this.originatorAndRecipientHandler.save(user);
            t.commit();
            int n = result;
            return n;
        }
    }

    public int getIgnoredPayments() {
        return this.ignoredPayments;
    }

    public PaymentConversionHandler<?> getPaymentConversionHandler() {
        return this.paymentConversionHandler;
    }

    public PaymentConversionHandler2<?> getPaymentConversionHandler2() {
        return this.paymentConversionHandler2;
    }

    public ConverterFormat getConverterFormat() {
        return this.converterFormat;
    }

    public PaymentTransferType.PmtType getPmtType() {
        return this.pmtType;
    }

    private void setPeriodicParameters(PeriodicPayment periodicPayment) {
        if (this.firstExecution != null) {
            periodicPayment.setFirstExecutionDate(new Date(this.firstExecution.getTime()));
        }
        if (this.previousExecution != null) {
            periodicPayment.setPreviousExecutionDate(new Date(this.previousExecution.getTime()));
        }
        if (this.nextExecution != null) {
            periodicPayment.setNextExecutionDate(new Date(this.nextExecution.getTime()));
        }
        if (this.lastExecution != null) {
            periodicPayment.setLastExecutionDate(new Date(this.lastExecution.getTime()));
        }
        periodicPayment.setExecutionInterval(PeriodicPayment.ExecutionInterval.valueOf((String)this.executionInterval));
    }

    private void createPeriodicPayment(PeriodicPayment periodicPayment, PaymentHandler<?> paymentHandler, Account account, PaymentTransferType.PmtType pmtType) throws PaymentException {
        if (this.sepaSingleBooking && paymentHandler instanceof SepaPaymentHandler) {
            ((SEPAPaymentData)((SepaPaymentHandler)paymentHandler).getPayment()).setDisplayAsSingleBooking(true);
        }
        String orderOrFileType = SendParameters.getTransferTypeByAccount((Account)account, (PaymentTransferType.PmtType)pmtType);
        BankSettings bank = account.getBank();
        periodicPayment.setBank(bank);
        periodicPayment.setAccount(account);
        if (BankUtils.isProtocolH005OrNewer((String)account.getBank().getProtocolVersion())) {
            periodicPayment.setOrderType("BTU");
            periodicPayment.setFileType(orderOrFileType);
        } else if (bank.isFrenchBank()) {
            periodicPayment.setOrderType("FUL");
            periodicPayment.setFileType(orderOrFileType);
        } else {
            periodicPayment.setOrderType(orderOrFileType);
            periodicPayment.setFileType(null);
        }
        periodicPayment.setPmtType(paymentHandler.getPaymentType(pmtType));
        periodicPayment.setCredit(paymentHandler.isCredit());
        periodicPayment.setUrgent(paymentHandler.isUrgent(pmtType));
        periodicPayment.setRecipient(paymentHandler.getRecipient());
        periodicPayment.setAmount(paymentHandler.getAmount());
        periodicPayment.setAmountCurrency(paymentHandler.getCurrencyCode());
        periodicPayment.setPurpose(paymentHandler.getPurpose());
        if (this.paymentFolder != null) {
            periodicPayment.setFolder(this.paymentFolder);
        }
        periodicPayment.setPaymentData(paymentHandler.buildPaymentData(periodicPayment.getBank()));
        periodicPayment.setSalaryPayment(Boolean.valueOf(paymentHandler.isSalaryPayment()));
        periodicPayment.setOriginator(paymentHandler.getOriginator());
    }

    private Account findAccount(PaymentHandler<?> paymentHandler, User user) {
        if (this.bankId != null && this.bankId >= 0) {
            return paymentHandler.getOriginatorAccount(BankSettings.getByIdAndUser((Integer)this.bankId, (User)user));
        }
        for (BankSettings bank : BankSettings.findBanksForUser((User)user)) {
            Account account = paymentHandler.getOriginatorAccount(bank);
            if (account == null) continue;
            return account;
        }
        return null;
    }

    private void checkRecipient(PaymentHandler<?> paymentHandler, User user, Tenant tenant) throws PaymentException {
        PaymentType paymentType;
        PaymentHandler<?> paymentHandler2 = paymentHandler;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{SepaPaymentHandler.class, DtazvPaymentHandler.class, Mt101PaymentHandler.class}, paymentHandler2, n)) {
            case 0: {
                SepaPaymentHandler ignored = (SepaPaymentHandler)paymentHandler2;
                if (new DatabasePreferenceStore(Preference.ApplicationId.SEPA, user).getBoolean((DatabasePreferenceConstant)de.businesslogics.banking.sepa.PreferenceConstants.USE_MANDATE_ADMISTRATION)) {
                    paymentType = PaymentType.MANDATE;
                    break;
                }
                paymentType = PaymentType.SEPA;
                break;
            }
            case 1: {
                DtazvPaymentHandler ignored = (DtazvPaymentHandler)paymentHandler2;
                paymentType = PaymentType.DTAZV;
                break;
            }
            case 2: {
                Mt101PaymentHandler ignored = (Mt101PaymentHandler)paymentHandler2;
                paymentType = PaymentType.MT101;
                break;
            }
            default: {
                return;
            }
        }
        if (this.saveRecipient && !this.originatorAndRecipientHandler.checkForRecipient(paymentHandler.getRecipient(), paymentHandler.getRecipientAccountNumber(), paymentHandler.getRecipientBankcode(), paymentType, tenant)) {
            this.originatorAndRecipientHandler.addRecipient(paymentHandler.buildRecipient(false, null, paymentType, tenant, user.getTenants(), true));
        }
    }

    private void checkOriginator(PaymentHandler<?> paymentHandler, Tenant tenant) throws PaymentException {
        PaymentType paymentType;
        PaymentHandler<?> paymentHandler2 = paymentHandler;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{SepaPaymentHandler.class, DtazvPaymentHandler.class, Mt101PaymentHandler.class}, paymentHandler2, n)) {
            case 0: {
                SepaPaymentHandler ignored = (SepaPaymentHandler)paymentHandler2;
                paymentType = PaymentType.SEPA;
                break;
            }
            case 1: {
                DtazvPaymentHandler ignored = (DtazvPaymentHandler)paymentHandler2;
                paymentType = PaymentType.DTAZV;
                break;
            }
            case 2: {
                Mt101PaymentHandler ignored = (Mt101PaymentHandler)paymentHandler2;
                paymentType = PaymentType.MT101;
                break;
            }
            default: {
                return;
            }
        }
        if (this.saveOriginator && !this.originatorAndRecipientHandler.checkForOriginator(paymentHandler.getOriginator(), paymentType, tenant)) {
            this.originatorAndRecipientHandler.addOriginator(paymentHandler.buildOriginator(tenant));
        }
    }

    private final class MyPeriodicPaymentImport
    extends PeriodicPaymentImport<PeriodicPaymentImportData> {
        private final User user;

        public MyPeriodicPaymentImport(BLLogger logger, User user) {
            super(logger);
            this.user = user;
        }

        protected PeriodicPaymentImportData loadPaymentFromStream(InputStream inputStream, PaymentTransferType.PmtType pmtType) {
            try {
                return new PeriodicPaymentImportData(PaymentImportForm.this, inputStream, pmtType, this.user);
            }
            catch (PaymentException e) {
                BLLoggerPlay.error("Failed to load payment data for import file!", e);
                return null;
            }
        }

        protected int storePayments(Map<PeriodicPayment, PeriodicPaymentImportData> payments) {
            if (PaymentImportForm.this.periodicPayments == null) {
                PaymentImportForm.this.periodicPayments = new ArrayList<PeriodicPayment>();
            }
            for (PeriodicPayment periodicPayment : payments.keySet()) {
                PeriodicPaymentImportData payment = payments.get(periodicPayment);
                try {
                    PaymentImportForm.this.createPeriodicPayment(periodicPayment, payment.getPaymentHandler(), payment.getAccount(), payment.getPmtType());
                }
                catch (PaymentException e) {
                    BLLoggerPlay.error("Failed to create imported periodic payment!", e);
                    return -1;
                }
                PaymentImportForm.this.periodicPayments.add(periodicPayment);
            }
            return payments.size();
        }
    }

    private final class MySepaPaymentImportHandler
    extends SepaPaymentImportHandler {
        private final User user;
        private final PaymentContextType paymentContextType;
        private final boolean useMandates;
        private final boolean isForeignSepa;

        public MySepaPaymentImportHandler(User user, PaymentContextType paymentContextType, Messages messages, boolean isForeignSepa) {
            super(BLLoggerPlay.getLogger(), messages.lang().locale(), true);
            this.user = user;
            this.paymentContextType = paymentContextType;
            this.useMandates = new DatabasePreferenceStore(Preference.ApplicationId.SEPA, user).getBoolean((DatabasePreferenceConstant)de.businesslogics.banking.sepa.PreferenceConstants.USE_MANDATE_ADMISTRATION);
            this.isForeignSepa = isForeignSepa;
        }

        protected void addIgnoredPayment(String message) {
            if (message != null) {
                if (PaymentImportForm.this.importErrors == null) {
                    PaymentImportForm.this.importErrors = new HashSet<String>();
                }
                PaymentImportForm.this.importErrors.add(message);
            }
            ++PaymentImportForm.this.ignoredPayments;
        }

        protected Account checkForReplaceAccount(List<Account> accounts2, String originatorBic, String originatorIban) {
            return null;
        }

        protected boolean checkForOverrideImportSalaries() {
            return false;
        }

        protected void createPayment(BankSettings bankSettings, PaymentTransferType.PmtType pmtType, SEPAPaymentData sepaPayment) throws SepaPaymentImportException {
            try {
                if (SepaApi.isInstantCreditPaymentType((PaymentTransferType.PmtType)pmtType)) {
                    sepaPayment.setLocalInstrument(SEPALocalInstrument.INST.name());
                }
                if (SepaApi.isUrgent((PaymentTransferType.PmtType)pmtType)) {
                    sepaPayment.setServiceLevel(GeneralSEPAExtractor.URGP);
                } else if (!this.isForeignSepa && SepaApi.isCreditPmtType((PaymentTransferType.PmtType)pmtType)) {
                    sepaPayment.setServiceLevel(GeneralSEPAExtractor.SEPA);
                }
                PaymentHandler<?> handler = PaymentHandler.getHandler(sepaPayment, pmtType);
                if (this.paymentContextType == PaymentContextType.OPEN_PAYMENT) {
                    if (PaymentImportForm.this.openPayments == null) {
                        PaymentImportForm.this.openPayments = new ArrayList<OpenPayment>();
                    }
                    PaymentImportForm.this.openPayments.add(handler.createOpenPayment(bankSettings, pmtType, PaymentImportForm.this.paymentFolder, false));
                } else if (this.paymentContextType == PaymentContextType.PAYMENT_TEMPLATE) {
                    if (PaymentImportForm.this.paymentTemplates == null) {
                        PaymentImportForm.this.paymentTemplates = new ArrayList<PaymentTemplate>();
                    }
                    PaymentImportForm.this.paymentTemplates.add(handler.createPaymentTemplate(bankSettings, pmtType, PaymentImportForm.this.templateName, PaymentImportForm.this.paymentFolder));
                } else if (this.paymentContextType == PaymentContextType.PERIODIC_PAYMENT) {
                    if (PaymentImportForm.this.periodicPayments == null) {
                        PaymentImportForm.this.periodicPayments = new ArrayList<PeriodicPayment>();
                    }
                    PeriodicPayment periodicPayment = handler.createPeriodicPayment(bankSettings, pmtType, PaymentImportForm.this.paymentFolder, false);
                    PaymentImportForm.this.periodicPayments.add(periodicPayment);
                    PaymentImportForm.this.setPeriodicParameters(periodicPayment);
                }
                if (PaymentImportForm.this.saveRecipient && !PaymentImportForm.this.originatorAndRecipientHandler.checkForRecipient(sepaPayment.getRecipient(), sepaPayment.getRecipientIban(), sepaPayment.getRecipientBic(), this.getRecipientPaymentType(sepaPayment.isCredit()), bankSettings.getTenant())) {
                    try {
                        PaymentImportForm.this.originatorAndRecipientHandler.addRecipient(handler.buildRecipient(false, null, this.getRecipientPaymentType(sepaPayment.isCredit()), bankSettings.getTenant(), this.user.getTenants(), true));
                    }
                    catch (PaymentException e) {
                        BLLoggerPlay.warning("Failed to build SEPA recipient info!", e);
                    }
                }
                if (PaymentImportForm.this.saveOriginator && !PaymentImportForm.this.originatorAndRecipientHandler.checkForOriginator(sepaPayment.getOriginator(), PaymentType.SEPA, bankSettings.getTenant())) {
                    try {
                        PaymentImportForm.this.originatorAndRecipientHandler.addOriginator(handler.buildOriginator(bankSettings.getTenant()));
                    }
                    catch (PaymentException e) {
                        BLLoggerPlay.warning("Failed to build SEPA originator info!", e);
                    }
                }
            }
            catch (PaymentException e) {
                throw new SepaPaymentImportException("Failed to create SEPA payment from import data!", (Throwable)e);
            }
        }

        protected boolean isImportSalaries() {
            return Util.importSalaries((User)this.user);
        }

        protected boolean isDisplayAsSingleBooking() {
            if (this.isForeignSepa) {
                return true;
            }
            return PaymentImportForm.this.sepaSingleBooking;
        }

        private PaymentType getRecipientPaymentType(boolean isCredit) {
            if (!isCredit && this.useMandates) {
                return PaymentType.MANDATE;
            }
            if (this.isForeignSepa) {
                return PaymentType.SEPA_FOREIGN;
            }
            return PaymentType.SEPA;
        }
    }

    private class MyDtazvPaymentImportHandler
    extends DtazvImportHandler {
        private final PaymentContextType paymentContextType;
        private final Messages messages;

        public MyDtazvPaymentImportHandler(PaymentContextType paymentContextType, Messages messages) {
            super(BLLoggerPlay.getLogger(), messages.lang().locale());
            this.paymentContextType = paymentContextType;
            this.messages = messages;
        }

        protected void addIgnoredPayment(String message) {
            if (message != null) {
                if (PaymentImportForm.this.importErrors == null) {
                    PaymentImportForm.this.importErrors = new HashSet<String>();
                }
                PaymentImportForm.this.importErrors.add(message);
            }
            ++PaymentImportForm.this.ignoredPayments;
        }

        protected void createPayment(BankSettings bankSettings, PaymentTransferType.PmtType pmtType, DTAZVPayment dtazvPayment) {
            try {
                PaymentHandler<?> handler = PaymentHandler.getHandler(dtazvPayment, pmtType);
                Account account = handler.getOriginatorAccount(bankSettings);
                if (account == null) {
                    this.addIgnoredPayment(BankingApiMessages.getString((Locale)this.messages.lang().locale(), (String)"GeneralMessages.unknownOriginatorAccount", (Object[])new Object[]{handler.getOriginatorAccount()}));
                    return;
                }
                if (this.paymentContextType == PaymentContextType.OPEN_PAYMENT) {
                    if (PaymentImportForm.this.openPayments == null) {
                        PaymentImportForm.this.openPayments = new ArrayList<OpenPayment>();
                    }
                    PaymentImportForm.this.openPayments.add(handler.createOpenPayment(bankSettings, pmtType, PaymentImportForm.this.paymentFolder, false));
                } else if (this.paymentContextType == PaymentContextType.PAYMENT_TEMPLATE) {
                    if (PaymentImportForm.this.paymentTemplates == null) {
                        PaymentImportForm.this.paymentTemplates = new ArrayList<PaymentTemplate>();
                    }
                    PaymentImportForm.this.paymentTemplates.add(handler.createPaymentTemplate(bankSettings, pmtType, PaymentImportForm.this.templateName, PaymentImportForm.this.paymentFolder));
                } else if (this.paymentContextType == PaymentContextType.PERIODIC_PAYMENT) {
                    if (PaymentImportForm.this.periodicPayments == null) {
                        PaymentImportForm.this.periodicPayments = new ArrayList<PeriodicPayment>();
                    }
                    PeriodicPayment periodicPayment = handler.createPeriodicPayment(bankSettings, pmtType, PaymentImportForm.this.paymentFolder, false);
                    PaymentImportForm.this.periodicPayments.add(periodicPayment);
                    PaymentImportForm.this.setPeriodicParameters(periodicPayment);
                }
                if (PaymentImportForm.this.saveRecipient && !PaymentImportForm.this.originatorAndRecipientHandler.checkForRecipient(handler.getRecipient(), handler.getRecipientAccountNumber(), handler.getRecipientBankcode(), PaymentType.DTAZV, bankSettings.getTenant())) {
                    try {
                        PaymentImportForm.this.originatorAndRecipientHandler.addRecipient(handler.buildRecipient(false, null, PaymentType.DTAZV, bankSettings.getTenant(), Collections.singletonList(bankSettings.getTenant()), true));
                    }
                    catch (PaymentException e) {
                        BLLoggerPlay.warning("Failed to build DTAZV recipient info!", e);
                    }
                }
                if (PaymentImportForm.this.saveOriginator && !PaymentImportForm.this.originatorAndRecipientHandler.checkForOriginator(dtazvPayment.getOriginator(), PaymentType.DTAZV, bankSettings.getTenant())) {
                    try {
                        PaymentImportForm.this.originatorAndRecipientHandler.addOriginator(handler.buildOriginator(bankSettings.getTenant()));
                    }
                    catch (PaymentException e) {
                        BLLoggerPlay.warning("Failed to build DTAZV originator info!", e);
                    }
                }
            }
            catch (PaymentException e) {
                throw new RuntimeException(e);
            }
        }

        protected Account checkForReplaceAccount(List<Account> accounts2, int blz, long accountNumber) {
            return null;
        }

        protected void handleException(Exception e) {
            throw new RuntimeException(e);
        }
    }

    private final class MyMt101PaymentImportHandler
    extends MT101PaymentImportHandler {
        private final PaymentContextType paymentContextType;
        private final Messages messages;

        public MyMt101PaymentImportHandler(PaymentContextType paymentContextType, Messages messages) {
            super(BLLoggerPlay.getLogger(), messages.lang().locale());
            this.paymentContextType = paymentContextType;
            this.messages = messages;
        }

        protected void createPayment(BankSettings bankSettings, PaymentTransferType.PmtType pmtType, MT101PaymentData mt101Payment) {
            try {
                PaymentHandler<?> handler = PaymentHandler.getHandler(mt101Payment, pmtType);
                Account account = handler.getOriginatorAccount(bankSettings);
                if (account == null) {
                    this.addIgnoredPayment(BankingApiMessages.getString((Locale)this.messages.lang().locale(), (String)"GeneralMessages.unknownOriginatorAccount", (Object[])new Object[]{handler.getOriginatorAccount()}));
                    return;
                }
                if (this.paymentContextType == PaymentContextType.OPEN_PAYMENT) {
                    if (PaymentImportForm.this.openPayments == null) {
                        PaymentImportForm.this.openPayments = new ArrayList<OpenPayment>();
                    }
                    PaymentImportForm.this.openPayments.add(handler.createOpenPayment(bankSettings, pmtType, PaymentImportForm.this.paymentFolder, false));
                } else if (this.paymentContextType == PaymentContextType.PAYMENT_TEMPLATE) {
                    if (PaymentImportForm.this.paymentTemplates == null) {
                        PaymentImportForm.this.paymentTemplates = new ArrayList<PaymentTemplate>();
                    }
                    PaymentImportForm.this.paymentTemplates.add(handler.createPaymentTemplate(bankSettings, pmtType, PaymentImportForm.this.templateName, PaymentImportForm.this.paymentFolder));
                } else if (this.paymentContextType == PaymentContextType.PERIODIC_PAYMENT) {
                    if (PaymentImportForm.this.periodicPayments == null) {
                        PaymentImportForm.this.periodicPayments = new ArrayList<PeriodicPayment>();
                    }
                    PeriodicPayment periodicPayment = handler.createPeriodicPayment(bankSettings, pmtType, PaymentImportForm.this.paymentFolder, false);
                    PaymentImportForm.this.periodicPayments.add(periodicPayment);
                    PaymentImportForm.this.setPeriodicParameters(periodicPayment);
                }
                if (PaymentImportForm.this.saveRecipient && !PaymentImportForm.this.originatorAndRecipientHandler.checkForRecipient(handler.getRecipient(), handler.getRecipientAccountNumber(), handler.getRecipientBankcode(), PaymentType.MT101, bankSettings.getTenant())) {
                    try {
                        PaymentImportForm.this.originatorAndRecipientHandler.addRecipient(handler.buildRecipient(false, null, PaymentType.MT101, bankSettings.getTenant(), Collections.singletonList(bankSettings.getTenant()), true));
                    }
                    catch (PaymentException e) {
                        BLLoggerPlay.warning("Failed to build MT101 recipient info!", e);
                    }
                }
                if (PaymentImportForm.this.saveOriginator && !PaymentImportForm.this.originatorAndRecipientHandler.checkForOriginator(mt101Payment.getOriginatorName(), PaymentType.MT101, bankSettings.getTenant())) {
                    try {
                        PaymentImportForm.this.originatorAndRecipientHandler.addOriginator(handler.buildOriginator(bankSettings.getTenant()));
                    }
                    catch (PaymentException e) {
                        BLLoggerPlay.warning("Failed to build MT101 originator info!", e);
                    }
                }
            }
            catch (PaymentException e) {
                throw new RuntimeException(e);
            }
        }

        protected Account checkForReplaceAccount(List<Account> accounts2, String bic, String accountNumber) {
            return null;
        }

        protected void addIgnoredPayment(String message) {
            if (message != null) {
                if (PaymentImportForm.this.importErrors == null) {
                    PaymentImportForm.this.importErrors = new HashSet<String>();
                }
                PaymentImportForm.this.importErrors.add(message);
            }
            ++PaymentImportForm.this.ignoredPayments;
        }
    }

    private final class PeriodicPaymentImportData {
        private final PaymentTransferType.PmtType pmtType;
        private final PaymentHandler<?> paymentHandler;
        private final Account account;

        public PeriodicPaymentImportData(PaymentImportForm paymentImportForm, InputStream inputStream, PaymentTransferType.PmtType pmtType, User user) throws PaymentException {
            this.pmtType = pmtType;
            List<PaymentHandler<?>> payments = PaymentHandler.getHandlers(inputStream, pmtType, null);
            if (payments == null || payments.size() != 1) {
                throw new PaymentException("Found unexpected number of periodic payments in imported file: " + (payments == null ? -1 : payments.size()));
            }
            this.paymentHandler = payments.getFirst();
            this.account = paymentImportForm.findAccount(this.paymentHandler, user);
            if (this.account == null) {
                throw new PaymentException("Did not find account for periodic payment!");
            }
            paymentImportForm.checkRecipient(this.paymentHandler, user, this.account.getBank().getTenant());
            paymentImportForm.checkOriginator(this.paymentHandler, this.account.getBank().getTenant());
        }

        public PaymentTransferType.PmtType getPmtType() {
            return this.pmtType;
        }

        public PaymentHandler<?> getPaymentHandler() {
            return this.paymentHandler;
        }

        public Account getAccount() {
            return this.account;
        }
    }
}

