/*
 * Decompiled with CFR 0.152.
 */
package models;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import controllers.OpenPayments;
import controllers.routes;
import controllers.util.BLLoggerPlay;
import controllers.util.SortingHandler;
import de.businesslogics.banking.api.BankingApiMessages;
import de.businesslogics.banking.api.DatabasePreferenceConstant;
import de.businesslogics.banking.api.DatabasePreferenceStore;
import de.businesslogics.banking.api.FormSettings;
import de.businesslogics.banking.api.Logger;
import de.businesslogics.banking.api.PermissionsLoader;
import de.businesslogics.banking.api.SendParameters;
import de.businesslogics.banking.database.api.DB;
import de.businesslogics.banking.database.vo.Account;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.database.vo.DsOpenOrder;
import de.businesslogics.banking.database.vo.DsOrderDetails;
import de.businesslogics.banking.database.vo.OpenPayment;
import de.businesslogics.banking.database.vo.PaymentExchangeRate;
import de.businesslogics.banking.database.vo.PaymentFolder;
import de.businesslogics.banking.database.vo.PaymentOriginator;
import de.businesslogics.banking.database.vo.PaymentTemplate;
import de.businesslogics.banking.database.vo.PaymentTransferType;
import de.businesslogics.banking.database.vo.PaymentType;
import de.businesslogics.banking.database.vo.PeriodicPayment;
import de.businesslogics.banking.database.vo.Preference;
import de.businesslogics.banking.database.vo.Send;
import de.businesslogics.banking.database.vo.SignedPayment;
import de.businesslogics.banking.database.vo.Sorting;
import de.businesslogics.banking.database.vo.Tenant;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.banking.payments.api.OriginatorData;
import de.businesslogics.banking.payments.api.PreferenceUtil;
import de.businesslogics.banking.payments.api.RecipientData;
import de.businesslogics.banking.payments.api.ScheduleHandler;
import de.businesslogics.banking.payments.core.PreferenceConstants;
import de.businesslogics.util.Currency;
import de.businesslogics.util.PaymentUtils;
import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.sql.Date;
import java.text.DateFormat;
import java.util.Base64;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import models.payments.PaymentContextType;
import models.payments.PaymentException;
import models.payments.PaymentHandler;
import play.data.Form;
import play.data.FormFactory;
import play.data.validation.Constraints;
import play.data.validation.ValidationError;
import play.i18n.Messages;
import play.libs.Json;
import views.Utils;

public abstract class PaymentForm {
    public String referer;
    @Constraints.Required
    public Integer originatorAccountId;
    @Constraints.Required
    public BigDecimal amount;
    public String currency = "EUR";
    @Constraints.Required
    public String originatorName;
    public String originatorAccount;
    public String originatorBankCode;
    @Constraints.Required
    public String recipientName;
    public Integer recipientId;
    public String recipientAccount;
    public String recipientBankCode;
    public String purpose;
    public java.util.Date executionDate;
    public String reference;
    public boolean isUrgent;
    public boolean rememberRecipient = true;
    public boolean createNewRecipient = false;
    public java.util.Date firstExecution = new java.util.Date();
    public java.util.Date previousExecution;
    public java.util.Date nextExecution;
    public java.util.Date lastExecution;
    public String executionInterval = PeriodicPayment.ExecutionInterval.MONTHLY.name();
    public Integer executionCount = 0;
    public Integer targetFolder;
    public String templateName;
    private OpenPayment openPaymentVO;
    private SignedPayment signedPaymentVO;
    private PeriodicPayment periodicPaymentVO;
    private PaymentTemplate paymentTemplateVO;
    private DsOpenOrder dsOpenOrderVO;
    private DsOrderDetails dsOrderDetailsVO;
    private Send sendVO;
    protected BankSettings bank;
    protected PaymentTransferType.PmtType pmtType;
    protected Map<Logger.PaymentField, String[]> fieldChangeReportingMap;

    public static String loadJsParameters(Messages messages) {
        ObjectNode resultJson = Json.newObject();
        resultJson.put("conversionMessage", messages.at("payment.amountconversiontext", new Object[0]));
        resultJson.put("conversionNotPossibleMessage", messages.at("payment.amountconversionnotpossible", new Object[0]));
        resultJson.put("addDecimalsUrl", routes.Application.addDecimals().toString());
        resultJson.put("multiplyDecimalsUrl", routes.Application.multiplyDecimals().toString());
        resultJson.put("convertAmountUrl", routes.Payments.convertAmount().toString());
        resultJson.put("calculateDiscountUrl", routes.Payments.calculateDiscount().toString());
        ArrayNode conversionFactorsNode = resultJson.putArray("conversionFactors");
        DateFormat dateFormat = DateFormat.getDateInstance(2, messages.lang().locale());
        for (Currency currency : Currency.getAvailableCurrencies()) {
            PaymentExchangeRate exchangeRate = (PaymentExchangeRate)DB.find(PaymentExchangeRate.class).where().eq("currencyCode", (Object)currency.getCurrencyCode()).findOne();
            if (exchangeRate == null && (currency.getDefaultFractionDigits() < 0 || currency.getDefaultFractionDigits() == 2)) continue;
            ObjectNode node = conversionFactorsNode.addObject();
            node.put("currency", currency.getCurrencyCode());
            if (exchangeRate != null) {
                node.put("factor", exchangeRate.getExchangeRate());
                node.put("date", dateFormat.format(exchangeRate.getRateTime()));
            }
            node.put("fractions", currency.getDefaultFractionDigits());
        }
        return Base64.getEncoder().encodeToString(Json.asciiStringify((JsonNode)resultJson).getBytes(StandardCharsets.US_ASCII));
    }

    public static boolean isEditable(PaymentContextType paymentContextType, Integer paymentDatabaseId, User forUser, boolean inEditMode) {
        switch (paymentContextType) {
            case SIGNED_PAYMENT: 
            case SENT_PAYMENT: {
                return false;
            }
            case OPEN_PAYMENT: {
                if (paymentDatabaseId == null) {
                    return true;
                }
                if (!inEditMode) {
                    return false;
                }
                OpenPayment payment = (OpenPayment)DB.find(OpenPayment.class, (Object)paymentDatabaseId);
                return payment == null || !OpenPayments.isPaymentLocked(payment, forUser);
            }
            case PERIODIC_PAYMENT: {
                if (paymentDatabaseId != null && !inEditMode) {
                    return false;
                }
            }
            case PAYMENT_TEMPLATE: {
                if (paymentDatabaseId == null || inEditMode) break;
                return false;
            }
        }
        return true;
    }

    public static boolean isGenericPurposeAllowed(PaymentContextType paymentContextType) {
        return switch (paymentContextType) {
            case PaymentContextType.PERIODIC_PAYMENT, PaymentContextType.PAYMENT_TEMPLATE, PaymentContextType.OPEN_TO_PERIODIC_PAYMENT, PaymentContextType.SIGNED_TO_PERIODIC_PAYMENT -> true;
            default -> false;
        };
    }

    protected PaymentForm() {
    }

    public PaymentForm(PaymentContextType paymentContextType, PaymentTransferType.PmtType pmtType, PaymentFolder folder, boolean saveRecipient) throws PaymentException {
        this.createNewVO(paymentContextType, pmtType, null, null, folder);
        this.pmtType = pmtType;
        this.executionDate = new java.util.Date();
        this.rememberRecipient = saveRecipient;
    }

    protected PaymentForm(Object databaseVO, boolean saveRecipient) throws PaymentException {
        this.rememberRecipient = saveRecipient;
        Object object = databaseVO;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{OpenPayment.class, SignedPayment.class, PeriodicPayment.class, PaymentTemplate.class, DsOpenOrder.class, DsOrderDetails.class, Send.class}, (Object)object, n)) {
            case 0: {
                OpenPayment openPayment;
                this.openPaymentVO = openPayment = (OpenPayment)object;
                this.pmtType = this.openPaymentVO.getPmtType();
                this.isUrgent = this.openPaymentVO.isUrgent();
                this.bank = this.openPaymentVO.getBank();
                if (this.openPaymentVO.getFolder() == null) break;
                this.targetFolder = this.openPaymentVO.getFolder().getId();
                break;
            }
            case 1: {
                SignedPayment signedPayment;
                this.signedPaymentVO = signedPayment = (SignedPayment)object;
                this.pmtType = this.signedPaymentVO.getPmtType();
                this.isUrgent = this.signedPaymentVO.isUrgent();
                this.bank = this.signedPaymentVO.getSend().getBank();
                if (this.signedPaymentVO.getFolder() == null) break;
                this.targetFolder = this.signedPaymentVO.getFolder().getId();
                break;
            }
            case 2: {
                PeriodicPayment periodicPayment;
                this.periodicPaymentVO = periodicPayment = (PeriodicPayment)object;
                this.pmtType = this.periodicPaymentVO.getPmtType();
                this.firstExecution = this.periodicPaymentVO.getFirstExecutionDate();
                this.previousExecution = this.periodicPaymentVO.getPreviousExecutionDate();
                this.nextExecution = this.periodicPaymentVO.getNextExecutionDate();
                this.lastExecution = this.periodicPaymentVO.getLastExecutionDate();
                if (this.periodicPaymentVO.getExecutionInterval() != null) {
                    this.executionInterval = this.periodicPaymentVO.getExecutionInterval().name();
                }
                this.executionCount = new ScheduleHandler(this.periodicPaymentVO).determineNumberOfExecutions();
                this.isUrgent = this.periodicPaymentVO.isUrgent();
                if (this.periodicPaymentVO.getFolder() != null) {
                    this.targetFolder = this.periodicPaymentVO.getFolder().getId();
                }
                this.bank = this.periodicPaymentVO.getBank();
                break;
            }
            case 3: {
                PaymentTemplate paymentTemplate;
                this.paymentTemplateVO = paymentTemplate = (PaymentTemplate)object;
                this.pmtType = this.paymentTemplateVO.getPmtType();
                this.isUrgent = this.paymentTemplateVO.isUrgent();
                this.templateName = this.paymentTemplateVO.getName();
                this.bank = this.paymentTemplateVO.getBank();
                if (this.paymentTemplateVO.getFolder() == null) break;
                this.targetFolder = this.paymentTemplateVO.getFolder().getId();
                break;
            }
            case 4: {
                DsOpenOrder dsOpenOrder;
                this.dsOpenOrderVO = dsOpenOrder = (DsOpenOrder)object;
                this.pmtType = this.dsOpenOrderVO.getPmtType();
                this.bank = this.dsOpenOrderVO.getBankUser().getBank();
                break;
            }
            case 5: {
                DsOrderDetails dsOrderDetails;
                this.dsOrderDetailsVO = dsOrderDetails = (DsOrderDetails)object;
                this.pmtType = this.dsOrderDetailsVO.getPmtType();
                this.bank = this.dsOrderDetailsVO.getBank();
                break;
            }
            case 6: {
                Send send;
                this.sendVO = send = (Send)object;
                this.pmtType = this.sendVO.getPmtType();
                this.bank = this.sendVO.getBank();
                break;
            }
            default: {
                throw new PaymentException("Invalid type of database VO!");
            }
        }
    }

    public final void store(User user, Map<String, String> flashMap, Messages messages) throws PaymentException {
        String iniMode;
        OriginatorData originator;
        PaymentHandler<?> handler;
        Account account = (Account)DB.find(Account.class, (Object)this.originatorAccountId);
        if (account == null) {
            throw new PaymentException("Did not find account with ID " + this.originatorAccountId);
        }
        PaymentFolder folder = null;
        if (this.targetFolder != null && (folder = PaymentFolder.findById((Integer)this.targetFolder, (User)user)) != null && !folder.getTenant().equals(account.getBank().getTenant())) {
            folder = null;
        }
        this.fieldChangeReportingMap = new HashMap<Logger.PaymentField, String[]>();
        switch (this.getPaymentContextType()) {
            case OPEN_PAYMENT: {
                this.openPaymentVO.setBank(account.getBank());
                this.reportFieldChange(Logger.PaymentField.ORIGINATOR_ACCOUNT, this.openPaymentVO.getAccount() == null ? null : this.openPaymentVO.getAccount().getName(), account.getName());
                this.openPaymentVO.setAccount(account);
                this.openPaymentVO.setFolder(folder);
                this.openPaymentVO.setOriginator(this.originatorName);
                handler = this.loadPaymentHandler(user);
                handler.updateOpenPayment(this.openPaymentVO);
                boolean isNewPayment = this.openPaymentVO.getId() == null;
                this.openPaymentVO.save(user, false);
                if (isNewPayment) {
                    Logger.logOpenPaymentCreated((User)user, (OpenPayment)this.openPaymentVO);
                    break;
                }
                for (Map.Entry entry : this.fieldChangeReportingMap.entrySet()) {
                    Logger.logOpenPaymentModified((User)user, (OpenPayment)this.openPaymentVO, (Logger.PaymentField)((Logger.PaymentField)entry.getKey()), (String)((String[])entry.getValue())[0], (String)((String[])entry.getValue())[1]);
                }
                break;
            }
            case PERIODIC_PAYMENT: {
                this.periodicPaymentVO.setBank(account.getBank());
                this.periodicPaymentVO.setAccount(account);
                this.periodicPaymentVO.setFirstExecutionDate(this.getSqlDate(this.firstExecution));
                this.periodicPaymentVO.setPreviousExecutionDate(this.getSqlDate(this.previousExecution));
                this.periodicPaymentVO.setNextExecutionDate(this.getSqlDate(this.nextExecution));
                this.periodicPaymentVO.setLastExecutionDate(this.getSqlDate(this.lastExecution));
                this.periodicPaymentVO.setFolder(folder);
                this.periodicPaymentVO.setOriginator(this.originatorName);
                for (PeriodicPayment.ExecutionInterval interval : PeriodicPayment.ExecutionInterval.values()) {
                    if (!interval.name().equals(this.executionInterval)) continue;
                    this.periodicPaymentVO.setExecutionInterval(interval);
                    break;
                }
                handler = this.loadPaymentHandler(user);
                handler.updatePeriodicPayment(this.periodicPaymentVO);
                boolean isNewPayment = this.periodicPaymentVO.getId() == null;
                this.periodicPaymentVO.save(user, false);
                if (isNewPayment) {
                    Logger.logPeriodicPaymentCreated((User)user, (PeriodicPayment)this.periodicPaymentVO);
                    break;
                }
                for (Map.Entry entry : this.fieldChangeReportingMap.entrySet()) {
                    Logger.logPeriodicPaymentModified((User)user, (PeriodicPayment)this.periodicPaymentVO, (Logger.PaymentField)((Logger.PaymentField)entry.getKey()), (String)((String[])entry.getValue())[0], (String)((String[])entry.getValue())[1]);
                }
                break;
            }
            case PAYMENT_TEMPLATE: {
                String oldName = this.paymentTemplateVO.getName();
                this.paymentTemplateVO.setName(this.templateName);
                this.paymentTemplateVO.setBank(account.getBank());
                this.paymentTemplateVO.setAccount(account);
                this.paymentTemplateVO.setFolder(folder);
                this.paymentTemplateVO.setOriginator(this.originatorName);
                handler = this.loadPaymentHandler(user);
                handler.updatePaymentTemplate(this.paymentTemplateVO);
                boolean isNewPayment = this.paymentTemplateVO.getId() == null;
                this.paymentTemplateVO.save();
                if (isNewPayment) {
                    Logger.logPaymentTemplateCreated((User)user, (PaymentTemplate)this.paymentTemplateVO);
                    break;
                }
                this.reportFieldChange(Logger.PaymentField.TEMPLATE_NAME, oldName, this.templateName);
                for (Map.Entry<Logger.PaymentField, String[]> entry : this.fieldChangeReportingMap.entrySet()) {
                    if (Logger.PaymentField.EXECUTION_DATE.equals((Object)entry.getKey())) continue;
                    Logger.logPaymentTemplateModified((User)user, (PaymentTemplate)this.paymentTemplateVO, (Logger.PaymentField)entry.getKey(), (String)entry.getValue()[0], (String)entry.getValue()[1]);
                }
                break;
            }
            default: {
                return;
            }
        }
        SortingHandler sortingHandler = new SortingHandler(user, Sorting.Table.PMT_OPEN);
        String string = sortingHandler.getProperty("folder", "-1");
        if (Integer.parseInt(string) >= 0) {
            String folderId = folder == null ? "-1" : String.valueOf(folder.getId());
            sortingHandler.setProperty("folder", folderId);
        }
        if ((originator = handler.buildOriginator(account.getBank().getTenant())) != null) {
            try {
                DatabasePreferenceStore preferences2 = new DatabasePreferenceStore(Preference.ApplicationId.PAYMENTS, user);
                iniMode = preferences2.getString((DatabasePreferenceConstant)PreferenceConstants.INITIALIZATION_OF_ACC_AND_ORIG);
                if (PreferenceConstants.InitializationOfAccAndOrig.WITH_PREVIOUS_VALUES.name().equals(iniMode)) {
                    originator.setDefaultAccount(account);
                }
                originator.save();
            }
            catch (IOException e) {
                if (flashMap != null) {
                    BLLoggerPlay.error("Failed to save originator info!", e);
                    Utils.addToFlash(flashMap, "warning", messages.at("payment.warning.noOriginatorSaved", new Object[0]));
                }
                throw new PaymentException("Failed to save originator info!", e);
            }
        }
        this.storeRememberRecipientPreference(user);
        if (this.rememberRecipient) {
            RecipientData recipient = handler.buildRecipient(this.createNewRecipient, this.recipientId, this.pmtType.getRecipientPaymentType(), account.getBank().getTenant(), user.getTenants(), true);
            if (recipient != null) {
                try {
                    recipient.save(user, PreferenceUtil.useFourEyesForRecipientRecording((User)user));
                }
                catch (IOException e) {
                    if (flashMap != null) {
                        BLLoggerPlay.error("Failed to store recipient info!", e);
                        Utils.addToFlash(flashMap, "warning", messages.at("payment.warning.noRecipientSaved", new Object[0]));
                    }
                    throw new PaymentException("Failed to save recipient info!", e);
                }
            }
        } else {
            this.internalRecipientHandling(user, handler, account.getBank().getTenant());
        }
        this.storeDefaultFormSettings(user);
        DatabasePreferenceStore preferences2 = new DatabasePreferenceStore(Preference.ApplicationId.PAYMENTS, user);
        iniMode = preferences2.getString((DatabasePreferenceConstant)PreferenceConstants.INITIALIZATION_OF_ACC_AND_ORIG);
        if (PreferenceConstants.InitializationOfAccAndOrig.WITH_PREVIOUS_VALUES.name().equals(iniMode)) {
            PaymentType t = originator.getPaymentType();
            if (PaymentType.DTAZV.equals((Object)t)) {
                account.setDtazvOriginator(originator.getPaymentOriginator());
            } else if (PaymentType.MT101.equals((Object)t)) {
                account.setMt101Originator(originator.getPaymentOriginator());
            } else {
                account.setSepaOriginator(originator.getPaymentOriginator());
            }
            account.save();
        }
    }

    public final void createNewVO(PaymentContextType paymentContextType, PaymentTransferType.PmtType pmtType, String orderType, String fileType, PaymentFolder selectedFolder) throws PaymentException {
        this.pmtType = pmtType;
        this.isUrgent = this.isUrgentPmtType(pmtType);
        PaymentFolder folder = this.targetFolder != null && this.targetFolder > 0 ? (PaymentFolder)DB.find(PaymentFolder.class, (Object)this.targetFolder) : selectedFolder;
        this.targetFolder = folder == null ? null : folder.getId();
        switch (paymentContextType) {
            case OPEN_PAYMENT: {
                this.openPaymentVO = new OpenPayment();
                this.openPaymentVO.setPmtType(pmtType);
                this.openPaymentVO.setOrderType(orderType);
                this.openPaymentVO.setFileType(fileType);
                this.openPaymentVO.setUrgent(this.isUrgent);
                this.openPaymentVO.setFolder(folder);
                if (folder == null) break;
                this.openPaymentVO.setFolder(folder);
                break;
            }
            case PERIODIC_PAYMENT: {
                this.periodicPaymentVO = new PeriodicPayment();
                this.periodicPaymentVO.setPmtType(pmtType);
                this.periodicPaymentVO.setOrderType(orderType);
                this.periodicPaymentVO.setFileType(fileType);
                this.periodicPaymentVO.setUrgent(this.isUrgent);
                if (folder == null) break;
                this.periodicPaymentVO.setFolder(folder);
                break;
            }
            case PAYMENT_TEMPLATE: {
                this.paymentTemplateVO = new PaymentTemplate();
                this.paymentTemplateVO.setPmtType(pmtType);
                this.paymentTemplateVO.setOrderType(orderType);
                this.paymentTemplateVO.setFileType(fileType);
                this.paymentTemplateVO.setUrgent(this.isUrgent);
                if (folder == null) break;
                this.paymentTemplateVO.setFolder(folder);
                break;
            }
            default: {
                throw new PaymentException("A payment of type " + String.valueOf((Object)paymentContextType) + " cannot be created!");
            }
        }
    }

    public final void setOpenPaymentVOWithPmtType(OpenPayment openPayment, PaymentTransferType.PmtType newPmtType) {
        this.openPaymentVO = openPayment;
        this.pmtType = newPmtType;
    }

    public final void updateVO(PaymentContextType paymentContextType, int databaseId, PaymentTransferType.PmtType defaultPmtType) throws PaymentException {
        switch (paymentContextType) {
            case OPEN_PAYMENT: {
                this.openPaymentVO = (OpenPayment)DB.find(OpenPayment.class, (Object)databaseId);
                if (this.openPaymentVO == null) {
                    throw new PaymentException("Failed to load open payment with ID " + databaseId + " - seems to be already deleted!");
                }
                this.pmtType = this.openPaymentVO.getPmtType();
                break;
            }
            case SIGNED_PAYMENT: {
                this.signedPaymentVO = (SignedPayment)DB.find(SignedPayment.class, (Object)databaseId);
                if (this.signedPaymentVO == null) {
                    throw new PaymentException("Failed to load signed payment with ID " + databaseId + " - seems to be already deleted!");
                }
                this.pmtType = this.signedPaymentVO.getPmtType();
                break;
            }
            case PERIODIC_PAYMENT: {
                this.periodicPaymentVO = (PeriodicPayment)DB.find(PeriodicPayment.class, (Object)databaseId);
                if (this.periodicPaymentVO == null) {
                    throw new PaymentException("Failed to load periodic payment with ID " + databaseId + " - seems to be already deleted!");
                }
                this.pmtType = this.periodicPaymentVO.getPmtType();
                break;
            }
            case PAYMENT_TEMPLATE: {
                this.paymentTemplateVO = (PaymentTemplate)DB.find(PaymentTemplate.class, (Object)databaseId);
                if (this.paymentTemplateVO == null) {
                    throw new PaymentException("Failed to load payment template with ID " + databaseId + " - seems to be already deleted!");
                }
                this.pmtType = this.paymentTemplateVO.getPmtType();
            }
        }
        if (this.pmtType == null) {
            this.pmtType = defaultPmtType;
        }
    }

    protected final BankSettings getBankFromVO() {
        return switch (this.getPaymentContextType()) {
            case PaymentContextType.OPEN_PAYMENT -> this.openPaymentVO.getBank();
            case PaymentContextType.SIGNED_PAYMENT -> this.signedPaymentVO.getSend().getBank();
            case PaymentContextType.PERIODIC_PAYMENT -> this.periodicPaymentVO.getBank();
            case PaymentContextType.PAYMENT_TEMPLATE -> this.paymentTemplateVO.getBank();
            case PaymentContextType.OPEN_DES_DETAILS -> this.dsOpenOrderVO.getBankUser().getBank();
            case PaymentContextType.DES_HISTORY_DETAILS -> this.dsOrderDetailsVO.getBank();
            case PaymentContextType.SENT_PAYMENT -> this.sendVO.getBank();
            default -> null;
        };
    }

    protected final byte[] getPaymentData() {
        return switch (this.getPaymentContextType()) {
            case PaymentContextType.OPEN_PAYMENT -> this.openPaymentVO.getPaymentData();
            case PaymentContextType.SIGNED_PAYMENT -> this.signedPaymentVO.getPaymentData();
            case PaymentContextType.PERIODIC_PAYMENT -> this.periodicPaymentVO.getPaymentData();
            case PaymentContextType.PAYMENT_TEMPLATE -> this.paymentTemplateVO.getPaymentData();
            default -> null;
        };
    }

    public final PaymentContextType getPaymentContextType() {
        if (this.openPaymentVO != null) {
            return PaymentContextType.OPEN_PAYMENT;
        }
        if (this.signedPaymentVO != null) {
            return PaymentContextType.SIGNED_PAYMENT;
        }
        if (this.periodicPaymentVO != null) {
            return PaymentContextType.PERIODIC_PAYMENT;
        }
        if (this.paymentTemplateVO != null) {
            return PaymentContextType.PAYMENT_TEMPLATE;
        }
        if (this.dsOpenOrderVO != null) {
            return PaymentContextType.OPEN_DES_DETAILS;
        }
        if (this.dsOrderDetailsVO != null) {
            return PaymentContextType.DES_HISTORY_DETAILS;
        }
        if (this.sendVO != null) {
            return PaymentContextType.SENT_PAYMENT;
        }
        throw new RuntimeException("Unknown context type, no value object is set up!");
    }

    public final Integer getDatabaseId() {
        return switch (this.getPaymentContextType()) {
            case PaymentContextType.OPEN_PAYMENT -> this.openPaymentVO.getId();
            case PaymentContextType.SIGNED_PAYMENT -> this.signedPaymentVO.getId();
            case PaymentContextType.PERIODIC_PAYMENT -> this.periodicPaymentVO.getId();
            case PaymentContextType.PAYMENT_TEMPLATE -> this.paymentTemplateVO.getId();
            case PaymentContextType.OPEN_DES_DETAILS -> this.dsOpenOrderVO.getId();
            case PaymentContextType.DES_HISTORY_DETAILS -> this.dsOrderDetailsVO.getId();
            case PaymentContextType.SENT_PAYMENT -> this.sendVO.getId();
            default -> null;
        };
    }

    public Form<? extends PaymentForm> validateBeforeVOCreation(Form<? extends PaymentForm> form, Messages messages, FormFactory formFactory, Map<String, String> flashMap) {
        return form;
    }

    public final Form<? extends PaymentForm> validateInputData(Form<? extends PaymentForm> form, Messages messages, FormFactory formFactory, User user, Map<String, String> flashMap) {
        PaymentFolder folder;
        this.rememberRecipient = Boolean.parseBoolean((String)form.rawData().get("rememberRecipient"));
        if (this.originatorAccountId == null) {
            return form.withError("originatorAccountId", "error.required");
        }
        Account originatorAccount = (Account)DB.find(Account.class, (Object)this.originatorAccountId);
        String orderTypeOrBtf = SendParameters.getTransferTypeByAccount((Account)originatorAccount, (PaymentTransferType.PmtType)this.getPmtType());
        if (originatorAccount == null) {
            return form.withError("originatorAccountId", "error.invalid");
        }
        Tenant tenant = originatorAccount.getBank().getTenant();
        if (new DatabasePreferenceStore(Preference.ApplicationId.PAYMENTS, user, tenant).getBoolean((DatabasePreferenceConstant)PreferenceConstants.CHECK_PERMISSION_FOR_PAYMENT_RECORDING) && new PermissionsLoader(user).getAccountOrderTypes(originatorAccount, new String[]{orderTypeOrBtf}).isEmpty()) {
            return form.withError("originatorAccountId", "payment.error.nopaymenttypepermissionfororiginatoraccount");
        }
        if (this.targetFolder == null || this.targetFolder <= 0) {
            folder = null;
        } else {
            PaymentFolder folderBeforeValidation = PaymentFolder.findById((Integer)this.targetFolder, (User)user);
            if (folderBeforeValidation != null && !tenant.equals(folderBeforeValidation.getTenant())) {
                folderBeforeValidation = this.getCurrentFolder();
                Utils.addToFlash(flashMap, "warning", messages.at("payment.created.nofolder", new Object[0]));
            }
            folder = folderBeforeValidation;
        }
        Integer n = this.targetFolder = folder == null ? null : folder.getId();
        if (this.amount != null) {
            if (BigDecimal.ZERO.compareTo(this.amount) >= 0) {
                form = form.withError("amount", "payment.error.amountgreaternull");
            } else {
                int fractionDigits = this.currency != null ? Currency.getInstance((String)this.currency).getDefaultFractionDigits() : 2;
                if (this.amount.stripTrailingZeros().scale() > fractionDigits) {
                    form = form.withError("amount", "error.invalid");
                }
            }
        }
        if (this.getPaymentContextType() == PaymentContextType.OPEN_PAYMENT && this.isExecutionDateInPast()) {
            form = form.withError("executionDate", BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.error.executionDateInPast", (Object[])new Object[0]));
        }
        if (this.getPaymentContextType() == PaymentContextType.PERIODIC_PAYMENT) {
            if (this.getDatabaseId() == null && this.firstExecution == null) {
                form = form.withError("firstExecution", "error.required");
            }
            Calendar today = Calendar.getInstance();
            today.set(11, 0);
            today.set(12, 0);
            today.set(13, 0);
            today.set(14, 0);
            if (this.nextExecution == null) {
                form = form.withError("nextExecution", "error.required");
            } else if (this.nextExecution.before(today.getTime())) {
                form = form.withError("nextExecution", "error.invalid");
            }
            if (this.executionInterval == null) {
                form = form.withError("executionInterval", "error.required");
            }
        }
        if (this.getPaymentContextType() == PaymentContextType.PAYMENT_TEMPLATE) {
            if (this.templateName == null || this.templateName.isEmpty()) {
                form = form.withError("templateName", "error.required");
            } else {
                PaymentTemplate paymentTemplate = PaymentTemplate.findTemplateByNameAndTenant((String)this.templateName, (Tenant)tenant);
                if (this.getDatabaseId() == null && paymentTemplate != null || this.getDatabaseId() != null && paymentTemplate != null && !this.getDatabaseId().equals(paymentTemplate.getId())) {
                    form = form.withError("templateName", BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.nameAlreadyExists", (Object[])new Object[0]));
                }
            }
        }
        if (this.doLoadOriginatorById(user)) {
            form = this.loadSelectedOriginator((Form<? extends PaymentForm>)form, tenant);
        }
        if (!PreferenceUtil.allowUnrestrictedRecipientRecording((User)user)) {
            this.rememberRecipient = false;
            form = this.loadSelectedRecipient(form, user, tenant);
        }
        return this.internalValidate(form, messages, formFactory, user, flashMap);
    }

    protected boolean doLoadOriginatorById(User user) {
        DatabasePreferenceStore preferences2 = new DatabasePreferenceStore(Preference.ApplicationId.PAYMENTS, user);
        return !preferences2.getBoolean((DatabasePreferenceConstant)PreferenceConstants.ALLOW_ORIGINATOR_RECORDING);
    }

    public void loadDefaultFormSettings(User user) {
        DatabasePreferenceStore preferences2 = new DatabasePreferenceStore(Preference.ApplicationId.PAYMENTS, user);
        String iniMode = preferences2.getString((DatabasePreferenceConstant)PreferenceConstants.INITIALIZATION_OF_ACC_AND_ORIG);
        if (!PreferenceConstants.InitializationOfAccAndOrig.NONE.name().equals(iniMode)) {
            FormSettings form = new FormSettings(user, this.getFormSettingsType(), BLLoggerPlay.getLogger());
            this.originatorAccountId = form.getValueInt("originatorAccountId", -1);
            if (this.originatorAccountId != -1) {
                String name = "";
                Account account = (Account)DB.find(Account.class, (Object)this.originatorAccountId);
                if (account != null && !PaymentTransferType.PmtType.SEPA_CORE_DIRECT_DEBIT.equals((Object)this.pmtType) && !PaymentTransferType.PmtType.SEPA_B2B_DIRECT_DEBIT.equals((Object)this.pmtType)) {
                    PaymentOriginator origi = PaymentTransferType.PmtType.MT101_TRANSFER.equals((Object)this.pmtType) ? account.getMt101Originator() : (PaymentTransferType.PmtType.DTAZV_TRANSFER.equals((Object)this.pmtType) ? account.getDtazvOriginator() : account.getSepaOriginator());
                    if (origi != null) {
                        name = origi.getName();
                    } else if (account.getAccountHolder() != null) {
                        name = account.getAccountHolder();
                    }
                    this.originatorName = form.getValue("originatorName", name);
                } else {
                    this.originatorAccountId = -1;
                }
            }
        } else {
            this.originatorAccountId = -1;
        }
    }

    public void storeDefaultFormSettings(User user) {
        DatabasePreferenceStore preferences2 = new DatabasePreferenceStore(Preference.ApplicationId.PAYMENTS, user);
        String iniMode = preferences2.getString((DatabasePreferenceConstant)PreferenceConstants.INITIALIZATION_OF_ACC_AND_ORIG);
        if (!PreferenceConstants.InitializationOfAccAndOrig.NONE.name().equals(iniMode)) {
            FormSettings form = new FormSettings(user, this.getFormSettingsType(), BLLoggerPlay.getLogger());
            form.setValue("originatorAccountId", this.originatorAccountId);
        }
    }

    protected Form<? extends PaymentForm> reloadForm(Form<? extends PaymentForm> form, FormFactory formFactory) {
        Form tempForm = this.reloadFormInternal(formFactory);
        for (ValidationError error : form.errors()) {
            tempForm = tempForm.withError(error);
        }
        return tempForm;
    }

    protected abstract Form<? extends PaymentForm> reloadFormInternal(FormFactory var1);

    protected abstract FormSettings.Form getFormSettingsType();

    public abstract PaymentHandler<?> loadPaymentHandler(User var1) throws PaymentException;

    public abstract boolean isUrgentPmtType(PaymentTransferType.PmtType var1);

    public abstract boolean isCredit();

    protected abstract PaymentType getPaymentType(User var1);

    protected abstract Form<? extends PaymentForm> loadSelectedOriginator(Form<? extends PaymentForm> var1, Tenant var2);

    protected abstract Form<? extends PaymentForm> loadSelectedRecipient(Form<? extends PaymentForm> var1, User var2, Tenant var3);

    protected abstract Form<? extends PaymentForm> internalValidate(Form<? extends PaymentForm> var1, Messages var2, FormFactory var3, User var4, Map<String, String> var5);

    protected abstract void internalRecipientHandling(User var1, PaymentHandler<?> var2, Tenant var3) throws PaymentException;

    public PaymentTransferType.PmtType getPmtType() {
        if (this.pmtType == null) {
            this.pmtType = this.getInternalPmtType();
        }
        return this.pmtType;
    }

    protected abstract PaymentTransferType.PmtType getInternalPmtType();

    protected void storeRememberRecipientPreference(User user) {
        new DatabasePreferenceStore(Preference.ApplicationId.PAYMENTS, user).setValue((DatabasePreferenceConstant)PreferenceConstants.SAVE_RECIPIENT, this.rememberRecipient);
    }

    protected final void reportFieldChange(Logger.PaymentField field, Object oldValue, Object newValue) {
        try {
            if (this.fieldChangeReportingMap == null) {
                this.fieldChangeReportingMap = new HashMap<Logger.PaymentField, String[]>();
            }
            if (Utils.fieldValueChanged(oldValue, newValue)) {
                if (this.fieldChangeReportingMap.containsKey(field)) {
                    BLLoggerPlay.warning("Payment field change for field " + String.valueOf(field) + " has already been reported! Old value: '" + String.valueOf(oldValue) + "' New value: '" + String.valueOf(newValue) + "'");
                }
                String[] values = oldValue instanceof BigDecimal && newValue instanceof BigDecimal ? new String[]{PaymentUtils.formatAmount((BigDecimal)((BigDecimal)oldValue), (Currency)null), PaymentUtils.formatAmount((BigDecimal)((BigDecimal)newValue), (Currency)null)} : (oldValue instanceof java.util.Date && newValue instanceof java.util.Date ? new String[]{DateFormat.getDateInstance(2).format((java.util.Date)oldValue), DateFormat.getDateInstance(2).format((java.util.Date)newValue)} : new String[]{String.valueOf(oldValue), String.valueOf(newValue)});
                this.fieldChangeReportingMap.put(field, values);
            }
        }
        catch (Exception e) {
            BLLoggerPlay.warning("Exception while trying to log payment change: " + e.getMessage());
        }
    }

    private boolean isExecutionDateInPast() {
        if (this.executionDate == null) {
            return false;
        }
        Calendar cal = Calendar.getInstance();
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime().compareTo(this.executionDate) > 0;
    }

    private Date getSqlDate(java.util.Date date2) {
        if (date2 == null) {
            return null;
        }
        return new Date(date2.getTime());
    }

    private PaymentFolder getCurrentFolder() {
        Object oldFolder = this.openPaymentVO != null ? this.openPaymentVO.getFolder() : (this.periodicPaymentVO != null ? this.periodicPaymentVO.getFolder() : (this.paymentTemplateVO != null ? this.paymentTemplateVO.getFolder() : null));
        return oldFolder;
    }
}

