/*
 * Decompiled with CFR 0.152.
 */
package models;

import controllers.util.TenantUtils;
import de.businesslogics.banking.database.api.DB;
import de.businesslogics.banking.database.vo.PaymentFolder;
import de.businesslogics.banking.database.vo.Tenant;
import de.businesslogics.banking.database.vo.User;
import play.data.Form;

public class PaymentFolderForm {
    public String name;
    public Integer tenantId;

    public PaymentFolderForm() {
    }

    public PaymentFolderForm(String name, Integer tenantId) {
        this.name = name;
        this.tenantId = tenantId;
    }

    public Form<PaymentFolderForm> validateFolderChanges(Form<PaymentFolderForm> form, PaymentFolder folder, User user) {
        String error = TenantUtils.checkTenantId(this.tenantId, user);
        if (error != null) {
            return form.withError("tenantId", error);
        }
        if (this.name.length() > 255) {
            this.name = this.name.substring(0, 255);
        }
        Tenant tenant = TenantUtils.getTenantByIdAndUser(this.tenantId, user);
        switch (PaymentFolder.nameIsValid((PaymentFolder)folder, (String)this.name, (Tenant)tenant)) {
            case EXISTS: {
                return form.withError("name", "openpayments.folder.alreadyexists");
            }
            case EMPTY: {
                return form.withError("name", "error.required");
            }
        }
        folder.setTenant(tenant);
        folder.setName(this.name);
        DB.save((Object)folder);
        return form;
    }
}

