/*
 * Decompiled with CFR 0.152.
 */
package models;

import de.businesslogics.banking.database.vo.PaymentFilter;
import de.businesslogics.banking.database.vo.PaymentTransferType;
import java.math.BigDecimal;
import java.util.Date;

public class PaymentFilterForm {
    public Integer account;
    public String text;
    public int textComparator;
    public BigDecimal amountFrom;
    public BigDecimal amountTo;
    public BigDecimal amountSingle;
    public int amountComparator;
    public Date executionDateFrom;
    public Date executionDateTo;
    public Date executionDateSingle;
    public int executionDateComparator;
    public Integer filterUser;
    public String filterPmtType;
    public Integer filterPmtTypeComparator;
    PaymentTransferType.PmtType pmtType;
    public String filterState;
    PaymentFilter.State state;

    public PaymentFilterForm() {
    }

    public PaymentFilterForm(PaymentFilter filter) {
        if (filter != null) {
            this.account = filter.getAccountId();
            if (filter.getPmtTypeComparator() != null) {
                this.filterPmtTypeComparator = filter.getPmtTypeComparator().ordinal();
            }
            if (filter.getPmtType() != null) {
                this.filterPmtType = filter.getPmtType().name();
            }
            this.text = filter.getText();
            this.textComparator = filter.getTextComparatorId();
            this.amountFrom = filter.getAmountFrom();
            this.amountTo = filter.getAmountTo();
            this.amountSingle = filter.getAmountFrom();
            this.amountComparator = filter.getAmountComparatorId();
            this.executionDateFrom = filter.getFromExecutionDate();
            this.executionDateTo = filter.getToExecutionDate();
            this.executionDateSingle = filter.getFromExecutionDate();
            this.executionDateComparator = filter.getExecutionDateCompatorId();
            this.filterUser = filter.getFilterUserId();
            if (filter.getState() != null) {
                this.filterState = filter.getState().name();
            }
        }
    }

    public void saveDataPeriodic(PaymentFilter filter) {
        this.saveData(filter, false, true, false);
    }

    public void saveDataTemplate(PaymentFilter filter) {
        this.saveData(filter, false, false, true);
    }

    public void saveDataOpen(PaymentFilter filter) {
        this.saveData(filter, false, false, false);
    }

    public void saveDataSigned(PaymentFilter filter) {
        this.saveData(filter, true, false, false);
    }

    private void saveData(PaymentFilter filter, boolean signed, boolean periodic, boolean template) {
        boolean open = !signed && !template && !periodic;
        boolean empty = this.account == null;
        filter.setAccountId(this.account);
        if (this.filterPmtTypeComparator != null) {
            filter.setPmtTypeComparator(this.filterPmtTypeComparator.intValue());
        } else {
            filter.setPmtTypeComparator(0);
        }
        if (this.filterPmtType != null && !this.filterPmtType.isEmpty()) {
            this.pmtType = PaymentTransferType.PmtType.valueOf((String)this.filterPmtType);
            filter.setPmtType(this.pmtType);
            empty = false;
        } else {
            filter.setPmtType(null);
        }
        if (this.filterState != null && !this.filterState.isEmpty()) {
            this.state = PaymentFilter.State.valueOf((String)this.filterState);
            filter.setState(this.state);
            empty = false;
        } else {
            filter.setState(null);
        }
        filter.setText(this.text);
        if (this.text != null && this.text.length() > 0) {
            empty = false;
        }
        filter.setTextComparator(this.textComparator);
        if (this.amountSingle == null) {
            filter.setAmountFrom(this.amountFrom);
            if (this.amountFrom != null) {
                empty = false;
            }
        } else {
            filter.setAmountFrom(this.amountSingle);
            if (this.amountSingle != null) {
                empty = false;
            }
        }
        filter.setAmountTo(this.amountTo);
        if (this.amountTo != null) {
            empty = false;
        }
        filter.setAmountComparator(this.amountComparator);
        if (!periodic && !template) {
            if (this.executionDateFrom != null) {
                filter.setFromExecutionDate(new java.sql.Date(this.executionDateFrom.getTime()));
                empty = false;
            } else if (this.executionDateSingle != null) {
                filter.setFromExecutionDate(new java.sql.Date(this.executionDateSingle.getTime()));
                empty = false;
            } else {
                filter.setFromExecutionDate(null);
            }
            if (this.executionDateTo != null) {
                filter.setToExecutionDate(new java.sql.Date(this.executionDateTo.getTime()));
                empty = false;
            } else {
                filter.setToExecutionDate(null);
            }
            filter.setExecutionDateCompator(this.executionDateComparator);
        }
        if (open || periodic) {
            if (this.filterUser != null) {
                filter.setFilterUserId(this.filterUser);
                empty = false;
            } else {
                filter.setFilterUserId(null);
            }
        }
        if (empty) {
            filter.reset();
        } else {
            filter.save();
        }
    }
}

