/*
 * Decompiled with CFR 0.152.
 */
package models;

import controllers.util.BLLoggerPlay;
import controllers.util.BankOrderFactory;
import controllers.util.CsvImport;
import de.businesslogics.banking.api.BankUtils;
import de.businesslogics.banking.api.BankingApiMessages;
import de.businesslogics.banking.api.CsvColumnSeparator;
import de.businesslogics.banking.api.DatabasePreferenceConstant;
import de.businesslogics.banking.api.DatabasePreferenceStore;
import de.businesslogics.banking.api.EncryptData;
import de.businesslogics.banking.api.PermissionsLoader;
import de.businesslogics.banking.api.SendParameters;
import de.businesslogics.banking.api.sepa.SepaSchemeHandler;
import de.businesslogics.banking.database.api.DB;
import de.businesslogics.banking.database.vo.Account;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.database.vo.ConverterFormat;
import de.businesslogics.banking.database.vo.OpenPayment;
import de.businesslogics.banking.database.vo.PaymentFolder;
import de.businesslogics.banking.database.vo.PaymentTransferType;
import de.businesslogics.banking.database.vo.PaymentType;
import de.businesslogics.banking.database.vo.PeriodicPayment;
import de.businesslogics.banking.database.vo.Preference;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.banking.dta.api.DtazvApi;
import de.businesslogics.banking.dta.api.DtazvPaymentConversionHandler;
import de.businesslogics.banking.mt101.api.MT101Api;
import de.businesslogics.banking.mt101.api.MT101PaymentConversionHandler;
import de.businesslogics.banking.payments.api.BankOrderPayment;
import de.businesslogics.banking.payments.api.PaymentConversionHandler;
import de.businesslogics.banking.payments.api.PaymentConversionHandler2;
import de.businesslogics.banking.payments.api.PreferenceUtil;
import de.businesslogics.banking.payments.api.TableFileReader;
import de.businesslogics.banking.payments.core.PreferenceConstants;
import de.businesslogics.banking.sepa.api.SepaApi;
import de.businesslogics.banking.sepa.api.SepaPaymentConversionHandler2;
import de.businesslogics.iban.IbanUtil;
import de.businesslogics.util.SystemUtils;
import io.ebean.Transaction;
import java.io.File;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.sql.Date;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import models.BankOrderWithPayments;
import models.payments.DtazvPaymentCsvImportHandler;
import models.payments.Mt101PaymentCsvImportHandler;
import models.payments.PaymentContextType;
import models.payments.PaymentCsvImportHandler;
import models.payments.PaymentException;
import models.payments.PaymentHandler;
import models.payments.PaymentImportOriginatorAndRecipientHandler;
import models.payments.SepaForeignPaymentCsvImportHandler;
import models.payments.SepaPaymentCsvImportHandler;
import play.data.Form;
import play.data.validation.ValidationError;
import play.i18n.Messages;
import views.Utils;

public final class PaymentCsvImportForm {
    public boolean hasHeadline;
    public String numberFormat;
    private PaymentCsvImportHandler handler;
    private PaymentContextType paymentContext;
    private BankSettings bank;
    private String templateName;
    public java.util.Date firstExecution;
    public java.util.Date nextExecution;
    public java.util.Date lastExecution;
    public String executionInterval;
    private int importCount;

    public String[][] loadFromCsv(User user, File file2, PaymentTransferType.PmtType pmtType, PaymentContextType context, Map<String, String> dataMap, PaymentConversionHandler<?> conversionHandler, PaymentConversionHandler2<?> conversionHandler2, ConverterFormat converterFormat, String encoding) {
        Charset charSet;
        this.paymentContext = context;
        if (SepaApi.isForeignPayment((PaymentTransferType.PmtType)pmtType)) {
            this.handler = new SepaForeignPaymentCsvImportHandler(user, conversionHandler2, converterFormat);
        } else if (SepaApi.isCreditPmtType((PaymentTransferType.PmtType)pmtType)) {
            this.handler = new SepaPaymentCsvImportHandler(user, conversionHandler2, converterFormat, true, SepaApi.isUrgent((PaymentTransferType.PmtType)pmtType), PaymentContextType.PAYMENT_TEMPLATE.equals((Object)this.paymentContext), PaymentContextType.PERIODIC_PAYMENT.equals((Object)this.paymentContext));
        } else if (SepaApi.isDebitPmtType((PaymentTransferType.PmtType)pmtType)) {
            this.handler = new SepaPaymentCsvImportHandler(user, conversionHandler2, converterFormat, false, SepaApi.isUrgent((PaymentTransferType.PmtType)pmtType), PaymentContextType.PAYMENT_TEMPLATE.equals((Object)this.paymentContext), PaymentContextType.PERIODIC_PAYMENT.equals((Object)this.paymentContext));
        } else if (DtazvApi.isDtazvPmtType((PaymentTransferType.PmtType)pmtType)) {
            this.handler = new DtazvPaymentCsvImportHandler(user, conversionHandler, converterFormat);
        } else if (MT101Api.isMt101PmtType((PaymentTransferType.PmtType)pmtType)) {
            this.handler = new Mt101PaymentCsvImportHandler(user, conversionHandler2, converterFormat);
        } else {
            BLLoggerPlay.error("Unsupported order type for CSV payment import!");
            return new String[0][0];
        }
        if (converterFormat != null) {
            this.hasHeadline = converterFormat.hasHeader();
            this.numberFormat = converterFormat.getCountryCode();
            dataMap.put("hasHeadline", String.valueOf(this.hasHeadline));
            dataMap.put("numberFormat", String.valueOf(this.numberFormat));
        }
        if (encoding == null || encoding.isEmpty()) {
            if (converterFormat != null && converterFormat.getEncoding() != null) {
                try {
                    charSet = Charset.forName(converterFormat.getEncoding());
                }
                catch (IllegalArgumentException e) {
                    BLLoggerPlay.error("Unknown character set: " + encoding, e);
                    charSet = Charset.defaultCharset();
                }
            } else {
                charSet = Charset.defaultCharset();
            }
        } else {
            try {
                charSet = Charset.forName(encoding);
            }
            catch (IllegalArgumentException e) {
                BLLoggerPlay.error("Unknown character set: " + encoding, e);
                charSet = Charset.defaultCharset();
            }
        }
        TableFileReader reader = new TableFileReader(CsvColumnSeparator.SEMICOLON, charSet, 0);
        try {
            reader.readFile(file2);
            String[][] content = reader.getTableContent(false);
            this.handler.loadFieldsToDataMap(dataMap);
            return content;
        }
        catch (Exception e) {
            BLLoggerPlay.error("Failed to load content of payment import file " + file2.getAbsolutePath(), e);
            return new String[0][0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[][] loadFromForm(User user, Integer bankId, PaymentTransferType.PmtType pmtType, PaymentContextType paymentContext, String orderOrFileType, Integer converterFormatId, File file2) {
        if (pmtType == null) {
            pmtType = SendParameters.getPmtTypeFromHandlerKey((String)orderOrFileType);
        }
        this.paymentContext = paymentContext;
        BankSettings bank = bankId != null && bankId >= 0 ? BankSettings.getByIdAndUser((Integer)bankId, (User)user) : null;
        ConverterFormat converterFormat = converterFormatId != null && converterFormatId >= 0 ? ConverterFormat.findById((int)converterFormatId, (User)user) : null;
        if (SepaApi.isForeignPayment((PaymentTransferType.PmtType)pmtType)) {
            SepaPaymentConversionHandler2 conversionHandler2 = new SepaPaymentConversionHandler2(SepaSchemeHandler.getSepaVersion((BankSettings)bank, (PaymentTransferType.PmtType)pmtType), ConverterFormat.Type.PAIN_001_INTERNATIONAL, BLLoggerPlay.getLogger(), null);
            this.handler = new SepaForeignPaymentCsvImportHandler(user, (PaymentConversionHandler2<?>)conversionHandler2, converterFormat);
        } else if (SepaApi.isCreditPmtType((PaymentTransferType.PmtType)pmtType)) {
            SepaPaymentConversionHandler2 conversionHandler2 = new SepaPaymentConversionHandler2(SepaSchemeHandler.getSepaVersion((BankSettings)bank, (PaymentTransferType.PmtType)pmtType), ConverterFormat.Type.SEPA_CREDIT, BLLoggerPlay.getLogger(), null);
            this.handler = new SepaPaymentCsvImportHandler(user, (PaymentConversionHandler2<?>)conversionHandler2, converterFormat, true, SepaApi.isUrgent((PaymentTransferType.PmtType)pmtType), PaymentContextType.PAYMENT_TEMPLATE.equals((Object)paymentContext), PaymentContextType.PERIODIC_PAYMENT.equals((Object)paymentContext));
        } else if (SepaApi.isDebitPmtType((PaymentTransferType.PmtType)pmtType)) {
            SepaPaymentConversionHandler2 conversionHandler2 = new SepaPaymentConversionHandler2(SepaSchemeHandler.getSepaVersion((BankSettings)bank, (PaymentTransferType.PmtType)pmtType), ConverterFormat.Type.SEPA_DEBIT, BLLoggerPlay.getLogger(), null);
            this.handler = new SepaPaymentCsvImportHandler(user, (PaymentConversionHandler2<?>)conversionHandler2, converterFormat, false, SepaApi.isUrgent((PaymentTransferType.PmtType)pmtType), PaymentContextType.PAYMENT_TEMPLATE.equals((Object)paymentContext), PaymentContextType.PERIODIC_PAYMENT.equals((Object)paymentContext));
        } else if (DtazvApi.isDtazvPmtType((PaymentTransferType.PmtType)pmtType)) {
            DtazvPaymentConversionHandler conversionHandler = new DtazvPaymentConversionHandler(BLLoggerPlay.getLogger(), null);
            this.handler = new DtazvPaymentCsvImportHandler(user, (PaymentConversionHandler<?>)conversionHandler, converterFormat);
        } else if (MT101Api.isMt101PmtType((PaymentTransferType.PmtType)pmtType)) {
            MT101PaymentConversionHandler conversionHandler2 = new MT101PaymentConversionHandler(BLLoggerPlay.getLogger(), null);
            this.handler = new Mt101PaymentCsvImportHandler(user, (PaymentConversionHandler2<?>)conversionHandler2, converterFormat);
        } else {
            BLLoggerPlay.error("Unsupported order type for CSV payment import!");
            return new String[0][0];
        }
        TableFileReader reader = new TableFileReader(CsvColumnSeparator.SEMICOLON, Charset.defaultCharset(), 0);
        InputStream inputStream = null;
        try {
            inputStream = EncryptData.getInstance().openInputStream(file2);
            reader.readCsvFile(inputStream);
            String[][] stringArray = reader.getTableContent(false);
            return stringArray;
        }
        catch (Exception e) {
            BLLoggerPlay.error("Failed to load content of payment import file " + file2.getAbsolutePath(), e);
            String[][] stringArray = new String[0][0];
            return stringArray;
        }
        finally {
            SystemUtils.close((AutoCloseable)inputStream);
        }
    }

    public List<CsvImport.Field> getColumnFields(Messages messages) {
        if (this.handler != null) {
            return this.handler.getFields(messages);
        }
        return new ArrayList<CsvImport.Field>();
    }

    public Form<PaymentCsvImportForm> validate(Form<PaymentCsvImportForm> form, PaymentContextType paymentContext, Integer bankId, User user, String templateName, String firstExecution, String nextExecution, String lastExecution, String executionInterval, String[][] content, Messages messages) {
        this.paymentContext = paymentContext;
        if (bankId != null && bankId >= 0) {
            this.bank = BankSettings.getByIdAndUser((Integer)bankId, (User)user);
            if (this.bank == null) {
                form = form.withGlobalError("error.invalid");
            }
        } else {
            this.bank = null;
        }
        if (paymentContext == PaymentContextType.PAYMENT_TEMPLATE) {
            this.templateName = templateName;
            if (templateName == null || templateName.isEmpty() || templateName.length() > 80) {
                form = form.withGlobalError("paymenttemplates.error.invalidName");
            }
        } else if (paymentContext == PaymentContextType.PERIODIC_PAYMENT) {
            try {
                this.firstExecution = Utils.getDateFromDatePickerFormattedDate(messages.lang().locale(), firstExecution);
                if (this.firstExecution == null) {
                    form = form.withGlobalError("periodicpayments.error.firstExecutionRequired");
                }
            }
            catch (NullPointerException | ParseException e) {
                form = form.withGlobalError("periodicpayments.error.firstExecutionRequired");
            }
            try {
                this.nextExecution = Utils.getDateFromDatePickerFormattedDate(messages.lang().locale(), nextExecution);
                if (this.nextExecution == null) {
                    form = form.withGlobalError("periodicpayments.error.nextExecutionRequired");
                }
            }
            catch (NullPointerException | ParseException e) {
                form = form.withGlobalError("periodicpayments.error.nextExecutionRequired");
            }
            try {
                this.lastExecution = Utils.getDateFromDatePickerFormattedDate(messages.lang().locale(), lastExecution);
            }
            catch (NullPointerException | ParseException e) {
                this.lastExecution = null;
            }
            try {
                this.executionInterval = executionInterval;
                if (this.executionInterval == null) {
                    form = form.withGlobalError("periodicpayments.error.executionIntervalRequired");
                } else {
                    PeriodicPayment.ExecutionInterval.valueOf((String)executionInterval);
                }
            }
            catch (IllegalArgumentException e) {
                form = form.withGlobalError("periodicpayments.error.executionIntervalRequired");
            }
        }
        int columns = 0;
        if (content != null) {
            for (String[] line : content) {
                if (line == null || line.length <= columns) continue;
                columns = line.length;
            }
        }
        for (CsvImport.Field field : this.handler.getFields(null)) {
            String columnString;
            block27: {
                columnString = (String)form.rawData().get(field.getFieldId());
                if (columnString == null || columnString.isEmpty()) {
                    columnString = (String)form.rawData().get(field.getFieldId() + "_fix");
                } else {
                    try {
                        int column = Integer.parseInt(columnString);
                        if (column < 0 || column >= columns) {
                            form = form.withError(field.getFieldId(), "error.invalid");
                        }
                        break block27;
                    }
                    catch (NumberFormatException e) {
                        form = form.withError(field.getFieldId(), "error.invalid");
                    }
                    continue;
                }
            }
            if (!field.isMandatory() || columnString != null && !columnString.isEmpty()) continue;
            form = form.withError(field.getFieldId(), "error.required");
        }
        return form;
    }

    public void runImport(Form<PaymentCsvImportForm> form, User user, PaymentTransferType.PmtType pmtType, String[][] content, Integer folderId, boolean saveRecipients, boolean saveOriginators, String encoding, Messages messages, Set<String> errorMessages) throws PaymentException {
        ArrayList<BankSettings> banks2;
        this.importCount = 0;
        if (this.bank == null) {
            banks2 = BankSettings.findBanksForUser((User)user);
        } else {
            banks2 = new ArrayList<BankSettings>(1);
            banks2.add(this.bank);
        }
        PaymentFolder folder = folderId != null && folderId >= 0 ? PaymentFolder.findById((Integer)folderId, (User)user) : null;
        DatabasePreferenceStore preferenceStore = new DatabasePreferenceStore(Preference.ApplicationId.PAYMENTS, user);
        saveOriginators &= preferenceStore.getBoolean((DatabasePreferenceConstant)PreferenceConstants.ALLOW_ORIGINATOR_RECORDING);
        saveRecipients &= !PreferenceUtil.disableRecipientRecording((User)user);
        PaymentImportOriginatorAndRecipientHandler originatorAndRecipientHandler = new PaymentImportOriginatorAndRecipientHandler();
        PaymentType recipientType = this.handler.getRecipientPaymentType(user);
        PaymentType originatorType = this.handler.getOriginatorPaymentType();
        List<PaymentHandler<?>> payments = this.generatePayments(form, content, pmtType, encoding);
        errorMessages.addAll(this.handler.getErrorMessages(messages));
        if (payments != null && !payments.isEmpty()) {
            PaymentHandler.USED_TEMPLATE_NAMES.clear();
            try (Transaction t = DB.beginTransaction();){
                for (PaymentHandler<?> payment : payments) {
                    BankSettings bank;
                    Account originatorAccount = null;
                    Iterator iterator = banks2.iterator();
                    while (iterator.hasNext() && (originatorAccount = payment.getOriginatorAccount(bank = (BankSettings)iterator.next())) == null) {
                    }
                    if (originatorAccount == null) {
                        BLLoggerPlay.error("Did not find originator account " + payment.getOriginatorAccount() + ", payment can not be imported!");
                        errorMessages.add(BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.unknownOriginatorAccount", (Object[])new Object[]{payment.getOriginatorAccount()}));
                        continue;
                    }
                    boolean checkPermissions = new DatabasePreferenceStore(Preference.ApplicationId.PAYMENTS, user, originatorAccount.getBank().getTenant()).getBoolean((DatabasePreferenceConstant)PreferenceConstants.CHECK_PERMISSION_FOR_PAYMENT_RECORDING);
                    if (checkPermissions) {
                        String orderTypeOrBtf;
                        BankSettings bankSettings = originatorAccount.getBank();
                        String string = orderTypeOrBtf = BankUtils.isProtocolH005OrNewer((String)bankSettings.getProtocolVersion()) ? SendParameters.getBTF((BankSettings)bankSettings, (PaymentTransferType.PmtType)pmtType) : SendParameters.getOrderType((BankSettings)bankSettings, (PaymentTransferType.PmtType)pmtType);
                        if (new PermissionsLoader(user).getAccountOrderTypes(originatorAccount, new String[]{orderTypeOrBtf}).isEmpty()) {
                            String iban = IbanUtil.formatIfIBAN((String)payment.getOriginatorAccount());
                            BLLoggerPlay.info("No permission for originator account " + iban + " or for order type " + orderTypeOrBtf);
                            errorMessages.add(BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.noPermissionForAccountOrOrderType", (Object[])new Object[]{orderTypeOrBtf, iban}));
                            continue;
                        }
                    }
                    if (PaymentContextType.OPEN_PAYMENT == this.paymentContext) {
                        payment.createOpenPayment(originatorAccount.getBank(), pmtType, folder, false).save(user, false);
                        ++this.importCount;
                    } else if (PaymentContextType.PAYMENT_TEMPLATE == this.paymentContext) {
                        payment.createPaymentTemplate(originatorAccount.getBank(), pmtType, this.templateName, folder).save();
                        ++this.importCount;
                    } else if (PaymentContextType.PERIODIC_PAYMENT == this.paymentContext) {
                        PeriodicPayment periodicPayment = payment.createPeriodicPayment(originatorAccount.getBank(), pmtType, folder, false);
                        periodicPayment.setFirstExecutionDate(new Date(this.firstExecution.getTime()));
                        periodicPayment.setNextExecutionDate(new Date(this.nextExecution.getTime()));
                        if (this.lastExecution != null) {
                            periodicPayment.setLastExecutionDate(new Date(this.lastExecution.getTime()));
                        }
                        periodicPayment.setExecutionInterval(PeriodicPayment.ExecutionInterval.valueOf((String)this.executionInterval));
                        periodicPayment.save(user, false);
                        ++this.importCount;
                    }
                    if (saveRecipients && !originatorAndRecipientHandler.checkForRecipient(payment.getRecipient(), payment.getRecipientAccountNumber(), payment.getRecipientBankcode(), recipientType, originatorAccount.getBank().getTenant())) {
                        originatorAndRecipientHandler.addRecipient(payment.buildRecipient(false, null, recipientType, originatorAccount.getBank().getTenant(), user.getTenants(), true));
                    }
                    if (!saveOriginators || originatorAndRecipientHandler.checkForOriginator(payment.getOriginator(), originatorType, originatorAccount.getBank().getTenant())) continue;
                    originatorAndRecipientHandler.addOriginator(payment.buildOriginator(originatorAccount.getBank().getTenant()));
                }
                t.commit();
            }
            PaymentHandler.USED_TEMPLATE_NAMES.clear();
        }
        originatorAndRecipientHandler.save(user);
        this.handler.updateConverterFormat(this.hasHeadline);
    }

    public List<BankOrderWithPayments> createBankOrders(Form<PaymentCsvImportForm> form, User user, String[][] content, Integer bankId, PaymentTransferType.PmtType pmtType, String orderOrFileType, Messages messages, String encoding, List<ValidationError> errors) {
        List<PaymentHandler<?>> payments = this.generatePayments(form, content, pmtType, encoding);
        Set<String> errorMessages = this.handler.getErrorMessages(messages);
        if (errorMessages != null && !errorMessages.isEmpty()) {
            for (String errorMessage : errorMessages) {
                errors.add(new ValidationError("", errorMessage));
            }
            return null;
        }
        if (payments == null || payments.size() < content.length) {
            int failed = payments == null ? content.length : content.length - payments.size();
            if (content.length <= 1) {
                errors.add(new ValidationError("", messages.at("sent.import.csv.couldnotconvertpayment", new Object[]{content.length})));
            } else {
                errors.add(new ValidationError("", messages.at("sent.import.csv.couldnotconvertallpayments", new Object[]{failed, content.length})));
            }
            return null;
        }
        BankSettings bank = BankSettings.getByIdAndUser((Integer)bankId, (User)user);
        if (bank == null) {
            errors.add(new ValidationError("", "sent.import.csv.nobankpermission"));
            return null;
        }
        String orderTypeOrBtf = orderOrFileType != null ? orderOrFileType : SendParameters.getTransferTypeByBank((BankSettings)bank, (PaymentTransferType.PmtType)pmtType);
        OpenPayment openPayment = new OpenPayment();
        openPayment.setBank(bank);
        if (BankUtils.isProtocolH005OrNewer((String)bank.getProtocolVersion())) {
            openPayment.setOrderType("BTU");
            openPayment.setFileType(orderTypeOrBtf);
        } else if (bank.isFrenchBank()) {
            openPayment.setOrderType("FUL");
            openPayment.setFileType(orderTypeOrBtf);
        } else {
            openPayment.setOrderType(orderTypeOrBtf);
            openPayment.setFileType(null);
        }
        openPayment.setPmtType(payments.getFirst().getPaymentType(pmtType));
        ArrayList<BankOrderPayment> bankOrderPayments = new ArrayList<BankOrderPayment>();
        for (PaymentHandler<?> payment : payments) {
            bankOrderPayments.add(new BankOrderPayment(openPayment, payment));
        }
        this.handler.updateConverterFormat(this.hasHeadline);
        return BankOrderWithPayments.getListFromMap(new BankOrderFactory(user, messages.lang().locale()).createBankOrders(user, bankOrderPayments));
    }

    public boolean hasImportedPayments() {
        return this.importCount > 0;
    }

    public String getResultMessage(Messages messages, int totalSize) {
        return switch (this.paymentContext) {
            case PaymentContextType.PAYMENT_TEMPLATE -> messages.at("payment.importedtemplates", new Object[]{this.importCount, totalSize - this.importCount});
            case PaymentContextType.PERIODIC_PAYMENT -> messages.at("periodicpayments.import.done", new Object[]{this.importCount, totalSize - this.importCount});
            default -> messages.at("payment.importedpayments", new Object[]{this.importCount, totalSize - this.importCount});
        };
    }

    private List<PaymentHandler<?>> generatePayments(Form<PaymentCsvImportForm> form, String[][] content, PaymentTransferType.PmtType pmtType, String encoding) {
        HashMap<String, Object> formatFields = new HashMap<String, Object>();
        for (CsvImport.Field field : this.handler.getFields(null)) {
            String columnString = (String)form.rawData().get(field.getFieldId());
            if (columnString == null || columnString.isEmpty()) {
                columnString = (String)form.rawData().get(field.getFieldId() + "_fix");
                if (columnString == null || columnString.isEmpty()) continue;
                formatFields.put(field.getFieldId(), columnString);
                continue;
            }
            formatFields.put(field.getFieldId(), Integer.parseInt(columnString));
        }
        String formatString = this.handler.buildFormatString(formatFields, pmtType);
        return this.handler.loadPayments(this.bank, formatString, pmtType, this.numberFormat, content, false, encoding);
    }
}

