/*
 * Decompiled with CFR 0.152.
 */
package models;

import controllers.Yubikeys;
import controllers.util.BLLoggerPlay;
import de.businesslogics.banking.api.BankingApiMessages;
import de.businesslogics.banking.api.DatabasePreferenceConstant;
import de.businesslogics.banking.api.DatabasePreferenceStore;
import de.businesslogics.banking.bank.DatabaseToken;
import de.businesslogics.banking.database.vo.Preference;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.banking.database.vo.Yubikey;
import de.businesslogics.banking.preferences.PreferenceConstants;
import de.businesslogics.util.BLLogger;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.Locale;
import models.WebAuthnData;
import play.data.Form;
import play.data.validation.Constraints;

public class PasswordForm {
    private boolean userLocked = false;
    @Constraints.Required
    public String password;
    public String otp;
    public String credentialId;
    public String authenticatorData;
    public String clientDataJSON;
    public String signature;

    public boolean isUserLocked() {
        return this.userLocked;
    }

    protected void setUserLocked(boolean locked) {
        this.userLocked = locked;
    }

    public <T extends PasswordForm> Form<T> checkPassword(Form<T> form, User user, PasswordType type, Locale locale) {
        return this.checkPassword(form, user, type, true, locale);
    }

    public <T extends PasswordForm> Form<T> checkPassword(Form<T> form, User user, PasswordType type, boolean checkOTP, Locale locale) {
        try {
            ((PasswordForm)form.get()).setUserLocked(false);
            if (this.password == null) {
                return form.withError("password", "error.required");
            }
            if (!DatabaseToken.checkPassword((User)user, (char[])this.password.toCharArray(), (BLLogger)BLLoggerPlay.getLogger())) {
                BLLoggerPlay.info("Incorrect password for user " + user.getName() + ".");
                switch (type.ordinal()) {
                    case 0: {
                        ((PasswordForm)form.get()).setUserLocked(user.setLoginError());
                        break;
                    }
                    case 1: {
                        ((PasswordForm)form.get()).setUserLocked(user.setSignatureError());
                    }
                }
                return form.withError("password", "general.passwordwrong");
            }
        }
        catch (IOException | GeneralSecurityException e) {
            BLLoggerPlay.warning("Error verifying password for user " + user.getName() + ".", e);
            return form.withError("password", "general.passwordwrong");
        }
        if (checkOTP && Yubikey.hasKeyOfType((User)user, (Yubikey.SecurityType[])new Yubikey.SecurityType[0])) {
            if (this.otp != null && !this.otp.isEmpty()) {
                if (!Yubikeys.validateOTP(this.otp, user)) {
                    BLLoggerPlay.info("Invalid OTP for user " + user.getName() + ".");
                    return form.withError("otp", BankingApiMessages.getString((Locale)locale, (String)"GeneralMessages.invalidOTP", (Object[])new Object[0]));
                }
            } else if (this.credentialId != null && !this.credentialId.isEmpty()) {
                if (!WebAuthnData.checkWebAuthn(user, Yubikeys.convertString(this.authenticatorData), Yubikeys.convertString(this.clientDataJSON), Yubikeys.convertString(this.signature), this.credentialId, User.getChallenge((User)user), null)) {
                    return form.withError("password", "general.passwordwrong");
                }
            } else {
                DatabasePreferenceStore preferenceStore = new DatabasePreferenceStore(Preference.ApplicationId.BANKING, user);
                if (!PasswordType.EBICS_PASSWORD.equals((Object)type) || preferenceStore.getBoolean((DatabasePreferenceConstant)PreferenceConstants.USE_2FA_FOR_SIGING)) {
                    BLLoggerPlay.info("No 2nd factor for user " + user.getName());
                    return form.withError("password", "general.passwordwrong");
                }
            }
        }
        switch (type.ordinal()) {
            case 0: {
                user.cleanLoginError(false);
                break;
            }
            case 1: {
                user.cleanSignatureError();
            }
        }
        return form;
    }

    public static enum PasswordType {
        LOGIN_PASSWORD,
        EBICS_PASSWORD;

    }

    public static enum PasswordOperation {
        SIGN,
        CANCEL,
        SYNC,
        INI,
        CANCEL_FROM_SENT,
        RENEW_KEYS,
        LOCK,
        SHARE_BANK,
        VOP_SUBMIT;

    }
}

