/*
 * Decompiled with CFR 0.152.
 */
package models;

import controllers.util.SortingHandler;
import de.businesslogics.banking.api.DatabasePreferenceConstant;
import de.businesslogics.banking.api.DatabasePreferenceStore;
import de.businesslogics.banking.database.vo.Account;
import de.businesslogics.banking.database.vo.PaymentOriginator;
import de.businesslogics.banking.database.vo.Preference;
import de.businesslogics.banking.database.vo.Sorting;
import de.businesslogics.banking.database.vo.Tenant;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.banking.payments.core.PreferenceConstants;
import java.io.IOException;
import play.data.Form;
import play.data.validation.Constraints;
import play.i18n.Messages;

public abstract class OriginatorForm {
    @Constraints.Required
    public String name;
    public Integer tenantId;
    protected Tenant tenant;
    public Account defaultAccount;
    public Integer defaultAccountId;

    public static boolean isFieldEnabled(String fieldName, User loggedInUser) {
        boolean originatorRecordingAllowed = new DatabasePreferenceStore(Preference.ApplicationId.PAYMENTS, loggedInUser).getBoolean((DatabasePreferenceConstant)PreferenceConstants.ALLOW_ORIGINATOR_RECORDING);
        return OriginatorForm.isFieldEnabled(fieldName, loggedInUser, originatorRecordingAllowed);
    }

    public static boolean isFieldEnabled(String fieldName, User loggedInUser, boolean editable) {
        return editable;
    }

    public abstract Form<? extends OriginatorForm> validate(Form<? extends OriginatorForm> var1, User var2, Messages var3, PaymentOriginator var4);

    public String checkAccountId(User user) {
        if (this.defaultAccountId != null && this.defaultAccountId > 0) {
            this.defaultAccount = Account.findAccountByIdAndUser((int)this.defaultAccountId, (User)user, (boolean)false);
            Tenant accountTenant = this.defaultAccount.getBank().getTenant();
            if (!accountTenant.equals(this.tenant)) {
                return "originators.defaultaccount.tenanterror";
            }
        }
        return null;
    }

    public abstract void store(PaymentOriginator var1, User var2) throws IOException;

    public void loadDefaultFormSettings(User user) {
        String tenantIdString = new SortingHandler(user, Sorting.Table.PMT_ORIGINATOR).getProperty("TENANT");
        if (tenantIdString != null) {
            try {
                this.tenantId = Integer.parseInt(tenantIdString);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

