/*
 * Decompiled with CFR 0.152.
 */
package models;

import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.database.vo.FilterComparator;
import de.businesslogics.banking.database.vo.NotificationFilter;
import de.businesslogics.banking.database.vo.User;
import java.util.Date;
import play.data.Form;

public final class NotificationFilterForm {
    public Integer bank;
    public Integer orderTypeComparator;
    public String orderType;
    public Integer dateComparator;
    public Date dateFrom;
    public Date dateTo;

    public NotificationFilterForm() {
    }

    public NotificationFilterForm(NotificationFilter notificationFilter) {
        BankSettings b;
        User user = notificationFilter.getUser();
        if (notificationFilter.getBank() != null && (b = BankSettings.getByIdAndUser((Integer)notificationFilter.getBank().getBankId(), (User)user)) != null) {
            this.bank = b.getBankId();
        }
        if (notificationFilter.getOrderTypeComparator() != null) {
            this.orderTypeComparator = notificationFilter.getOrderTypeComparator().ordinal();
        }
        this.orderType = notificationFilter.getOrderType();
        this.dateComparator = notificationFilter.getDateComparatorIndex();
        if (this.dateComparator < 0) {
            this.dateComparator = null;
        }
        this.dateFrom = notificationFilter.getFromDate();
        this.dateTo = notificationFilter.getToDate();
    }

    public Form<NotificationFilterForm> validate(Form<NotificationFilterForm> form, NotificationFilter notificationFilter) {
        User user = notificationFilter.getUser();
        if (this.bank == null || this.bank < 0) {
            notificationFilter.setBank(null);
        } else {
            BankSettings b = BankSettings.getByIdAndUser((Integer)this.bank, (User)user);
            if (b != null) {
                notificationFilter.setBank(b);
            } else {
                form = form.withError("bank", "error.invalid");
            }
        }
        notificationFilter.setOrderTypeComparator(this.orderTypeComparator.intValue());
        notificationFilter.setOrderType(this.orderType);
        if (this.dateComparator == null || this.dateComparator < 0) {
            notificationFilter.setDateComparator(null);
            notificationFilter.setFromDate(null);
            notificationFilter.setToDate(null);
            if (this.dateFrom != null || this.dateTo != null) {
                form = form.withError("dateComparator", "error.invalid");
            }
        } else {
            notificationFilter.setDateComparatorIndex(this.dateComparator.intValue());
            if (notificationFilter.getDateComparator() == FilterComparator.Date.BETWEEN) {
                if (this.dateFrom == null && this.dateTo == null) {
                    notificationFilter.setFromDate(null);
                    notificationFilter.setToDate(null);
                    notificationFilter.setDateComparator(null);
                } else {
                    if (this.dateFrom == null) {
                        notificationFilter.setFromDate(null);
                    } else {
                        notificationFilter.setFromDate(new java.sql.Date(this.dateFrom.getTime()));
                    }
                    if (this.dateTo == null) {
                        notificationFilter.setDateComparator(FilterComparator.Date.GREATER);
                        notificationFilter.setToDate(null);
                    } else if (this.dateFrom == null) {
                        notificationFilter.setDateComparator(FilterComparator.Date.LESS);
                        notificationFilter.setFromDate(new java.sql.Date(this.dateTo.getTime()));
                    } else {
                        notificationFilter.setToDate(new java.sql.Date(this.dateTo.getTime()));
                    }
                }
            } else {
                if (this.dateFrom == null) {
                    form = form.withError("dateFrom", "error.invalid");
                    notificationFilter.setFromDate(null);
                } else {
                    notificationFilter.setFromDate(new java.sql.Date(this.dateFrom.getTime()));
                }
                notificationFilter.setToDate(null);
            }
        }
        return form;
    }
}

