/*
 * Decompiled with CFR 0.152.
 */
package models;

import controllers.util.GeneralUtils;
import controllers.util.TenantUtils;
import de.businesslogics.banking.api.BankingApiMessages;
import de.businesslogics.banking.database.api.DB;
import de.businesslogics.banking.database.vo.Account;
import de.businesslogics.banking.database.vo.CmFolder;
import de.businesslogics.banking.database.vo.CmValueGroup;
import de.businesslogics.banking.database.vo.Tenant;
import de.businesslogics.banking.database.vo.User;
import java.util.HashSet;
import java.util.Locale;
import java.util.stream.Collectors;
import play.data.Form;

public class NewValueGroupForm {
    public String name;
    public Integer tenantId;
    public String accounts = "";
    public String folders = "";

    public static NewValueGroupForm fill(CmValueGroup group) {
        NewValueGroupForm form = new NewValueGroupForm();
        form.name = group.getName();
        form.tenantId = group.getTenant().getId();
        form.folders = NewValueGroupForm.getFolderIds(group);
        form.accounts = NewValueGroupForm.getAccountIds(group);
        return form;
    }

    public static String getAccountIds(CmValueGroup group) {
        if (group == null) {
            return "";
        }
        return group.getAccounts().stream().map(f -> f.getId().toString()).collect(Collectors.joining(","));
    }

    public static String getFolderIds(CmValueGroup group) {
        if (group == null) {
            return "";
        }
        return group.getFolders().stream().map(f -> f.getId().toString()).collect(Collectors.joining(","));
    }

    public Form<NewValueGroupForm> validateAndSave(Form<NewValueGroupForm> form, CmValueGroup group, User user, Locale locale) {
        Tenant tenant;
        if (group.getId() == null) {
            String error = TenantUtils.checkTenantId(this.tenantId, user);
            if (error != null) {
                return form.withError("tenantId", error);
            }
            tenant = TenantUtils.getTenantByIdAndUser(this.tenantId, user);
        } else {
            tenant = group.getTenant();
        }
        group.setTenant(tenant);
        switch (CmValueGroup.nameIsValid((CmValueGroup)group, (String)this.name, (Tenant)tenant)) {
            case EXISTS: {
                return form.withError("name", BankingApiMessages.getString((Locale)locale, (String)"GeneralMessages.nameAlreadyExists", (Object[])new Object[0]));
            }
            case EMPTY: {
                return form.withError("name", BankingApiMessages.getString((Locale)locale, (String)"GeneralMessages.error.empty", (Object[])new Object[0]));
            }
        }
        group.setName(this.name);
        group.getAccounts().clear();
        if (this.accounts != null && !this.accounts.isEmpty()) {
            HashSet<Integer> uniqueAccountIds = new HashSet<Integer>(GeneralUtils.getSelectionIds(this.accounts));
            for (Integer accountId : uniqueAccountIds) {
                Account account = Account.findById((int)accountId);
                if (account == null || !account.getBank().getTenant().equals(tenant)) continue;
                group.getAccounts().add(account);
            }
        }
        group.getFolders().clear();
        if (this.folders != null && !this.folders.isEmpty()) {
            HashSet<Integer> uniqueFolderIds = new HashSet<Integer>(GeneralUtils.getSelectionIds(this.folders));
            for (Integer folderId : uniqueFolderIds) {
                CmFolder folder = CmFolder.findById((Integer)folderId, (User)user);
                if (folder == null || !folder.getTenant().equals(tenant)) continue;
                group.getFolders().add(folder);
            }
        }
        DB.save((Object)group);
        return form;
    }
}

