/*
 * Decompiled with CFR 0.152.
 */
package models;

import de.businesslogics.banking.api.BankUtils;
import de.businesslogics.banking.database.vo.BankUser;
import de.businesslogics.ebics.schema.types.SignatureVersion;
import java.util.HashMap;
import java.util.Map;
import models.PasswordForm;
import play.data.validation.Constraints;

public class NewUserIniForm
extends PasswordForm {
    public Map<Integer, String> userId = new HashMap<Integer, String>();
    @Constraints.Required
    public SignatureVersion signatureVersion = SignatureVersion.A006;
    @Constraints.Min(value=2048L)
    @Constraints.Max(value=4096L)
    @Constraints.Required
    public @Constraints.Min(value=2048L) @Constraints.Max(value=4096L) @Constraints.Required int sigKeyLength = 2048;
    @Constraints.Min(value=2048L)
    @Constraints.Max(value=4096L)
    @Constraints.Required
    public @Constraints.Min(value=2048L) @Constraints.Max(value=4096L) @Constraints.Required int authKeyLength = 2048;
    @Constraints.Min(value=2048L)
    @Constraints.Max(value=4096L)
    @Constraints.Required
    public @Constraints.Min(value=2048L) @Constraints.Max(value=4096L) @Constraints.Required int encKeyLength = 2048;

    public BankUser createTemporaryBankUser(BankUser bankUser) {
        BankUser b = new BankUser();
        b.setId(bankUser.getId());
        b.setUser(bankUser.getUser());
        b.setBank(bankUser.getBank());
        b.setDefaultUser(this.userId.get(bankUser.getId()).trim());
        b.setSignatureVersion(this.signatureVersion.getValue());
        b.setAuthKeyLength(this.authKeyLength);
        b.setEncrKeyLength(this.encKeyLength);
        b.setSigKeyLength(this.sigKeyLength);
        b.setState(BankUser.UserState.CREATED);
        b.setOrderNumber(bankUser.getOrderNumber());
        b.setSepaMessageId(bankUser.getSepaMessageId());
        b.setDtausReferenceNumber(bankUser.getDtausReferenceNumber());
        b.setBundesbankFileNumber(bankUser.getBundesbankFileNumber());
        if (bankUser.getBank() != null) {
            b.setWithCerts(bankUser.getBank().isFrenchBank() || BankUtils.isProtocolH005OrNewer((String)bankUser.getBank().getProtocolVersion()));
        }
        return b;
    }
}

