/*
 * Decompiled with CFR 0.152.
 */
package models;

import controllers.Banks;
import controllers.branding.Branding;
import controllers.util.BLLoggerAdmin;
import controllers.util.BLLoggerPlay;
import controllers.util.EbicsUtil;
import controllers.util.LicenseHandler;
import controllers.util.TenantUtils;
import de.businesslogics.banking.api.AdminLogger;
import de.businesslogics.banking.api.BankingApiMessages;
import de.businesslogics.banking.bank.PropertiesKeys;
import de.businesslogics.banking.database.api.DB;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.database.vo.BankUser;
import de.businesslogics.banking.database.vo.Tenant;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.ebics.client.EbicsHttpEngine;
import de.businesslogics.ebics.client.EbicsHttpEngineImpl;
import de.businesslogics.ebics.client.EbicsSession;
import de.businesslogics.ebics.schema.h000.EbicsHEVResponse;
import de.businesslogics.ebics.schema.response.EbicsException;
import de.businesslogics.ebics.schema.types.ProtocolVersion;
import de.businesslogics.ebics.schema.types.ReturnCode;
import de.businesslogics.util.BLLogger;
import de.businesslogics.util.StringUtils;
import de.businesslogics.validation.RegularExpressions;
import io.ebean.Transaction;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import models.KnownBank;
import play.data.Form;
import play.data.validation.Constraints;
import play.i18n.Messages;
import views.Utils;

public final class NewBankForm {
    public static final String HEV_ERROR_KEY = "hev_fetch_failed";
    public Integer tenantId;
    public String icon = Branding.getBranding().getDefaultBankIcon();
    @Constraints.Required
    public String bankname;
    @Constraints.Required
    public String url;
    @Constraints.Required
    public String hostId;
    @Constraints.Required
    public String customerId;
    @Constraints.Required
    public ProtocolVersion protocolVersion = ProtocolVersion.H005;
    public String e002Hash;
    public String x002Hash;
    public boolean startIni;
    public boolean ignoreHevError;
    public boolean createFetchSchedule;
    public Map<Integer, Boolean> users = new HashMap<Integer, Boolean>();
    private List<User> usersToAdd;
    private Tenant tenant;
    public String countryCode = "DE";

    public void fillFromKnownBank(String bankName) {
        for (KnownBank b : Banks.getKnownBanks()) {
            if (!b.bankname.equals(bankName)) continue;
            this.bankname = b.bankname;
            this.hostId = b.hostId;
            this.url = b.url;
            this.icon = Banks.getIcon(b.icon);
            this.e002Hash = b.e002Cert;
            this.x002Hash = b.x002Cert;
            this.countryCode = b.countryCode;
            break;
        }
    }

    public void fillFromLicenseInfo(User user) throws IOException {
        Properties p = LicenseHandler.getInstance().getLicenseProperties(user).getProperties();
        this.bankname = p.getProperty(PropertiesKeys.Bank.DISPLAY_NAME.name());
        this.customerId = p.getProperty(PropertiesKeys.Bank.CUSTOMER_ID.name());
        this.hostId = p.getProperty(PropertiesKeys.Bank.HOST_ID.name());
        this.url = p.getProperty(PropertiesKeys.Bank.URL.name());
        this.protocolVersion = ProtocolVersion.getInstance((String)p.getProperty(PropertiesKeys.Bank.PROTOCOL_VERSION.name(), ProtocolVersion.H004.getValue()));
        this.icon = p.getProperty(PropertiesKeys.Bank.ICON.name(), "");
        this.e002Hash = p.getProperty(PropertiesKeys.Bank.E002.name() + PropertiesKeys.Bank._DIGEST.name(), "");
        this.x002Hash = p.getProperty(PropertiesKeys.Bank.X002.name() + PropertiesKeys.Bank._DIGEST.name(), "");
    }

    private static boolean formHasErrors(Form<NewBankForm> form, boolean includeHevError) {
        return includeHevError ? form.hasErrors() : form.errors().size() > form.errors(HEV_ERROR_KEY).size();
    }

    public Form<NewBankForm> validate(Form<NewBankForm> form, User user, Messages messages) {
        List existingBanks;
        this.hostId = StringUtils.trim((String)this.hostId);
        this.customerId = StringUtils.trim((String)this.customerId);
        this.e002Hash = StringUtils.trimAndUpperCase((String)this.e002Hash);
        this.e002Hash = StringUtils.removeAllWhitespace((String)this.e002Hash);
        this.x002Hash = StringUtils.trimAndUpperCase((String)this.x002Hash);
        this.x002Hash = StringUtils.removeAllWhitespace((String)this.x002Hash);
        if (this.hostId != null && !this.hostId.isEmpty() && !StringUtils.check((String)this.hostId, (RegularExpressions)RegularExpressions.EBICS_V24_HOST_ID)) {
            form = form.withError("hostId", "bankdetails.hostid.invalid");
        }
        if (this.customerId != null && !this.customerId.isEmpty() && !StringUtils.check((String)this.customerId, (RegularExpressions)RegularExpressions.EBICS_V24_PARTNER_ID)) {
            form = form.withError("customerId", "general.error.invalidCharacters");
        }
        if (this.e002Hash != null && !this.e002Hash.isEmpty() && !StringUtils.check((String)this.e002Hash, (RegularExpressions)RegularExpressions.HEX_STRING)) {
            form = form.withError("e002Hash", "bankdetails.hash.hexValue");
        }
        if (this.x002Hash != null && !this.x002Hash.isEmpty() && !StringUtils.check((String)this.x002Hash, (RegularExpressions)RegularExpressions.HEX_STRING)) {
            form = form.withError("x002Hash", "bankdetails.hash.hexValue");
        }
        if (this.url == null || this.url.isEmpty()) {
            form = form.withError("url", "error.required");
        } else {
            try {
                URL u = new URI(this.url).toURL();
                if (!"HTTPS".equalsIgnoreCase(u.getProtocol())) {
                    form = form.withError("url", BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.urlNoHttps", (Object[])new Object[0]));
                } else {
                    EbicsHEVResponse hev = EbicsSession.getEbicsVersions((URL)u, (String)this.hostId, (EbicsHttpEngine)new EbicsHttpEngineImpl(), (File)EbicsUtil.getLogDir(user));
                    if (hev != null && !hev.can(this.protocolVersion)) {
                        Map<String, String> versionsMap = Banks.protocolVersionsMap(true);
                        StringBuilder supported = new StringBuilder();
                        for (String version : versionsMap.keySet()) {
                            if (!hev.can(ProtocolVersion.getInstance((String)version))) continue;
                            if (!supported.isEmpty()) {
                                supported.append(", ");
                            }
                            supported.append(versionsMap.get(version));
                        }
                        form = form.withError("protocolVersion", "bank.create.invalidprotocolversion", Collections.singletonList(supported.toString()));
                    }
                }
            }
            catch (EbicsException | IOException | URISyntaxException e) {
                if (e instanceof EbicsException) {
                    BLLoggerPlay.error("An error occurred while checking the EBICS URL: " + e.getMessage());
                } else {
                    BLLoggerPlay.error("An error occurred while checking the EBICS URL!", e);
                }
                String error = Utils.getLocalizedMessage(e, messages);
                if (e instanceof EbicsException) {
                    EbicsException ebics = (EbicsException)e;
                    form = ebics.getReturnCode().equals((Object)ReturnCode.EBICS_INVALID_HOSTID) ? form.withGlobalError(error) : form.withError(HEV_ERROR_KEY, error);
                }
                form = form.withError(HEV_ERROR_KEY, error);
            }
        }
        String tenantError = TenantUtils.checkTenantId(this.tenantId, user, true);
        if (tenantError != null) {
            return form.withError("tenantId", tenantError);
        }
        this.tenant = TenantUtils.getTenantByIdAndUser(this.tenantId, user, true);
        if (NewBankForm.formHasErrors((Form<NewBankForm>)form, false) && !form.hasGlobalErrors()) {
            form = form.withGlobalError("general.formerror");
        }
        if ((existingBanks = BankSettings.findByCustomer((String)this.url, (String)this.hostId, (String)this.customerId, (Tenant)this.tenant)) != null && !existingBanks.isEmpty()) {
            form = form.withGlobalError("bank.create.alreadyexists");
        }
        this.usersToAdd = new ArrayList<User>();
        for (User u : User.getAllForTenants(Collections.singletonList(this.tenant), (boolean)true)) {
            if (!Boolean.TRUE.equals(this.users.get(u.getId()))) continue;
            this.usersToAdd.add(u);
        }
        if (this.usersToAdd.isEmpty()) {
            form = form.withGlobalError("bank.create.nousers");
        }
        return form;
    }

    public BankSettings storeBank(User user) {
        try (Transaction t = DB.beginTransaction();){
            AdminLogger logger = new AdminLogger((BLLogger)BLLoggerAdmin.getLogger());
            BankSettings bank = new BankSettings();
            bank.setCustomerId(this.customerId);
            bank.setDisplayName(this.bankname);
            bank.setExpectedDigestE002(this.e002Hash);
            bank.setExpectedDigestX002(this.x002Hash);
            bank.setHostId(this.hostId);
            bank.setIcon(this.icon);
            bank.setProtocolVersion(this.protocolVersion.getValue());
            bank.setUrl(this.url);
            bank.setTenant(this.tenant);
            bank.setCountryCode(this.countryCode);
            bank.save();
            logger.logBankCreated(user, bank);
            for (User u : this.usersToAdd) {
                BankUser.createBankUser((BankSettings)bank, (User)u);
                logger.logBankAddedUser(user, u, bank);
            }
            t.commit();
            BankSettings bankSettings = bank;
            return bankSettings;
        }
    }
}

