/*
 * Decompiled with CFR 0.152.
 */
package models;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import controllers.branding.Branding;
import controllers.routes;
import controllers.util.BLLoggerPlay;
import de.businesslogics.banking.api.BankingApiMessages;
import de.businesslogics.banking.api.DatabasePreferenceConstant;
import de.businesslogics.banking.api.DatabasePreferenceStore;
import de.businesslogics.banking.api.FormSettings;
import de.businesslogics.banking.api.Logger;
import de.businesslogics.banking.api.PermissionsLoader;
import de.businesslogics.banking.api.mt101.MT101FeeType;
import de.businesslogics.banking.database.api.DB;
import de.businesslogics.banking.database.vo.Account;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.database.vo.BankUser;
import de.businesslogics.banking.database.vo.PaymentFolder;
import de.businesslogics.banking.database.vo.PaymentOriginator;
import de.businesslogics.banking.database.vo.PaymentRecipient;
import de.businesslogics.banking.database.vo.PaymentTransferType;
import de.businesslogics.banking.database.vo.PaymentType;
import de.businesslogics.banking.database.vo.Preference;
import de.businesslogics.banking.database.vo.Tenant;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.banking.mt101.api.MT101Api;
import de.businesslogics.banking.mt101.api.MT101OriginatorData;
import de.businesslogics.banking.mt101.api.MT101RecipientData;
import de.businesslogics.banking.payments.api.PreferenceUtil;
import de.businesslogics.banking.payments.core.PreferenceConstants;
import de.businesslogics.format.swift.Field23E;
import de.businesslogics.format.swift.InstructionCode;
import de.businesslogics.format.swift.mt101.MT101PaymentData;
import de.businesslogics.iban.IbanUtil;
import de.businesslogics.util.Currency;
import de.businesslogics.util.StringUtils;
import de.businesslogics.validation.RegularExpressions;
import java.io.IOException;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import models.PaymentForm;
import models.payments.Mt101PaymentHandler;
import models.payments.PaymentContextType;
import models.payments.PaymentException;
import models.payments.PaymentHandler;
import play.data.Form;
import play.data.FormFactory;
import play.data.validation.ValidationError;
import play.i18n.Messages;
import play.libs.Json;
import play.libs.Scala;
import scala.Tuple2;
import scala.collection.immutable.Seq;
import views.Utils;

public final class Mt101PaymentForm
extends PaymentForm {
    private static final List<String> INSTRUCTION_CODES_WITH_ADDITIONAL_INFO = Arrays.asList(InstructionCode.REPA.toString(), InstructionCode.CMTO.toString(), InstructionCode.PHON.toString(), InstructionCode.OTHR.toString());
    public String originatorName2;
    public String originatorStreet;
    public String originatorTown;
    public String senderBic;
    public String receiverBic;
    public String recipientName2;
    public String recipientStreet;
    public String recipientTown;
    public String intermediaryBankCode;
    public String currency = "EUR";
    public boolean counterValue;
    public String counterValueCurrency = "EUR";
    public String purpose2;
    public String purpose3;
    public String purpose4;
    public String feeType;
    public Map<Integer, Instruction> instructions;
    private MT101PaymentData paymentData;

    public static PaymentTransferType.PmtType[] getPmtTypes() {
        return new PaymentTransferType.PmtType[]{PaymentTransferType.PmtType.MT101_TRANSFER};
    }

    public static boolean isMt101PmtType(PaymentTransferType.PmtType pmtType) {
        return Arrays.asList(Mt101PaymentForm.getPmtTypes()).contains(pmtType);
    }

    public static List<MT101OriginatorData> loadOriginators(User user) {
        ArrayList<MT101OriginatorData> result = new ArrayList<MT101OriginatorData>();
        for (PaymentOriginator paymentOriginator : PaymentOriginator.findOriginatorsForPaymentType((PaymentType)PaymentType.MT101, (List)user.getTenants())) {
            MT101OriginatorData originator = new MT101OriginatorData();
            try {
                originator.setPaymentOriginator(paymentOriginator);
                result.add(originator);
            }
            catch (IOException e) {
                BLLoggerPlay.error("Failed to load MT101 originator with ID: " + paymentOriginator.getId(), e);
            }
        }
        return result;
    }

    public static Seq<Tuple2<String, String>> loadOriginatorSequence(User user, boolean includeEmptyLine) {
        ArrayList<Tuple2> result = new ArrayList<Tuple2>();
        if (includeEmptyLine) {
            result.add(Scala.Tuple((Object)"-1", (Object)""));
        }
        for (MT101OriginatorData originator : Mt101PaymentForm.loadOriginators(user)) {
            result.add(Scala.Tuple((Object)originator.getPaymentOriginator().getId().toString(), (Object)Utils.addZWNJ(originator.getName())));
        }
        return Scala.toSeq(result);
    }

    public static List<MT101RecipientData> loadRecipients(User user) {
        ArrayList<MT101RecipientData> result = new ArrayList<MT101RecipientData>();
        for (PaymentRecipient paymentRecipient : PaymentRecipient.findRecipientsForPaymentType((PaymentType)PaymentType.MT101, (List)user.getTenants())) {
            MT101RecipientData recipient = new MT101RecipientData();
            try {
                recipient.setPaymentRecipient(paymentRecipient);
                result.add(recipient);
            }
            catch (IOException e) {
                BLLoggerPlay.error("Failed to load MT101 recipient with ID: " + paymentRecipient.getId(), e);
            }
        }
        return result;
    }

    public static Seq<Tuple2<String, String>> loadFeeTypes(Locale locale) {
        ArrayList<Tuple2> result = new ArrayList<Tuple2>();
        for (MT101FeeType feeType : MT101FeeType.values()) {
            result.add(Scala.Tuple((Object)feeType.name(), (Object)feeType.getDescription(locale)));
        }
        return Scala.toSeq(result);
    }

    public static Seq<Tuple2<String, String>> loadInstructionCodes() {
        return Scala.toSeq(Mt101PaymentForm.loadInstructionCodesList());
    }

    private static List<Tuple2<String, String>> loadInstructionCodesList() {
        ArrayList<Tuple2<String, String>> result = new ArrayList<Tuple2<String, String>>();
        result.add(Scala.Tuple((Object)InstructionCode.CHQB.toString(), (Object)InstructionCode.CHQB.toString()));
        result.add(Scala.Tuple((Object)InstructionCode.CMSW.toString(), (Object)InstructionCode.CMSW.toString()));
        result.add(Scala.Tuple((Object)InstructionCode.CMTO.toString(), (Object)InstructionCode.CMTO.toString()));
        result.add(Scala.Tuple((Object)InstructionCode.CMZB.toString(), (Object)InstructionCode.CMZB.toString()));
        result.add(Scala.Tuple((Object)InstructionCode.CORT.toString(), (Object)InstructionCode.CORT.toString()));
        result.add(Scala.Tuple((Object)InstructionCode.EQUI.toString(), (Object)InstructionCode.EQUI.toString()));
        result.add(Scala.Tuple((Object)InstructionCode.INTC.toString(), (Object)InstructionCode.INTC.toString()));
        result.add(Scala.Tuple((Object)InstructionCode.NETS.toString(), (Object)InstructionCode.NETS.toString()));
        result.add(Scala.Tuple((Object)InstructionCode.OTHR.toString(), (Object)InstructionCode.OTHR.toString()));
        result.add(Scala.Tuple((Object)InstructionCode.PHON.toString(), (Object)InstructionCode.PHON.toString()));
        result.add(Scala.Tuple((Object)InstructionCode.REPA.toString(), (Object)InstructionCode.REPA.toString()));
        result.add(Scala.Tuple((Object)InstructionCode.RTGS.toString(), (Object)InstructionCode.RTGS.toString()));
        result.add(Scala.Tuple((Object)InstructionCode.URGP.toString(), (Object)InstructionCode.URGP.toString()));
        return result;
    }

    public static boolean isInstructionWithAdditionalInfo(String code) {
        return INSTRUCTION_CODES_WITH_ADDITIONAL_INFO.contains(code);
    }

    public static List<Integer> getFormInstructionIds(Form<Mt101PaymentForm> form) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        form.value().ifPresent(mt101PaymentForm -> {
            if (mt101PaymentForm.instructions != null) {
                result.addAll(mt101PaymentForm.instructions.keySet());
            }
        });
        result.sort(Comparator.naturalOrder());
        return result;
    }

    public static boolean isFieldEnabled(String fieldName, User operator) {
        boolean allowOriginatorRecording = new DatabasePreferenceStore(Preference.ApplicationId.PAYMENTS, operator).getBoolean((DatabasePreferenceConstant)PreferenceConstants.ALLOW_ORIGINATOR_RECORDING);
        boolean allowRecipientRecording = PreferenceUtil.allowUnrestrictedRecipientRecording((User)operator);
        if ("originatorName2".equals(fieldName) || "originatorStreet".equals(fieldName) || "originatorTown".equals(fieldName) || "senderBic".equals(fieldName) || "receiverBic".equals(fieldName)) {
            return allowOriginatorRecording;
        }
        if ("recipientName2".equals(fieldName) || "recipientStreet".equals(fieldName) || "recipientTown".equals(fieldName) || "recipientAccount".equals(fieldName) || "recipientBankCode".equals(fieldName) || "intermediaryBankCode".equals(fieldName)) {
            return allowRecipientRecording;
        }
        return true;
    }

    public static String loadJsParameters(User user, Messages messages, boolean isNew, boolean formHasError) {
        ObjectNode node;
        ObjectNode resultJson = Json.newObject();
        DatabasePreferenceStore paymentsPreferenceStore = new DatabasePreferenceStore(Preference.ApplicationId.PAYMENTS, user);
        boolean allowOriginatorRecording = paymentsPreferenceStore.getBoolean((DatabasePreferenceConstant)PreferenceConstants.ALLOW_ORIGINATOR_RECORDING);
        boolean overwriteRecipientData = isNew || paymentsPreferenceStore.getBoolean((DatabasePreferenceConstant)PreferenceConstants.OVERWRITE_RECIPIENT_DATA);
        boolean initializeAccountAndOriginator = isNew && !PreferenceConstants.InitializationOfAccAndOrig.NONE.name().equals(paymentsPreferenceStore.getString((DatabasePreferenceConstant)PreferenceConstants.INITIALIZATION_OF_ACC_AND_ORIG));
        resultJson.put("initializeAccountAndOriginator", initializeAccountAndOriginator);
        resultJson.put("hasError", formHasError);
        resultJson.put("isNew", isNew);
        resultJson.put("overwriteRecipientData", overwriteRecipientData);
        resultJson.put("showRecipientWithAccountNumber", paymentsPreferenceStore.getBoolean((DatabasePreferenceConstant)PreferenceConstants.DISPLAY_RECIPIENTS_WITH_ACCOUNT_NUMBER));
        resultJson.put("searchOriginatorsUrl", routes.Payments.findOriginators("SEARCH", 999, "MT101").toString());
        resultJson.put("searchRecipientsUrl", routes.Payments.findRecipients("SEARCH", 999, "MT101").toString());
        resultJson.put("deleteMessage", BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.delete", (Object[])new Object[0]));
        resultJson.put("displayNameLocalized", BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.displayName", (Object[])new Object[0]));
        ArrayNode accountsNode = resultJson.putArray("accounts");
        for (Account account : new PermissionsLoader(user).loadAccounts(new String[]{"RFT", "RFT_mt101"}, PermissionsLoader.AccountType.IBAN_OR_NAT_ACC_NUMBER_AND_BIC)) {
            node = accountsNode.addObject();
            node.put("accountId", account.getId());
            node.put("bankId", account.getBank().getBankId());
            if (user.getTenants().size() > 1) {
                node.put("tenantId", account.getBank().getTenant().getId());
            }
            if (account.getCurrency() != null && !account.getCurrency().isEmpty()) {
                node.put("currency", account.getCurrency());
            }
            if (account.getMt101Originator() != null) {
                if (allowOriginatorRecording) {
                    node.put("defaultOriginator", account.getMt101Originator().getName());
                } else {
                    node.put("defaultOriginator", account.getMt101Originator().getId());
                }
            }
            if (account.getAccountHolder() == null || account.getAccountHolder().isEmpty()) continue;
            node.put("holder", Mt101PaymentForm.convertToMt101StringFormat(account.getAccountHolder(), 35));
        }
        ArrayNode banksBicsNode = resultJson.putArray("bankBics");
        for (Object bankUser : BankUser.findActiveBanksForUser((User)user)) {
            StringBuilder bicsList = null;
            for (String bic : Account.findBicsForBank((BankSettings)bankUser.getBank())) {
                if (bic == null || bic.isEmpty()) continue;
                if (bicsList == null) {
                    bicsList = new StringBuilder();
                } else if (bicsList.length() > 0) {
                    bicsList.append(',');
                }
                bicsList.append(bic);
            }
            if (bicsList == null || bicsList.length() <= 0) continue;
            banksBicsNode.addObject().put("bankId", bankUser.getBank().getBankId()).put("bics", bicsList.toString());
        }
        ArrayNode originatorsNode = resultJson.putArray("originators");
        for (MT101OriginatorData mT101OriginatorData : Mt101PaymentForm.loadOriginators(user)) {
            node = originatorsNode.addObject();
            node.put("id", mT101OriginatorData.getPaymentOriginator().getId());
            if (user.getTenants().size() > 1) {
                node.put("tenantId", mT101OriginatorData.getPaymentOriginator().getTenant().getId());
            }
            if (mT101OriginatorData.getDefaultAccount() != null) {
                node.put("defaultAccountId", mT101OriginatorData.getDefaultAccount().getId());
            }
            node.put("name", mT101OriginatorData.getName());
            node.put("name2", mT101OriginatorData.getName2());
            node.put("street", mT101OriginatorData.getStreet());
            node.put("town", mT101OriginatorData.getTown());
            node.put("senderbic", mT101OriginatorData.getSenderBic());
            node.put("receiverbic", mT101OriginatorData.getReceiverBic());
        }
        if (user.getTenants().size() > 1) {
            ArrayNode recipientsNode = resultJson.putArray("recipients");
            for (MT101RecipientData recipientData : Mt101PaymentForm.loadRecipients(user)) {
                recipientsNode.addObject().put("id", recipientData.getPaymentRecipient().getId()).put("tenantId", recipientData.getPaymentRecipient().getTenant().getId());
            }
        }
        ArrayNode instructionCodesNode = resultJson.putArray("instructionCodes");
        ArrayNode arrayNode = resultJson.putArray("instructionCodesWithAddInfo");
        for (Tuple2<String, String> tuple : Mt101PaymentForm.loadInstructionCodesList()) {
            node = instructionCodesNode.addObject();
            node.put("key", (String)tuple._1);
            node.put("value", (String)tuple._2);
            String[] forbiddenOtherCodes = InstructionCode.getForbiddenMT101Codes((String)((String)tuple._1));
            if (forbiddenOtherCodes != null) {
                ArrayNode forbiddenOtherCodesNode = node.putArray("forbiddenOtherCodes");
                for (String code : forbiddenOtherCodes) {
                    forbiddenOtherCodesNode.add(code);
                }
            }
            if (!Mt101PaymentForm.isInstructionWithAdditionalInfo((String)tuple._1)) continue;
            arrayNode.addObject().put("key", (String)tuple._1());
        }
        resultJson.put("instructionPlaceholder", BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.additionalInformationSingular", (Object[])new Object[0]));
        return Base64.getEncoder().encodeToString(Json.asciiStringify((JsonNode)resultJson).getBytes(StandardCharsets.US_ASCII));
    }

    public Mt101PaymentForm() {
    }

    public Mt101PaymentForm(Object databaseVO, boolean allowRecipientRecording, boolean saveRecipient) throws PaymentException {
        super(databaseVO, saveRecipient);
        this.loadPayment();
        this.loadPaymentDataInfo(allowRecipientRecording);
    }

    public Mt101PaymentForm(Object dsOrder, MT101PaymentData paymentData, boolean allowRecipientRecording, boolean saveRecipient) throws PaymentException {
        super(dsOrder, saveRecipient);
        this.paymentData = paymentData;
        this.loadPaymentDataInfo(allowRecipientRecording);
    }

    public Mt101PaymentForm(PaymentContextType paymentContextType, PaymentTransferType.PmtType pmtType, PaymentFolder folder, boolean saveRecipient) throws PaymentException {
        super(paymentContextType, pmtType, folder, saveRecipient);
        this.loadPayment();
    }

    @Override
    public PaymentHandler<?> loadPaymentHandler(User user) throws PaymentException {
        Account originatorAccount;
        if (this.paymentData == null) {
            this.loadPayment();
        }
        boolean newPayment = false;
        if (this.paymentData == null) {
            this.paymentData = new MT101PaymentData();
            newPayment = true;
        }
        if ((originatorAccount = (Account)DB.find(Account.class, (Object)this.originatorAccountId)) != null) {
            if (originatorAccount.getIban() != null && originatorAccount.getIban().length() > 0) {
                this.paymentData.setOriginatorAccount(originatorAccount.getIban());
            } else if (originatorAccount.getNationalAccountNumber() != null && originatorAccount.getNationalAccountNumber().length() > 0) {
                this.paymentData.setOriginatorAccount(originatorAccount.getNationalAccountNumber());
            }
            if (originatorAccount.getBic() != null && originatorAccount.getBic().length() > 0) {
                this.paymentData.setOriginatorBic(originatorAccount.getBic());
            } else {
                this.paymentData.setOriginatorBic(this.receiverBic);
            }
        }
        ArrayList<String> address = new ArrayList<String>();
        if (this.originatorName != null && this.originatorName.length() > 0) {
            address.add(this.originatorName);
        }
        if (this.originatorName2 != null && this.originatorName2.length() > 0) {
            address.add(this.originatorName2);
        }
        if (this.originatorStreet != null && this.originatorStreet.length() > 0) {
            address.add(this.originatorStreet);
        }
        if (this.originatorTown != null && this.originatorTown.length() > 0) {
            address.add(this.originatorTown);
        }
        CharSequence[] newOriginatorAddress = StringUtils.addSpaceWhenLineStartsWithMinus((String[])address.toArray(new String[0]), (int)4, (int)35);
        if (!newPayment) {
            this.reportFieldChange(Logger.PaymentField.ORIGINATOR, String.join((CharSequence)", ", this.paymentData.getOriginatorAddress()), String.join((CharSequence)", ", newOriginatorAddress));
        }
        this.paymentData.setOriginatorAddress((String[])newOriginatorAddress);
        if (!newPayment) {
            this.reportFieldChange(Logger.PaymentField.SENDER_BIC, this.paymentData.getSenderBic(), this.senderBic);
        }
        this.paymentData.setSenderBic(this.senderBic);
        if (!newPayment) {
            this.reportFieldChange(Logger.PaymentField.RECEIVER_BIC, this.paymentData.getReceiverBic(), this.receiverBic);
        }
        this.paymentData.setReceiverBic(this.receiverBic);
        address.clear();
        if (this.recipientName != null && this.recipientName.length() > 0) {
            address.add(this.recipientName);
        }
        if (this.recipientName2 != null && this.recipientName2.length() > 0) {
            address.add(this.recipientName2);
        }
        if (this.recipientStreet != null && this.recipientStreet.length() > 0) {
            address.add(this.recipientStreet);
        }
        if (this.recipientTown != null && this.recipientTown.length() > 0) {
            address.add(this.recipientTown);
        }
        CharSequence[] newRecipientAddress = StringUtils.addSpaceWhenLineStartsWithMinus((String[])address.toArray(new String[0]), (int)4, (int)35);
        if (!newPayment) {
            this.reportFieldChange(Logger.PaymentField.RECIPIENT, String.join((CharSequence)", ", this.paymentData.getRecipientAddress()), String.join((CharSequence)", ", newRecipientAddress));
        }
        this.paymentData.setRecipientAddress((String[])newRecipientAddress);
        if (!newPayment) {
            this.reportFieldChange(Logger.PaymentField.INTERMEDIARY_BANK_CODE, this.paymentData.getIntermediaryBankCode(), this.intermediaryBankCode);
        }
        this.paymentData.setIntermediaryBankCode(this.intermediaryBankCode);
        String recipientAccountTrimmed = this.recipientAccount.replace(" ", "");
        if (IbanUtil.checkIban((String)recipientAccountTrimmed)) {
            this.recipientAccount = recipientAccountTrimmed;
        }
        if (!newPayment) {
            this.reportFieldChange(Logger.PaymentField.RECIPIENT_ACCOUNT_NUMBER, this.paymentData.getRecipientAccount(), this.recipientAccount);
        }
        this.paymentData.setRecipientAccount(this.recipientAccount);
        if (!newPayment) {
            this.reportFieldChange(Logger.PaymentField.RECIPIENT_BANK_CODE, this.paymentData.getRecipientBankCode(), this.recipientBankCode);
        }
        this.paymentData.setRecipientBankCode(this.recipientBankCode);
        if (this.amount != null) {
            if (!newPayment) {
                this.reportFieldChange(Logger.PaymentField.AMOUNT, this.paymentData.getAmount(), this.amount);
            }
            this.paymentData.setAmount(this.amount);
        }
        if (this.counterValue) {
            Currency newCurrency = Currency.getInstance((String)originatorAccount.getCurrency());
            if (!newPayment) {
                this.reportFieldChange(Logger.PaymentField.CURRENCY, this.paymentData.getCurrency(), newCurrency);
            }
            this.paymentData.setCurrency(newCurrency);
            if (!newPayment) {
                this.reportFieldChange(Logger.PaymentField.COUNTER_VALUE_CURRENCY, this.paymentData.getCounterValueCurrency(), this.counterValueCurrency != null ? Currency.getInstance((String)this.counterValueCurrency) : null);
            }
            this.paymentData.setCounterValueCurrency(Currency.getInstance((String)this.counterValueCurrency));
            this.paymentData.setAmountInCounterValueCurrency(BigDecimal.ZERO);
        } else {
            if (!newPayment) {
                this.reportFieldChange(Logger.PaymentField.CURRENCY, this.paymentData.getCurrency(), this.currency != null ? Currency.getInstance((String)this.currency) : null);
            }
            this.paymentData.setCurrency(Currency.getInstance((String)this.currency));
            if (!newPayment) {
                this.reportFieldChange(Logger.PaymentField.COUNTER_VALUE_CURRENCY, this.paymentData.getCounterValueCurrency(), null);
            }
            this.paymentData.setCounterValueCurrency(null);
            this.paymentData.setAmountInCounterValueCurrency(null);
        }
        ArrayList<String> purposeList = new ArrayList<String>();
        if (this.purpose != null && this.purpose.length() > 0) {
            purposeList.add(this.purpose);
        }
        if (this.purpose2 != null && this.purpose2.length() > 0) {
            purposeList.add(this.purpose2);
        }
        if (this.purpose3 != null && this.purpose3.length() > 0) {
            purposeList.add(this.purpose3);
        }
        if (this.purpose4 != null && this.purpose4.length() > 0) {
            purposeList.add(this.purpose4);
        }
        CharSequence[] newPurpose = StringUtils.addSpaceWhenLineStartsWithMinus((String[])purposeList.toArray(new String[0]), (int)4, (int)35);
        if (!newPayment) {
            this.reportFieldChange(Logger.PaymentField.PURPOSE, String.join((CharSequence)", ", this.paymentData.getPurposeArray()), String.join((CharSequence)", ", newPurpose));
        }
        this.paymentData.setPurposeArray((String[])newPurpose);
        if (this.executionDate != null) {
            if (!newPayment) {
                Date oldDate = null;
                try {
                    oldDate = this.paymentData.getExecutionDateAsDate();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.reportFieldChange(Logger.PaymentField.EXECUTION_DATE, oldDate, this.executionDate);
            }
            this.paymentData.setExecutionDate(this.executionDate);
        }
        if (!newPayment) {
            this.reportFieldChange(Logger.PaymentField.END_TO_END_REFERENCE, this.paymentData.getTransactionReference(), this.reference);
        }
        this.paymentData.setTransactionReference(this.reference);
        if (!newPayment) {
            this.reportFieldChange(Logger.PaymentField.FEE_TYPE, this.paymentData.getFeeType(), this.feeType);
        }
        this.paymentData.setFeeType(this.feeType);
        if (this.instructions != null) {
            Field23E[] paymentInstructions = new Field23E[this.instructions.size()];
            int counter = 0;
            for (Integer id : this.instructions.keySet()) {
                Instruction instruction = this.instructions.get(id);
                InstructionCode instructionCode = instruction.code == null ? null : InstructionCode.getInstance((String)instruction.code);
                if (instructionCode == null) continue;
                paymentInstructions[counter] = new Field23E(instructionCode);
                String additionalInfo = instruction.additionalInformation;
                if (additionalInfo != null && additionalInfo.length() > 30) {
                    additionalInfo = additionalInfo.substring(0, 30);
                }
                additionalInfo = additionalInfo == null || additionalInfo.isEmpty() ? null : additionalInfo;
                paymentInstructions[counter].setAdditionalInformation(additionalInfo);
                ++counter;
            }
            Object[] oldInstructionCodes = this.paymentData.getInstructionCodeArray();
            this.paymentData.setInstructionCodes(paymentInstructions);
            Object[] newInstructionCodes = this.paymentData.getInstructionCodeArray();
            if (!newPayment) {
                String oldInstructionCodesString = null;
                if (oldInstructionCodes != null) {
                    Arrays.sort(oldInstructionCodes);
                    oldInstructionCodesString = String.join((CharSequence)", ", (CharSequence[])oldInstructionCodes);
                }
                String newInstructionCodesString = null;
                if (newInstructionCodes != null) {
                    Arrays.sort(newInstructionCodes);
                    newInstructionCodesString = String.join((CharSequence)", ", (CharSequence[])newInstructionCodes);
                }
                this.reportFieldChange(Logger.PaymentField.INSTRUCTION_CODES, oldInstructionCodesString, newInstructionCodesString);
            }
        } else {
            Object[] oldInstructionCodes = this.paymentData.getInstructionCodeArray();
            this.paymentData.setInstructionCodes(null);
            if (!newPayment) {
                String oldInstructionCodesString = null;
                if (oldInstructionCodes != null) {
                    Arrays.sort(oldInstructionCodes);
                    oldInstructionCodesString = String.join((CharSequence)", ", (CharSequence[])oldInstructionCodes);
                }
                this.reportFieldChange(Logger.PaymentField.INSTRUCTION_CODES, oldInstructionCodesString, null);
            }
        }
        return PaymentHandler.getHandler(this.paymentData, this.getPmtType());
    }

    @Override
    public boolean isUrgentPmtType(PaymentTransferType.PmtType pmtType) {
        return false;
    }

    @Override
    public boolean isCredit() {
        return true;
    }

    @Override
    protected PaymentType getPaymentType(User user) {
        return PaymentType.MT101;
    }

    @Override
    protected Form<? extends PaymentForm> loadSelectedOriginator(Form<? extends PaymentForm> form, Tenant tenant) {
        PaymentOriginator paymentOriginator;
        if (this.originatorName == null || this.originatorName.length() == 0) {
            return form.withError("originatorName", "error.required");
        }
        try {
            int originatorId = Integer.parseInt(this.originatorName);
            if (originatorId <= 0) {
                return form.withError("originatorName", "error.required");
            }
            paymentOriginator = (PaymentOriginator)DB.find(PaymentOriginator.class).where().eq("id", (Object)originatorId).eq("tenant", (Object)tenant).eq("paymentType", (Object)PaymentType.MT101).setMaxRows(1).findOne();
        }
        catch (NumberFormatException e) {
            paymentOriginator = null;
        }
        if (paymentOriginator == null) {
            return form.withError("originatorName", "error.originatorNotFound");
        }
        this.originatorName = paymentOriginator.getName();
        MT101OriginatorData mt101Originator = new MT101OriginatorData();
        try {
            mt101Originator.setPaymentOriginator(paymentOriginator);
            this.originatorName2 = mt101Originator.getName2();
            this.originatorStreet = mt101Originator.getStreet();
            this.originatorTown = mt101Originator.getTown();
            this.senderBic = mt101Originator.getSenderBic();
            this.receiverBic = mt101Originator.getReceiverBic();
        }
        catch (IOException e) {
            BLLoggerPlay.warning("Failed to load MT101 originator!", e);
        }
        return form;
    }

    @Override
    protected Form<? extends PaymentForm> loadSelectedRecipient(Form<? extends PaymentForm> form, User user, Tenant tenant) {
        List paymentRecipients;
        if (this.recipientName == null || this.recipientName.length() == 0) {
            return form.withError("recipientName", "error.required");
        }
        PaymentRecipient paymentRecipient = PaymentRecipient.findRecipientByDisplayName((PaymentType)PaymentType.MT101, (String)this.recipientName, (Tenant)tenant);
        if (paymentRecipient == null && (paymentRecipients = PaymentRecipient.findRecipientByName((PaymentType)PaymentType.MT101, (String)this.recipientName, (Tenant)tenant)).size() == 1) {
            paymentRecipient = (PaymentRecipient)paymentRecipients.get(0);
        }
        if (paymentRecipient == null) {
            return form.withError("recipientName", "error.recipientNotFound");
        }
        this.recipientName = paymentRecipient.getName();
        this.recipientAccount = paymentRecipient.getAccountNumber();
        this.recipientBankCode = paymentRecipient.getBankCode();
        MT101RecipientData mt101RecipientData = new MT101RecipientData();
        try {
            mt101RecipientData.setPaymentRecipient(paymentRecipient);
            this.recipientName2 = mt101RecipientData.getName2();
            this.recipientStreet = mt101RecipientData.getStreet();
            this.recipientTown = mt101RecipientData.getTown();
            this.intermediaryBankCode = mt101RecipientData.getIntermediaryBankCode();
        }
        catch (IOException e) {
            BLLoggerPlay.warning("Failed to load MT101 recipient!", e);
        }
        return form;
    }

    public static int getRecipientsCount(User user) {
        ArrayList<PaymentType> paymentTypes = new ArrayList<PaymentType>();
        paymentTypes.add(PaymentType.MT101);
        return PaymentRecipient.countRecipientsForPaymentTypes(paymentTypes, (List)user.getTenants());
    }

    @Override
    protected Form<? extends PaymentForm> internalValidate(Form<? extends PaymentForm> form, Messages messages, FormFactory formFactory, User user, Map<String, String> flashMap) {
        Account account;
        this.originatorName = Mt101PaymentForm.convertToMt101StringFormat(this.originatorName, 35);
        this.originatorName2 = Mt101PaymentForm.convertToMt101StringFormat(this.originatorName2, 35);
        this.originatorStreet = Mt101PaymentForm.convertToMt101StringFormat(this.originatorStreet, 35);
        this.originatorTown = Mt101PaymentForm.convertToMt101StringFormat(this.originatorTown, 35);
        this.recipientName = Mt101PaymentForm.convertToMt101StringFormat(this.recipientName, 35);
        this.recipientName2 = Mt101PaymentForm.convertToMt101StringFormat(this.recipientName2, 35);
        this.recipientStreet = Mt101PaymentForm.convertToMt101StringFormat(this.recipientStreet, 35);
        this.recipientTown = Mt101PaymentForm.convertToMt101StringFormat(this.recipientTown, 35);
        this.intermediaryBankCode = Mt101PaymentForm.convertToMt101StringFormat(this.intermediaryBankCode, 35);
        this.purpose = Mt101PaymentForm.convertToMt101StringFormat(this.purpose, 35);
        this.purpose2 = Mt101PaymentForm.convertToMt101StringFormat(this.purpose2, 35);
        this.purpose3 = Mt101PaymentForm.convertToMt101StringFormat(this.purpose3, 35);
        this.purpose4 = Mt101PaymentForm.convertToMt101StringFormat(this.purpose4, 35);
        this.reference = Mt101PaymentForm.convertToMt101StringFormat(this.reference, 16);
        if (this.instructions != null && !this.instructions.isEmpty()) {
            Set<Integer> instructionIds = this.instructions.keySet();
            Set usedCodes = instructionIds.stream().map(id -> this.instructions.get((Object)id).code).collect(Collectors.toSet());
            for (Integer key : instructionIds) {
                Instruction instruction = this.instructions.get(key);
                if (instruction.code == null || instruction.code.isEmpty()) {
                    form = form.withError("instructions[" + key + "].code", messages.at("error.required", new Object[0]));
                    continue;
                }
                InstructionCode instructionCode = InstructionCode.getInstance((String)instruction.code);
                if (instructionCode == null) {
                    form = form.withError("instructions[" + key + "].code", messages.at("error.invalid", new Object[0]));
                    continue;
                }
                CharSequence[] forbiddenCodes = InstructionCode.getForbiddenMT101Codes((String)instruction.code);
                if (forbiddenCodes == null) continue;
                if (!Arrays.stream(forbiddenCodes).anyMatch(usedCodes::contains)) continue;
                form = form.withError("instructions[" + key + "].code", messages.at("mt101payment.error.forbiddenInstruction", new Object[]{String.join((CharSequence)", ", forbiddenCodes)}));
            }
        }
        if ((account = (Account)DB.find(Account.class, (Object)this.originatorAccountId)) == null || (account.getIban() == null || account.getIban().length() == 0) && (account.getNationalAccountNumber() == null || account.getNationalAccountNumber().length() == 0)) {
            form = form.withError("originatorAccountId", "error.invalid");
        }
        if (this.originatorName == null || this.originatorName.length() == 0) {
            form = form.withError("originatorName", "error.required");
        } else if (!RegularExpressions.SWIFT.matches(this.originatorName)) {
            form = form.withError("originatorName", "error.invalid");
        }
        if (this.originatorName2 != null && this.originatorName2.length() > 0 && !RegularExpressions.SWIFT.matches(this.originatorName2)) {
            form = form.withError("originatorName2", "error.invalid");
        }
        if (this.originatorStreet != null && this.originatorStreet.length() > 0 && !RegularExpressions.SWIFT.matches(this.originatorStreet)) {
            form = form.withError("originatorStreet", "error.invalid");
        }
        if (this.originatorTown != null && this.originatorTown.length() > 0 && !RegularExpressions.SWIFT.matches(this.originatorTown)) {
            form = form.withError("originatorTown", "error.invalid");
        }
        if (this.senderBic == null || this.senderBic.length() == 0) {
            form = form.withError("senderBic", "error.required");
        } else if (!RegularExpressions.BIC.matches(this.senderBic)) {
            form = form.withError("senderBic", "error.invalid");
        }
        if (this.receiverBic == null || this.receiverBic.length() == 0) {
            form = form.withError("receiverBic", "error.required");
        } else if (!RegularExpressions.BIC.matches(this.receiverBic)) {
            form = form.withError("receiverBic", "error.invalid");
        }
        if (this.recipientName == null || this.recipientName.length() == 0) {
            form = form.withError("recipientName", "error.required");
        } else if (!RegularExpressions.SWIFT.matches(this.recipientName)) {
            form = form.withError("recipientName", "error.invalid");
        }
        if (this.recipientName2 != null && this.recipientName2.length() > 0 && !RegularExpressions.SWIFT.matches(this.recipientName2)) {
            form = form.withError("recipientName2", "error.invalid");
        }
        if (this.recipientStreet != null && this.recipientStreet.length() > 0 && !RegularExpressions.SWIFT.matches(this.recipientStreet)) {
            form = form.withError("recipientStreet", "error.invalid");
        }
        if (this.recipientTown != null && this.recipientTown.length() > 0 && !RegularExpressions.SWIFT.matches(this.recipientTown)) {
            form = form.withError("recipientTown", "error.invalid");
        }
        if (this.recipientAccount == null || this.recipientAccount.length() == 0) {
            form = form.withError("recipientAccount", "error.required");
        } else if (this.recipientAccount.length() > 34 || !RegularExpressions.SWIFT.matches(this.recipientAccount)) {
            form = form.withError("recipientAccount", "error.invalid");
        }
        if (this.recipientBankCode == null || this.recipientBankCode.length() == 0) {
            form = form.withError("recipientBankCode", "error.required");
        } else if (!RegularExpressions.SWIFT.matches(this.recipientBankCode) || this.recipientBankCode.length() > 34) {
            form = form.withError("recipientBankCode", "error.invalid");
        }
        if (this.intermediaryBankCode != null && !this.intermediaryBankCode.isEmpty() && !RegularExpressions.BIC.matches(this.intermediaryBankCode)) {
            form = form.withError("intermediaryBankCode", "error.invalid");
        }
        if (MT101PaymentData.MAX_AMOUNT.compareTo(this.amount) < 0) {
            form = form.withError("amount", "mt101payment.error.maxamount");
        }
        if (this.currency == null || this.currency.length() == 0) {
            form = form.withError("amount", "error.required");
        } else {
            try {
                Currency.getInstance((String)this.currency);
            }
            catch (IllegalArgumentException e) {
                BLLoggerPlay.warning("Invalid currency: " + this.currency, e);
                form = form.withError("amount", "error.invalid");
            }
        }
        if (Branding.getBranding().isPurposeMandatory() && (this.purpose == null || this.purpose.isEmpty())) {
            form = form.withError("purpose", messages.at("error.required", new Object[0]));
        }
        if (this.purpose != null && this.purpose.length() > 0 && !RegularExpressions.SWIFT.matches(this.purpose)) {
            form = form.withError("purpose", "error.invalid");
        }
        if (this.purpose2 != null && this.purpose2.length() > 0 && !RegularExpressions.SWIFT.matches(this.purpose2)) {
            form = form.withError("purpose2", "error.invalid");
        }
        if (this.purpose3 != null && this.purpose3.length() > 0 && !RegularExpressions.SWIFT.matches(this.purpose3)) {
            form = form.withError("purpose3", "error.invalid");
        }
        if (this.purpose4 != null && this.purpose4.length() > 0 && !RegularExpressions.SWIFT.matches(this.purpose4)) {
            form = form.withError("purpose4", "error.invalid");
        }
        if (this.getPaymentContextType() != PaymentContextType.PERIODIC_PAYMENT && this.getPaymentContextType() != PaymentContextType.PAYMENT_TEMPLATE) {
            if (this.executionDate == null) {
                form = form.withError("executionDate", messages.at("error.required", new Object[0]));
            } else {
                Calendar cal = Calendar.getInstance();
                cal.set(11, 0);
                cal.set(12, 0);
                cal.set(13, 0);
                cal.set(14, 0);
                if (this.executionDate.before(cal.getTime())) {
                    this.executionDate = cal.getTime();
                    form = form.withError("executionDate", BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.executionDateUpdated", (Object[])new Object[0]));
                    Form tempForm = formFactory.form(Mt101PaymentForm.class).fill((Object)this);
                    for (ValidationError error : form.errors()) {
                        tempForm = tempForm.withError(error);
                    }
                    form = tempForm;
                }
            }
        } else if (this.executionDate == null) {
            this.executionDate = ((PaymentForm)form.get()).firstExecution;
        }
        if (this.reference != null && this.reference.length() > 0 && !RegularExpressions.SWIFT.matches(this.reference)) {
            form = form.withError("reference", "error.invalid");
        }
        if (this.feeType == null || this.feeType.length() == 0) {
            form = form.withError("feeType", "error.required");
        } else if (MT101FeeType.getByKey((String)this.feeType) == null) {
            form = form.withError("feeType", "error.invalid");
        }
        return form;
    }

    @Override
    protected void internalRecipientHandling(User user, PaymentHandler<?> payment, Tenant tenant) {
    }

    @Override
    protected PaymentTransferType.PmtType getInternalPmtType() {
        return MT101Api.getPmtType();
    }

    @Override
    protected Form<? extends PaymentForm> reloadFormInternal(FormFactory formFactory) {
        return formFactory.form(Mt101PaymentForm.class).fill((Object)this);
    }

    @Override
    protected FormSettings.Form getFormSettingsType() {
        return FormSettings.Form.MT101_PAYMENT;
    }

    private void loadPayment() throws PaymentException {
        byte[] rawPaymentData = this.getPaymentData();
        if (rawPaymentData != null) {
            Mt101PaymentHandler paymentHandler = (Mt101PaymentHandler)PaymentHandler.getHandler(this.getPmtType(), this.getPaymentData());
            this.paymentData = (MT101PaymentData)paymentHandler.getPayment();
        } else {
            this.paymentData = null;
        }
    }

    private void loadPaymentDataInfo(boolean allowRecipientRecording) throws PaymentException {
        if (this.paymentData != null) {
            PaymentHandler<?> paymentHandler = PaymentHandler.getHandler(this.paymentData, this.getPmtType());
            Account originatorAccount = paymentHandler.getOriginatorAccount(this.getBankFromVO());
            if (originatorAccount != null) {
                this.originatorAccountId = originatorAccount.getId();
            }
            this.originatorAccount = IbanUtil.formatIfIBAN((String)this.paymentData.getOriginatorAccount());
            this.originatorBankCode = this.paymentData.getOriginatorBic();
            this.amount = paymentHandler.getAmount();
            this.currency = paymentHandler.getCurrencyCode() != null ? paymentHandler.getCurrencyCode() : "EUR";
            this.originatorName = paymentHandler.getOriginator();
            this.recipientAccount = paymentHandler.getRecipientAccountNumber();
            if (IbanUtil.checkIban((String)this.recipientAccount)) {
                this.recipientAccount = IbanUtil.formatIBAN((String)this.recipientAccount);
            }
            this.recipientBankCode = paymentHandler.getRecipientBankcode();
            if (allowRecipientRecording) {
                this.recipientName = paymentHandler.getRecipient();
            } else {
                String recipientAccountTrimmed = this.recipientAccount.replace(" ", "");
                PaymentRecipient paymentRecipient = PaymentRecipient.findRecipientByAccountInfo((PaymentType)PaymentType.MT101, (String)paymentHandler.getRecipient(), (String)recipientAccountTrimmed, (String)this.recipientBankCode, (Tenant)this.bank.getTenant());
                this.recipientName = paymentRecipient == null ? paymentHandler.getRecipient() : paymentRecipient.getDisplayName();
            }
            this.purpose = paymentHandler.getPurpose();
            this.executionDate = paymentHandler.getExecutionDate();
            this.originatorName2 = this.paymentData.getOriginatorName2();
            this.originatorStreet = this.paymentData.getOriginatorStreet();
            this.originatorTown = this.paymentData.getOriginatorTown();
            this.senderBic = this.paymentData.getSenderBic();
            this.receiverBic = this.paymentData.getReceiverBic();
            this.recipientName2 = this.paymentData.getRecipientName2();
            this.recipientStreet = this.paymentData.getRecipientStreet();
            this.recipientTown = this.paymentData.getRecipientTown();
            this.intermediaryBankCode = this.paymentData.getIntermediaryBankCode();
            this.purpose2 = this.paymentData.getPurpose2();
            this.purpose3 = this.paymentData.getPurpose3();
            this.purpose4 = this.paymentData.getPurpose4();
            this.reference = this.paymentData.getTransactionReference();
            this.feeType = this.paymentData.getFeeType();
            if (this.paymentData.getInstructionCodes() != null) {
                this.instructions = new HashMap<Integer, Instruction>();
                int counter = 0;
                for (Field23E instructionCode : this.paymentData.getInstructionCodes()) {
                    this.instructions.put(counter++, new Instruction(instructionCode));
                }
            }
            this.counterValue = this.paymentData.isCounterValuePayment();
            if (this.counterValue) {
                this.counterValueCurrency = this.paymentData.getCounterValueCurrency().toString();
            }
        }
    }

    public static String convertToMt101StringFormat(String toConvert, int maximumLength) {
        if (toConvert == null) {
            return null;
        }
        boolean hasLowerCase = false;
        for (int i = 0; !hasLowerCase && i < toConvert.length(); ++i) {
            hasLowerCase = toConvert.charAt(i) >= 'a' && toConvert.charAt(i) <= 'z';
        }
        char appendix = hasLowerCase ? (char)'e' : 'E';
        String result = toConvert.replaceAll("\u00c4", "A" + appendix).replaceAll("\u00d6", "O" + appendix).replaceAll("\u00dc", "U" + appendix).replaceAll("\u00e4", "a" + appendix).replaceAll("\u00f6", "o" + appendix).replaceAll("\u00fc", "u" + appendix).replaceAll("\u00df", "ss");
        if ((result = result.replaceAll("[^A-Za-z0-9 .,\\-/+)(?:']", "")).length() > maximumLength) {
            return result.substring(0, maximumLength);
        }
        return result;
    }

    public static class Instruction {
        public String code;
        public String additionalInformation;

        public Instruction() {
        }

        private Instruction(Field23E field23E) {
            if (field23E != null && field23E.getInstructionCode() != null) {
                this.code = field23E.getInstructionCode().toString();
            }
            if (field23E != null) {
                this.additionalInformation = field23E.getAdditionalInformation();
            }
        }
    }
}

