/*
 * Decompiled with CFR 0.152.
 */
package models;

import controllers.OpenPayments;
import controllers.PaymentTemplates;
import controllers.PeriodicPayments;
import controllers.SignedPayments;
import controllers.util.GeneralUtils;
import de.businesslogics.banking.database.api.DB;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.database.vo.BankUser;
import de.businesslogics.banking.database.vo.OpenPayment;
import de.businesslogics.banking.database.vo.PaymentFolder;
import de.businesslogics.banking.database.vo.PaymentTemplate;
import de.businesslogics.banking.database.vo.PeriodicPayment;
import de.businesslogics.banking.database.vo.SignedPayment;
import de.businesslogics.banking.database.vo.Tenant;
import de.businesslogics.banking.database.vo.User;
import io.ebean.Transaction;
import java.util.List;
import java.util.Map;
import models.payments.PaymentContextType;
import play.i18n.Messages;

public final class MovePaymentToFolderForm {
    public String paymentIds;
    public Integer folderId;
    public PaymentContextType paymentContextType;
    private PaymentFolder folder;
    private List<OpenPayment> payments;
    private List<PeriodicPayment> periodicPayments;
    private List<SignedPayment> signedPayments;
    private List<PaymentTemplate> paymentTemplates;

    public void validate(Map<String, String> flashMap, Messages messages, User user) {
        int numberOfPaymentsFound;
        this.folder = this.folderId == -2 ? PaymentFolder.NULL_FOLDER : (this.folderId >= 0 ? PaymentFolder.findById((Integer)this.folderId, (User)user) : null);
        if (this.folder == null) {
            flashMap.put("error", messages.at("payment.error.unknownfolder", new Object[0]));
            return;
        }
        List<Integer> paymentIdsList = GeneralUtils.getSelectionIds(this.paymentIds);
        if (paymentIdsList.isEmpty()) {
            numberOfPaymentsFound = 0;
        } else {
            switch (this.paymentContextType) {
                case OPEN_PAYMENT: {
                    this.payments = OpenPayments.getQueryCheckPermission(user).where().in("id", paymentIdsList).findList();
                    numberOfPaymentsFound = this.payments.size();
                    break;
                }
                case PERIODIC_PAYMENT: {
                    this.periodicPayments = PeriodicPayments.getQueryCheckPermission(user).where().in("id", paymentIdsList).findList();
                    numberOfPaymentsFound = this.periodicPayments.size();
                    break;
                }
                case PAYMENT_TEMPLATE: {
                    this.paymentTemplates = PaymentTemplates.getQueryCheckPermission(user).where().in("id", paymentIdsList).findList();
                    numberOfPaymentsFound = this.paymentTemplates.size();
                    break;
                }
                case SIGNED_PAYMENT: {
                    this.signedPayments = SignedPayments.getQueryCheckPermission(user).where().in("id", paymentIdsList).findList();
                    numberOfPaymentsFound = this.signedPayments.size();
                    break;
                }
                default: {
                    numberOfPaymentsFound = 0;
                }
            }
        }
        if (numberOfPaymentsFound == 0) {
            flashMap.put("error", messages.at("payment.error.nopaymentsselected", new Object[0]));
            return;
        }
        Tenant folderTenant = this.folder.getTenant();
        switch (this.paymentContextType) {
            case OPEN_PAYMENT: {
                for (OpenPayment payment : this.payments) {
                    Tenant paymentTenant = payment.getAccount().getBank().getTenant();
                    if (paymentTenant.equals(folderTenant) || folderTenant == null) continue;
                    flashMap.put("error", messages.at("openpayments.error.failedtomovepayments.wrongtenant", new Object[]{this.payments.size()}));
                    this.payments = null;
                    return;
                }
                break;
            }
            case PERIODIC_PAYMENT: {
                for (PeriodicPayment payment : this.periodicPayments) {
                    Tenant paymentTenant = payment.getAccount().getBank().getTenant();
                    if (paymentTenant.equals(folderTenant) || folderTenant == null) continue;
                    flashMap.put("error", messages.at("openpayments.error.failedtomovepayments.wrongtenant", new Object[]{this.periodicPayments.size()}));
                    this.periodicPayments = null;
                    return;
                }
                break;
            }
            case PAYMENT_TEMPLATE: {
                for (PaymentTemplate payment : this.paymentTemplates) {
                    Tenant paymentTenant = payment.getAccount().getBank().getTenant();
                    if (paymentTenant.equals(folderTenant) || folderTenant == null) continue;
                    flashMap.put("error", messages.at("openpayments.error.failedtomovepayments.wrongtenant", new Object[]{this.paymentTemplates.size()}));
                    this.paymentTemplates = null;
                    return;
                }
                break;
            }
            case SIGNED_PAYMENT: {
                for (SignedPayment payment : this.signedPayments) {
                    Tenant paymentTenant = payment.getAccount().getBank().getTenant();
                    if (paymentTenant.equals(folderTenant) || folderTenant == null) continue;
                    flashMap.put("error", messages.at("openpayments.error.failedtomovepayments.wrongtenant", new Object[]{this.signedPayments.size()}));
                    this.signedPayments = null;
                    return;
                }
                break;
            }
        }
    }

    public void store(Map<String, String> flashMap, Messages messages, User user) {
        if (this.folder == null || this.payments == null && this.periodicPayments == null && this.signedPayments == null && this.paymentTemplates == null) {
            return;
        }
        try (Transaction t = DB.beginTransaction();){
            int counter = 0;
            switch (this.paymentContextType) {
                case OPEN_PAYMENT: {
                    for (OpenPayment payment : this.payments) {
                        if (BankUser.findBankUser((BankSettings)payment.getBank(), (User)user) == null) continue;
                        Tenant folderTenant = this.folder.getTenant();
                        if (folderTenant == null || folderTenant.equals(payment.getAccount().getBank().getTenant())) {
                            payment.setFolder(this.folder);
                        }
                        payment.save(user, false);
                        ++counter;
                    }
                    break;
                }
                case PERIODIC_PAYMENT: {
                    for (PeriodicPayment payment : this.periodicPayments) {
                        if (BankUser.findBankUser((BankSettings)payment.getBank(), (User)user) == null) continue;
                        Tenant folderTenant = this.folder.getTenant();
                        if (folderTenant == null || folderTenant.equals(payment.getAccount().getBank().getTenant())) {
                            payment.setFolder(this.folder);
                        }
                        payment.save(user, false);
                        ++counter;
                    }
                    break;
                }
                case PAYMENT_TEMPLATE: {
                    for (PaymentTemplate payment : this.paymentTemplates) {
                        Tenant folderTenant = this.folder.getTenant();
                        if (folderTenant == null || folderTenant.equals(payment.getAccount().getBank().getTenant())) {
                            payment.setFolder(this.folder);
                        }
                        payment.save();
                        ++counter;
                    }
                    break;
                }
                case SIGNED_PAYMENT: {
                    for (SignedPayment payment : this.signedPayments) {
                        Tenant folderTenant = this.folder.getTenant();
                        if (folderTenant == null || folderTenant.equals(payment.getAccount().getBank().getTenant())) {
                            payment.setFolder(this.folder);
                        }
                        payment.save();
                        ++counter;
                    }
                    break;
                }
            }
            if (this.folder == PaymentFolder.NULL_FOLDER) {
                flashMap.put("success", messages.at("payment.movedtodefaultfolder", new Object[]{counter}));
            } else {
                flashMap.put("success", messages.at("payment.movedtofolder", new Object[]{counter, this.folder.getName()}));
            }
            t.commit();
        }
    }
}

