/*
 * Decompiled with CFR 0.152.
 */
package models;

import controllers.util.BLLoggerPlay;
import de.businesslogics.banking.api.Logger;
import de.businesslogics.banking.api.PermissionsLoader;
import de.businesslogics.banking.database.api.DB;
import de.businesslogics.banking.database.vo.Account;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.database.vo.OpenPayment;
import de.businesslogics.banking.database.vo.PaymentOriginator;
import de.businesslogics.banking.database.vo.PaymentProperties;
import de.businesslogics.banking.database.vo.PaymentType;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.banking.payments.api.BankOrderPayment;
import io.ebean.Transaction;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.regex.PatternSyntaxException;
import models.payments.PaymentException;
import models.payments.PaymentHandler;
import play.data.Form;
import play.libs.Scala;
import scala.Tuple2;
import scala.collection.immutable.Seq;
import views.Utils;

public final class ModifyOpenPaymentsForm {
    public String paymentIds;
    public boolean modifyOriginatorAccount;
    public Integer originatorAccount;
    public boolean modifyOriginator;
    public Integer originator;
    public boolean modifyPurpose;
    public String replacePurpose;
    public String byPurpose;
    public boolean modifyExecutionDate;
    public Date executionDate = new Date();
    private Account originatorAccountVO;
    private PaymentOriginator originatorVO;

    public static Seq<Tuple2<String, String>> getOriginators(String username) {
        User user = User.getUser((String)username);
        ArrayList<Tuple2> result = new ArrayList<Tuple2>();
        ArrayList<PaymentType> paymentTypes = new ArrayList<PaymentType>();
        paymentTypes.add(PaymentType.DTAZV);
        paymentTypes.add(PaymentType.SEPA);
        paymentTypes.add(PaymentType.MANDATE);
        paymentTypes.add(PaymentType.MT101);
        for (PaymentOriginator paymentOriginator : PaymentOriginator.findOriginatorsForPaymentTypes(paymentTypes, (List)user.getTenants())) {
            String originatorName = paymentOriginator.getName() + " - " + paymentOriginator.getPaymentType().name();
            result.add(Scala.Tuple((Object)String.valueOf(paymentOriginator.getId()), (Object)Utils.addZWNJ(originatorName)));
        }
        result.sort((o1, o2) -> {
            if (o1 == null || o1._2 == null) {
                if (o2 == null || o2._2 == null) {
                    return 0;
                }
                return 1;
            }
            if (o2 == null || o2._2 == null) {
                return -1;
            }
            return ((String)o1._2).compareTo((String)o2._2);
        });
        return Scala.toSeq(result);
    }

    public Form<ModifyOpenPaymentsForm> validate(Form<ModifyOpenPaymentsForm> form, User user) {
        if (this.modifyOriginatorAccount) {
            if (this.originatorAccount != null) {
                this.originatorAccountVO = Account.findById((int)this.originatorAccount);
            }
            if (this.originatorAccountVO == null) {
                form = form.withError("originatorAccount", "error.invalid");
            } else if (!new PermissionsLoader(user).loadAccounts(null, null).contains(this.originatorAccountVO)) {
                form = form.withError("originatorAccount", "payment.error.nopermissionfororiginatoraccount");
            }
        }
        if (this.modifyOriginator) {
            if (this.originator != null) {
                this.originatorVO = PaymentOriginator.findById((int)this.originator, (User)user);
            }
            if (this.originatorVO == null) {
                form = form.withError("originator", "error.invalid");
            }
        }
        if (this.modifyExecutionDate) {
            Calendar cal = Calendar.getInstance();
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            if (((ModifyOpenPaymentsForm)form.get()).executionDate == null || ((ModifyOpenPaymentsForm)form.get()).executionDate.before(cal.getTime())) {
                form = form.withError("date", "error.invalid");
            }
        }
        return form;
    }

    public int modify(List<BankOrderPayment<PaymentHandler<?>>> payments, User user) throws PaymentException {
        try (Transaction t = DB.beginTransaction();){
            HashMap<BankSettings, PaymentProperties> paymentPropertiesMap = new HashMap<BankSettings, PaymentProperties>();
            PermissionsLoader permissionsLoader = new PermissionsLoader(user);
            int count = 0;
            for (BankOrderPayment<PaymentHandler<?>> p : payments) {
                boolean changed;
                boolean modified = false;
                BankSettings bank = p.getOpenPayment().getBank();
                PaymentProperties paymentProperties = (PaymentProperties)paymentPropertiesMap.get(bank);
                if (paymentProperties == null) {
                    paymentProperties = PaymentProperties.findForBank((BankSettings)bank);
                    paymentPropertiesMap.put(bank, paymentProperties);
                }
                if (this.modifyOriginatorAccount) {
                    if (this.originatorAccountVO == null) {
                        BLLoggerPlay.warning("Failed to set originator account, no originator account set!");
                    } else if (!permissionsLoader.hasPermissionForAccount(this.originatorAccountVO, p.getOpenPayment().getOrderType(), p.getOpenPayment().getFileTypeOrBTF())) {
                        BLLoggerPlay.warning("Failed to set originator account to open payment with ID " + p.getOpenPayment().getId() + ", no permission for account " + this.originatorAccount + "!");
                    } else if (!((PaymentHandler)p.getPaymentData()).setOriginatorAccount(this.originatorAccountVO)) {
                        BLLoggerPlay.warning("Failed to set originator account to open payment with ID " + p.getOpenPayment().getId() + ", originator account cannot be used for payment type!");
                    } else {
                        if (Utils.fieldValueChanged(p.getOpenPayment().getAccount().getId(), this.originatorAccount)) {
                            Logger.logOpenPaymentModified((User)user, (OpenPayment)p.getOpenPayment(), (Logger.PaymentField)Logger.PaymentField.ORIGINATOR_ACCOUNT, (String)p.getOpenPayment().getAccount().getName(), (String)this.originatorAccountVO.getName());
                        }
                        p.getOpenPayment().setBank(this.originatorAccountVO.getBank());
                        p.getOpenPayment().setAccount(this.originatorAccountVO);
                        modified = true;
                    }
                }
                if (this.modifyOriginator) {
                    if (this.originatorVO == null) {
                        BLLoggerPlay.warning("Failed to set originator, no originator set!");
                    } else {
                        String oldOriginator = p.getOpenPayment().getOriginator();
                        changed = ((PaymentHandler)p.getPaymentData()).setOriginator(this.originatorVO);
                        if (changed && Utils.fieldValueChanged(oldOriginator, this.originatorVO.getName())) {
                            Logger.logOpenPaymentModified((User)user, (OpenPayment)p.getOpenPayment(), (Logger.PaymentField)Logger.PaymentField.ORIGINATOR, (String)oldOriginator, (String)this.originatorVO.getName());
                            modified = true;
                        }
                        if (!changed) {
                            BLLoggerPlay.warning("Failed to set originator to open payment with ID " + p.getOpenPayment().getId() + ", originator cannot be used for payment type!");
                        }
                    }
                }
                if (this.modifyPurpose) {
                    if (this.replacePurpose == null) {
                        this.replacePurpose = "";
                    }
                    if (this.byPurpose == null) {
                        this.byPurpose = "";
                    }
                    String oldPurpose = p.getOpenPayment().getPurpose();
                    changed = false;
                    try {
                        changed = ((PaymentHandler)p.getPaymentData()).replaceInPurpose(this.replacePurpose, this.byPurpose);
                    }
                    catch (PatternSyntaxException e) {
                        BLLoggerPlay.warning("Error trying to replace payment purpose: " + e.getDescription());
                    }
                    String newPurpose = ((PaymentHandler)p.getPaymentData()).getPurpose();
                    if (changed && Utils.fieldValueChanged(oldPurpose, newPurpose)) {
                        Logger.logOpenPaymentModified((User)user, (OpenPayment)p.getOpenPayment(), (Logger.PaymentField)Logger.PaymentField.PURPOSE, (String)oldPurpose, (String)newPurpose);
                        p.getOpenPayment().setPurpose(((PaymentHandler)p.getPaymentData()).getPurpose());
                        modified = true;
                    }
                    if (!changed) {
                        BLLoggerPlay.warning("Nothing to update in purpose of payment with ID " + p.getOpenPayment().getId());
                    }
                }
                if (this.modifyExecutionDate) {
                    if (this.executionDate != null) {
                        Timestamp oldExecutionDate = p.getOpenPayment().getExecutionDate();
                        ((PaymentHandler)p.getPaymentData()).setEarliestExecutionDate(this.executionDate, bank, paymentProperties);
                        Timestamp newExecutionDate = new Timestamp(((PaymentHandler)p.getPaymentData()).getExecutionDate().getTime());
                        if (Utils.fieldValueChanged(new Date(oldExecutionDate.getTime()), new Date(newExecutionDate.getTime()))) {
                            Logger.logOpenPaymentModified((User)user, (OpenPayment)p.getOpenPayment(), (Logger.PaymentField)Logger.PaymentField.EXECUTION_DATE, (String)DateFormat.getDateInstance(2).format(new Date(oldExecutionDate.getTime())), (String)DateFormat.getDateInstance(2).format(new Date(newExecutionDate.getTime())));
                        }
                        p.getOpenPayment().setExecutionDate(newExecutionDate);
                        modified = true;
                    } else {
                        BLLoggerPlay.warning("Failed to set execution date in open payment, no execution date specified!");
                    }
                }
                if (!modified) continue;
                p.getOpenPayment().setPaymentData(((PaymentHandler)p.getPaymentData()).buildPaymentData(bank));
                p.getOpenPayment().save(user, false);
                ++count;
            }
            t.commit();
            int n = count;
            return n;
        }
    }
}

