/*
 * Decompiled with CFR 0.152.
 */
package models;

import controllers.util.TenantUtils;
import de.businesslogics.banking.api.Logger;
import de.businesslogics.banking.database.vo.PaymentRecipient;
import de.businesslogics.banking.database.vo.PaymentType;
import de.businesslogics.banking.database.vo.Tenant;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.banking.mt101.api.MT101RecipientData;
import de.businesslogics.banking.payments.api.PreferenceUtil;
import de.businesslogics.banking.payments.api.RecipientData;
import de.businesslogics.iban.IbanUtil;
import de.businesslogics.validation.RegularExpressions;
import java.io.IOException;
import models.Mt101PaymentForm;
import models.RecipientForm;
import play.data.Form;
import play.i18n.Messages;
import views.Utils;

public final class MT101RecipientForm
extends RecipientForm {
    public String name2;
    public String street;
    public String town;
    public String accountNumber;
    public String bankCode;
    public String intermediaryBankCode;
    public String purpose1;
    public String purpose2;
    public String purpose3;
    public String purpose4;
    public String feeType;

    public MT101RecipientForm() {
    }

    public MT101RecipientForm(PaymentRecipient paymentRecipient) {
        MT101RecipientData recipient = new MT101RecipientData();
        try {
            recipient.setPaymentRecipient(paymentRecipient);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.id = paymentRecipient.getId();
        this.displayName = recipient.getDisplayName();
        this.name = recipient.getName();
        this.tenantId = recipient.getTenant().getId();
        this.name2 = recipient.getName2();
        this.street = recipient.getStreet();
        this.town = recipient.getTown();
        this.accountNumber = IbanUtil.formatIfIBAN((String)recipient.getAccountNumber());
        this.bankCode = recipient.getBankCode();
        this.intermediaryBankCode = recipient.getIntermediaryBankCode();
        this.feeType = recipient.getFeeType();
        this.purpose1 = recipient.getPurpose1();
        this.purpose2 = recipient.getPurpose2();
        this.purpose3 = recipient.getPurpose3();
        this.purpose4 = recipient.getPurpose4();
    }

    @Override
    public Form<? extends RecipientForm> validate(Form<? extends RecipientForm> form, Messages messages, User user) {
        this.name = Mt101PaymentForm.convertToMt101StringFormat(this.name, 35);
        this.name2 = Mt101PaymentForm.convertToMt101StringFormat(this.name2, 35);
        this.street = Mt101PaymentForm.convertToMt101StringFormat(this.street, 35);
        this.town = Mt101PaymentForm.convertToMt101StringFormat(this.town, 35);
        this.purpose1 = Mt101PaymentForm.convertToMt101StringFormat(this.purpose1, 35);
        this.purpose2 = Mt101PaymentForm.convertToMt101StringFormat(this.purpose2, 35);
        this.purpose3 = Mt101PaymentForm.convertToMt101StringFormat(this.purpose3, 35);
        this.purpose4 = Mt101PaymentForm.convertToMt101StringFormat(this.purpose4, 35);
        String tenantError = TenantUtils.checkTenantId(this.tenantId, user);
        if (tenantError != null) {
            form = form.withError("tenantId", tenantError);
        }
        if (this.name == null || this.name.length() == 0) {
            form = form.withError("name", "error.required");
        } else if (!RegularExpressions.SWIFT.matches(this.name)) {
            form = form.withError("name", "error.invalid");
        }
        if (this.name2 != null && this.name2.length() > 0 && !RegularExpressions.SWIFT.matches(this.name2)) {
            form = form.withError("name2", "error.invalid");
        }
        if (this.street != null && this.street.length() > 0 && !RegularExpressions.SWIFT.matches(this.street)) {
            form = form.withError("street", "error.invalid");
        }
        if (this.town != null && this.town.length() > 0 && !RegularExpressions.SWIFT.matches(this.town)) {
            form = form.withError("town", "error.invalid");
        }
        if (this.accountNumber == null || this.accountNumber.length() == 0) {
            form = form.withError("accountNumber", "error.required");
        } else if (this.accountNumber.length() > 34 || !RegularExpressions.SWIFT.matches(this.accountNumber)) {
            form = form.withError("accountNumber", "error.invalid");
        }
        if (this.bankCode == null || this.bankCode.length() == 0) {
            form = form.withError("bankCode", "error.required");
        } else if (!RegularExpressions.SWIFT.matches(this.bankCode) || this.bankCode.length() > 34) {
            form = form.withError("bankCode", "error.invalid");
        }
        if (this.intermediaryBankCode != null && !this.intermediaryBankCode.isEmpty() && !RegularExpressions.BIC.matches(this.intermediaryBankCode)) {
            form = form.withError("intermediaryBankCode", "error.invalid");
        }
        if (this.purpose1 != null && this.purpose1.length() > 0 && !RegularExpressions.SWIFT.matches(this.purpose1)) {
            form = form.withError("purpose1", "error.invalid");
        }
        if (this.purpose2 != null && this.purpose2.length() > 0 && !RegularExpressions.SWIFT.matches(this.purpose2)) {
            form = form.withError("purpose2", "error.invalid");
        }
        if (this.purpose3 != null && this.purpose3.length() > 0 && !RegularExpressions.SWIFT.matches(this.purpose3)) {
            form = form.withError("purpose3", "error.invalid");
        }
        if (this.purpose4 != null && this.purpose4.length() > 0 && !RegularExpressions.SWIFT.matches(this.purpose4)) {
            form = form.withError("purpose4", "error.invalid");
        }
        return form;
    }

    @Override
    public void store(PaymentRecipient paymentRecipient, User user) throws IOException {
        boolean isNewRecipient;
        Tenant tenant = TenantUtils.getTenantByIdAndUser(this.tenantId, user);
        boolean bl = isNewRecipient = paymentRecipient.getId() == null;
        if (isNewRecipient) {
            this.displayName = RecipientData.getUniqueDisplayName((String)this.displayName, (PaymentType)PaymentType.MT101, (Tenant)tenant);
        }
        MT101RecipientData recipientData = new MT101RecipientData();
        recipientData.setPaymentRecipient(paymentRecipient);
        if (MT101RecipientForm.isFieldEnabled("displayName", user, paymentRecipient.getId())) {
            recipientData.setDisplayName(this.displayName);
        }
        String oldName = paymentRecipient.getName();
        boolean nameChanged = false;
        if (MT101RecipientForm.isFieldEnabled("name", user, paymentRecipient.getId())) {
            nameChanged = !isNewRecipient && Utils.fieldValueChanged(oldName, this.name);
            recipientData.setName(this.name);
        }
        if (MT101RecipientForm.isFieldEnabled("name2", user, paymentRecipient.getId())) {
            recipientData.setName2(this.name2);
        }
        if (MT101RecipientForm.isFieldEnabled("street", user, paymentRecipient.getId())) {
            recipientData.setStreet(this.street);
        }
        if (MT101RecipientForm.isFieldEnabled("town", user, paymentRecipient.getId())) {
            recipientData.setTown(this.town);
        }
        String oldAccNbr = paymentRecipient.getAccountNumber();
        boolean accNbrChanged = false;
        if (MT101RecipientForm.isFieldEnabled("accountNumber", user, paymentRecipient.getId())) {
            accNbrChanged = !isNewRecipient && Utils.fieldValueChanged(oldAccNbr, this.accountNumber);
            recipientData.setAccountNumber(this.accountNumber);
        }
        String oldBankCode = paymentRecipient.getBankCode();
        boolean bankCodeChanged = false;
        if (MT101RecipientForm.isFieldEnabled("bankCode", user, paymentRecipient.getId())) {
            bankCodeChanged = !isNewRecipient && Utils.fieldValueChanged(oldBankCode, this.bankCode);
            recipientData.setBankCode(this.bankCode);
        }
        String oldIntermediaryBankCode = recipientData.getIntermediaryBankCode();
        boolean intermediaryBankCodeChanged = false;
        if (MT101RecipientForm.isFieldEnabled("intermediaryBankCode", user, paymentRecipient.getId())) {
            intermediaryBankCodeChanged = !isNewRecipient && Utils.fieldValueChanged(oldIntermediaryBankCode, this.intermediaryBankCode);
            recipientData.setIntermediaryBankCode(this.intermediaryBankCode);
        }
        if (MT101RecipientForm.isFieldEnabled("feeType", user, paymentRecipient.getId())) {
            recipientData.setFeeType(this.feeType);
        }
        if (MT101RecipientForm.isFieldEnabled("purpose1", user, paymentRecipient.getId())) {
            recipientData.setPurpose1(this.purpose1);
        }
        if (MT101RecipientForm.isFieldEnabled("purpose2", user, paymentRecipient.getId())) {
            recipientData.setPurpose2(this.purpose2);
        }
        if (MT101RecipientForm.isFieldEnabled("purpose3", user, paymentRecipient.getId())) {
            recipientData.setPurpose3(this.purpose3);
        }
        if (MT101RecipientForm.isFieldEnabled("purpose4", user, paymentRecipient.getId())) {
            recipientData.setPurpose4(this.purpose4);
        }
        if (MT101RecipientForm.isFieldEnabled("tenantId", user, paymentRecipient.getId())) {
            recipientData.setTenant(tenant);
        }
        recipientData.save(user, PreferenceUtil.useFourEyesForRecipientRecording((User)user));
        if (nameChanged) {
            Logger.logRecipientModified((User)user, (PaymentRecipient)paymentRecipient, (Logger.RecipientField)Logger.RecipientField.NAME, (String)oldName, (String)this.name);
        }
        if (accNbrChanged) {
            Logger.logRecipientModified((User)user, (PaymentRecipient)paymentRecipient, (Logger.RecipientField)Logger.RecipientField.ACCOUNT_NUMBER, (String)oldAccNbr, (String)this.accountNumber);
        }
        if (bankCodeChanged) {
            Logger.logRecipientModified((User)user, (PaymentRecipient)paymentRecipient, (Logger.RecipientField)Logger.RecipientField.BANK_CODE, (String)oldBankCode, (String)this.bankCode);
        }
        if (intermediaryBankCodeChanged) {
            Logger.logRecipientModified((User)user, (PaymentRecipient)paymentRecipient, (Logger.RecipientField)Logger.RecipientField.INTERMEDIARY_BANK_CODE, (String)oldIntermediaryBankCode, (String)this.intermediaryBankCode);
        }
    }
}

